/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.imforward.vo.IMSessionRspVO;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.doctor.basedata.api.vo.UcUserEvaluationVO;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.ImInfosParameter;
import com.doctoruser.api.pojo.base.dto.doctor.ImInfosReq;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.dto.verify.DocAllInfoDto;
import com.doctoruser.api.pojo.base.vo.DoctorAllInfoVo;
import com.doctoruser.api.pojo.base.vo.ImInfosRes;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMBatchGetSessionReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import com.ebaiyihui.onlineoutpatient.common.dto.FollowUpCaseRecord;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.MedicalOpinionDto;
import com.ebaiyihui.onlineoutpatient.common.dto.PatAdvisoryDetailDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryNewestOrderorAdmDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.AdmAndOrderInfo;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.AdmissionDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.AdvisoryDetailDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.CheckInformStatusInfo;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.DocAdvisoryRecordReq;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.OrderInfoDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.PatAdvisoryRecordReq;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.UpdateAdmissionDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.UpdateDoctorAdmissionStatusDto;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.UpdateRefuseAdmDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.QueryAppealOrderTypeDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.OrderCreateDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.OrderCreateResponseDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.AdmDateVo;
import com.ebaiyihui.onlineoutpatient.common.vo.AdvisoryDetailVo;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.DocAdvisoryDetailVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DocAdvisoryRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ImAccountVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.common.vo.MedicalInfoVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatAdvisoryDetailVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatAdvisoryRecordRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PatAdvisoryRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientBaseInfoVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientEndAdmReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryMedicalRecordsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.TeamImAccount;
import com.ebaiyihui.onlineoutpatient.common.vo.TimeDelayQueryReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.TimeDelayQueryRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.TimeDelayUpdateReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.UserEvaluationVO;
import com.ebaiyihui.onlineoutpatient.common.vo.inform.IMMsgResultVO;
import com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.ReceiveOrderManage;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.DoctorNetinquiryOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.GenderEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PatientNetinquiryOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ReturnCodeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.EvaluationMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.NcefyDeptMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalPictureMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ReferralInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.EvaluationEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MedicalAdmissionRefEntity;
import com.ebaiyihui.onlineoutpatient.core.model.NcefyDeptEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalPictureEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ReferralInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionService;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.GoEasyPushService;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ImAccountService;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DepartmentFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorUserEvaluationFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorWorkingServiceClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.IMSyncMsgClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.ImApiFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.PatientMedicalFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryAdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseScheduleTimeIntervalServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.IMInformServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.PatientMedicalRecordServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.PatientServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.nczk.ZkbgService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.B64ImgReplacedElementFactory;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.OSSClientUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.PageUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionInfoParam;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorApprovalMedicalFormDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetMainIdsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPersonTeamDetialResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPersonTeamResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ImAccountReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InternetHospitalEntity;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderAndAdmInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PatientAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqMgrWebAdmissionDetailInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqMgrWebScheduleAdmissionVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestDoctorServiceCheckVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResMgrWebAdmissionDetailInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResMgrWebAllScheduleAdmissionVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientInformationVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UpdatePatientDynamicMedicalUserFillsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PatientInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.TransModelVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgRefundVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.InsertTagsRecordVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalSortVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.itextpdf.html2pdf.HtmlConverter;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextRenderer;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AdmissionServiceImpl
implements AdmissionService {
    private static final Logger log = LoggerFactory.getLogger(AdmissionServiceImpl.class);
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private BaseInquiryAdmissionServiceImpl baseInquiryAdmissionService;
    @Autowired
    private OrderMapper orderMapper;
    @Resource
    private PatientMapper patientMapper;
    @Autowired
    private PatientServiceImpl patientService;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private DoctorUserEvaluationFeignClient evaluationFeignClient;
    @Resource
    private PatientMedicalRecordMapper medicalRecordMapper;
    @Resource
    private PatientMedicalPictureMapper medicalPictureMapper;
    @Autowired
    private BaseInquiryServiceConfigServiceImpl baseService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Resource
    private ImAccountService imAccountService;
    @Resource
    private OrderService orderService;
    @Resource
    private IMInformService iMInformService;
    @Resource
    private DoctorWorkingServiceClient doctorWorkingServiceClient;
    @Autowired
    private DoctorInfofeignClient doctorInfofeignClient;
    @Autowired
    private DepartmentFeignClient departmentInfoApi;
    @Autowired
    private IMSyncMsgClient imSyncMsgClient;
    @Autowired
    private ImApiFeignClient imApiFeignClient;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private UmAppPushService umAppPushService;
    @Autowired
    private BaseScheduleTimeIntervalServiceImpl baseScheduleTimeIntervalService;
    @Autowired
    ReceiveOrderManage receiveOrderManage;
    @Autowired
    private AliSmsPushService aliSmsPushService;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private PatientMedicalFeignClient patientMedicalFeignClient;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private PatientMedicalRecordServiceImpl patientMedicalRecordService;
    @Autowired
    private EvaluationMapper evaluationMapper;
    @Autowired
    private ICDMapper icdMapper;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private ZkbgService zkbgService;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static final String STATUS_DESC = "\u5df2\u5931\u6548";
    @Autowired
    private NcefyDeptMapper ncefyDeptMapper;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private GoEasyPushService goEasyPushService;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    @Resource
    ReferralInfoMapper referralInfoMapper;
    @Autowired
    private SpringTemplateEngine templateEngine;
    @Resource
    private PatientMedicalRecordMapper patientMedicalRecordMapper;

    public BaseResponse<PageUtil<DocAdvisoryRecordVo>> queryDocAdvisoryRecord(DocAdvisoryRecordReq param) {
        ArrayList admIds = new ArrayList();
        List teamDoctorInfoEntityList = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getDoctorId, (Object)param.getDoctorId()));
        if (!CollectionUtils.isEmpty((Collection)teamDoctorInfoEntityList)) {
            teamDoctorInfoEntityList.forEach(entity -> admIds.add(entity.getAdmId()));
            param.setAdmIds(admIds);
        }
        if (!this.setStatusList(param)) {
            BaseResponse.error((String)"\u67e5\u8be2\u7c7b\u578bqueryType\u53c2\u6570\u9519\u8bef");
        }
        PageHelper.startPage((Object)param);
        log.info("queryDoctorIms\u5165\u53c2\uff1a" + param.toString());
        Page pages = this.admissionMapper.queryDoctorIms(param);
        List voList = pages.getResult();
        log.info("voList\uff1a{}" + voList.toString());
        HashMap<String, DocAdvisoryRecordVo> map = new HashMap<String, DocAdvisoryRecordVo>(10);
        for (DocAdvisoryRecordVo docAdvisoryRecordVo : voList) {
            if (docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.REFUNDED_APPLY.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.RETIRED.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.EXPIRED.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.ADMIN_REFUNDED.getValue())) {
                docAdvisoryRecordVo.setStatusDesc("\u5df2\u5931\u6548");
                continue;
            }
            if (docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.REFERRAL.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.FINISH_TIME_OUT.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER.getValue()) || docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue())) {
                docAdvisoryRecordVo.setStatusDesc(AdmissionStatusEnum.FINISH_APPLY.getDesc());
                continue;
            }
            if (docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
                docAdvisoryRecordVo.setStatusDesc(AdmissionStatusEnum.TO_BE_RECEIVED.getDesc());
                continue;
            }
            if (docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
                docAdvisoryRecordVo.setStatusDesc(AdmissionStatusEnum.IN_CONSULTATION.getDesc());
                continue;
            }
            if (docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.WAIT_ADMISSION.getValue())) {
                docAdvisoryRecordVo.setStatusDesc(AdmissionStatusEnum.WAIT_ADMISSION.getDesc());
                continue;
            }
            if (!docAdvisoryRecordVo.getStatus().equals(AdmissionStatusEnum.PASSNUMBER.getValue())) continue;
            docAdvisoryRecordVo.setStatusDesc(AdmissionStatusEnum.PASSNUMBER.getDesc());
        }
        log.info("voList:{}" + JSONObject.toJSONString((Object)voList));
        for (DocAdvisoryRecordVo docAdvisoryRecordVo : voList) {
            String key = "byh_" + docAdvisoryRecordVo.getAimId() + "_" + docAdvisoryRecordVo.getPatientId() + "_" + docAdvisoryRecordVo.getServType() + "_" + docAdvisoryRecordVo.getOrganId() + "_" + docAdvisoryRecordVo.getStatusDesc() + "_" + docAdvisoryRecordVo.getDoctorType() + "_" + docAdvisoryRecordVo.getKeepOrder();
            log.info("key:{}" + key);
            if (map.containsKey(key)) continue;
            map.put(key, docAdvisoryRecordVo);
        }
        pages.getResult().clear();
        for (Map.Entry entry : map.entrySet()) {
            log.info("key2:{}" + (String)entry.getKey());
            pages.getResult().add(entry.getValue());
        }
        log.info("queryDoctorIms\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)pages.getResult()));
        PageUtil advisoryPages = new PageUtil((List)pages);
        List list = advisoryPages.getList();
        for (DocAdvisoryRecordVo imItem : list) {
            imItem.setTokenDoctorId(param.getDoctorId());
            this.perfectInfo(imItem);
        }
        if (Objects.equals("NCZK", param.getAppCode())) {
            list.sort(Comparator.comparing(DocAdvisoryRecordVo::getCreateTime).reversed());
        } else {
            list.sort(Comparator.comparing(DocAdvisoryRecordVo::getUpdateTime).reversed());
        }
        return BaseResponse.success((Object)advisoryPages);
    }

    private void perfectInfo(DocAdvisoryRecordVo imItem) {
        imItem.setServTypeDesc(ServiceTypeEnum.getDesc((Integer)imItem.getServType()));
        try {
            imItem.setAge(IDCardUtil.getAge((String)imItem.getIdCard()));
        }
        catch (Exception e) {
            imItem.setAge(IDCardUtil.getAgeByBirthDates((String)imItem.getBirthDates(), (String)"yyyy-MM-dd"));
        }
        if (imItem.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.REFUNDED_APPLY.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.RETIRED.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.EXPIRED.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.ADMIN_REFUNDED.getValue())) {
            imItem.setStatusDesc("\u5df2\u5931\u6548");
        } else if (imItem.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.REFERRAL.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.FINISH_TIME_OUT.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER.getValue())) {
            imItem.setStatusDesc(AdmissionStatusEnum.FINISH_APPLY.getDesc());
        } else if (imItem.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
            imItem.setStatusDesc(AdmissionStatusEnum.TO_BE_RECEIVED.getDesc());
        } else if (imItem.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
            imItem.setStatusDesc(AdmissionStatusEnum.IN_CONSULTATION.getDesc());
        } else if (imItem.getStatus().equals(AdmissionStatusEnum.WAIT_ADMISSION.getValue())) {
            imItem.setStatusDesc(AdmissionStatusEnum.WAIT_ADMISSION.getDesc());
        } else if (imItem.getStatus().equals(AdmissionStatusEnum.PASSNUMBER.getValue())) {
            imItem.setStatusDesc(AdmissionStatusEnum.PASSNUMBER.getDesc());
        }
        CheckInformStatusInfo parameter = new CheckInformStatusInfo();
        parameter.setAimId(imItem.getAimId());
        parameter.setCurrentDoctorId(imItem.getCurrentDoctorId());
        parameter.setDoctorType(imItem.getDoctorType());
        parameter.setTokenDoctorId(imItem.getTokenDoctorId());
        imItem.setInformStatus(Boolean.valueOf(true));
    }

    public BaseResponse<PageUtil<PatAdvisoryRecordVo>> queryPatAdvisoryRecord(PatAdvisoryRecordReq param) {
        List oldAdmissionEntityList = this.admissionMapper.getAdmissionInfoByUserId(param.getUserId(), param.getAppCode());
        log.info("oldAdmissionEntityList{}", (Object)JSON.toJSONString((Object)oldAdmissionEntityList));
        if (CollectionUtils.isEmpty((Collection)oldAdmissionEntityList)) {
            ArrayList advisoryRecords = new ArrayList();
            PageUtil data = new PageUtil(advisoryRecords);
            return BaseResponse.success((Object)data);
        }
        Map<String, List<AdmissionEntity>> doctorIdAdmissionEntityMap = oldAdmissionEntityList.stream().collect(Collectors.groupingBy(AdmissionEntity::getDoctorId));
        ArrayList admissionEntityList = new ArrayList();
        doctorIdAdmissionEntityMap.keySet().forEach(doctorId -> {
            List admissionEntityListByDoctorGroup = (List)doctorIdAdmissionEntityMap.get(doctorId);
            Map<String, List<AdmissionEntity>> patientIdAdmissionEntityMap = admissionEntityListByDoctorGroup.stream().collect(Collectors.groupingBy(AdmissionEntity::getPatientId));
            patientIdAdmissionEntityMap.keySet().forEach(patientId -> {
                List tempAdmissionEntityList = (List)patientIdAdmissionEntityMap.get(patientId);
                Map<Integer, List<AdmissionEntity>> admissionEntityMap = tempAdmissionEntityList.stream().collect(Collectors.groupingBy(AdmissionEntity::getServType));
                admissionEntityMap.keySet().forEach(servType -> {
                    List admissionEntitiesByServType = (List)admissionEntityMap.get(servType);
                    Map<Integer, List<AdmissionEntity>> collect = admissionEntitiesByServType.stream().collect(Collectors.groupingBy(AdmissionEntity::getDoctorType));
                    collect.keySet().forEach(doctorType -> {
                        List admissionEntities = (List)collect.get(doctorType);
                        AdmissionEntity admissionEntity = (AdmissionEntity)admissionEntities.stream().sorted(Comparator.comparing(AdmissionEntity::getXCreateTime).reversed()).collect(Collectors.toList()).get(0);
                        admissionEntityList.add(admissionEntity);
                    });
                });
            });
        });
        List imList = this.convertAdmissionEntityListToPatAdvisoryRecordRes(admissionEntityList);
        Map aimInfos = this.getDoctorBaseInfo(imList);
        log.info("getDoctorBaseInfo\u5904\u7406\u540e\uff1a{}", (Object)JSON.toJSONString((Object)imList));
        List<Object> advisoryRecords = new ArrayList();
        for (PatAdvisoryRecordRes imItem : imList) {
            PatAdvisoryRecordVo record = this.perfectRecords(imItem, aimInfos);
            if (DoctorTypeEnum.TEAM.getValue().equals(imItem.getDoctorType())) {
                record.setGroupId(this.getSessionGroupId(imItem.getAdmId()));
                TeamDoctorInfoEntity teamDoctorInfoEntity = (TeamDoctorInfoEntity)this.teamDoctorInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)imItem.getAdmId())).last("limit 1"));
                if (Objects.nonNull(teamDoctorInfoEntity) && StringUtils.isNotEmpty((String)teamDoctorInfoEntity.getTeamName())) {
                    record.setDoctorName(teamDoctorInfoEntity.getTeamName());
                }
            }
            advisoryRecords.add(record);
        }
        advisoryRecords = advisoryRecords.stream().sorted(Comparator.comparing(PatAdvisoryRecordVo::getCreateTime).reversed()).collect(Collectors.toList());
        log.info("advisoryRecords:{}" + advisoryRecords.toString());
        PageUtil data = new PageUtil(advisoryRecords);
        return BaseResponse.success((Object)data);
    }

    private String getSessionGroupId(String admId) {
        IMBatchGetSessionReqVO imBatchGetSessionReqVO = new IMBatchGetSessionReqVO();
        ArrayList<String> admIds = new ArrayList<String>();
        admIds.add(admId);
        imBatchGetSessionReqVO.setBusiCode("zxzx");
        imBatchGetSessionReqVO.setTreatmentId(admIds);
        BaseResponse listBaseResponse = this.imApiFeignClient.batchGetSession(imBatchGetSessionReqVO);
        if (listBaseResponse.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listBaseResponse.getData()))) {
            return ((IMSessionRspVO)((List)listBaseResponse.getData()).get(0)).getGroupId();
        }
        return null;
    }

    private List<PatAdvisoryRecordRes> convertAdmissionEntityListToPatAdvisoryRecordRes(List<AdmissionEntity> admissionEntityList) {
        log.info("convertAdmissionEntityListToPatAdvisoryRecordRes\u5165\u53c2{}", (Object)admissionEntityList.toString());
        return admissionEntityList.stream().map(admissionEntity -> {
            PatAdvisoryRecordRes patAdvisoryRecordRes = new PatAdvisoryRecordRes();
            OrderEntity orderEntity = this.getOrderById(admissionEntity.getOrderId());
            patAdvisoryRecordRes.setAdmId(admissionEntity.getXId());
            patAdvisoryRecordRes.setDoctorId(admissionEntity.getDoctorId());
            if (null != orderEntity) {
                log.info("convertAdmissionEntityListToPatAdvisoryRecordRes\u67e5\u8be2\u51fa\u8ba2\u5355{}", (Object)orderEntity.toString());
                patAdvisoryRecordRes.setDoctorName(orderEntity.getDoctorName());
                patAdvisoryRecordRes.setOrganId(orderEntity.getHospitalId());
                patAdvisoryRecordRes.setServType(orderEntity.getServType());
                patAdvisoryRecordRes.setDoctorType(orderEntity.getDoctorType());
                patAdvisoryRecordRes.setOrganName(orderEntity.getHospitalName());
                patAdvisoryRecordRes.setDepartment(orderEntity.getDeptName());
            }
            patAdvisoryRecordRes.setCreateTime(admissionEntity.getXCreateTime());
            if (orderEntity.getStatus().equals(OrderStatusEnum.CANCEL.getValue())) {
                patAdvisoryRecordRes.setStatus(OrderStatusEnum.CANCEL.getValue());
                patAdvisoryRecordRes.setStatusDesc(OrderStatusEnum.CANCEL.getDesc());
            } else if (orderEntity.getStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                patAdvisoryRecordRes.setStatus(AdmissionStatusEnum.EXPIRED.getValue());
                patAdvisoryRecordRes.setStatusDesc(AdmissionStatusEnum.EXPIRED.getDesc());
            } else {
                patAdvisoryRecordRes.setStatus(admissionEntity.getStatus());
                patAdvisoryRecordRes.setStatusDesc(AdmissionStatusEnum.getDesc((Integer)admissionEntity.getStatus()));
            }
            return patAdvisoryRecordRes;
        }).collect(Collectors.toList());
    }

    private Map<String, ImInfosRes> getDoctorBaseInfo(List<PatAdvisoryRecordRes> imList) {
        ArrayList<ImInfosParameter> docImInfos = new ArrayList<ImInfosParameter>();
        for (PatAdvisoryRecordRes imItem : imList) {
            ImInfosParameter imInfosParameter = new ImInfosParameter();
            imInfosParameter.setAdmissionId(imItem.getAdmId());
            imInfosParameter.setOrganId(imItem.getOrganId());
            imInfosParameter.setAimId(imItem.getDoctorId());
            docImInfos.add(imInfosParameter);
        }
        ImInfosReq imInfosReq = new ImInfosReq();
        imInfosReq.setImInfos(docImInfos);
        List docRes = this.getDocImInfos(imInfosReq);
        HashMap<String, ImInfosRes> aimInfosMap = new HashMap<String, ImInfosRes>(10);
        for (ImInfosRes imInfosRes : docRes) {
            aimInfosMap.put(imInfosRes.getAdmissionId(), imInfosRes);
        }
        return aimInfosMap;
    }

    private PatAdvisoryRecordVo perfectRecords(PatAdvisoryRecordRes imItem, Map<String, ImInfosRes> aimInfos) {
        String admissionId = imItem.getAdmId();
        PatAdvisoryRecordVo record = new PatAdvisoryRecordVo();
        ImInfosRes aimInfo = aimInfos.get(admissionId);
        if (aimInfo == null) {
            aimInfo = new ImInfosRes();
        }
        record.setAdmId(admissionId);
        record.setCreateTime(imItem.getCreateTime());
        record.setDoctorType(imItem.getDoctorType());
        record.setOrganName(imItem.getOrganName());
        record.setStatus(imItem.getStatus());
        record.setServType(imItem.getServType());
        log.info("item:{}", (Object)imItem);
        if (null != imItem.getStatus()) {
            if (imItem.getStatus().equals(AdmissionStatusEnum.REFUNDED_APPLY.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.RETIRED.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.EXPIRED.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.ADMIN_REFUNDED.getValue()) || imItem.getStatus().equals(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue())) {
                record.setStatusDesc("\u5df2\u5931\u6548");
            } else if (imItem.getStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                record.setStatusDesc("\u5df2\u5931\u6548");
            } else if (imItem.getStatus().equals(OrderStatusEnum.CANCEL.getValue())) {
                record.setStatusDesc("\u5df2\u5931\u6548");
            } else {
                record.setStatusDesc(AdmissionStatusEnum.getDesc((Integer)imItem.getStatus()));
            }
        }
        record.setDepartment(imItem.getDepartment());
        record.setDoctorName(imItem.getDoctorName());
        record.setProtrait(aimInfo.getPortrait());
        return record;
    }

    private List<ImInfosRes> getDocImInfos(ImInfosReq docImInfos) {
        if (docImInfos.getImInfos().isEmpty()) {
            return new ArrayList<ImInfosRes>();
        }
        log.info("getDocImInfos\u83b7\u53d6\u5230\u533b\u751f\u4fe1\u606f\u5165\u53c2:" + docImInfos.toString());
        BaseResponse result = this.doctorInfofeignClient.queryDoctorImInfos(docImInfos);
        if (result.getData() == null) {
            return new ArrayList<ImInfosRes>();
        }
        log.info("getDocImInfos\u83b7\u53d6\u5230\u533b\u751f\u4fe1\u606f\u51fa\u53c2:" + result.toString());
        return (List)result.getData();
    }

    private boolean setStatusList(DocAdvisoryRecordReq param) {
        if (param.getKeyWord() != null) {
            return true;
        }
        Integer[] statusTypes = new Integer[]{AdmissionStatusEnum.REFUNDED_REFUSE.getValue(), AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue(), AdmissionStatusEnum.REFUNDED_APPLY.getValue(), AdmissionStatusEnum.FINISH_APPLY.getValue(), AdmissionStatusEnum.FINISH_TIME_OUT.getValue(), AdmissionStatusEnum.TO_BE_RECEIVED.getValue(), AdmissionStatusEnum.IN_CONSULTATION.getValue(), AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue(), AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue(), AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue(), AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue(), AdmissionStatusEnum.REFERRAL.getValue(), AdmissionStatusEnum.REFERRAL_MANAGER.getValue(), AdmissionStatusEnum.PASSNUMBER_REFUND.getValue(), AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue(), AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue(), AdmissionStatusEnum.PASSNUMBER.getValue(), AdmissionStatusEnum.ADMIN_REFUNDED.getValue()};
        param.setStatusTypes(statusTypes);
        return true;
    }

    public BaseResponse<ImAccountVo> queryImAccount(ImAccountReqVo param) {
        if ("EHOS_DOCTOR".equals(param.getImAppCode())) {
            param.setImAppCode("EHOS_PATIENT");
        } else if ("EHOS_PATIENT".equals(param.getImAppCode())) {
            param.setImAppCode("EHOS_DOCTOR");
        }
        if (StringUtils.isEmpty((String)param.getOrderId()) && StringUtils.isEmpty((String)param.getAdmissionId())) {
            return BaseResponse.error((String)"\u4e0d\u80fdadmssionId\u548corderId\u90fd\u4e3a\u7a7a");
        }
        String admissionId = param.getAdmissionId();
        if (!StringUtils.isEmpty((String)param.getOrderId()) && StringUtils.isEmpty((String)param.getAdmissionId())) {
            admissionId = this.admissionMapper.queryAdmByOrderId(param.getOrderId()).getXId();
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findByAdmId(admissionId);
        if (StringUtils.isEmpty((String)param.getDoctorId())) {
            param.setDoctorId(admissionEntity.getDoctorId());
        }
        return BaseResponse.success((Object)this.getImAccounts(admissionId, param.getImAppCode(), param.getDoctorId()));
    }

    public ImAccountVo getImAccounts(String admId, String imAppCode, String doctorId) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        ImAccountVo admission = new ImAccountVo();
        admission.setDoctorType(admissionEntity.getDoctorType());
        IMQueryTargetSdkAccountRspVO imAccountRes = this.imAccountService.queryImAccount(admId, imAppCode, doctorId);
        if (imAccountRes == null) {
            OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
            this.payAsyncService.createImSession(orderEntity, admissionEntity);
            IMQueryTargetSdkAccountRspVO imAccountRes1 = this.imAccountService.queryImAccount(admId, imAppCode, doctorId);
            if (imAccountRes1 == null) {
                log.info("IM ERROR \u6ca1\u6709\u67e5\u8be2\u5230IM\u8d26\u6237-admId:{}", (Object)admId);
                return admission;
            }
            log.info("imAccountRes1:{}" + JSON.toJSONString((Object)imAccountRes1));
            if ("EHOS_DOCTOR".equals(imAppCode)) {
                admission.setDocImAccount(imAccountRes1.getSdkAccount());
            } else if ("EHOS_PATIENT".equals(imAppCode)) {
                admission.setPatImAccount(imAccountRes1.getSdkAccount());
            }
            admission.setRoomNum(Long.valueOf(imAccountRes1.getRoomNum()));
            if (DoctorTypeEnum.TEAM.getValue().equals(admissionEntity.getDoctorType())) {
                admission.setGroupId(this.getSessionGroupId(admId));
                List list = this.getTeamImAccounts(admId, "EHOS_DOCTOR");
                admission.setTeamImAccount(list);
            }
            return admission;
        }
        log.info("imAccountRes:{}" + JSON.toJSONString((Object)imAccountRes));
        if ("EHOS_DOCTOR".equals(imAppCode)) {
            admission.setDocImAccount(imAccountRes.getSdkAccount());
        } else if ("EHOS_PATIENT".equals(imAppCode)) {
            admission.setPatImAccount(imAccountRes.getSdkAccount());
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionEntity.getDoctorType())) {
            admission.setGroupId(this.getSessionGroupId(admId));
            List list = this.getTeamImAccounts(admId, "EHOS_DOCTOR");
            admission.setTeamImAccount(list);
        }
        admission.setRoomNum(Long.valueOf(imAccountRes.getRoomNum()));
        return admission;
    }

    private List<TeamImAccount> getTeamImAccounts(String admId, String imAppCode) {
        List list = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admId));
        ArrayList<TeamImAccount> teamImAccounts = new ArrayList<TeamImAccount>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TeamDoctorInfoEntity teamDoctorInfoEntity : list) {
                TeamImAccount teamImAccount = new TeamImAccount();
                IMQueryTargetSdkAccountRspVO imAccountRes = this.imAccountService.queryImAccount(admId, imAppCode, teamDoctorInfoEntity.getDoctorId());
                teamImAccount.setImAccount(imAccountRes.getSdkAccount());
                teamImAccount.setDoctorName(teamDoctorInfoEntity.getDoctorName());
                teamImAccount.setPortrait(teamDoctorInfoEntity.getPortrait());
                teamImAccount.setTitle(teamDoctorInfoEntity.getTitle());
                teamImAccounts.add(teamImAccount);
            }
        }
        return teamImAccounts;
    }

    public AdmissionInfoVo findInfo(AdmissionInfoParam admissionInfoParam) {
        return this.admissionMapper.findInfo(admissionInfoParam);
    }

    public BaseResponse<FollowUpCaseRecord> queryFollowUpCaseRecord(QueryAppealOrderTypeDTO param) {
        FollowUpCaseRecord followUpCaseRecord = new FollowUpCaseRecord();
        OrderEntity orderEntity = this.orderMapper.findByAdmId(param.getAdmissionId());
        if (null == orderEntity) {
            return BaseResponse.error((String)"\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        if (null == patientEntity) {
            return BaseResponse.error((String)"\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25");
        }
        followUpCaseRecord.setPatientName(patientEntity.getPatientName());
        followUpCaseRecord.setDeptId(orderEntity.getDeptId().toString());
        followUpCaseRecord.setDeptName(orderEntity.getDeptName());
        followUpCaseRecord.setPatientGender(patientEntity.getGender());
        Integer age = IDCardUtil.getAge((String)patientEntity.getIdcard());
        followUpCaseRecord.setPatientAge(age);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = simpleDateFormat.format(new Date());
        followUpCaseRecord.setPrescriptionDate(date);
        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(param.getAdmissionId());
        if (null != entityVo && StringUtils.isNotEmpty((String)entityVo.getPrimaryDiagno())) {
            followUpCaseRecord.setIcdName(entityVo.getPrimaryDiagno());
            String[] names = entityVo.getPrimaryDiagno().split(";");
            List<String> namesList = Arrays.asList(names);
            log.info("namesList:{}", (Object)JSONObject.toJSONString(namesList));
            List codeList = this.icdMapper.selctCodeByName(namesList);
            log.info("codeList:{}", (Object)JSONObject.toJSONString((Object)codeList));
            String code = StringUtils.join((Collection)codeList, (String)";");
            followUpCaseRecord.setIcdCode(code);
        }
        return BaseResponse.success((Object)followUpCaseRecord);
    }

    public BaseResponse<String> updateRefuseAdm(UpdateRefuseAdmDTO param) {
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmId());
        if (admission == null) {
            return BaseResponse.error((String)"\u4e0d\u5b58\u5728\u7684\u5c31\u8bca\u8bb0\u5f55");
        }
        if (!AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus())) {
            return BaseResponse.error((String)"\u975e\u53ef\u62d2\u7edd\u7684\u5c31\u8bca\u8bb0\u5f55");
        }
        if (!this.refuseAdmissionFail(admission, param)) {
            return BaseResponse.error((String)"\u53d6\u6d88\u5c31\u8bca\u5931\u8d25");
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admission.getOrderId()));
        return BaseResponse.success();
    }

    private boolean refuseAdmissionFail(AdmissionEntity admission, UpdateRefuseAdmDTO param) {
        OrderEntity orderEntity = this.getOrderById(admission.getOrderId());
        if ("130134".equals(orderEntity.getOrganId()) && "3".equals(orderEntity.getFundType())) {
            admission.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admission.setMessage(param.getMessage());
            admission.setEndTime(new Date());
            admission.setLastStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admission.setXRemark(param.getMessage());
        } else {
            if (!this.refund(admission.getXId())) {
                return false;
            }
            admission.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admission.setMessage(param.getMessage());
            admission.setEndTime(new Date());
            admission.setXRemark(param.getMessage());
        }
        if (!this.updateAdmission(admission).booleanValue()) {
            return false;
        }
        if (StringUtils.isEmpty((String)param.getDoctorId())) {
            param.setDoctorId(admission.getDoctorId());
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    private boolean refund(String admId) {
        AdmissionEntity admission = this.admissionMapper.findById(admId);
        if (admission == null) {
            log.error("\u533b\u751f\u62d2\u7edd\u9000\u6b3e\u5931\u8d25\uff0c\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u5c31\u8bca\u8bb0\u5f55ID\uff1a{}", (Object)admId);
            return false;
        }
        OrderEntity order = this.orderMapper.findById(admission.getOrderId());
        RequestRefundVo requestRefundVo = new RequestRefundVo();
        requestRefundVo.setOrderId(order.getXId());
        BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
        return baseResponse.isSuccess();
    }

    private Boolean updateAdmission(AdmissionEntity entity) {
        if (this.admissionMapper.update(entity) != 1) {
            return false;
        }
        return true;
    }

    public BaseResponse<UpdateAdmissionDTO> updateFinishAdm(UpdateAdmissionDTO param) {
        String redisKey;
        Boolean flag;
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmId());
        OrderEntity orderEntity = this.orderMapper.findByAdmId(param.getAdmId());
        log.info("admission:" + JSON.toJSONString((Object)admission));
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus())) {
            return BaseResponse.error((String)"\u975e\u53ef\u7ed3\u675f\u7684\u5c31\u8bca\u8bb0\u5f55");
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admission.getDoctorType()) && (flag = Boolean.valueOf(this.redisTemplateService.addLockNew(redisKey = param.getAdmId() + "_YSJS", redisKey, 600L))).booleanValue()) {
            log.info("\u8be5\u8ba2\u5355\u5df2\u7ed3\u675f");
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ed3\u675f");
        }
        admission.setEndTime(new Date());
        admission.setStatus(AdmissionStatusEnum.FINISH_APPLY.getValue());
        if (Objects.nonNull(orderEntity.getKeepOrder())) {
            ZkbgRefundVo zkbgRefundVo = new ZkbgRefundVo();
            zkbgRefundVo.setAdmId(param.getAdmId());
            zkbgRefundVo.setStatus("2");
            this.zkbgService.refund(zkbgRefundVo);
            return BaseResponse.success();
        }
        if (this.updateAdmission(admission).booleanValue()) {
            this.iMInformService.initiativeFinish(param.getAdmId());
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.umAppPushService.onlineCompletionAppPush(admission.getXId());
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admission.getOrderId()));
            return BaseResponse.success((Object)param);
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }

    public BaseResponse<DocAdvisoryDetailVo> queryDocAdvisoryDetail(AdvisoryDetailDTO param) {
        List medicalSortVoList;
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmId());
        if (admission == null) {
            return BaseResponse.error((String)"\u672a\u627e\u5230\u5c31\u8bca\u8bb0\u5f55");
        }
        DocAdvisoryDetailVo advisoryDetail = new DocAdvisoryDetailVo();
        this.setAdmissionInfo(advisoryDetail, admission);
        this.setAdvisoryTime(advisoryDetail, admission);
        this.setPatientInfo((AdvisoryDetailVo)advisoryDetail, admission.getPatientId());
        this.setRecordInfo((AdvisoryDetailVo)advisoryDetail, admission.getMedicalRecordId());
        PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = this.internetHospitalDetailInfoService.getMedicalInfoById(admission.getMedicalRecordId());
        if (Objects.nonNull(patientDynamicMedicalEntityVo) && !CollectionUtils.isEmpty((Collection)(medicalSortVoList = this.internetHospitalDetailInfoService.getMedicalUserFills(patientDynamicMedicalEntityVo.getServType(), patientDynamicMedicalEntityVo.getMedicalDetail(), patientDynamicMedicalEntityVo.getHospitalId(), patientDynamicMedicalEntityVo.getDeptId())))) {
            advisoryDetail.setMedicalUserFills(medicalSortVoList);
        }
        OrderEntity orderEntity = this.getOrderById(admission.getOrderId());
        advisoryDetail.setOrganId(orderEntity.getOrganId());
        advisoryDetail.setOrderSeq(orderEntity.getOrderSeq());
        advisoryDetail.setDealSeq(orderEntity.getDealSeq());
        advisoryDetail.setPayTime(orderEntity.getPaymentTime());
        advisoryDetail.setPayMethod(orderEntity.getPayMethod());
        advisoryDetail.setPayAmount(orderEntity.getPayAmount());
        advisoryDetail.setCreateOrderTime(orderEntity.getXCreateTime());
        advisoryDetail.setScheduleDate(orderEntity.getScheduleDate());
        advisoryDetail.setScheduleRange(orderEntity.getScheduleRange());
        advisoryDetail.setScheduleStartTime(orderEntity.getScheduleStartTime());
        advisoryDetail.setScheduleEndTime(orderEntity.getScheduleEndTime());
        advisoryDetail.setServType(orderEntity.getServType());
        advisoryDetail.setDoctorId(orderEntity.getDoctorId());
        advisoryDetail.setKeepOrder(orderEntity.getKeepOrder());
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.medicalRecordMapper.findById(admission.getMedicalRecordId());
        if (null != patientMedicalRecordEntity) {
            log.info("patientMedicalRecordEntity:{}" + patientMedicalRecordEntity.toString());
            advisoryDetail.setLastDeptName(patientMedicalRecordEntity.getDeptName());
            advisoryDetail.setLastDoctorName(patientMedicalRecordEntity.getDoctorName());
            advisoryDetail.setMedicalRecordNo(patientMedicalRecordEntity.getMedicalRecordNo());
        }
        this.getdoctorTeam(param, admission, advisoryDetail);
        this.setMedicalOrdersInfo((AdvisoryDetailVo)advisoryDetail, param.getAdmId());
        if (DoctorTypeEnum.TEAM.getValue().equals(admission.getDoctorType())) {
            advisoryDetail.setGroupId(this.getSessionGroupId(param.getAdmId()));
        }
        advisoryDetail.setMedicalRecordNo(admission.getMedicalRecordId());
        return BaseResponse.success((Object)advisoryDetail);
    }

    private void getdoctorTeam(AdvisoryDetailDTO param, AdmissionEntity admission, DocAdvisoryDetailVo advisoryDetail) {
        String doctor = admission.getDoctorId();
        List getPersonTeamResVoList = this.patientMedicalRecordService.personTeam(param.getAccessToken(), doctor);
        log.info("getPersonTeamResVoList:{}" + getPersonTeamResVoList.toString());
        ArrayList<Long> teamIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)getPersonTeamResVoList)) {
            advisoryDetail.setTeamId(teamIds);
        } else {
            for (GetPersonTeamResVo getPersonTeamResVo : getPersonTeamResVoList) {
                List getPersonTeamDetialResVoList = getPersonTeamResVo.getTeamList();
                log.info("getPersonTeamDetialResVoList\uff1a" + getPersonTeamDetialResVoList.toString());
                getPersonTeamDetialResVoList = getPersonTeamDetialResVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GetPersonTeamDetialResVo>(Comparator.comparing(GetPersonTeamDetialResVo::getTeamId))), ArrayList::new));
                log.info("getPersonTeamDetialResVoList\uff1a" + getPersonTeamDetialResVoList.toString());
                for (GetPersonTeamDetialResVo getPersonTeamDetialResVo : getPersonTeamDetialResVoList) {
                    Long teamId = getPersonTeamDetialResVo.getTeamId();
                    teamIds.add(teamId);
                }
            }
            log.info("teamIds\uff1a" + ((Object)teamIds).toString());
            advisoryDetail.setTeamId(teamIds);
        }
    }

    private void setMedicalOrdersInfo(AdvisoryDetailVo advisoryDetail, String admId) {
        advisoryDetail.setHasInHospital(Boolean.valueOf(false));
        advisoryDetail.setHasOeorder(Boolean.valueOf(false));
        advisoryDetail.setHasDrugAdvice(Boolean.valueOf(false));
    }

    private void setAdvisoryTime(DocAdvisoryDetailVo advisoryDetail, AdmissionEntity admission) {
        Integer visitedTime = this.admissionMapper.queryAdvisoryTime(admission.getDoctorId(), admission.getPatientId(), admission.getOrganId());
        advisoryDetail.setVisitedTime(visitedTime);
    }

    private void setAdmissionInfo(DocAdvisoryDetailVo advisoryDetail, AdmissionEntity admission) {
        advisoryDetail.setOrderId(admission.getOrderId());
        advisoryDetail.setPatientId(admission.getPatientId());
        advisoryDetail.setStartTime(admission.getStartTime());
        advisoryDetail.setEndTime(admission.getEndTime());
        advisoryDetail.setDoctorType(admission.getDoctorType());
        this.setDocAdvisoryDetailVoStatus(advisoryDetail, admission, admission.getOrderId());
        List entities = this.admissionMapper.findRecentById(admission.getDoctorId(), admission.getOrganId(), admission.getPatientId());
        if (entities.isEmpty()) {
            log.info("\u672a\u67e5\u8be2\u5230\u6700\u65b0\u8bb0\u5f55\uff0cdoctor_id{}\uff0corgan_id{}\uff0cpatient_id{}", new Object[]{admission.getDoctorId(), admission.getOrganId(), admission.getPatientId()});
            advisoryDetail.setRecentAdmId(admission.getXId());
            return;
        }
        advisoryDetail.setRecentAdmId(((AdmissionEntity)entities.get(0)).getXId());
    }

    private void setDocAdvisoryDetailVoStatus(DocAdvisoryDetailVo advisoryDetail, AdmissionEntity admission, String orderId) {
        OrderEntity order = this.orderMapper.findById(orderId);
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.TO_CONSULTATION.getValue());
            advisoryDetail.setStatusDesc(DoctorNetinquiryOrderStatusEnum.TO_CONSULTATION.getDesc());
            advisoryDetail.setNowTime(new Date());
            InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
            wrapperEntity.setDoctorId(admission.getDoctorId());
            wrapperEntity.setDeptId(order.getDeptId());
            wrapperEntity.setOrganId(String.valueOf(admission.getOrganId()));
            if (ServiceTypeEnum.NOS.getValue().equals(admission.getServType())) {
                wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
            }
            if (ServiceTypeEnum.HOS.getValue().equals(admission.getServType())) {
                wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
            }
            log.info("wrapperEntity:{}" + JSON.toJSONString((Object)wrapperEntity));
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.setEntity((Object)wrapperEntity);
            queryWrapper1.last("limit 1");
            InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper1);
            if (null == inquiryServiceConfigEntity) {
                log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606f");
                return;
            }
            log.info("\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
            log.info("setDocAdvisoryDetailVoStatus\u54a8\u8be2\u8be6\u60c5order:{}", (Object)JSON.toJSONString((Object)order));
            if (null != order.getScheduleDate()) {
                String expiredTime = DateUtils.dateToSimpleString((Date)order.getScheduleDate()) + " " + order.getScheduleEndTime() + ":00";
                advisoryDetail.setExpiredTime(DateUtils.stringToFullDate((String)expiredTime));
            } else if (null != inquiryServiceConfigEntity.getOrderTime()) {
                log.info("order.getPaymentTime():{}" + order.getPaymentTime());
                log.info("order.getPaymentTime().getTime():{}" + order.getPaymentTime().getTime());
                int addMinutes = inquiryServiceConfigEntity.getOrderTime();
                Date paymentTime = order.getPaymentTime();
                Date date = DateUtils.dateAddMinutes((Date)paymentTime, (int)addMinutes);
                log.info("date:{}" + date.getTime());
                advisoryDetail.setExpiredTime(date);
            } else {
                log.info("order.getPaymentTime():{}" + order.getPaymentTime());
                log.info("order.getPaymentTime().getTime():{}" + order.getPaymentTime().getTime());
                Date date = DateUtils.getDateAfter((Date)order.getPaymentTime(), (int)1);
                log.info("date:{}" + date.getTime());
                advisoryDetail.setExpiredTime(date);
            }
            OrderEntity orderEntity1 = this.orderMapper.findByAdmId(admission.getXId());
            if (null == orderEntity1) {
                log.info("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            log.info("orderEntity1:{}" + JSONObject.toJSONString((Object)orderEntity1));
            if (Objects.equals(orderEntity1.getKeepOrder(), 1) || Objects.equals(orderEntity1.getKeepOrder(), 2)) {
                advisoryDetail.setExpiredTime(admission.getEndTime());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            OrderEntity entity = new OrderEntity();
            entity.setDealSeq(orderEntity1.getDealSeq());
            queryWrapper.setEntity((Object)entity);
            List orderList = this.orderMapper.selectList((Wrapper)queryWrapper);
            log.info("orderList:{}" + JSONObject.toJSONString((Object)orderList));
            if (orderList.size() == 1) {
                advisoryDetail.setIsReferred(WhetherEnum.FORBID.getValue());
            } else {
                advisoryDetail.setIsReferred(WhetherEnum.ALLOW.getValue());
                AdmissionEntity admissionEntity = this.admissionMapper.findById(admission.getXId());
                log.info("\u8f6c\u8bca\u7684AdmId:{}", (Object)admission.getXId());
                log.info("\u8f6c\u8bca\u7684admissionEntity\uff1a{}", (Object)JSON.toJSONString((Object)admissionEntity));
                int addMinutes = inquiryServiceConfigEntity.getOrderTime();
                Date date = DateUtils.dateAddMinutes((Date)admissionEntity.getXCreateTime(), (int)addMinutes);
                log.info("\u8f6c\u8bca\u7684\u5012\u8ba1\u65f6date:{}", (Object)date.getTime());
                advisoryDetail.setExpiredTime(date);
            }
            log.info("queryDocAdvisoryDetail\u63a5\u53e3,\u8fd4\u56de\u7684\u5012\u8ba1\u65f6,{}", (Object)JSON.toJSONString((Object)advisoryDetail.getExpiredTime().getTime()));
            ImAccountVo imAccountVo = this.getImAccounts(admission.getXId(), "EHOS_PATIENT", admission.getDoctorId());
            advisoryDetail.setPatImAccount(imAccountVo.getPatImAccount());
        } else if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStartTime(admission.getStartTime());
            advisoryDetail.setEndTime(admission.getEndTime());
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.IN_CONSULTATION.getValue());
            advisoryDetail.setStatusDesc(DoctorNetinquiryOrderStatusEnum.IN_CONSULTATION.getDesc());
            advisoryDetail.setNowTime(new Date());
        } else if (AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.PASSNUMBER_REFUND.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.ADMIN_REFUNDED.getValue().equals(admission.getStatus())) {
            if (OrderStatusEnum.REFUNDING.getValue().equals(order.getStatus())) {
                advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.REQUEST_REFUNDING.getValue());
                advisoryDetail.setStatusDesc("\u5df2\u5931\u6548");
            } else {
                advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.REQUEST_REFUND.getValue());
                advisoryDetail.setStatusDesc("\u5df2\u5931\u6548");
            }
        } else if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.REFUSE_ADMISSION.getValue());
            advisoryDetail.setStatusDesc("\u5df2\u5931\u6548");
        } else if (AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
            advisoryDetail.setStatusDesc("\u5df2\u5931\u6548");
        } else if (AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.ZERO_REFUSE_REFUND.getValue());
            advisoryDetail.setStatusDesc("\u5df2\u5931\u6548");
        } else if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.ADMISSION_NOT_HANDLE.getValue());
            advisoryDetail.setStatusDesc("\u5df2\u5931\u6548");
        } else if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.END_CONSULTATION.getValue());
            advisoryDetail.setStatusDesc(DoctorNetinquiryOrderStatusEnum.END_CONSULTATION.getDesc());
        } else if (AdmissionStatusEnum.REFERRAL.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.REFERRAL_MANAGER.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.REFERRAL.getValue());
            advisoryDetail.setStatusDesc(DoctorNetinquiryOrderStatusEnum.REFERRAL.getDesc());
            QueryWrapper query = new QueryWrapper();
            ReferralInfoEntity entity1 = new ReferralInfoEntity();
            entity1.setOrderId(admission.getOrderId());
            query.setEntity((Object)entity1);
            ReferralInfoEntity referralInfoEntity = (ReferralInfoEntity)this.referralInfoMapper.selectOne((Wrapper)query);
            advisoryDetail.setIsReferred(WhetherEnum.ALLOW.getValue());
            advisoryDetail.setReferredId(referralInfoEntity.getId().toString());
        } else if (AdmissionStatusEnum.PASSNUMBER.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.PASS_NUMBER.getValue());
            advisoryDetail.setStatusDesc(DoctorNetinquiryOrderStatusEnum.PASS_NUMBER.getDesc());
        } else if (AdmissionStatusEnum.ADMIN_REFUNDED.getValue().equals(admission.getStatus())) {
            advisoryDetail.setStatus(DoctorNetinquiryOrderStatusEnum.ADMIN_REFUNDED.getValue());
            advisoryDetail.setStatusDesc(DoctorNetinquiryOrderStatusEnum.ADMIN_REFUNDED.getDesc());
        }
        ImAccountVo imAccountVo = this.getImAccounts(admission.getXId(), "EHOS_PATIENT", admission.getDoctorId());
        if (null != imAccountVo) {
            advisoryDetail.setDocImAccount(imAccountVo.getDocImAccount());
            advisoryDetail.setPatImAccount(imAccountVo.getPatImAccount());
        }
    }

    private void setPatientInfo(AdvisoryDetailVo advisoryDetail, String patientId) {
        PatientEntity patient = this.patientMapper.selectById(patientId);
        if (patient == null) {
            return;
        }
        Integer age = IDCardUtil.getAge((String)patient.getIdcard());
        advisoryDetail.setPatientAge(age);
        advisoryDetail.setPatientName(patient.getPatientName());
        advisoryDetail.setCardNo(patient.getCardNo());
        advisoryDetail.setIdCard(patient.getIdcard());
        Integer gender = patient.getGender();
        if (GenderEnum.FEMALE.getValue().equals(gender)) {
            advisoryDetail.setPatientGender(GenderEnum.FEMALE.getDesc());
        } else {
            advisoryDetail.setPatientGender(GenderEnum.MALE.getDesc());
        }
    }

    private void setRecordInfo(AdvisoryDetailVo advisoryDetail, String recordId) {
        PatientMedicalRecordEntity medicalRecord = this.medicalRecordMapper.findById(recordId);
        if (medicalRecord == null) {
            return;
        }
        advisoryDetail.setIllnessTime(medicalRecord.getIllnessTime());
        advisoryDetail.setMedicalRecordNo(medicalRecord.getMedicalRecordNo());
        advisoryDetail.setVisited(medicalRecord.getVisited());
        advisoryDetail.setDescription(medicalRecord.getDescription());
        advisoryDetail.setQuestion(medicalRecord.getQuestion());
        advisoryDetail.setTags(medicalRecord.getTags());
        List pictures = this.medicalPictureMapper.queryRecordPictures(recordId);
        advisoryDetail.setPictures(pictures);
    }

    public BaseResponse<PatAdvisoryDetailVo> queryPatAdvisoryDetail(PatAdvisoryDetailDTO param) {
        BaseResponse baseResponse;
        List medicalSortVoList;
        PatientEntity patientEntity;
        if (StringUtils.isBlank((String)param.getOrderId()) && StringUtils.isBlank((String)param.getAdmissionId()) && StringUtils.isBlank((String)param.getClinicCode())) {
            return BaseResponse.error((String)"\u5165\u53c2\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        AdmAndOrderInfo admAndOrderInfo = this.buildAdmAndOrderInfo(param);
        if (admAndOrderInfo == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        AdmissionDTO admissionEntity = admAndOrderInfo.getAdmissionDTO();
        OrderInfoDTO orderEntity = admAndOrderInfo.getOrderInfoDTO();
        PatAdvisoryDetailVo advisoryDetail = new PatAdvisoryDetailVo();
        advisoryDetail.setOrganId(orderEntity.getHospitalId());
        advisoryDetail.setOrderSeq(orderEntity.getOrderSeq());
        advisoryDetail.setDealSeq(orderEntity.getDealSeq());
        advisoryDetail.setPayTime(orderEntity.getPaymentTime());
        advisoryDetail.setPayMethod(orderEntity.getPayMethod());
        advisoryDetail.setPayAmount(orderEntity.getPayAmount());
        advisoryDetail.setCreateOrderTime(orderEntity.getXCreateTime());
        advisoryDetail.setPatientId(orderEntity.getPatientId());
        advisoryDetail.setDoctorId(orderEntity.getDoctorId());
        advisoryDetail.setDoctorName(orderEntity.getDoctorName());
        advisoryDetail.setDeptId(String.valueOf(orderEntity.getDeptId()));
        advisoryDetail.setOrderId(orderEntity.getXId());
        advisoryDetail.setRefundTime(orderEntity.getRefundTime());
        advisoryDetail.setPayCost(orderEntity.getPayCost());
        advisoryDetail.setTotCost(orderEntity.getTotCost());
        advisoryDetail.setOwnCost(orderEntity.getOwnCost());
        advisoryDetail.setPubCost(orderEntity.getPubCost());
        advisoryDetail.setPrice(orderEntity.getPrice());
        advisoryDetail.setDiscount(orderEntity.getDiscount());
        advisoryDetail.setRegLeve(orderEntity.getRegLeve());
        advisoryDetail.setFundType(orderEntity.getFundType());
        advisoryDetail.setMedicalUrl(orderEntity.getHisDocCode());
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.patientMedicalRecordMapper.findById(admissionEntity.getMedicalRecordId());
        advisoryDetail.setTags(patientMedicalRecordEntity.getTags());
        if (StringUtils.isNotEmpty((String)orderEntity.getInvoicePicture())) {
            advisoryDetail.setInvoicePicture(orderEntity.getInvoicePicture());
        }
        if (null == (patientEntity = this.patientMapper.selectById(orderEntity.getPatientId()))) {
            return BaseResponse.error((String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(orderEntity.getDoctorId());
        BaseResponse doctorDetailsVOBaseResponse = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVOBaseResponse || null == doctorDetailsVOBaseResponse.getData()) {
            log.error("\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519,\u5934\u50cf\u804c\u79f0\u672a\u8bbe\u7f6e{}", (Object)doctorDetailsVOBaseResponse.toString());
        } else {
            PersonnelInfo data = (PersonnelInfo)doctorDetailsVOBaseResponse.getData();
            advisoryDetail.setPortrait(data.getPortrait());
            advisoryDetail.setTitleName(data.getTitle());
        }
        advisoryDetail.setDeptName(orderEntity.getDeptName());
        advisoryDetail.setPayTime(orderEntity.getPaymentTime());
        advisoryDetail.setOrganName(orderEntity.getHospitalName());
        advisoryDetail.setDoctorType(orderEntity.getDoctorType());
        advisoryDetail.setMedicalRecordId(orderEntity.getMedicalRecordId());
        if (orderEntity.getScheduleDate() != null) {
            advisoryDetail.setScheduleDate(DateUtils.dateToSimpleString((Date)orderEntity.getScheduleDate()));
            advisoryDetail.setScheduleRange(orderEntity.getScheduleRange());
            advisoryDetail.setStartTime(orderEntity.getScheduleStartTime());
            advisoryDetail.setEndTime(orderEntity.getScheduleEndTime());
            String day = DateUtils.getForWeek((String)DateUtils.dateToSimpleString((Date)orderEntity.getScheduleDate()));
            log.info("day:{}" + day);
            advisoryDetail.setDay(day);
        }
        advisoryDetail.setPatientFinish(admissionEntity.getPatientFinish());
        advisoryDetail.setServType(orderEntity.getServType());
        advisoryDetail.setServCode(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        advisoryDetail.setDealSeq(orderEntity.getDealSeq());
        PatientDynamicMedicalEntityVo patientDynamicMedicalEntity = this.internetHospitalDetailInfoService.getMedicalInfoById(orderEntity.getMedicalRecordId());
        if (Objects.nonNull(patientDynamicMedicalEntity) && !CollectionUtils.isEmpty((Collection)(medicalSortVoList = this.internetHospitalDetailInfoService.getMedicalUserFills(patientDynamicMedicalEntity.getServType(), patientDynamicMedicalEntity.getMedicalDetail(), patientDynamicMedicalEntity.getHospitalId(), patientDynamicMedicalEntity.getDeptId())))) {
            advisoryDetail.setMedicalUserFills(medicalSortVoList);
        }
        advisoryDetail.setMedicalDetail(patientDynamicMedicalEntity.getMedicalDetail());
        this.setPatientInfo((AdvisoryDetailVo)advisoryDetail, orderEntity.getPatientId());
        this.setPatAdvisoryDetailVoStatus(advisoryDetail, orderEntity);
        this.setDoctorOrTeamInfo(advisoryDetail, orderEntity);
        this.setMedicalOrdersInfo((AdvisoryDetailVo)advisoryDetail, admissionEntity.getXId());
        advisoryDetail.setCurrentNum(admissionEntity.getCurrentNum());
        advisoryDetail.setTotalNum(admissionEntity.getTotalNum());
        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(param.getAdmissionId());
        if (null == entityVo) {
            log.info("\u75c5\u4f8b\u8be6\u60c5\u67e5\u4e3a\u7a7a,\u67e5\u8be2\u4e3a\u7a7a");
            advisoryDetail.setIsMedicalRecord(WhetherEnum.FORBID.getValue());
        } else {
            log.info("\u67e5\u8be2\u7684\u75c5\u4f8b\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)entityVo));
            advisoryDetail.setIsMedicalRecord(WhetherEnum.ALLOW.getValue());
            advisoryDetail.setFollowUpId(entityVo.getXId());
        }
        if (advisoryDetail.getVoStatus().equals(PatientNetinquiryOrderStatusEnum.FINISH_EVALUATED.getValue()) && null != (baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServiceTypeEnum.getCode((Integer)orderEntity.getServType()), admissionEntity.getXId(), null)) && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
            UcUserEvaluationVO ucUserEvaluationVO = (UcUserEvaluationVO)((List)baseResponse.getData()).get(0);
            UserEvaluationVO userEvaluationVO = new UserEvaluationVO();
            BeanUtils.copyProperties((Object)ucUserEvaluationVO, (Object)userEvaluationVO);
            advisoryDetail.setUserEvaluationVO(userEvaluationVO);
        }
        GetMainIdsReqVo getMainIdsReqVo = new GetMainIdsReqVo();
        getMainIdsReqVo.setAppCode(orderEntity.getAppCode());
        getMainIdsReqVo.setAdmissionId(admissionEntity.getXId());
        List invoceIds = this.internetHospitalDetailInfoService.getInvoceMainIdsByAdmIdAndAppCode(getMainIdsReqVo);
        List ids = this.internetHospitalDetailInfoService.getMainIdsByAdmIdAndAppCode(getMainIdsReqVo);
        advisoryDetail.setPrescriptIds(ids);
        advisoryDetail.setInvocePrescriptIds(invoceIds);
        return BaseResponse.success((Object)advisoryDetail);
    }

    private PatientDynamicMedicalEntityVo getMedicalFills(String medicalRecordId) {
        PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = this.internetHospitalDetailInfoService.getMedicalInfoById(medicalRecordId);
        if (null == patientDynamicMedicalEntityVo) {
            return null;
        }
        return patientDynamicMedicalEntityVo;
    }

    public BaseResponse<QueryMedicalRecordsVo> queryMedicalRecordsList(PatAdvisoryDetailDTO param) {
        PatientDynamicMedicalEntityVo medicalInfoById;
        NcefyDeptEntity ncefyDeptEntity;
        if (StringUtils.isBlank((String)param.getOrderId()) && StringUtils.isBlank((String)param.getAdmissionId()) && StringUtils.isBlank((String)param.getClinicCode())) {
            return BaseResponse.error((String)"\u53c2\u6570\u51fa\u9519");
        }
        AdmAndOrderInfo admAndOrderInfo = this.buildAdmAndOrderInfo(param);
        if (admAndOrderInfo == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        OrderInfoDTO orderEntity = admAndOrderInfo.getOrderInfoDTO();
        AdmissionDTO admissionEntity = admAndOrderInfo.getAdmissionDTO();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(orderEntity.getDoctorId());
        BaseResponse doctorDetailsVOBaseResponse = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVOBaseResponse || doctorDetailsVOBaseResponse.getData() == null) {
            return BaseResponse.error((String)"\u67e5\u8be2\u533b\u751f\u51fa\u9519");
        }
        PersonnelInfo data = (PersonnelInfo)doctorDetailsVOBaseResponse.getData();
        BaseResponse departmentDetail = this.departmentInfoApi.getDepartmentDetail(Long.valueOf(Long.parseLong(data.getDeptId().toString())));
        if (null == departmentDetail || departmentDetail.getData() == null) {
            return BaseResponse.error((String)"\u67e5\u8be2\u79d1\u5ba4\u51fa\u9519");
        }
        QueryMedicalRecordsVo queryMedicalRecordsVo = new QueryMedicalRecordsVo();
        queryMedicalRecordsVo.setPresDoctorId(data.getDoctorId().toString());
        queryMedicalRecordsVo.setPresDoctorName(data.getDoctorName());
        queryMedicalRecordsVo.setPresDoctorPhone(data.getPhoneNum());
        queryMedicalRecordsVo.setPresDeptName(data.getDeptName());
        queryMedicalRecordsVo.setPresDeptCode(data.getDeptId().toString());
        queryMedicalRecordsVo.setOrderPrice(orderEntity.getPayAmount());
        queryMedicalRecordsVo.setServType(orderEntity.getServType().toString());
        queryMedicalRecordsVo.setMedicalId(orderEntity.getMedicalRecordId());
        queryMedicalRecordsVo.setMerchantId(orderEntity.getMerchantId());
        queryMedicalRecordsVo.setPresDoctorCode(data.getEmplCode());
        queryMedicalRecordsVo.setOrderSeq(orderEntity.getDealSeq());
        queryMedicalRecordsVo.setDoctorType(orderEntity.getDoctorType().toString());
        queryMedicalRecordsVo.setHisDeptId(((DepartmentDetailVo)departmentDetail.getData()).getDeptCode());
        queryMedicalRecordsVo.setHisDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        queryMedicalRecordsVo.setInvoiceNo(orderEntity.getInvoiceNo());
        if (Objects.nonNull(orderEntity.getKeepOrder()) && Objects.equals("NCZK", orderEntity.getAppCode())) {
            MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)admissionEntity.getXId()));
            queryMedicalRecordsVo.setElecOrder(medicalAdmissionRefEntity.getUniqueId());
            queryMedicalRecordsVo.setDrugList(medicalAdmissionRefEntity.getDrugs());
            queryMedicalRecordsVo.setStoreCode(medicalAdmissionRefEntity.getStoreCode());
            queryMedicalRecordsVo.setOrderType(orderEntity.getKeepOrder().toString());
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(orderEntity.getDoctorType())) {
            List teamDoctorInfo = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admissionEntity.getXId()));
            ArrayList<String> teamDoctorIds = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)teamDoctorInfo)) {
                for (TeamDoctorInfoEntity teamDoctorInfoEntity : teamDoctorInfo) {
                    teamDoctorIds.add(teamDoctorInfoEntity.getDoctorId());
                }
            } else {
                teamDoctorIds.add(orderEntity.getDoctorId());
            }
            queryMedicalRecordsVo.setTeamDoctorIds(teamDoctorIds);
        }
        if ("NCEFY".equals(orderEntity.getAppCode()) && null != (ncefyDeptEntity = this.ncefyDeptMapper.queryHisDeptName(data.getDeptId().toString()))) {
            queryMedicalRecordsVo.setHisDeptId(ncefyDeptEntity.getHisDeptId());
            queryMedicalRecordsVo.setHisDeptName(ncefyDeptEntity.getHisDeptName());
        }
        if ("HYT".equals(orderEntity.getAppCode()) && ServiceTypeEnum.NOS.getValue().equals(orderEntity.getServType()) && StringUtils.isEmpty((String)orderEntity.getClinicCode())) {
            return BaseResponse.error((String)"\u6302\u53f7\u5931\u8d25");
        }
        queryMedicalRecordsVo.setRegisterTime(orderEntity.getPaymentTime());
        if (null != orderEntity.getScheduleDate()) {
            queryMedicalRecordsVo.setRegisterTime(orderEntity.getScheduleDate());
        }
        PatientBaseInfoVo oneByPatientIdAndOrganId = this.patientMapper.findOneByPatientIdAndOrganId(orderEntity.getPatientId());
        if (data == null) {
            return BaseResponse.error((String)"\u75c5\u4eba\u4e0d\u5b58\u5728");
        }
        if (oneByPatientIdAndOrganId != null) {
            queryMedicalRecordsVo.setPatientId(orderEntity.getPatientId());
            if (StringUtils.isNotEmpty((String)orderEntity.getPatientUserId())) {
                queryMedicalRecordsVo.setPatientUserId(orderEntity.getPatientUserId());
            } else {
                queryMedicalRecordsVo.setPatientUserId(oneByPatientIdAndOrganId.getUserId());
            }
            queryMedicalRecordsVo.setPatientName(oneByPatientIdAndOrganId.getPatientName());
            queryMedicalRecordsVo.setPatientNo(orderEntity.getIdCard());
            queryMedicalRecordsVo.setPatientGender(oneByPatientIdAndOrganId.getGender().toString());
            queryMedicalRecordsVo.setPatientPhone(oneByPatientIdAndOrganId.getTelphone());
            queryMedicalRecordsVo.setBirthDates(AdmissionServiceImpl.dataParse((String)oneByPatientIdAndOrganId.getIdcard()));
            queryMedicalRecordsVo.setMedicalNO(oneByPatientIdAndOrganId.getMedicalNO());
            queryMedicalRecordsVo.setCardNo(oneByPatientIdAndOrganId.getCardNo());
            if (oneByPatientIdAndOrganId.getAge() != null) {
                queryMedicalRecordsVo.setPatientAge(oneByPatientIdAndOrganId.getAge().toString());
            }
        }
        if (oneByPatientIdAndOrganId == null) {
            PatientEntity oneByPatientId = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
            queryMedicalRecordsVo.setPatientGender(oneByPatientId.getGender().toString());
            queryMedicalRecordsVo.setBirthDates(AdmissionServiceImpl.dataParse((String)oneByPatientId.getIdcard()));
            queryMedicalRecordsVo.setPatientId(orderEntity.getPatientId());
            queryMedicalRecordsVo.setPatientPhone(oneByPatientId.getTelphone());
            if (StringUtils.isNotEmpty((String)orderEntity.getPatientUserId())) {
                queryMedicalRecordsVo.setPatientUserId(orderEntity.getPatientUserId());
            } else {
                queryMedicalRecordsVo.setPatientUserId(oneByPatientId.getUserId());
            }
            queryMedicalRecordsVo.setPatientName(oneByPatientId.getPatientName());
            queryMedicalRecordsVo.setPatientNo(orderEntity.getIdCard());
        }
        if (Objects.nonNull(medicalInfoById = this.internetHospitalDetailInfoService.getMedicalInfoById(orderEntity.getMedicalRecordId()))) {
            String medicalUserFills = medicalInfoById.getMedicalUserFills();
            ArrayList medicalInfoVos = new ArrayList();
            Map map = (Map)JSON.parse((String)medicalUserFills);
            log.info("map:{}" + Objects.toString(map, "I am null"));
            map.forEach((k, v) -> {
                MedicalInfoVo vo = new MedicalInfoVo();
                vo.setValue(v);
                vo.setKeywords(k);
                medicalInfoVos.add(vo);
            });
            log.info("medicalInfoVos{}", (Object)JSON.toJSONString(medicalInfoVos));
            if (!CollectionUtils.isEmpty(medicalInfoVos)) {
                for (MedicalInfoVo medicalInfoVo : medicalInfoVos) {
                    if ("cardNo".equals(medicalInfoVo.getKeywords()) && null != medicalInfoVo.getValue()) {
                        queryMedicalRecordsVo.setMedicalRecordNo(medicalInfoVo.getValue().toString());
                    }
                    if ("doctName".equals(medicalInfoVo.getKeywords()) && null != medicalInfoVo.getValue()) {
                        queryMedicalRecordsVo.setDoctorName(medicalInfoVo.getValue().toString());
                    }
                    if ("deptName".equals(medicalInfoVo.getKeywords()) && null != medicalInfoVo.getValue()) {
                        queryMedicalRecordsVo.setDeptName(medicalInfoVo.getValue().toString());
                    }
                    if (!"patientAge".equals(medicalInfoVo.getKeywords()) || null == medicalInfoVo.getValue()) continue;
                    queryMedicalRecordsVo.setPatientAge(medicalInfoVo.getValue().toString());
                }
            }
        }
        return BaseResponse.success((Object)queryMedicalRecordsVo);
    }

    private AdmAndOrderInfo buildAdmAndOrderInfo(PatAdvisoryDetailDTO param) {
        AdmissionEntity admissionEntity = null;
        OrderEntity orderEntity = null;
        if (StringUtils.isBlank((String)param.getAdmissionId())) {
            if (StringUtils.isBlank((String)param.getOrderId())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                OrderEntity orderEntity1 = new OrderEntity();
                orderEntity1.setClinicCode(param.getClinicCode());
                queryWrapper.setEntity((Object)orderEntity1);
                orderEntity = (OrderEntity)this.orderMapper.selectOne((Wrapper)queryWrapper);
                if (orderEntity == null) {
                    log.warn("\u65e0\u6cd5\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff1aclinicCode:{}", (Object)param.getClinicCode());
                    return null;
                }
                admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
                if (admissionEntity == null) {
                    admissionEntity = new AdmissionEntity();
                }
            } else {
                orderEntity = this.getOrderById(param.getOrderId());
                if (orderEntity == null) {
                    log.warn("\u65e0\u6cd5\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff1aorderId:{}", (Object)param.getOrderId());
                    return null;
                }
                admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
                if (admissionEntity == null) {
                    admissionEntity = new AdmissionEntity();
                }
            }
        } else {
            admissionEntity = this.admissionMapper.findById(param.getAdmissionId());
            if (admissionEntity == null) {
                log.warn("\u65e0\u6cd5\u83b7\u53d6\u5c31\u8bca\u4fe1\u606f\uff1aadmissionId:{}", (Object)param.getAdmissionId());
                return null;
            }
            orderEntity = this.getOrderById(admissionEntity.getOrderId());
            if (orderEntity == null) {
                log.warn("\u65e0\u6cd5\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff1aorderId:{}", (Object)admissionEntity.getOrderId());
                return null;
            }
        }
        AdmAndOrderInfo admAndOrderInfo = new AdmAndOrderInfo();
        AdmissionDTO admissionDTO = new AdmissionDTO();
        OrderInfoDTO orderInfoDTO = new OrderInfoDTO();
        log.info("\u8ba2\u5355\u8bb0\u5f55copy\u6e90\u6587\u4ef6" + orderEntity.toString());
        BeanUtils.copyProperties((Object)orderEntity, (Object)orderInfoDTO);
        log.info("\u8ba2\u5355\u8bb0\u5f55copy\u76ee\u6807\u6587\u4ef6" + orderInfoDTO.toString());
        BeanUtils.copyProperties((Object)admissionEntity, (Object)admissionDTO);
        admAndOrderInfo.setAdmissionDTO(admissionDTO);
        admAndOrderInfo.setOrderInfoDTO(orderInfoDTO);
        return admAndOrderInfo;
    }

    private void setDoctorOrTeamInfo(PatAdvisoryDetailVo vo, OrderInfoDTO order) {
        DocAllInfoDto param = new DocAllInfoDto();
        param.setDoctorId(order.getDoctorId());
        param.setOrganId(order.getOrganId());
        BaseResponse result = this.doctorInfofeignClient.findDoctorAllInfo(param);
        if ("1".equals(result.getErrCode())) {
            DoctorAllInfoVo doctorInfoVo = (DoctorAllInfoVo)result.getData();
            vo.setDoctorName(doctorInfoVo.getDoctorName());
            vo.setDeptName(doctorInfoVo.getDeptName());
            vo.setPortrait(doctorInfoVo.getPortrait());
            vo.setTitleName(doctorInfoVo.getHospitalTitle());
            vo.setOrganName(doctorInfoVo.getOrganName());
            vo.setOrganCode(doctorInfoVo.getOrganCode());
        }
    }

    private void setPatAdvisoryDetailVoStatus(PatAdvisoryDetailVo vo, OrderInfoDTO order) {
        if (OrderStatusEnum.TOPAY.getValue().equals(order.getStatus())) {
            vo.setDealSeq(order.getDealSeq());
            vo.setOrderSeq(order.getOrderSeq());
            vo.setMerchantSeq(order.getMerchantId());
            vo.setNowTime(new Date());
            vo.setExpiredTime(DateUtils.dateAddMinutes((Date)order.getXCreateTime(), (int)30));
            vo.setVoStatus(PatientNetinquiryOrderStatusEnum.TOPAY.getValue());
        } else if (OrderStatusEnum.EXPIRED.getValue().equals(order.getStatus())) {
            vo.setVoStatus(PatientNetinquiryOrderStatusEnum.PAY_EXPIRED.getValue());
        } else if (OrderStatusEnum.CANCEL.getValue().equals(order.getStatus())) {
            vo.setVoStatus(PatientNetinquiryOrderStatusEnum.CANCEL.getValue());
        } else if (OrderStatusEnum.PAID.getValue().equals(order.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(order.getStatus()) || OrderStatusEnum.REFUNDING.getValue().equals(order.getStatus())) {
            vo.setPayTime(order.getPaymentTime());
            vo.setPayMethod(order.getPayMethod());
            AdmissionEntity adm = this.getAdmissionEntityByOrderId(order.getXId());
            if (null != adm) {
                vo.setAdmId(adm.getXId());
                log.info("\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u7684\u5c31\u8bca\u8bb0\u5f55\u4e3a" + adm.toString());
            }
            if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.TO_CONSULTATION.getValue());
                ImAccountVo imAccountVo = this.getImAccounts(adm.getXId(), "EHOS_DOCTOR", adm.getDoctorId());
                vo.setDocImAccount(imAccountVo.getDocImAccount());
                vo.setPatImAccount(imAccountVo.getPatImAccount());
            } else if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.IN_CONSULTATION.getValue());
                vo.setNowTime(new Date());
                vo.setAdmStartTime(adm.getStartTime());
                vo.setAdmEndTime(adm.getEndTime());
                ImAccountVo imAccountVo = this.getImAccounts(adm.getXId(), "EHOS_DOCTOR", adm.getDoctorId());
                vo.setDocImAccount(imAccountVo.getDocImAccount());
                vo.setPatImAccount(imAccountVo.getPatImAccount());
            } else if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(adm.getStatus())) {
                if (order.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                    vo.setVoStatus(PatientNetinquiryOrderStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
                } else {
                    vo.setVoStatus(PatientNetinquiryOrderStatusEnum.REFUSE_ADMISSION.getValue());
                }
            } else if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.ADMISSION_NOT_HANDLE.getValue());
            } else if (AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
            } else if (AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.PASSNUMBER_REFUND.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.REQUEST_REFUND.getValue());
            } else if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(adm.getStatus())) {
                QueryWrapper evaluationWrapper = new QueryWrapper();
                EvaluationEntity evaluationEntity = new EvaluationEntity();
                evaluationEntity.setAdmId(adm.getXId());
                evaluationEntity.setDisplay(new Integer(1).byteValue());
                evaluationWrapper.setEntity((Object)evaluationEntity);
                EvaluationEntity one = (EvaluationEntity)this.evaluationMapper.selectOne((Wrapper)evaluationWrapper);
                if (null != one) {
                    log.info("one{}", (Object)JSON.toJSONString((Object)one));
                    vo.setVoStatus(PatientNetinquiryOrderStatusEnum.FINISH_EVALUATED.getValue());
                } else {
                    vo.setVoStatus(PatientNetinquiryOrderStatusEnum.FINISH_NOT_EVALUATED.getValue());
                }
            } else if (AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.FINISH_EVALUATED.getValue());
            } else if (AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.TO_REPORT.getValue());
            } else if (AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
            } else if (AdmissionStatusEnum.RETIRED.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.RETIRED_REFUND.getValue());
            } else if (AdmissionStatusEnum.REFERRAL.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.REFERRAL_MANAGER.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.REFERRAL.getValue());
            } else if (AdmissionStatusEnum.EXPIRED.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.EXPIRED.getValue());
            } else if (AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.DOCTOR_CLOSED_SCHEDULE_REFUND.getValue());
            } else if (AdmissionStatusEnum.PASSNUMBER.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.PASS_NUMBER.getValue());
            } else if (AdmissionStatusEnum.ADMIN_REFUNDED.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.ADMIN_REFUNDED.getValue());
            } else if (AdmissionStatusEnum.WAIT_REFUND.getValue().equals(adm.getStatus())) {
                vo.setVoStatus(PatientNetinquiryOrderStatusEnum.WAIT_REFUND.getValue());
            }
        }
    }

    private InquiryMchCodeEntity getHisUrl(String hospital, String appCode) {
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(appCode);
        inquiryMchCodeEntity.setHospitalId(hospital);
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        log.info("entity:" + JSON.toJSONString((Object)entity));
        return entity;
    }

    public BaseResponse<AdmDateVo> updateDoctorAdmissionStatus(UpdateDoctorAdmissionStatusDto param) {
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmId());
        if (null == admission) {
            return BaseResponse.error((String)"\u67e5\u8be2\u65e0\u5c31\u8bca\u8bb0\u5f55");
        }
        OrderEntity order = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)admission.getOrderId()));
        if (null == order) {
            return BaseResponse.error((String)"\u67e5\u8be2\u65e0\u8ba2\u5355\u8bb0\u5f55");
        }
        InquiryMchCodeEntity entity = this.getHisUrl(order.getHospitalId(), order.getAppCode());
        if (null == entity || StringUtils.isEmpty((String)entity.getHisUrl())) {
            log.info("\u6ca1\u6709\u914d\u7f6ehis");
        }
        if (!admission.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
            return BaseResponse.error((String)"\u975e\u5f85\u63a5\u8bca\u72b6\u6001\u4e0d\u53ef\u63a5\u8bca");
        }
        if (admission.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
            Integer servTime = admission.getServTime();
            admission.setStartTime(new Date());
            admission.setEndTime(DateUtils.dateAddMinutes((Date)admission.getStartTime(), (int)servTime));
            AdmDateVo dateRes = new AdmDateVo();
            dateRes.setEdTime(admission.getEndTime());
            dateRes.setNowTime(new Date());
            return BaseResponse.success((Object)dateRes);
        }
        BaseResponse baseResponse = this.receiveOrderManage.receiveOrder(admission, order);
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        Integer servTime = admission.getServTime();
        admission.setStartTime(new Date());
        admission.setEndTime(DateUtils.dateAddMinutes((Date)admission.getStartTime(), (int)servTime));
        AdmDateVo dateRes = new AdmDateVo();
        dateRes.setEdTime(admission.getEndTime());
        dateRes.setNowTime(new Date());
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus())) {
            log.info("\u5b9a\u65f6\u7ed3\u675f\u65f6\u95f4\u67e5\u770b" + admission.toString());
            admission.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            admission.setReceptionTime(new Date());
            Integer row = this.admissionMapper.update(admission);
            if (row <= 0) {
                return BaseResponse.error((String)"\u4fee\u6539\u5c31\u8bca\u72b6\u6001\u5931\u8d25");
            }
        } else {
            return BaseResponse.error((String)"\u53ea\u6709\u5f85\u63a5\u5f85\u72b6\u6001\u624d\u80fd\u63a5\u5355");
        }
        this.inquiryEndPrePush(param.getAdmId());
        Date nowDate = new Date();
        int i = DateUtils.secondsBetween((Date)nowDate, (Date)admission.getEndTime());
        if (i < 600) {
            log.info("\u5ef6\u65f6\u65f6\u95f4\u5c0f\u65f610\u5206\u949f\u4e0d\u63a8\u9001");
        } else if (i == 600) {
            this.iMInformService.tenMinutesBeforeEnd(admission.getXId());
            this.umAppPushService.noMedicalOpinionFollowUpCaseAppPush(admission.getXId());
            log.info("\u533b\u751f\u8ddd\u79bb\u95ee\u8bca\u7ed3\u675f10\u5206\u949f\u524d\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u6216\u8005\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u6210\u529f");
        } else {
            log.info("=======\u65f6\u95f4\u5927\u4e8e10\u5206\u949f\uff0c\u653e\u5165\u5ef6\u8fdf\u961f\u5217========");
            OrderTaskVo orderTaskVoNew = new OrderTaskVo();
            orderTaskVoNew.setId(order.getXId());
            orderTaskVoNew.setType(Integer.valueOf(6));
            log.info("orderTaskVoNew:{}", (Object)JSONObject.toJSONString((Object)orderTaskVoNew));
            this.orderSender.sendDelay(orderTaskVoNew);
        }
        OrderTaskVo orderTaskVo4 = new OrderTaskVo();
        orderTaskVo4.setType(Integer.valueOf(9));
        orderTaskVo4.setTimes(Integer.valueOf(1));
        orderTaskVo4.setId(order.getXId());
        log.info("\u6bcf\u95f4\u96942\u5c0f\u65f6\u53d1\u77ed\u4fe1\u63d0\u9192\u533b\u751f\u56de\u590d\u60a3\u8005\u8ba2\u5355\u5904\u7406orderTaskVo9\uff1a{}", (Object)orderTaskVo4.toString());
        this.orderSender.sendDelay(orderTaskVo4);
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admission.getOrderId()));
        return BaseResponse.success((Object)dateRes);
    }

    public void inquiryEndPrePush(String admId) {
        log.info("\u95ee\u8bca\u7ed3\u675f\u524d3\u5206\u949f\u8c03\u7528\u5165\u53c2,{}", (Object)admId);
        AdmissionEntity admissionInfo = this.admissionMapper.findById(admId);
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionInfo.getStatus())) {
            boolean b1;
            boolean b;
            log.info("==\u5c31\u8bca\u72b6\u6001\u7b26\u5408\u95ee\u8bca\u4e2d==");
            Date nowDate = new Date();
            int i = DateUtils.secondsBetween((Date)nowDate, (Date)admissionInfo.getEndTime());
            boolean bl = b = admissionInfo.getExtendTimes() == 0 || admissionInfo.getExtendTimes() == 1;
            if (i == 180 && b) {
                log.info("\u63a5\u8bca\u7684\u65f6\u95f4\u5dee\u521a\u597d==3\uff0c\u6267\u884c\u63a8\u9001");
                this.imInformService.inquiryEndPre(admId);
                this.umAppPushService.inquiryEndPreAppPush(admId);
            }
            Integer differentTime = i - 180;
            boolean bl2 = b1 = admissionInfo.getExtendTimes() == 0 || admissionInfo.getExtendTimes() == 1;
            if (i > 180 && b1) {
                log.info("\u65f6\u95f4\u5dee\u5927\u4e8e3\uff0c\u653e\u5230\u6267\u884c\u6d88\u606f\u961f\u5217\u4e2d");
                OrderSender.sendInquiryEndPreNo((RabbitTemplate)this.rabbitTemplate, (String)admId, (Integer)differentTime);
            }
        }
    }

    public BaseResponse<ImmediateConsultationVo> immediateConsultation(ImmediateConsultationDTO immediateConsultationDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(immediateConsultationDTO.getDoctorId());
        wrapperEntity.setOrganId(immediateConsultationDTO.getOrganId());
        if (ServiceTypeEnum.HOS.getValue().equals(immediateConsultationDTO.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(immediateConsultationDTO.getServType())) {
            wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getDeptId())));
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        log.info("wrapperEntity:{}" + JSON.toJSONString((Object)wrapperEntity));
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u4e0d\u53ef\u8d2d\u4e70");
        }
        log.info("inquiryServiceConfigEntity:{}" + inquiryServiceConfigEntity.toString());
        OrderEntity order = this.getOrderByDocIdAndHospIdAndPatientId(immediateConsultationDTO.getDoctorId(), immediateConsultationDTO.getHospitalId(), immediateConsultationDTO.getPatientId(), immediateConsultationDTO.getServType());
        if (order == null) {
            return this.createOrder(immediateConsultationDTO);
        }
        log.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)order.toString());
        if (OrderStatusEnum.TOPAY.getValue().equals(order.getStatus())) {
            log.info("\u5904\u7406\u672a\u652f\u4ed8\u8ba2\u5355\uff1a{}", (Object)order.toString());
            ImmediateConsultationVo vo = new ImmediateConsultationVo();
            vo.setType(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
            vo.setDealSeq(order.getDealSeq());
            vo.setMerchantSeq(order.getMerchantId());
            vo.setOrderSeq(order.getOrderSeq());
            vo.setXCreateTime(order.getXCreateTime());
            vo.setPayAmount(order.getPayAmount());
            vo.setOrderId(order.getXId());
            vo.setScheduleRange(order.getScheduleRange());
            if (null != order.getScheduleDate()) {
                vo.setScheduleDate(DateUtils.dateToString((Date)order.getScheduleDate(), (String)"yyyy-MM-dd"));
                vo.setScheduleStartTime(order.getScheduleStartTime());
                vo.setScheduleEndTime(order.getScheduleEndTime());
            }
            vo.setPayPrice(inquiryServiceConfigEntity.getPrice());
            vo.setHospitalName(immediateConsultationDTO.getHospitalName());
            vo.setDeptName(immediateConsultationDTO.getDeptName());
            vo.setDocName(immediateConsultationDTO.getDoctorName());
            BigDecimal bigDecimal = order.getPayAmount().setScale(2, 4);
            vo.setOwnCost(bigDecimal.toString());
            OrderEntity orderE = new OrderEntity();
            orderE.setXId(order.getXId());
            orderE.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
            this.orderMapper.updateById((Object)orderE);
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(order.getXId());
            if (null != admissionEntity) {
                AdmissionEntity adm = new AdmissionEntity();
                adm.setXId(admissionEntity.getXId());
                adm.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
                this.admissionMapper.update(adm);
            }
            InquiryMchCodeEntity entity = this.getHisUrl(order.getHospitalId(), order.getAppCode());
            PatientEntity patientEntity = this.patientMapper.selectById(order.getPatientId());
            if (order.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != patientEntity && null != entity && StringUtils.isNotEmpty((String)entity.getHisUrl()) && "HYT".equals(entity.getAppCode())) {
                BaseResponse preSettlement = this.getPreSettlement(patientEntity, order, immediateConsultationDTO.getHospFlag().toString());
                if (!preSettlement.isSuccess()) {
                    return BaseResponse.error((String)"\u9884\u7ed3\u7b97\u8c03\u7528\u5931\u8d25");
                }
                vo.setPayCost(((PreSettlementResVo)preSettlement.getData()).getPayCost());
                vo.setTotCost(((PreSettlementResVo)preSettlement.getData()).getTotCost());
                vo.setPubCost(((PreSettlementResVo)preSettlement.getData()).getPubCost());
                vo.setOwnCost(((PreSettlementResVo)preSettlement.getData()).getOwnCost());
                OrderEntity orderEntity = new OrderEntity();
                orderEntity.setXId(order.getXId());
                orderEntity.setHospFlag(immediateConsultationDTO.getHospFlag());
                orderEntity.setPayCost(((PreSettlementResVo)preSettlement.getData()).getPayCost());
                orderEntity.setPubCost(((PreSettlementResVo)preSettlement.getData()).getPubCost());
                orderEntity.setOwnCost(((PreSettlementResVo)preSettlement.getData()).getOwnCost());
                orderEntity.setTotCost(((PreSettlementResVo)preSettlement.getData()).getTotCost());
                if (immediateConsultationDTO.getServType().equals(ServiceTypeEnum.NOS.getValue()) && "HYT".equals(order.getAppCode())) {
                    orderEntity.setFundType(patientEntity.getFundType());
                }
                this.orderMapper.updateById((Object)orderEntity);
            }
            vo.setPrice(order.getPrice());
            this.insertTagsRecord(immediateConsultationDTO);
            return BaseResponse.success((Object)vo);
        }
        AdmissionEntity admission = this.getAdmissionByHospitalIdAndOrderId(order.getHospitalId(), order.getXId());
        log.info("\u4e0b\u5355\u67e5\u8be2\u5230\u5c31\u8bca\u8bb0\u5f55:" + JSON.toJSONString((Object)admission));
        if (admission == null) {
            return this.createOrder(immediateConsultationDTO);
        }
        boolean isWaitAdmission = AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admission.getStatus());
        boolean inConsult = AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus());
        boolean toBeReceive = AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus());
        if (!(inConsult || toBeReceive || isWaitAdmission)) {
            return this.createOrder(immediateConsultationDTO);
        }
        ImmediateConsultationVo vo = new ImmediateConsultationVo();
        vo.setType(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        vo.setAdmId(admission.getXId());
        this.insertTagsRecord(immediateConsultationDTO);
        return BaseResponse.success((Object)vo);
    }

    private BaseResponse<PreSettlementResVo> getPreSettlement(PatientEntity patientEntity, OrderEntity orderEntity, String hospFlag) {
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(orderEntity.getDeptId().toString(), orderEntity.getDoctorId());
        if (null == hisDeptAndDocCode) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u8c03\u7528\u51fa\u9519");
        }
        PreSettlementReqVo preSettlementReqVo = new PreSettlementReqVo();
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setBirthDay(patientEntity.getBirthDates());
        patientInfoVo.setCardNO(patientEntity.getMedicalNO());
        patientInfoVo.setSex(patientEntity.getGender().toString());
        patientInfoVo.setPhone(patientEntity.getAccountPhone());
        patientInfoVo.setName(patientEntity.getPatientName());
        patientInfoVo.setPactCode(patientEntity.getPactCode());
        patientInfoVo.setIdCard(patientEntity.getIdcard());
        patientInfoVo.setAddress(patientEntity.getAddress());
        TransModelVo transModelVo = new TransModelVo();
        transModelVo.setMachineNO("byhl");
        transModelVo.setTransNO("");
        transModelVo.setBankTransNO("");
        preSettlementReqVo.setTransModelVo(transModelVo);
        preSettlementReqVo.setPatientInfoVo(patientInfoVo);
        preSettlementReqVo.setDeptCode(hisDeptAndDocCode.getDeptCode());
        preSettlementReqVo.setDoctCode(hisDeptAndDocCode.getDoctorCode());
        preSettlementReqVo.setRegLeve("15");
        preSettlementReqVo.setRegLeveName("\u4e92\u8054\u7f51\u590d\u8bca\u53f7");
        preSettlementReqVo.setRegType("0");
        preSettlementReqVo.setFundType(patientEntity.getFundType());
        preSettlementReqVo.setHospFlag(hospFlag);
        preSettlementReqVo.setMarkNO(patientEntity.getCardNo());
        preSettlementReqVo.setMarkType(patientEntity.getFundType());
        preSettlementReqVo.setNoonID("0");
        preSettlementReqVo.setOrderID("");
        preSettlementReqVo.setSchemaID("");
        preSettlementReqVo.setDeptName(hisDeptAndDocCode.getDeptName());
        preSettlementReqVo.setDoctName(hisDeptAndDocCode.getDoctorName());
        log.info("\u6302\u53f7\u9884\u7ed3\u7b97\u5165\u53c2:" + preSettlementReqVo.toString());
        PreSettlementResVo preSettlementResVo = this.hisTemplateService.preSettlement(preSettlementReqVo);
        return BaseResponse.success((Object)preSettlementResVo);
    }

    private BaseResponse<ImmediateConsultationVo> createOrder(ImmediateConsultationDTO immediateConsultationDTO) {
        OrderCreateDTO orderCreateDTO = new OrderCreateDTO();
        BeanUtils.copyProperties((Object)immediateConsultationDTO, (Object)orderCreateDTO);
        BaseResponse createOrderResult = this.orderService.createOrder(orderCreateDTO);
        if (createOrderResult.isSuccess()) {
            OrderCreateResponseDTO orderCreateResponseDTO = (OrderCreateResponseDTO)createOrderResult.getData();
            ImmediateConsultationVo vo = new ImmediateConsultationVo();
            BeanUtils.copyProperties((Object)orderCreateResponseDTO, (Object)vo);
            vo.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
            this.insertTagsRecord(immediateConsultationDTO);
            return BaseResponse.success((Object)vo);
        }
        return BaseResponse.error((String)createOrderResult.getMsg());
    }

    private void insertTagsRecord(ImmediateConsultationDTO immediateConsultationDTO) {
        InsertTagsRecordVo insertTagsRecordVo = new InsertTagsRecordVo();
        insertTagsRecordVo.setDeptId(immediateConsultationDTO.getDeptId());
        insertTagsRecordVo.setHospitalId(immediateConsultationDTO.getHospitalId());
        insertTagsRecordVo.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
        insertTagsRecordVo.setServType(immediateConsultationDTO.getServType());
        String response = this.internetHospitalDetailInfoService.insertTagsRecord(insertTagsRecordVo);
        if (StringUtils.isEmpty((String)response)) {
            return;
        }
        log.info("\u4e0b\u5355\u75c5\u4f8b\u4f7f\u7528\u8bb0\u5f55\u65b0\u589e\u6210\u529f");
    }

    private OrderEntity getOrderByDocIdAndHospIdAndPatientId(String doctorId, String hospitalId, String patientId, Integer servType) {
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setDoctorId(doctorId);
        orderEntity.setHospitalId(hospitalId);
        orderEntity.setPatientId(patientId);
        orderEntity.setServType(servType);
        QueryWrapper queryWrapperOrderEntity = new QueryWrapper((Object)orderEntity);
        queryWrapperOrderEntity.notIn((Object)"status", new Object[]{-1, 6});
        queryWrapperOrderEntity.last("limit 1");
        queryWrapperOrderEntity.orderByDesc((Object)"x_create_time");
        return (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapperOrderEntity);
    }

    private AdmissionEntity getAdmissionByHospitalIdAndOrderId(String hospitalId, String orderId) {
        QueryWrapper queryWrapperAdmissionEntity = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrganId(hospitalId);
        admissionEntity.setOrderId(orderId);
        queryWrapperAdmissionEntity.setEntity((Object)admissionEntity);
        return (AdmissionEntity)this.baseInquiryAdmissionService.getOne((Wrapper)queryWrapperAdmissionEntity);
    }

    public BaseResponse<AllowBuyCheckRespVO> allowBuyCheck(AllowBuyCheckReqVO param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(param.getDoctorId());
        wrapperEntity.setOrganId(param.getOrganId());
        if (ServiceTypeEnum.HOS.getValue().equals(param.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(param.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        wrapperEntity.setDeptId(param.getDeptId());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u4e0d\u53ef\u8d2d\u4e70");
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(param.getDoctorId());
        BaseResponse doctorDetailsVOBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVOBaseResponse || null == doctorDetailsVOBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
        PatientEntity patientEntity = this.patientMapper.selectById(param.getPatientId());
        if (null == patientEntity) {
            return BaseResponse.error((String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        log.info("\u60a3\u8005\u4fe1\u606f:" + patientEntity.toString());
        data.setFundType(patientEntity.getFundType());
        if (param.getServType().equals(ServiceTypeEnum.NOS.getValue()) && "HYT".equals(param.getAppCode()) && param.getIsMedicare().equals(WhetherEnum.ALLOW.getValue())) {
            String t1 = "23:50:00";
            String t2 = DateUtils.getCurrentTime();
            String t3 = "24:00:00";
            Integer isUse = DateUtils.timeCompare((String)t1, (String)t2, (String)t3);
            data.setIsUse(isUse);
        } else {
            data.setIsUse(WhetherEnum.ALLOW.getValue());
        }
        InquiryMchCodeEntity entity = this.patientService.getInquiryMchCodeEntity(inquiryServiceConfigEntity.getAppCode(), inquiryServiceConfigEntity.getOrganId());
        if (null == entity) {
            log.info("\u8be5\u533b\u9662\u7684\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u5546\u6237\u53f7");
            return BaseResponse.error((String)"\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u6539\u533b\u9662\u76f8\u5173\u7684mchCode\u548chisUrl");
        }
        log.info("entity:{}" + entity.toString());
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setHospitalId(param.getOrganId());
        orderEntity.setPatientId(param.getPatientId());
        orderEntity.setServType(param.getServType());
        QueryWrapper queryWrapperOrderEntity = new QueryWrapper((Object)orderEntity);
        queryWrapperOrderEntity.notIn((Object)"status", new Object[]{-1, 6});
        queryWrapperOrderEntity.last("limit 1");
        queryWrapperOrderEntity.orderByDesc((Object)"x_create_time");
        OrderEntity order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapperOrderEntity);
        log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4order: {}", (Object)JSON.toJSONString((Object)order));
        if (StringUtils.isEmpty((String)entity.getHisUrl()) || param.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            log.info("\u67e5\u8be2\u7684\u590d\u8bca\u8c03\u7528his\u7684\u5730\u5740\u4e3a\u7a7a\uff0c\u68c0\u67e5\u6570\u636e\u5e93\u786e\u8ba4\u8be5\u533b\u9662\u662f\u5426\u5bf9\u63a5his");
            if (order == null) {
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            if (OrderStatusEnum.TOPAY.getValue().equals(order.getStatus())) {
                data.setOrderId(order.getXId());
                data.setType(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
                data.setDealSeq(order.getDealSeq());
                data.setMerchantSeq(order.getMerchantId());
                return BaseResponse.success((Object)data);
            }
            AdmissionEntity admission = this.getAdmissionByHospitalIdAndOrderId(order.getHospitalId(), order.getXId());
            if (null == admission) {
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4admission: {}", (Object)JSON.toJSONString((Object)admission));
            boolean isWaitAdmission = AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admission.getStatus());
            boolean inConsult = AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus());
            boolean toBeReceive = AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus());
            if (admission == null) {
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            if (!(inConsult || toBeReceive || isWaitAdmission)) {
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            data.setOrderId(order.getXId());
            data.setType(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
            data.setAdmId(admission.getXId());
            ImAccountVo imAccountVo = this.getImAccounts(admission.getXId(), "EHOS_DOCTOR", admission.getDoctorId());
            data.setDocImAccount(imAccountVo.getDocImAccount());
            data.setPatImAccount(imAccountVo.getPatImAccount());
            log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4data: {}", (Object)JSON.toJSONString((Object)data));
            return BaseResponse.success((Object)data);
        }
        String hisUrl = entity.getHisUrl();
        if (StringUtils.isNotEmpty((String)entity.getHisUrl()) && param.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            RegisteredRecordResVo his = new RegisteredRecordResVo();
            ArrayList<RegisteredRecordResVo> registeredRecordResVos = new ArrayList<RegisteredRecordResVo>();
            ResPatientInformationVo resPatientInformationVo = this.patientMapper.getPatientById(param.getPatientId());
            log.info("\u67e5\u8be2his\u5c31\u8bca\u8bb0\u5f55\u5f00\u59cb\u65f6\u95f4:{}" + System.currentTimeMillis());
            List registeredRecordList = this.hisTemplateService.getRegisteredRecord(resPatientInformationVo.getIdcard(), resPatientInformationVo.getPatientName(), param.getDeptName(), hisUrl, param.getDeptId().toString(), ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDoctorId(), param.getCardNo(), param.getAppCode());
            log.info("\u67e5\u8be2his\u5c31\u8bca\u8bb0\u5f55\u7ed3\u675f\u65f6\u95f4:{}" + System.currentTimeMillis());
            if (CollectionUtils.isEmpty((Collection)registeredRecordList)) {
                data.setType(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
                return BaseResponse.success();
            }
            for (RegisteredRecordResVo registeredRecordResVo : registeredRecordList) {
                String regDateStr = registeredRecordResVo.getRegDate();
                Date regDate = DateUtils.stringToFullDateUtil((String)regDateStr);
                int betweenDayNumber = DateUtils.getBetweenDayNumber((Date)regDate, (Date)new Date());
                if (betweenDayNumber >= 180) continue;
                registeredRecordResVos.add(registeredRecordResVo);
            }
            log.info("hisRecords:{}" + JSONObject.toJSONString(registeredRecordResVos));
            if (CollectionUtils.isEmpty(registeredRecordResVos)) {
                data.setType(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
                return BaseResponse.success();
            }
            registeredRecordResVos.sort(Comparator.comparing(RegisteredRecordResVo::getRegDate).reversed());
            his = (RegisteredRecordResVo)registeredRecordResVos.get(0);
            log.info("his:" + JSON.toJSONString((Object)his));
            if (order == null) {
                data.setRegDate(DateUtils.stringToFullDateUtil((String)his.getRegDate()));
                data.setCardNo(his.getCardNo());
                data.setDeptName(his.getDeptName());
                data.setDoctorName(his.getDoctName());
                data.setDiagnose(his.getDiagnose());
                data.setRegisteredRecords(registeredRecordResVos);
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            if (OrderStatusEnum.TOPAY.getValue().equals(order.getStatus())) {
                data.setOrderId(order.getXId());
                data.setType(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
                data.setDealSeq(order.getDealSeq());
                data.setMerchantSeq(order.getMerchantId());
                return BaseResponse.success((Object)data);
            }
            AdmissionEntity admission = this.getAdmissionByHospitalIdAndOrderId(order.getHospitalId(), order.getXId());
            if (null == admission) {
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4admission: {}", (Object)JSON.toJSONString((Object)admission));
            boolean isWaitAdmission = AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admission.getStatus());
            boolean inConsult = AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus());
            boolean toBeReceive = AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus());
            if (admission == null) {
                data.setRegDate(DateUtils.stringToFullDateUtil((String)his.getRegDate()));
                data.setCardNo(his.getCardNo());
                data.setDeptName(his.getDeptName());
                data.setDoctorName(his.getDoctName());
                data.setDiagnose(his.getDiagnose());
                data.setRegisteredRecords(registeredRecordResVos);
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            if (!(inConsult || toBeReceive || isWaitAdmission)) {
                data.setRegDate(DateUtils.stringToFullDateUtil((String)his.getRegDate()));
                data.setCardNo(his.getCardNo());
                data.setDeptName(his.getDeptName());
                data.setDoctorName(his.getDoctName());
                data.setDiagnose(his.getDiagnose());
                data.setRegisteredRecords(registeredRecordResVos);
                data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
                return BaseResponse.success((Object)data);
            }
            data.setOrderId(order.getXId());
            data.setType(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
            data.setAdmId(admission.getXId());
            ImAccountVo imAccountVo = this.getImAccounts(admission.getXId(), "EHOS_DOCTOR", admission.getDoctorId());
            data.setDocImAccount(imAccountVo.getDocImAccount());
            data.setPatImAccount(imAccountVo.getPatImAccount());
            log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4data: {}", (Object)JSON.toJSONString((Object)data));
        }
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<TimeDelayQueryRespVO> timeDelayQuery(TimeDelayQueryReqVO param) {
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmId());
        if (admission == null) {
            return BaseResponse.error((String)"\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(param.getAdmId());
        if (orderEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        QueryNewestOrderorAdmDTO queryDto = new QueryNewestOrderorAdmDTO();
        BeanUtils.copyProperties((Object)admission, (Object)queryDto);
        if (admission == null) {
            return BaseResponse.error((String)"\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus())) {
            TimeDelayQueryRespVO data = new TimeDelayQueryRespVO();
            data.setAdmId(admission.getXId());
            data.setMsgCurrent(admission.getCurrentNum());
            data.setTimeDelayCurrent(admission.getExtendTimes());
            Integer maxTimeDelay = this.queryMaxTimeDelay(admission, orderEntity);
            if (maxTimeDelay == null) {
                return BaseResponse.error((String)"\u67e5\u8be2\u8be5\u533b\u9662\u65e0\u670d\u52a1\u914d\u7f6e\u4fe1\u606f");
            }
            long timeCurrent = (admission.getEndTime().getTime() - System.currentTimeMillis()) / 1000L / 60L;
            data.setTimeCurrent(Long.valueOf(admission.getEndTime().getTime() - System.currentTimeMillis()));
            data.setStatusDesc(AdmissionStatusEnum.IN_CONSULTATION.getDesc());
            data.setMsgMax(Integer.valueOf(admission.getTotalNum() - admission.getCurrentNum()));
            if (timeCurrent == 0L) {
                data.setTimeMax(Integer.valueOf(maxTimeDelay - (int)timeCurrent));
            } else {
                data.setTimeMax(Integer.valueOf(maxTimeDelay - (int)timeCurrent - 1));
            }
            data.setTimeDelayMax(Integer.valueOf(2));
            return BaseResponse.success((Object)data);
        }
        return BaseResponse.success();
    }

    private Integer queryMaxTimeDelay(AdmissionEntity admission, OrderEntity orderEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(admission.getDoctorId());
        wrapperEntity.setOrganId(admission.getOrganId());
        if (ServiceTypeEnum.HOS.getValue().equals(admission.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(admission.getServType())) {
            wrapperEntity.setDeptId(orderEntity.getDeptId());
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        log.info("wrapperEntity:{}" + JSON.toJSONString((Object)wrapperEntity));
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return null;
        }
        log.info("inquiryServiceConfigEntity:{}" + inquiryServiceConfigEntity.toString());
        return inquiryServiceConfigEntity.getServTime();
    }

    public BaseResponse<String> timeDelayUpdate(TimeDelayUpdateReqVO param) {
        String redisKey;
        Boolean flag;
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmId());
        if (admission == null) {
            return BaseResponse.error((String)"\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(param.getAdmId());
        if (orderEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admission.getDoctorType()) && admission.getExtendTimes() != null && admission.getExtendTimes() == 1 && (flag = Boolean.valueOf(this.redisTemplateService.addLockNew(redisKey = param.getAdmId() + "_YSYS", redisKey, 600L))).booleanValue()) {
            log.info("\u5ef6\u957f\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650\uff0c\u5ef6\u65f6\u5931\u8d25");
            return BaseResponse.error((String)"\u5ef6\u957f\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650\uff0c\u5ef6\u65f6\u5931\u8d25");
        }
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus())) {
            if (admission.getExtendTimes() != null && admission.getExtendTimes() >= 2) {
                return BaseResponse.error((String)"\u5ef6\u957f\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650\uff0c\u5ef6\u65f6\u5931\u8d25");
            }
            if (admission.getCurrentNum() + param.getMsgIncrease() > admission.getTotalNum()) {
                return BaseResponse.error((String)"\u5ef6\u957f\u7684\u6d88\u606f\u6761\u6570\u8d85\u8fc7\u533b\u751f\u5355\u6b21\u670d\u52a1\u7684\u6700\u5927\u6d88\u606f\u6761\u6570\uff0c\u5ef6\u957f\u5931\u8d25");
            }
            Integer maxTimeDelay = this.queryMaxTimeDelay(admission, orderEntity);
            if (maxTimeDelay == null) {
                return BaseResponse.error((String)"\u67e5\u8be2\u8be5\u533b\u9662\u65e0\u670d\u52a1\u914d\u7f6e\u4fe1\u606f");
            }
            if (maxTimeDelay < param.getTimeIncrease()) {
                return BaseResponse.error((String)"\u5ef6\u957f\u7684\u65f6\u95f4\u8d85\u8fc7\u533b\u751f\u5355\u6b21\u670d\u52a1\u7684\u6700\u957f\u65f6\u95f4\uff0c\u5ef6\u957f\u5931\u8d25");
            }
            admission.setEndTime(DateUtils.dateAddMinutes((Date)admission.getEndTime(), (int)param.getTimeIncrease()));
            if (admission.getCurrentNum() == 0 && param.getMsgIncrease() == 0 && param.getTimeIncrease() > 0) {
                return BaseResponse.error((String)"\u8be5\u54a8\u8be2\u6d88\u606f\u6761\u6570\u5df2\u7528\u5b8c\uff0c\u4e0d\u80fd\u5355\u72ec\u5ef6\u957f\u54a8\u8be2\u65f6\u95f4\uff0c\u8bf7\u8bbe\u7f6e\u5ef6\u957f\u6761\u6570");
            }
            admission.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            Long pauseTime = (admission.getPauseTime() == null ? 0L : admission.getPauseTime()) + System.currentTimeMillis() - admission.getEndTime().getTime();
            admission.setPauseTime(pauseTime);
            admission.setExtendTimes(Integer.valueOf(admission.getExtendTimes() == null ? 1 : admission.getExtendTimes() + 1));
            admission.setCurrentNum(Integer.valueOf(admission.getCurrentNum() + param.getMsgIncrease()));
            if (this.admissionMapper.update(admission) > 0) {
                this.iMInformService.delay(admission.getXId(), param.getDoctorId());
                this.inquiryEndPrePush(param.getAdmId());
                Date nowDate = new Date();
                int i = DateUtils.secondsBetween((Date)nowDate, (Date)admission.getEndTime());
                if (i < 600) {
                    log.info("\u5ef6\u65f6\u65f6\u95f4\u5c0f\u65f610\u5206\u949f\u4e0d\u63a8\u9001");
                    return BaseResponse.success((Object)"\u5ef6\u65f6\u6210\u529f");
                }
                if (i == 600) {
                    this.iMInformService.tenMinutesBeforeEnd(admission.getXId());
                    this.umAppPushService.noMedicalOpinionFollowUpCaseAppPush(admission.getXId());
                    log.info("\u533b\u751f\u8ddd\u79bb\u95ee\u8bca\u7ed3\u675f10\u5206\u949f\u524d\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u6216\u8005\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u6210\u529f");
                } else {
                    log.info("\u672a\u523010\u5206\u949f\u653e\u5165\u5bf9\u5217");
                    OrderTaskVo orderTaskVo = new OrderTaskVo();
                    orderTaskVo.setId(admission.getOrderId());
                    orderTaskVo.setType(Integer.valueOf(6));
                    this.orderSender.sendDelay(orderTaskVo);
                }
                return BaseResponse.success((Object)"\u5ef6\u65f6\u6210\u529f");
            }
            return BaseResponse.error((String)"\u5ef6\u957f\u5931\u8d25,\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        return BaseResponse.error((String)"\u4e0d\u53ef\u5ef6\u957f\u7684\u5c31\u8bca\u72b6\u6001");
    }

    public BaseResponse<String> patientEndAdm(PatientEndAdmReqVO reqVO) {
        AdmissionEntity admission = this.admissionMapper.findById(reqVO.getAdmId());
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus())) {
            return BaseResponse.error((String)"\u4e0d\u662f\u53ef\u4ee5\u7ed3\u675f\u7684\u5c31\u8bca\u72b6\u6001");
        }
        admission.setEndTime(new Date());
        admission.setStatus(AdmissionStatusEnum.FINISH_APPLY.getValue());
        admission.setPatientFinish(CommonConstants.STATUS_VALID);
        Integer count = this.admissionMapper.update(admission);
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admission.getOrderId()));
        if (count > 0) {
            this.iMInformService.patientEndAdm(reqVO.getAdmId());
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.umAppPushService.onlineCompletionAppPush(admission.getXId());
            return BaseResponse.success((Object)AdmissionStatusEnum.FINISH_APPLY.getValue().toString());
        }
        return BaseResponse.error((String)"\u66f4\u65b0\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25");
    }

    public BaseResponse<List<IMMsgResultVO>> getAllMsgContent(IMQueryMsgReqVO reqVO) {
        log.info("\u540c\u6b65\u4f1a\u8bdd\u6d88\u606f\u5165\u53c2" + JSON.toJSONString((Object)reqVO));
        BaseResponse listBaseResponse = this.imSyncMsgClient.queryImMsg(reqVO);
        log.info("\u540c\u6b65\u4f1a\u8bdd\u6d88\u606f\u51fa\u53c2" + JSON.toJSONString((Object)listBaseResponse));
        if (!listBaseResponse.isSuccess()) {
            log.info("imSyncMsgClient.queryImMsg: " + listBaseResponse.toString());
            return BaseResponse.error((String)listBaseResponse.getMsg());
        }
        if (listBaseResponse.getData() == null) {
            return BaseResponse.success(new ArrayList());
        }
        List imMsgResultVOList = ((List)listBaseResponse.getData()).stream().map(imSingleMsgResultVO -> {
            IMMsgResultVO imMsgResultVO = new IMMsgResultVO();
            BeanUtils.copyProperties((Object)imSingleMsgResultVO, (Object)imMsgResultVO);
            return imMsgResultVO;
        }).collect(Collectors.toList());
        log.info("\u67e5\u8be2\u5230\u7ed3\u679c\u4e3a:{}" + imMsgResultVOList.toString());
        return BaseResponse.success(imMsgResultVOList);
    }

    public BaseResponse<List<IMSingleMsgResultVO>> getAllMsgContentNew(IMQueryMsgReqVO reqVO) {
        log.info("\u540c\u6b65\u4f1a\u8bdd\u6d88\u606f\u5165\u53c2" + JSON.toJSONString((Object)reqVO));
        BaseResponse listBaseResponse = this.imSyncMsgClient.queryImMsg(reqVO);
        log.info("\u540c\u6b65\u4f1a\u8bdd\u6d88\u606f\u51fa\u53c2" + JSON.toJSONString((Object)listBaseResponse));
        if (!listBaseResponse.isSuccess()) {
            log.info("imSyncMsgClient.queryImMsg: " + listBaseResponse.toString());
            return BaseResponse.error((String)listBaseResponse.getMsg());
        }
        if (listBaseResponse.getData() == null) {
            return BaseResponse.success(new ArrayList());
        }
        List imMsgResultVOList = (List)listBaseResponse.getData();
        for (IMSingleMsgResultVO imSingleMsgResultVO : imMsgResultVOList) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)imSingleMsgResultVO.getMsgContent());
                if (jsonObject.get((Object)"msgId") == null || !StringUtils.isNotEmpty((String)jsonObject.get((Object)"msgId").toString())) continue;
                String msgId = jsonObject.get((Object)"msgId").toString();
                imSingleMsgResultVO.setMsgId(msgId);
            }
            catch (Exception e) {}
        }
        log.info("\u67e5\u8be2\u5230\u7ed3\u679c\u4e3a:{}" + imMsgResultVOList.toString());
        return BaseResponse.success((Object)imMsgResultVOList);
    }

    public BaseResponse<?> querySdkLogin(IMQueryUserLoginReqVO reqVO) {
        BaseResponse imSysResult = this.imApiFeignClient.queryUserLogin(reqVO);
        if (imSysResult == null) {
            return BaseResponse.error((String)imSysResult.getMsg());
        }
        if ("0".equals(imSysResult.getCode())) {
            return BaseResponse.error((String)imSysResult.getMsg());
        }
        return BaseResponse.success((Object)imSysResult.getData());
    }

    public ResultData<Object> medicalOpinion(MedicalOpinionDto param) {
        String redisKey;
        Boolean flag;
        AdmissionEntity admissionEntity = this.admissionMapper.findById(param.getAdmId());
        if (Objects.nonNull(admissionEntity) && StringUtils.isNotEmpty((String)admissionEntity.getMedicalOpinion())) {
            return new ResultData(true, "\u64cd\u4f5c\u6210\u529f", "-1", (Object)"\u8be5\u60a3\u8005\u5df2\u5f00\u8fc7\u54a8\u8be2\u5c0f\u7ed3");
        }
        if (Objects.equals(DoctorTypeEnum.TEAM.getValue(), admissionEntity.getDoctorType()) && (flag = Boolean.valueOf(this.redisTemplateService.addLockNew(redisKey = param.getAdmId() + "_ZLYJ", redisKey, 600L))).booleanValue()) {
            log.info("\u8be5\u60a3\u8005\u5df2\u5f00\u8fc7\u54a8\u8be2\u5c0f\u7ed3");
            return new ResultData().success((Object)"\u8be5\u60a3\u8005\u5df2\u5f00\u8fc7\u54a8\u8be2\u5c0f\u7ed3");
        }
        Integer integer = this.admissionMapper.medicalOpinion(param);
        if (integer > 0) {
            this.iMInformService.medicalOpinion(param.getAdmId());
        }
        return new ResultData().success();
    }

    public void patientAdmission(PatientAdmissionVoReq patientAdmissionVoReq) throws AdmissionException {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(patientAdmissionVoReq.getAdmId());
        AdmissionEntity admissionEntity = this.admissionMapper.findById(patientAdmissionVoReq.getAdmId());
        boolean isCanAdmission = this.isCanAdmission(orderEntity);
        if (!isCanAdmission) {
            throw new AdmissionException("\u672a\u5230\u5019\u8bca\u65f6\u95f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u5019\u8bca\u62a5\u5230");
        }
        admissionEntity.setConvertWaitTime(new Date());
        this.admissionMapper.updateById((Object)admissionEntity);
        this.admissionMapper.updateAdmissionStatusById(patientAdmissionVoReq.getAdmId(), AdmissionStatusEnum.TO_BE_RECEIVED.getValue(), null);
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isCanAdmission(OrderEntity orderEntity) {
        Date admissionStartTime = null;
        Date admissionEndTime = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String scheduleDate = simpleDateFormat.format(orderEntity.getScheduleDate());
        admissionStartTime = this.convertStrToDate(scheduleDate + " " + orderEntity.getScheduleStartTime() + ":00");
        admissionEndTime = this.convertStrToDate(scheduleDate + " " + orderEntity.getScheduleEndTime() + ":00");
        log.info("\u9884\u7ea6\u65f6\u95f4\uff1a\u5f00\u59cb\u65f6\u95f4{},\u7ed3\u675f\u65f6\u95f4{}", (Object)admissionStartTime, (Object)admissionEndTime);
        return admissionStartTime.getTime() < System.currentTimeMillis() && admissionEndTime.getTime() > System.currentTimeMillis();
    }

    private Date convertStrToDate(String dateStr) {
        try {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sDateFormat.parse(dateStr);
            return date;
        }
        catch (Exception px) {
            px.printStackTrace();
            return null;
        }
    }

    public static String dataParse(String data) {
        String birthDate = data.substring(6, 14);
        if (null != birthDate) {
            StringBuffer stringBuffer = new StringBuffer(birthDate);
            stringBuffer.insert(6, "-");
            stringBuffer.insert(4, "-");
            birthDate = stringBuffer.toString();
        }
        return birthDate;
    }

    public BaseResponse<String> patientBackSource(PatientAdmissionVoReq patientAdmissionVoReq) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(patientAdmissionVoReq.getAdmId());
        log.info("orderEntity{}", (Object)JSON.toJSONString((Object)orderEntity));
        if (null == orderEntity) {
            log.error("=======\u672a\u67e5\u8be2\u5230\u6539\u8ba2\u5355=======\u5c31\u8bcaid" + patientAdmissionVoReq.getAdmId());
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355");
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findById(patientAdmissionVoReq.getAdmId());
        if (orderEntity.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
                scheduleRecordEntity.setId(Integer.valueOf(orderEntity.getScheduleId()));
                queryWrapper.setEntity((Object)scheduleRecordEntity);
                ScheduleRecordEntity scheduleOne = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)queryWrapper);
                if (null != scheduleOne) {
                    this.scheduleRecordMapper.addAvailableCount(scheduleOne.getId());
                }
            }
            this.orderService.updateStatusById(orderEntity.getXId(), OrderStatusEnum.REFUNDED.getValue());
            this.imInformService.patientZeroCancel(patientAdmissionVoReq.getAdmId());
            admissionEntity.setStatus(AdmissionStatusEnum.RETIRED.getValue());
            admissionEntity.setXRemark("\u60a3\u8005\u9000\u53f7");
            admissionEntity.setMessage("\u60a3\u8005\u9000\u53f7");
            this.admissionMapper.update(admissionEntity);
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
            return BaseResponse.success((Object)"\u9000\u53f7\u6210\u529f");
        }
        if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setId(Integer.valueOf(orderEntity.getScheduleId()));
            queryWrapper.setEntity((Object)scheduleRecordEntity);
            ScheduleRecordEntity scheduleOne = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)queryWrapper);
            if (null != scheduleOne) {
                this.scheduleRecordMapper.addAvailableCount(scheduleOne.getId());
            }
        }
        if ("130134".equals(orderEntity.getOrganId()) && "3".equals(orderEntity.getFundType())) {
            admissionEntity.setStatus(AdmissionStatusEnum.RETIRED.getValue());
            admissionEntity.setXRemark("\u60a3\u8005\u9000\u53f7");
            admissionEntity.setMessage("\u60a3\u8005\u9000\u53f7");
            admissionEntity.setLastStatus(AdmissionStatusEnum.RETIRED.getValue());
            this.admissionMapper.update(admissionEntity);
        } else {
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(orderEntity.getXId());
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
            if (Objects.nonNull(baseResponse) && !baseResponse.isSuccess()) {
                return BaseResponse.success((Object)"\u9000\u6b3e\u5931\u8d25");
            }
            this.orderService.updateStatusById(orderEntity.getXId(), OrderStatusEnum.REFUNDED.getValue());
            admissionEntity.setStatus(AdmissionStatusEnum.RETIRED.getValue());
            admissionEntity.setXRemark("\u60a3\u8005\u9000\u53f7");
            admissionEntity.setMessage("\u60a3\u8005\u9000\u53f7");
            this.admissionMapper.update(admissionEntity);
        }
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success((Object)"\u9000\u53f7\u6210\u529f");
    }

    public BaseResponse<String> updateStatusByReview(String admid) {
        AdmissionEntity admissionEntity = this.getAdmissionEntityById(admid);
        if (null == admissionEntity) {
            return BaseResponse.error((String)"\u4e0d\u5b58\u5728\u8be5\u8ba2\u5355");
        }
        Integer flag = this.admissionMapper.updateStatusByAdmId(admid, AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
        if (flag == 1) {
            return BaseResponse.success((Object)"\u66f4\u65b0\u72b6\u6001\u6210\u529f");
        }
        return BaseResponse.error((String)"\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff01");
    }

    public BaseResponse<String> updateStatusForTimeOut(String admId) {
        Integer flag;
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) && (flag = this.admissionMapper.updateStatusByAdmId(admId, AdmissionStatusEnum.FINISH_TIME_OUT.getValue())) == 1) {
            this.imInformService.expiredFinish(admId);
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            return BaseResponse.success();
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> doctorServiceCheck(RequestDoctorServiceCheckVo vo) {
        if (StringUtils.isEmpty((String)vo.getDoctorId())) {
            return BaseResponse.error((String)"\u4f20\u5165\u7684\u533b\u751fid\u4e3a\u7a7a");
        }
        String serviceCode = "";
        if (ServiceTypeEnum.HOS.getValue().equals(vo.getServType())) {
            serviceCode = ServiceTypeEnum.HOS.getCode();
        }
        if (ServiceTypeEnum.NOS.getValue().equals(vo.getServType())) {
            serviceCode = ServiceTypeEnum.NOS.getCode();
        }
        ServiceCheckReqVo serviceCheckReqVo = new ServiceCheckReqVo();
        serviceCheckReqVo.setDeptId(Long.valueOf(Long.parseLong(vo.getDeptId())));
        serviceCheckReqVo.setDoctorId(Long.valueOf(Long.parseLong(vo.getDoctorId())));
        serviceCheckReqVo.setOrganId(Long.valueOf(Long.parseLong(vo.getOrganId())));
        serviceCheckReqVo.setServiceCode(serviceCode);
        log.info("serviceCheckReqVo" + JSON.toJSONString((Object)serviceCheckReqVo));
        BaseResponse baseResponse = this.doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
        log.info("baseResponse:{}" + ((Boolean)baseResponse.getData()).toString());
        log.info("baseResponse:{}" + JSON.toJSONString((Object)baseResponse.getData()));
        if (!((Boolean)baseResponse.getData()).booleanValue()) {
            return BaseResponse.error((String)"");
        }
        return BaseResponse.success();
    }

    public ResMgrWebAdmissionDetailInfoVo getMgrWebAdmissionDetailInfo(ReqMgrWebAdmissionDetailInfoVo reqMgrWebAdmissionDetailInfoVo) {
        log.info("\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)reqMgrWebAdmissionDetailInfoVo.toString());
        ResMgrWebAdmissionDetailInfoVo mgrWebAdmissionDetailInfo = this.admissionMapper.getMgrWebAdmissionDetailInfo(reqMgrWebAdmissionDetailInfoVo);
        log.info("\u83b7\u53d6\u5230\u7684\u5c31\u8bca\u8bb0\u5f55\u8be6\u60c5\uff1a{admissionMapper.getMgrWebAdmissionDetailInfo}", (Object)mgrWebAdmissionDetailInfo.toString());
        List allPatientMedicalPictureList = this.medicalPictureMapper.findByRecordIdAllPatientMedicalPicture(mgrWebAdmissionDetailInfo.getMedicalRecordId());
        log.info("\u83b7\u53d6\u5230\u7684\u5c31\u8bca\u9644\u4ef6\u8d44\u6599\u4fe1\u606f\uff1a{medicalPictureMapper.findByRecordIdAllPatientMedicalPicture}", (Object)allPatientMedicalPictureList.toString());
        ArrayList<String> pictureList = new ArrayList<String>();
        if (null != allPatientMedicalPictureList) {
            for (PatientMedicalPictureEntity pictureEntity : allPatientMedicalPictureList) {
                pictureList.add(pictureEntity.getPicUrl());
            }
            mgrWebAdmissionDetailInfo.setAdmissionPictureList(pictureList);
        }
        log.info("\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)mgrWebAdmissionDetailInfo.toString());
        return mgrWebAdmissionDetailInfo;
    }

    public ResMgrWebAllScheduleAdmissionVo getMgrWebScheduleAdmission(ReqMgrWebScheduleAdmissionVo reqMgrWebScheduleAdmissionVo) {
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(reqMgrWebScheduleAdmissionVo.getOrganId(), this.projProperties.getInternetHospitalUrl());
        if (StringUtils.isNotBlank((String)internetHospitalEntity.getRelOrganId())) {
            reqMgrWebScheduleAdmissionVo.setOrganId(internetHospitalEntity.getRelOrganId());
        }
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)reqMgrWebScheduleAdmissionVo.toString());
        PageHelper.startPage((int)reqMgrWebScheduleAdmissionVo.getPageNum(), (int)reqMgrWebScheduleAdmissionVo.getPageSize());
        Page mgrWebScheduleAdmissionList = this.admissionMapper.getMgrWebScheduleAdmission(reqMgrWebScheduleAdmissionVo);
        log.info("\u5c31\u8bca\u8bb0\u5f55\uff1a{}", (Object)mgrWebScheduleAdmissionList.toString());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(mgrWebScheduleAdmissionList.getTotal()).intValue());
        pageResult.setContent(mgrWebScheduleAdmissionList.getResult());
        Integer totalFinishAdmissionAccount = this.admissionMapper.getMgrWebScheduleAdmissionFinshedAccount(reqMgrWebScheduleAdmissionVo);
        log.info("\u5c31\u8bca\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\u7684\u603b\u6761\u6570\uff1a{}", (Object)totalFinishAdmissionAccount.toString());
        ResMgrWebAllScheduleAdmissionVo resMgrWebAllScheduleAdmissionVo = new ResMgrWebAllScheduleAdmissionVo();
        resMgrWebAllScheduleAdmissionVo.setGetMgrWebScheduleAdmissionVoRes(pageResult);
        resMgrWebAllScheduleAdmissionVo.setTotalFinishAdmission(totalFinishAdmissionAccount);
        log.info("\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)resMgrWebAllScheduleAdmissionVo.toString());
        return resMgrWebAllScheduleAdmissionVo;
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    private AdmissionEntity getAdmissionEntityById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        AdmissionEntity admissionEntityWrapper = new AdmissionEntity();
        admissionEntityWrapper.setXId(id);
        queryWrapper.setEntity((Object)admissionEntityWrapper);
        AdmissionEntity admissionEntity = (AdmissionEntity)this.baseInquiryAdmissionService.getOne((Wrapper)queryWrapper);
        if (null == admissionEntity) {
            return null;
        }
        return admissionEntity;
    }

    private AdmissionEntity getAdmissionEntityByOrderId(String orderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        AdmissionEntity admissionEntityWrapper = new AdmissionEntity();
        admissionEntityWrapper.setOrderId(orderId);
        queryWrapper.setEntity((Object)admissionEntityWrapper);
        AdmissionEntity admissionEntity = (AdmissionEntity)this.baseInquiryAdmissionService.getOne((Wrapper)queryWrapper);
        if (null == admissionEntity) {
            return null;
        }
        return admissionEntity;
    }

    public BaseResponse<String> patientRefund(PatientAdmissionVoReq patientAdmissionVoReq) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(patientAdmissionVoReq.getAdmId());
        log.info("\u5c31\u8bca\u8bb0\u5f55\u4e3a:{}" + JSON.toJSONString((Object)admissionEntity));
        if (null == admissionEntity) {
            return BaseResponse.error((String)"\u67e5\u8be2\u7684\u5c31\u8bca\u72b6\u6001\u8bb0\u5f55\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(patientAdmissionVoReq.getAdmId());
        log.info("\u8ba2\u5355\u8bb0\u5f55\u4e3a:{}" + JSON.toJSONString((Object)orderEntity));
        if (null == orderEntity) {
            return BaseResponse.error((String)"\u67e5\u8be2\u7684\u8ba2\u5355\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        if (!admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
            return BaseResponse.error((String)"\u60a3\u8005\u7684\u72b6\u6001\u4e0d\u662f\u5f85\u63a5\u8bca,\u9000\u6b3e\u5931\u8d25");
        }
        if (0 != new BigDecimal(orderEntity.getOwnCost()).compareTo(new BigDecimal(0.0))) {
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(orderEntity.getXId());
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId()));
        }
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
        }
        admissionEntity.setXUpdateTime(new Date());
        if (this.admissionMapper.update(admissionEntity) != 1) {
            return BaseResponse.error((String)"\u4fee\u6539\u5c31\u8bca\u72b6\u6001\u5931\u8d25");
        }
        this.imInformService.patientRefund(patientAdmissionVoReq.getAdmId());
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
        return BaseResponse.success((Object)"\u9000\u6b3e\u6210\u529f");
    }

    public BaseResponse<String> toAdmAgain(AdmissionInfoParam admissionInfoParam) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionInfoParam.getAdmId());
        if (null == admissionEntity) {
            return BaseResponse.error((String)"\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!AdmissionStatusEnum.PASSNUMBER.getValue().equals(admissionEntity.getStatus())) {
            return BaseResponse.error((String)"\u8be5\u72b6\u6001\u4e0d\u80fd\u91cd\u65b0\u5019\u8bca");
        }
        Integer status = this.admissionMapper.updateStatusByAdmId(admissionInfoParam.getAdmId(), AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        this.iMInformService.doctorMedicalRecord(admissionEntity.getXId());
        this.imInformService.waitingReportPushPatientCard(admissionEntity.getXId());
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        if (status == 1) {
            OrderTaskVo orderTaskVo = new OrderTaskVo();
            orderTaskVo.setId(admissionInfoParam.getOrderId());
            orderTaskVo.setType(Integer.valueOf(2));
            this.orderSender.sendDelay(orderTaskVo);
            return BaseResponse.success((Object)admissionEntity.getXId());
        }
        return BaseResponse.error((String)"\u91cd\u65b0\u5019\u8bca\u5931\u8d25");
    }

    public BaseResponse<String> passNumber(AdmissionInfoParam admissionInfoParam) {
        OrderAndAdmInfoVo orderAndAdmInfoVo = this.admissionMapper.getOrderAndAdmByAdmId(admissionInfoParam.getAdmId());
        if (null == orderAndAdmInfoVo) {
            return BaseResponse.error((String)"\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(orderAndAdmInfoVo.getStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u8fc7\u53f7");
        }
        log.info("orderAndAdmInfoVo{}", (Object)orderAndAdmInfoVo.toString());
        boolean equals = ServiceTypeEnum.NOS.getValue().equals(orderAndAdmInfoVo.getServType());
        boolean notEmpty = StringUtils.isNotEmpty((String)orderAndAdmInfoVo.getScheduleId());
        log.info("\u590d\u8bca:" + equals);
        log.info("\u9884\u7ea6:" + notEmpty);
        if (!equals || !notEmpty) {
            return BaseResponse.error((String)"\u5f53\u524d\u4e1a\u52a1\u4e0d\u652f\u6301\u8fc7\u53f7");
        }
        this.admissionMapper.updateStatusByAdmId(admissionInfoParam.getAdmId(), AdmissionStatusEnum.PASSNUMBER.getValue());
        String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String scheduleDate = DateUtils.dateToString((Date)orderAndAdmInfoVo.getScheduleTime(), (String)"yyyy-MM-dd") + " " + orderAndAdmInfoVo.getScheduleEnd() + ":00";
        boolean b = DateUtils.dateCompare((String)scheduleDate, (String)format);
        log.info("\u5f53\u524d\u65f6\u95f4:" + format);
        log.info("\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4:" + scheduleDate);
        log.info("\u65f6\u95f4\u6bd4\u8f83:" + b);
        if (b) {
            if ("HYT".equals(orderAndAdmInfoVo.getAppCode())) {
                AdmissionOrCancellationReqVo admissionOrCancellationReqVo = new AdmissionOrCancellationReqVo();
                admissionOrCancellationReqVo.setClinicCode(orderAndAdmInfoVo.getClinicCode());
                admissionOrCancellationReqVo.setYnSee("0");
                AdmissionOrCancellationResVo admissionOrCancellation = this.hisTemplateService.admissionOrCancellation(admissionOrCancellationReqVo);
                if (null == admissionOrCancellation) {
                    log.info("\u53d6\u6d88\u63a5\u8bca\u5931\u8d25");
                    return BaseResponse.error((String)"\u53d6\u6d88\u63a5\u8bca\u5931\u8d25");
                }
            }
            if (StringUtils.isEmpty((String)orderAndAdmInfoVo.getTotCost()) && orderAndAdmInfoVo.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                this.admissionMapper.updateStatusByAdmId(admissionInfoParam.getAdmId(), AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue());
            } else {
                RequestRefundVo requestRefundVo = new RequestRefundVo();
                requestRefundVo.setOrderId(orderAndAdmInfoVo.getOrderId());
                BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
                this.admissionMapper.updateStatusByAdmId(admissionInfoParam.getAdmId(), AdmissionStatusEnum.PASSNUMBER_REFUND.getValue());
            }
            return BaseResponse.success((Object)admissionInfoParam.getAdmId());
        }
        OrderTaskVo orderTaskVo = new OrderTaskVo();
        orderTaskVo.setId(orderAndAdmInfoVo.getOrderId());
        orderTaskVo.setType(Integer.valueOf(4));
        this.orderSender.sendDelay(orderTaskVo);
        this.smallProgramPushService.passNumber(admissionInfoParam.getAdmId(), orderAndAdmInfoVo.getHospitalId());
        this.alipaySmallProgramPushService.passNumber(admissionInfoParam.getAdmId(), orderAndAdmInfoVo.getHospitalId());
        this.imInformService.passNumberToPatient(admissionInfoParam.getAdmId());
        return BaseResponse.success((Object)admissionInfoParam.getAdmId());
    }

    public BaseResponse<ImmediateConsultationVo> getOrderInfo(AdmissionInfoParam admissionInfoParam) {
        if (StringUtils.isEmpty((String)admissionInfoParam.getOrderId())) {
            return BaseResponse.error((String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setXId(admissionInfoParam.getOrderId());
        queryWrapper.setEntity((Object)orderEntity);
        OrderEntity order = (OrderEntity)this.orderMapper.selectOne((Wrapper)queryWrapper);
        if (null == order) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ImmediateConsultationVo immediateConsultationVo = new ImmediateConsultationVo();
        immediateConsultationVo.setPubCost(order.getPubCost());
        immediateConsultationVo.setOwnCost(order.getOwnCost());
        immediateConsultationVo.setTotCost(order.getTotCost());
        immediateConsultationVo.setPayCost(order.getPayCost());
        immediateConsultationVo.setHospitalName(order.getHospitalName());
        immediateConsultationVo.setDocName(order.getDoctorName());
        immediateConsultationVo.setDeptName(order.getDeptName());
        immediateConsultationVo.setOrderId(admissionInfoParam.getOrderId());
        immediateConsultationVo.setScheduleDate(DateUtils.dateToString((Date)order.getScheduleDate(), (String)"yyyy-MM-dd"));
        immediateConsultationVo.setScheduleStartTime(order.getScheduleStartTime());
        immediateConsultationVo.setScheduleEndTime(order.getScheduleEndTime());
        immediateConsultationVo.setPayAmount(order.getPayAmount());
        immediateConsultationVo.setPayPrice(order.getPayAmount());
        return BaseResponse.success((Object)immediateConsultationVo);
    }

    public BaseResponse<String> doctorApprovalMedicalForm(DoctorApprovalMedicalFormDTO dto) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(dto.getAdmId());
        PatientEntity patient = this.patientMapper.selectById(admissionEntity.getPatientId());
        UpdatePatientDynamicMedicalUserFillsReqVo updatePatientDynamicMedicalReqVo = new UpdatePatientDynamicMedicalUserFillsReqVo();
        updatePatientDynamicMedicalReqVo.setxId(admissionEntity.getMedicalRecordId());
        updatePatientDynamicMedicalReqVo.setMedicalUserFills(dto.getMedicalUserFills());
        BaseResponse baseResponse = this.internetHospitalDetailInfoService.updateMedicalInfoById(updatePatientDynamicMedicalReqVo);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u66f4\u65b0\u533b\u751f\u7b7e\u540d\u5931\u8d25");
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        if (!((Boolean)baseResponse.getData()).booleanValue()) {
            return BaseResponse.error((String)"\u66f4\u65b0\u533b\u751f\u7b7e\u540d\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u66f4\u65b0\u533b\u751f\u7b7e\u540d\u6210\u529f");
    }

    public String medicalToWord(DoctorApprovalMedicalFormDTO vo, PatientEntity patient) {
        log.info("\u75c5\u5386\u4e0a\u4f20\u5f00\u59cb");
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_25);
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            String templateContent = "";
            byte[] downloadLocal = OSSClientUtil.downloadLocal((String)"webStatic/wechat-applets/sdfsyy/sdy-mz-caseTemplate-new16.html");
            templateContent = new String(downloadLocal, StandardCharsets.UTF_8);
            stringLoader.putTemplate("patienitMedical", templateContent);
            configuration.setTemplateLoader((TemplateLoader)stringLoader);
            Template template = configuration.getTemplate("patienitMedical");
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(vo.getMedicalUserFills().replace("\\", ""));
            HashMap<String, String> resultMap = new HashMap<String, String>();
            for (JsonNode node : rootNode) {
                String key = node.path("keywords").asText();
                String value = node.path("value").asText();
                resultMap.put(key, value);
            }
            String jsonOutput = mapper.writeValueAsString(resultMap);
            JsonNode resultJsonNode = mapper.readTree(jsonOutput);
            log.info("\u75c5\u5386\u4e0a\u4f20\u5f00\u59cb{}", (Object)JSON.toJSONString((Object)jsonOutput));
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("patientName", patient.getPactName());
            placeholders.put("patientSex", patient.getGender().equals(1) ? "\u7537" : "\u5973");
            Integer age = IDCardUtil.getAge((String)patient.getIdcard());
            placeholders.put("patientAge", age + "\u5c81");
            placeholders.put("clinicDate", DateUtils.getDateStr((String)resultJsonNode.get("clinicDate").toString().replace("\"", "")));
            placeholders.put("cardNo", patient.getCardNo());
            placeholders.put("patientHeight", resultJsonNode.get("patientHeight").toString().replace("\"", ""));
            placeholders.put("patientWeight", null == resultJsonNode.get("patientWeight") ? "" : resultJsonNode.get("patientWeight").toString().replace("\"", ""));
            placeholders.put("isCardiovascularDisease", null == resultJsonNode.get("isCardiovascularDisease") ? "" : resultJsonNode.get("isCardiovascularDisease").toString().replace("\"", ""));
            placeholders.put("cardiovascularDiseaseDrug", null == resultJsonNode.get("cardiovascularDiseaseDrug") ? "\u6682\u65e0" : resultJsonNode.get("cardiovascularDiseaseDrug").toString().replace("\"", ""));
            placeholders.put("isAsthma", null == resultJsonNode.get("isAsthma") ? "\u65e0" : resultJsonNode.get("isAsthma").toString().replace("\"", ""));
            placeholders.put("asthmaDrug", null == resultJsonNode.get("asthmaDrug") ? "\u6682\u65e0" : resultJsonNode.get("asthmaDrug").toString().replace("\"", ""));
            placeholders.put("isCerebralInfarction", null == resultJsonNode.get("isCerebralInfarction") ? "" : resultJsonNode.get("isCerebralInfarction").toString().replace("\"", ""));
            placeholders.put("cerebralInfarctionDrug", null == resultJsonNode.get("cerebralInfarctionDrug") ? "\u6682\u65e0" : resultJsonNode.get("cerebralInfarctionDrug").toString().replace("\"", ""));
            placeholders.put("isDiabetes", null == resultJsonNode.get("isDiabetes") ? "" : resultJsonNode.get("isDiabetes").toString().replace("\"", ""));
            placeholders.put("diabetesDrug", null == resultJsonNode.get("diabetesDrug") ? "\u6682\u65e0" : resultJsonNode.get("diabetesDrug").toString().replace("\"", ""));
            placeholders.put("isFever", null == resultJsonNode.get("isFever") ? "" : resultJsonNode.get("isFever").toString().replace("\"", ""));
            placeholders.put("isPregnant", null == resultJsonNode.get("isPregnant") ? "" : resultJsonNode.get("isPregnant").toString().replace("\"", ""));
            placeholders.put("isClimbingStairs", null == resultJsonNode.get("isClimbingStairs") ? "" : resultJsonNode.get("isClimbingStairs").toString().replace("\"", ""));
            placeholders.put("isAllergic", null == resultJsonNode.get("isAllergic") ? "" : resultJsonNode.get("isAllergic").toString().replace("\"", ""));
            placeholders.put("isSurgery", null == resultJsonNode.get("isSurgery") ? "" : resultJsonNode.get("isSurgery").toString().replace("\"", ""));
            placeholders.put("historySurgery", null == resultJsonNode.get("historySurgery") ? "\u6682\u65e0" : resultJsonNode.get("historySurgery").toString().replace("\"", ""));
            placeholders.put("isOSAS", null == resultJsonNode.get("isOSAS") ? "" : resultJsonNode.get("isOSAS").toString().replace("\"", ""));
            placeholders.put("remark", null == resultJsonNode.get("remark") ? "\u6682\u65e0" : resultJsonNode.get("remark").toString().replace("\"", ""));
            placeholders.put("isPass", null == resultJsonNode.get("isPass") ? "" : resultJsonNode.get("isPass").toString().replace("\"", ""));
            placeholders.put("patient_sign", null == resultJsonNode.get("patientSignature") ? "" : resultJsonNode.get("patientSignature").toString().replace("\"", ""));
            placeholders.put("doctor_sign", null == resultJsonNode.get("doctorSignature") ? "" : resultJsonNode.get("doctorSignature").toString().replace("\"", ""));
            StringWriter fileWriter = new StringWriter();
            template.process(placeholders, (Writer)fileWriter);
            String doc = fileWriter.toString();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ITextRenderer renderer = new ITextRenderer();
            IMInformServiceImpl.ResourceLoaderUserAgent callback = new IMInformServiceImpl.ResourceLoaderUserAgent(renderer.getOutputDevice());
            SharedContext sharedContext = renderer.getSharedContext();
            sharedContext.setReplacedElementFactory((ReplacedElementFactory)new B64ImgReplacedElementFactory());
            sharedContext.setUserAgentCallback((UserAgentCallback)callback);
            callback.setSharedContext(sharedContext);
            renderer.setScaleToFit(true);
            renderer.getFontResolver().addFont("template/SimSun.ttc", "Identity-H", false);
            renderer.setDocumentFromString(doc);
            renderer.layout();
            renderer.createPDF((OutputStream)os, false);
            renderer.finishPDF();
            String rodom = vo.getAdmId();
            ByteArrayInputStream instream = new ByteArrayInputStream(os.toByteArray());
            OSSClientUtil.uploadFile2OSS((InputStream)instream, (String)("medical_mz_" + rodom + ".pdf"));
            String ossPath = OSSClientUtil.getViewUrl((String)"cdn2019.oss-cn-beijing.aliyuncs.com/", (String)("medical_mz_" + rodom + ".pdf"));
            return ossPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String medicalToWordNew(DoctorApprovalMedicalFormDTO vo, PatientEntity patient) {
        List medicalUserFills = JSON.parseArray((String)vo.getMedicalUserFills(), MedicalSortVo.class);
        medicalUserFills.sort(Comparator.comparingInt(MedicalSortVo::getSort));
        String templateContent = "";
        byte[] downloadLocal = OSSClientUtil.downloadLocal((String)"webStatic/wechat-applets/sdfsyy/sdy-mz-caseTemplate-new15.html");
        templateContent = new String(downloadLocal, StandardCharsets.UTF_8);
        Context context = new Context();
        context.setVariable("medicalUserFills", (Object)medicalUserFills);
        String htmlContent = this.templateEngine.process(templateContent, (IContext)context);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HtmlConverter.convertToPdf((String)htmlContent, (OutputStream)outputStream);
        String rodom = vo.getAdmId();
        OSSClientUtil.uploadFile2OSS((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), (String)("medical_mz_" + rodom + ".pdf"));
        String ossPath = OSSClientUtil.getViewUrl((String)"cdn2019.oss-cn-beijing.aliyuncs.com/", (String)("medical_mz_" + rodom + ".pdf"));
        return ossPath;
    }

    static /* synthetic */ SmallProgramPushService access$000(AdmissionServiceImpl x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ UmAppPushService access$100(AdmissionServiceImpl x0) {
        return x0.umAppPushService;
    }

    static /* synthetic */ AliSmsPushService access$200(AdmissionServiceImpl x0) {
        return x0.aliSmsPushService;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ IMInformService access$400(AdmissionServiceImpl x0) {
        return x0.iMInformService;
    }

    static /* synthetic */ AlipaySmallProgramPushService access$500(AdmissionServiceImpl x0) {
        return x0.alipaySmallProgramPushService;
    }

    static /* synthetic */ OrderEntity access$600(AdmissionServiceImpl x0, String x1) {
        return x0.getOrderById(x1);
    }

    static /* synthetic */ OrderSender access$700(AdmissionServiceImpl x0) {
        return x0.orderSender;
    }

    static /* synthetic */ IMInformService access$800(AdmissionServiceImpl x0) {
        return x0.imInformService;
    }

    static /* synthetic */ GoEasyPushService access$900(AdmissionServiceImpl x0) {
        return x0.goEasyPushService;
    }

    static /* synthetic */ OrderMapper access$1000(AdmissionServiceImpl x0) {
        return x0.orderMapper;
    }

    static /* synthetic */ PatientMedicalRecordMapper access$1100(AdmissionServiceImpl x0) {
        return x0.patientMedicalRecordMapper;
    }
}

