/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientNoResponseReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestGetDoctorOfficeStatus;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestOnlineOrOfflineVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.H5UrlEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.PushUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.GetMainIdsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PushConfigurationDetailVO;
import com.ebaiyihui.push.pojo.alisms.AliSmsSendAuthCodeReqPhoneVO;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.xikang.hc.sdk.client.impl.HcEntranceOptClientImpl;
import com.xikang.hc.sdk.common.exception.HcBizException;
import com.xikang.hc.sdk.common.exception.HcSysException;
import com.xikang.hc.sdk.cond.TemplateDataInfo;
import com.xikang.hc.sdk.cond.WechatTemplateMessage;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliSmsPushServiceImpl
implements AliSmsPushService {
    private static final Logger log = LoggerFactory.getLogger(AliSmsPushServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private DoctorInfofeignClient doctorInfoClient;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PushUtils pushUtils;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    private static final String ONE = "-1";

    public void onlinepaymentCompletedAliSmsPush(String admId) {
        log.info("\u652f\u4ed8\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getPaymentCompleted());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getPaymentCompletedByHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void onlineDiagnosisCompletedAliSmsPush(String admId) {
        log.info("\u7ed3\u675f\u5c31\u8bca\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getDiagnosisCompleted());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void AliSmsPush(String admId, String temp) {
        log.info("\u7ed3\u675f\u5c31\u8bca\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        BaseResponse baseResponse = this.queryDoctorByDoctorId(doctorId);
        String doctorPhone = ((PersonnelInfo)baseResponse.getData()).getPhoneNum();
        String doctorName = ((PersonnelInfo)baseResponse.getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(temp);
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        nameMap.put("name", patientEntity.getPatientName());
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(doctorPhone);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void writeMedicalRecordRemind(String admId, String temp) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        BaseResponse baseResponse = this.queryDoctorByDoctorId(doctorId);
        String doctorPhone = ((PersonnelInfo)baseResponse.getData()).getPhoneNum();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(temp);
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("name", patientEntity.getPatientName());
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(doctorPhone);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void remindReplaySms(String admId, String temp, String isPatient) {
        log.info("\u53d1\u9001\u6d88\u606f\u5165\u53c2" + admId + temp + isPatient);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        BaseResponse baseResponse = this.queryDoctorByDoctorId(doctorId);
        String doctorPhone = ((PersonnelInfo)baseResponse.getData()).getPhoneNum();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(temp);
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        if ("1".equals(isPatient)) {
            HashMap<String, String> nameMap = new HashMap<String, String>(1);
            nameMap.put("name", ((PersonnelInfo)baseResponse.getData()).getDoctorName());
            aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
            aliSmsSendAuthCodeReqPhoneVO.setPhone(patientEntity.getTelphone());
        } else {
            HashMap<String, String> nameMap1 = new HashMap<String, String>(1);
            nameMap1.put("name", patientEntity.getPatientName());
            aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap1);
            aliSmsSendAuthCodeReqPhoneVO.setPhone(doctorPhone);
        }
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void onlineCallAliSmsPush(String admId) {
        log.info("\u89c6\u9891\u901a\u8bdd\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getVideoCall());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getCallForHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        this.stemplateMessage(patientEntity, admId, "3");
    }

    public void onlineVideoCallAliSmsPush(String admId) {
        log.info("\u89c6\u9891\u901a\u8bdd\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getVideoCall());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getVideoCallForHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        this.stemplateMessage(patientEntity, admId, "3");
    }

    public void onlineChargeBackAliSmsPush(String admId) {
        log.info("\u9000\u5355\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getChargeBack());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getChargeBackByHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void onlineApplicationSuccessfulAliSmsPush(String doctorId, String patientId, String admId) {
        log.info("\u590d\u8bca\u4e0b\u5355\u6210\u529f\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.getOrderInfo(admId);
        if (null == orderEntity) {
            log.info("=======admd\u4e0b\u6ca1\u6709\u8ba2\u5355=======");
            return;
        }
        if (DoctorTypeEnum.TEAM.getValue() == orderEntity.getDoctorType()) {
            List teamDoctorInfoEntityList = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admId));
            if (CollectionUtil.isNotEmpty((Collection)teamDoctorInfoEntityList)) {
                log.info("------\u77ed\u4fe1\u7fa4\u53d1\u5f00\u59cb-----" + JSONObject.toJSONString(teamDoctorInfoEntityList.stream().map(i -> i.getDoctorId()).collect(Collectors.toList())));
                for (TeamDoctorInfoEntity teamDoctorInfoEntity : teamDoctorInfoEntityList) {
                    this.onlineAliMessageonlinePush(orderEntity, patientId, teamDoctorInfoEntity.getDoctorId(), admId);
                }
            }
        } else {
            this.onlineAliMessageonlinePush(orderEntity, patientId, doctorId, admId);
        }
    }

    public void onlineDoctorReceptionAliSmsPush(String admId) {
        log.info("\u533b\u751f\u63a5\u8bca\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        if (null == admissionEntity) {
            log.info("=====\u5c31\u8bca\u7a7a====");
            return;
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getDoctorReception());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getDoctorReceptionByHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void refuseReceiveVisit(String admId) {
        log.info("\u533b\u751f\u62d2\u7edd\u63a5\u8bca\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001");
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        if (null == admissionEntity) {
            log.info("=====\u5c31\u8bca\u7a7a====");
            return;
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            log.info("=====\u8ba2\u5355\u7a7a====");
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.info("=====\u60a3\u8005====");
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getRefuseReceiveVisit());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getRefuseReceiveVisitByHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void ScheduleChange(String doctorId, String appCode, String hospitalId) {
        log.info("\u6392\u671f\u53d8\u66f4\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001");
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(appCode);
        requestGetDoctorOfficeStatus.setDoctorId(doctorId);
        requestGetDoctorOfficeStatus.setHospitalId(hospitalId);
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        String phoneNum = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getPhoneNum();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getScheduleChange());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCodeByAppCode(appCode).getClientCode());
        HashMap nameMap = new HashMap(1);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCodeByAppCode(appCode).getDoctorCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        log.info("\u6392\u671f\u53d8\u66f4\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001\u7ed3\u675f");
    }

    public void onlineVisitsApplicationSuccessfulAliSmsPush(String doctorId, String patientId, String admId) {
        log.info("\u4e0b\u5355\u6210\u529f\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001");
        OrderEntity orderEntity = this.getOrderInfo(admId);
        if (null == orderEntity) {
            log.info("=======admd\u4e0b\u6ca1\u6709\u8ba2\u5355=======");
            return;
        }
        if (DoctorTypeEnum.TEAM.getValue() == orderEntity.getDoctorType()) {
            List teamDoctorInfoEntityList = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admId));
            if (CollectionUtil.isNotEmpty((Collection)teamDoctorInfoEntityList)) {
                log.info("------\u77ed\u4fe1\u7fa4\u53d1\u5f00\u59cb-----" + JSONObject.toJSONString(teamDoctorInfoEntityList.stream().map(i -> i.getDoctorId()).collect(Collectors.toList())));
                for (TeamDoctorInfoEntity teamDoctorInfoEntity : teamDoctorInfoEntityList) {
                    this.aliMessagePush(orderEntity, patientId, teamDoctorInfoEntity.getDoctorId(), admId);
                }
            }
        } else {
            this.aliMessagePush(orderEntity, patientId, doctorId, admId);
        }
    }

    public void aliMessagePush(OrderEntity orderEntity, String patientId, String doctorId, String admId) {
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(doctorId);
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        String phoneNum = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getPhoneNum();
        String patientName = this.getpatientByPatientId(patientId);
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getAliSmsTemplateCode());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("name", patientName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getDoctorCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        log.info("\u4e0b\u5355\u6210\u529f\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001\u7ed3\u675f");
    }

    public void onlineAliMessageonlinePush(OrderEntity orderEntity, String patientId, String doctorId, String admId) {
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(doctorId);
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        String phoneNum = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getPhoneNum();
        String patientName = this.getpatientByPatientId(patientId);
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getFollowupVisitAliSmsTemplateCode());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("name", patientName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getDoctorCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        log.info("\u590d\u8bca\u4e0b\u5355\u6210\u529f\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001\u7ed3\u675f");
    }

    public void onlineVisitsApplicationNoResponseInTwoHoursAliSmsPush(PatientNoResponseReqVo patientNoResponseReqVo) throws AdmissionException {
        OrderEntity orderEntity = this.getOrderInfo(patientNoResponseReqVo.getAdmId());
        if (null == orderEntity) {
            log.info("=======admd\u4e0b\u6ca1\u6709\u8ba2\u5355=======");
            return;
        }
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(orderEntity.getDoctorId());
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findById(patientNoResponseReqVo.getAdmId());
        if (null == admissionEntity) {
            return;
        }
        if ("1".equals(patientNoResponseReqVo.getType())) {
            log.error("\u8868\u793a\u533b\u751f\u672a\u56de\u590d\u6d88\u606f10\u5206\u949f\uff0c\u4e0d\u63a8\u9001");
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("=====\u5c31\u8bca\u72b6\u6001\u4e0d\u662f\u95ee\u8bca\u4e2d\u7684\u72b6\u6001\uff0c\u4e0d\u4f1a\u63a8\u9001\u77ed\u606f\u6d88\u606f=====");
            return;
        }
        String doctorId = admissionEntity.getDoctorId();
        String patientId = admissionEntity.getPatientId();
        String phoneNum = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getPhoneNum();
        String patientName = this.getpatientByPatientId(patientId);
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getNoReplyInTwoHoursAliSmsTemplateCode());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(patientNoResponseReqVo.getAdmId()).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("patientName", patientName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(patientNoResponseReqVo.getAdmId()).getDoctorCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void onlineVisitsApplicationNoResponseInTenMinutesAliSmsPush(String admId) throws AdmissionException {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        if (null == admissionEntity) {
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("=====\u5c31\u8bca\u72b6\u6001\u4e0d\u662f\u95ee\u8bca\u4e2d\u7684\u72b6\u6001=====");
            return;
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getNoReplyInInTenMinuteAliSmsTemplateCode());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorName", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void toPay(String admId) {
        log.info("\u4e0b\u5355\u77ed\u4fe1\u53d1\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return;
        }
        String patientId = orderEntity.getPatientId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToPay());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToPayForHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap nameMap = new HashMap(1);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void toWait(String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return;
        }
        String doctorName = orderEntity.getDoctorName();
        String patientId = orderEntity.getPatientId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToWait());
        } else {
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToWaitForHos());
        }
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorname", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void toWriteMedicalRecord(String admId, String doctorPhone) {
        PatientDynamicMedicalEntityVo entityVo;
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return;
        }
        String patientId = orderEntity.getPatientId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            return;
        }
        String patientName = patientEntity.getPatientName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToWriteMedicalRecord());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("name", patientName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(doctorPhone);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        GetMainIdsReqVo getMainIdsReqVo = new GetMainIdsReqVo();
        getMainIdsReqVo.setAppCode(orderEntity.getAppCode());
        getMainIdsReqVo.setAdmissionId(admId);
        List ids = this.internetHospitalDetailInfoService.findMainIdsByAdmIdAndAppCode(getMainIdsReqVo);
        log.info("ids{}", (Object)JSON.toJSONString((Object)ids));
        if (ObjectUtils.isEmpty((Object)ids)) {
            log.info("\u63d0\u9192\u533b\u751f\u5f00\u5904\u65b9");
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToWritePrecriptions());
            this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        }
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectById((Serializable)((Object)admId));
        if (ServiceTypeEnum.NOS.getValue().equals(admissionEntity.getServType()) && ObjectUtils.isEmpty((Object)(entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admId)))) {
            log.info("\u63d0\u9192\u533b\u751f\u5199\u75c5\u5386");
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToWriteMedicalRecord());
            this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        }
    }

    public void toWritePrecriptions(String admId, String doctorPhone) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return;
        }
        String patientId = orderEntity.getPatientId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            return;
        }
        String patientName = patientEntity.getPatientName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getToWritePrecriptions());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("name", patientName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(doctorPhone);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public BaseResponse<PersonnelInfo> queryDoctorByDoctorId(String doctorId) {
        log.info("\u533b\u751f\u7528\u6237\u8c03\u7528:{} ", (Object)JSON.toJSONString((Object)doctorId));
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorId);
        BaseResponse personnelInfoBaseResponse = this.doctorInfoClient.queryPersonnelInfo(queryPersonnelInfoReq);
        log.info("req :{}", (Object)JSON.toJSONString((Object)personnelInfoBaseResponse));
        return personnelInfoBaseResponse;
    }

    private String getpatientByPatientId(String patientId) {
        log.info("\u60a3\u8005\u8c03\u7528\u5165\u53c2:{} ", (Object)JSON.toJSONString((Object)patientId));
        PatientEntity patientEntity = this.patientMapper.selectById(patientId);
        log.info("patientEntity :{}", (Object)JSON.toJSONString((Object)patientEntity));
        return patientEntity.getPatientName();
    }

    private void stemplateMessage(PatientEntity patientEntity, String admId, String servType) {
        HcEntranceOptClientImpl c = new HcEntranceOptClientImpl();
        WechatTemplateMessage templateSendCond = new WechatTemplateMessage();
        templateSendCond.setReceiveProofNum(patientEntity.getIdcard());
        templateSendCond.setTemplateCode("TEMP_CH_VIDEO_01");
        templateSendCond.setLinkUrl(H5UrlEnum.MESSAGE.getValue() + "?admId=" + admId + "&servType=" + servType + "&inlet=card");
        templateSendCond.setWeichatNo("JSJKT");
        HashMap<String, TemplateDataInfo> templateDataInfoMap = new HashMap<String, TemplateDataInfo>();
        templateDataInfoMap.put("keyword1", new TemplateDataInfo(patientEntity.getPatientName(), "#000000"));
        templateDataInfoMap.put("keyword2", new TemplateDataInfo(patientEntity.getGender() == 1 ? "\u7537" : "\u5973", "#000000"));
        templateDataInfoMap.put("keyword3", new TemplateDataInfo(String.valueOf(IDCardUtil.getAge((String)patientEntity.getIdcard())), "#000000"));
        templateDataInfoMap.put("keyword4", new TemplateDataInfo(patientEntity.getTelphone(), "#000000"));
        templateDataInfoMap.put("keyword5", new TemplateDataInfo(DateUtils.getCurrentDateToString(), "#000000"));
        templateSendCond.setTemplateContentMap(templateDataInfoMap);
        try {
            c.sendWechatTemplateMessage(templateSendCond);
        }
        catch (HcBizException | HcSysException e) {
            e.printStackTrace();
        }
    }

    private String getEchatMessageApi(AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO) {
        log.info("\u77ed\u4fe1\u63a8\u9001\u5165\u53c2" + JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
        String url = this.projProperties.getAliSmsPushUrl();
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u63a8\u9001\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
        if (ONE.equals(response.getErrCode())) {
            log.info("=================\u77ed\u4fe1\u63a8\u9001\u5931\u8d25================");
            return "\u77ed\u4fe1\u63a8\u9001\u5931\u8d25";
        }
        return null;
    }

    private PushConfigurationDetailVO getSmsClientCode(String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return null;
        }
        String appCode = orderEntity.getAppCode();
        PushConfigurationDetailVO pushConfig = this.pushUtils.getPushConfig(appCode, "sms", "doctor", "sms");
        if (null == pushConfig) {
            return null;
        }
        return pushConfig;
    }

    private PushConfigurationDetailVO getSmsClientCodeByAppCode(String appCode) {
        PushConfigurationDetailVO pushConfig = this.pushUtils.getPushConfig(appCode, "sms", "doctor", "sms");
        if (null == pushConfig) {
            return null;
        }
        return pushConfig;
    }

    private OrderEntity getOrderInfo(String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return null;
        }
        return orderEntity;
    }
}

