/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.MangerRefundReq;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.AppealInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.AppealInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AppealInfoService;
import com.ebaiyihui.onlineoutpatient.core.service.ManagerAdvisoryService;
import com.ebaiyihui.onlineoutpatient.core.vo.appeal.AppealDetailReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.appeal.AppealFindForDoctorReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.appeal.AppealFindForManagerReeqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.appeal.AppealSaveReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.appeal.AppealVerifyReqVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppealInfoServiceImpl
implements AppealInfoService {
    private static final Logger log = LoggerFactory.getLogger(AppealInfoServiceImpl.class);
    @Resource
    private AppealInfoMapper appealInfoMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private PatientMapper patientMapper;
    @Resource
    private ManagerAdvisoryService managerAdvisoryService;

    public BaseResponse saveAppeal(AppealSaveReqVo appealSaveReqVo) {
        try {
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)appealSaveReqVo.getOrderId()));
            PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
            AppealInfoEntity appealInfoEntity = new AppealInfoEntity();
            appealInfoEntity.setStatus(1);
            appealInfoEntity.setAppealReason(appealSaveReqVo.getAppealReason());
            appealInfoEntity.setAppealType(appealSaveReqVo.getAppealType());
            appealInfoEntity.setOrderId(appealSaveReqVo.getOrderId());
            appealInfoEntity.setDeptId(orderEntity.getDeptId().toString());
            appealInfoEntity.setDeptName(orderEntity.getDeptName());
            appealInfoEntity.setDoctorId(orderEntity.getDoctorId());
            appealInfoEntity.setDoctorName(orderEntity.getDoctorName());
            appealInfoEntity.setPatientId(orderEntity.getPatientId());
            appealInfoEntity.setPatientName(patientEntity.getPatientName());
            appealInfoEntity.setPatientPhone(patientEntity.getTelphone());
            appealInfoEntity.setHospitalId(orderEntity.getOrganId());
            this.appealInfoMapper.insert((Object)appealInfoEntity);
            QueryWrapper queryWrapper = new QueryWrapper();
            AdmissionEntity admissionEntity = new AdmissionEntity();
            admissionEntity.setOrderId(appealSaveReqVo.getOrderId());
            queryWrapper.setEntity((Object)admissionEntity);
            AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapper);
            if (2 == admission.getStatus()) {
                admission.setStatus(AdmissionStatusEnum.FINISH_APPLY.getValue());
                admission.setEndTime(new Date());
                this.admissionMapper.update(admission);
            }
        }
        catch (Exception e) {
            log.info("\u7533\u8bc9\u4fdd\u5b58\u5931\u8d25!{}", (Throwable)e);
            return BaseResponse.error((String)"\u7533\u8bc9\u4fdd\u5b58\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse verifyAppeal(AppealVerifyReqVo appealVerifyReqVo) {
        try {
            AppealInfoEntity appealInfoEntity = (AppealInfoEntity)this.appealInfoMapper.selectById((Serializable)((Object)appealVerifyReqVo.getId()));
            if (Objects.isNull(appealInfoEntity)) {
                log.info("\u7533\u8bc9\u8bb0\u5f55\u4e0d\u5b58\u5728");
                return BaseResponse.error((String)"\u7533\u8bc9\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            if (1 != appealInfoEntity.getStatus()) {
                log.info("\u4e0d\u53ef\u91cd\u590d\u5ba1\u6838");
                return BaseResponse.error((String)"\u4e0d\u53ef\u91cd\u590d\u5ba1\u6838");
            }
            if (appealVerifyReqVo.getStatus() == 2) {
                MangerRefundReq param = new MangerRefundReq();
                AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(appealInfoEntity.getOrderId());
                param.setAdmissionId(admissionEntity.getXId());
                param.setIsRefund(Integer.valueOf(2));
                param.setReason(appealInfoEntity.getAppealReason());
                this.managerAdvisoryService.managerRefund(param);
            }
            appealInfoEntity.setVerifier(appealVerifyReqVo.getVerifier());
            appealInfoEntity.setVerifyId(appealVerifyReqVo.getVerifyId());
            appealInfoEntity.setStatus(appealVerifyReqVo.getStatus());
            appealInfoEntity.setRefuseReason(appealVerifyReqVo.getRefuseReason());
            appealInfoEntity.setVerifyTime(new Date());
            this.appealInfoMapper.updateById((Object)appealInfoEntity);
        }
        catch (Exception e) {
            log.info("\u7533\u8bc9\u5ba1\u6838\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u7533\u8bc9\u5ba1\u6838\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<AppealInfoEntity>> getAppealListForDoctor(AppealFindForDoctorReqVo appealFindForDoctorReqVo) {
        List appealInfoEntities = this.appealInfoMapper.getAppealListForDoctor(appealFindForDoctorReqVo);
        return BaseResponse.success((Object)appealInfoEntities);
    }

    public BaseResponse<PageInfo<AppealInfoEntity>> getAppealListForManager(AppealFindForManagerReeqVo appealFindForManagerReeqVo) {
        PageHelper.startPage((int)appealFindForManagerReeqVo.getPageNum(), (int)appealFindForManagerReeqVo.getPageSize());
        List appealInfoEntities = this.appealInfoMapper.getAppealListForManager(appealFindForManagerReeqVo);
        PageInfo pageInfo = new PageInfo(appealInfoEntities);
        return BaseResponse.success((Object)pageInfo);
    }

    public BaseResponse<AppealInfoEntity> getAppealDetail(AppealDetailReqVo appealDetailReqVo) {
        AppealInfoEntity appealInfoEntity = this.appealInfoMapper.getAppealDetail(appealDetailReqVo);
        return BaseResponse.success((Object)appealInfoEntity);
    }
}

