/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.DepartmentNode;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorSectionRelMapper;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorSectionRelEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaseDoctorSectionRelServiceImpl
extends ServiceImpl<DoctorSectionRelMapper, DoctorSectionRelEntity> {
    private static final Logger log = LoggerFactory.getLogger(BaseDoctorSectionRelServiceImpl.class);

    public BaseResponse<List<DepartmentNode>> getDepartmentTreeBySectionId(Integer sectionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorSectionRelEntity doctorSectionRelEntity = new DoctorSectionRelEntity();
        if (null == sectionId) {
            return BaseResponse.error((String)"\u67e5\u8be2\u79d1\u5ba4\u5217\u8868\u5931\u8d25");
        }
        doctorSectionRelEntity.setSectionId(sectionId);
        queryWrapper.setEntity((Object)doctorSectionRelEntity);
        List list = this.list((Wrapper)queryWrapper);
        log.info("list{}", (Object)JSON.toJSONString((Object)list));
        Map<String, List<DoctorSectionRelEntity>> groupedByFirstDeptId = list.stream().collect(Collectors.groupingBy(DoctorSectionRelEntity::getFirstDeptId));
        ArrayList<DepartmentNode> departmentNodeList = new ArrayList<DepartmentNode>();
        for (Map.Entry<String, List<DoctorSectionRelEntity>> entry : groupedByFirstDeptId.entrySet()) {
            String firstDeptId = entry.getKey();
            List<DoctorSectionRelEntity> firstDeptEntities = entry.getValue();
            DoctorSectionRelEntity firstEntity = firstDeptEntities.get(0);
            DepartmentNode departmentNode = new DepartmentNode();
            departmentNode.setFirstDeptId(firstDeptId);
            departmentNode.setFirstDeptName(firstEntity.getFirstDeptName());
            ArrayList<DepartmentNode.SubDepartmentNode> subDepartments = new ArrayList<DepartmentNode.SubDepartmentNode>();
            for (DoctorSectionRelEntity doctorSectionRel : firstDeptEntities) {
                DepartmentNode.SubDepartmentNode subDepartmentNode = new DepartmentNode.SubDepartmentNode();
                subDepartmentNode.setDoctorDeptId(doctorSectionRel.getDoctorDeptId());
                subDepartmentNode.setDoctorDeptName(doctorSectionRel.getDoctorDeptName());
                subDepartments.add(subDepartmentNode);
            }
            List subDepartmentNodeList = subDepartments.stream().collect(Collectors.toMap(DepartmentNode.SubDepartmentNode::getDoctorDeptId, doctDepartmentNodor -> doctDepartmentNodor, (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
            departmentNode.setSubDepartments(subDepartmentNodeList);
            departmentNodeList.add(departmentNode);
        }
        return BaseResponse.success(departmentNodeList);
    }
}

