/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.dao.ComplaintMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.ComplaintEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.ComplaintService;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestComlaintVo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ComplaintServiceImpl
implements ComplaintService {
    private static final Logger log = LoggerFactory.getLogger(ComplaintServiceImpl.class);
    @Resource
    private ComplaintMapper complaintMapper;
    @Resource
    OrderMapper orderMapper;
    @Resource
    PatientMapper patientMapper;

    public BaseResponse<ComplaintEntity> saveComplaint(RequestComlaintVo requestComlaintVo) {
        try {
            ComplaintEntity complaintEntity = new ComplaintEntity();
            BeanUtils.copyProperties((Object)requestComlaintVo, (Object)complaintEntity);
            String admId = requestComlaintVo.getAdmId();
            OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
            PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
            complaintEntity.setAdmId(admId);
            complaintEntity.setOrganId(orderEntity.getOrganId());
            complaintEntity.setAppCode(orderEntity.getAppCode());
            complaintEntity.setDoctorId(orderEntity.getDoctorId());
            complaintEntity.setDoctorName(orderEntity.getDoctorName());
            complaintEntity.setPaitientId(patientEntity.getXId());
            complaintEntity.setPatientName(patientEntity.getPatientName());
            complaintEntity.setPatientCredNo(patientEntity.getIdcard());
            complaintEntity.setPatientPhone(patientEntity.getTelphone());
            this.complaintMapper.insert((Object)complaintEntity);
            return BaseResponse.success((Object)complaintEntity);
        }
        catch (Exception e) {
            log.error("exception", (Throwable)e);
            return BaseResponse.error((String)"\u65b0\u589e\u6295\u8bc9\u4e3e\u62a5\u5931\u8d25");
        }
    }
}

