/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.ServiceConfigVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ReferralInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorTeamEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ReferralInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorTeamService;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorTemInfomService;
import com.ebaiyihui.onlineoutpatient.core.service.GoEasyPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorWorkFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorWorkingServiceClient;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqTeamReferralVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientInformationVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResReferralDetailsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResTeamReferralVo;
import com.ebaiyihui.onlineoutpatient.core.vo.workservice.GetDocServiceConfigReq;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DoctorTeamServiceImpl
implements DoctorTeamService {
    private static final Logger log = LoggerFactory.getLogger(DoctorTeamServiceImpl.class);
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Resource
    private DoctorWorkFeignClient doctorWorkFeignClient;
    @Resource
    private DoctorWorkingServiceClient doctorWorkingServiceClient;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private UmAppPushService umAppPushService;
    @Autowired
    private AdmissionService admissionService;
    @Autowired
    private PayAsyncService payAsyncService;
    @Resource
    private IMInformService imInformService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private DoctorTemInfomService doctorTemInfomService;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;
    @Autowired
    private GoEasyPushService goEasyPushService;
    @Resource
    ReferralInfoMapper referralInfoMapper;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public BaseResponse<ResPatientInformationVo> getPatientById(String patientId) {
        if (null == patientId) {
            return BaseResponse.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PatientEntity patientEntity = this.patientMapper.selectById(patientId);
        if (patientEntity == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25");
        }
        log.info("patientEntity:{}" + patientEntity.toString());
        ResPatientInformationVo resPatientInformationVo = new ResPatientInformationVo();
        resPatientInformationVo.setGender(patientEntity.getGender());
        resPatientInformationVo.setIdcard(patientEntity.getIdcard());
        resPatientInformationVo.setTelphone(patientEntity.getTelphone());
        resPatientInformationVo.setPatientId(patientEntity.getXId());
        resPatientInformationVo.setPatientName(patientEntity.getPatientName());
        try {
            Integer age = IDCardUtil.getAge((String)patientEntity.getIdcard());
            resPatientInformationVo.setAge(age);
        }
        catch (Exception e) {
            log.error("\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u60a3\u8005\u5e74\u9f84\u5931\u8d25\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801={}", (Object)patientEntity.getIdcard(), (Object)e);
        }
        resPatientInformationVo.setCardNo(patientEntity.getCardNo());
        log.info("resPatientInformationVo:{}" + resPatientInformationVo.toString());
        return BaseResponse.success((Object)resPatientInformationVo);
    }

    public BaseResponse<ResTeamReferralVo> insertDoctorTermRecords(ReqTeamReferralVo reqTeamReferralVo) {
        ServiceConfigVo serviceConfig;
        Integer t;
        AdmissionEntity admissionEntity = this.admissionMapper.findByAdmId(reqTeamReferralVo.getAdmissionId());
        if (null == admissionEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u5c31\u8bca\u4fe1\u606f\u5931\u8d25" + reqTeamReferralVo.getAdmissionId()));
        }
        log.info("admissionEntity:{}" + admissionEntity.toString());
        OrderEntity orderEntity = this.orderMapper.findByAdmId(reqTeamReferralVo.getAdmissionId());
        if (null == orderEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25" + reqTeamReferralVo.getAdmissionId()));
        }
        log.info("orderEntity:{}" + orderEntity.toString());
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign())) {
            if (!AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
                return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u8f6c\u8bca");
            }
        } else {
            if (ServiceTypeEnum.NOS.getValue().equals(admissionEntity.getServType())) {
                return BaseResponse.error((String)"\u5728\u7ebf\u590d\u8bca\u4e0d\u80fd\u8fdb\u884c\u8f6c\u8bca");
            }
            if (!AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus()) && !AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
                return BaseResponse.error((String)("\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u8f6c\u8bca\u7684\u8ba2\u5355" + reqTeamReferralVo.getAdmissionId()));
            }
        }
        DoctorTeamEntity doctorTeamEntity = this.getDoctorTeamEntity(reqTeamReferralVo, admissionEntity, orderEntity);
        admissionEntity.setStatus(AdmissionStatusEnum.REFERRAL.getValue());
        admissionEntity.setXUpdateTime(new Date());
        admissionEntity.setEndTime(new Date());
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign())) {
            doctorTeamEntity.setTeamId("\u7ba1\u7406\u7aef\u8f6c\u8bca");
            doctorTeamEntity.setXVersion(Long.valueOf(1L));
            admissionEntity.setStatus(AdmissionStatusEnum.REFERRAL_MANAGER.getValue());
        }
        if ((t = this.admissionMapper.update(admissionEntity)) != 1) {
            return BaseResponse.error((String)"\u66f4\u65b0\u5c31\u8bca\u8bb0\u5f55\u4e3a\u5df2\u8f6c\u8bca\u5931\u8d25");
        }
        AdmissionEntity admissionEntityNew = new AdmissionEntity();
        admissionEntityNew.setXId(UUIDUtil.getUUID());
        doctorTeamEntity.setAdmissionIdNew(admissionEntityNew.getXId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntity((Object)doctorTeamEntity);
        DoctorTeamEntity entity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (entity != null) {
            return BaseResponse.error((String)"\u8be5\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728");
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        Integer count = this.doctorTeamMapper.insert((Object)doctorTeamEntity);
        if (null == count) {
            return BaseResponse.error((String)"\u65b0\u5efa\u8f6c\u8bca\u5355\u5931\u8d25");
        }
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign()) && StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
            QueryWrapper doctorTeamEntityQueryWrapper = new QueryWrapper();
            DoctorTeamEntity doctorTeam = new DoctorTeamEntity();
            doctorTeam.setDealSeq(orderEntity.getDealSeq());
            doctorTeamEntityQueryWrapper.setEntity((Object)doctorTeam);
            List doctorTeamEntities = this.doctorTeamMapper.selectList((Wrapper)doctorTeamEntityQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)doctorTeamEntities)) {
                return BaseResponse.error((String)"\u8f6c\u8bca\u5931\u8d25");
            }
            if (doctorTeamEntities.size() == 1) {
                this.scheduleRecordMapper.addAvailableCount(Integer.valueOf(orderEntity.getScheduleId()));
            }
        }
        OrderEntity orderEntityNew = this.insertOrderEntity(reqTeamReferralVo, orderEntity);
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(reqTeamReferralVo.getAdmissionDoctorId());
        log.info("queryPersonnelInfoReq:{}" + JSON.toJSONString((Object)queryPersonnelInfoReq));
        BaseResponse personnelInfoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (!personnelInfoBaseResponse.isSuccess()) {
            return BaseResponse.error((String)personnelInfoBaseResponse.getMsg());
        }
        PersonnelInfo personnelInfo = (PersonnelInfo)personnelInfoBaseResponse.getData();
        log.info("personnelInfo:{}" + JSON.toJSONString((Object)personnelInfo));
        orderEntityNew.setDeptId(Long.valueOf(personnelInfo.getDeptId().intValue()));
        orderEntityNew.setDeptName(personnelInfo.getDeptName());
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign())) {
            orderEntityNew.setDeptId(Long.valueOf(reqTeamReferralVo.getDeptId()));
            orderEntityNew.setDeptName(reqTeamReferralVo.getDeptName());
        }
        if ((serviceConfig = this.calculateOrderPrice(orderEntityNew.getOrganId(), orderEntityNew.getDoctorId(), orderEntityNew.getServType(), orderEntityNew.getDeptId())) == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        orderEntityNew.setServTime(serviceConfig.getServTime());
        orderEntityNew.setTotalNum(serviceConfig.getNumLimit());
        admissionEntityNew.setXCreateTime(new Date());
        admissionEntityNew.setXUpdateTime(new Date());
        admissionEntityNew.setOrderId(orderEntityNew.getXId());
        admissionEntityNew.setDoctorId(reqTeamReferralVo.getAdmissionDoctorId());
        admissionEntityNew.setDoctorName(reqTeamReferralVo.getAdmissionDoctorName());
        admissionEntityNew.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        admissionEntityNew.setPackageId(admissionEntity.getPackageId());
        admissionEntityNew.setServTime(orderEntityNew.getServTime());
        admissionEntityNew.setTotalNum(orderEntityNew.getTotalNum());
        admissionEntityNew.setCurrentNum(orderEntityNew.getTotalNum());
        admissionEntityNew.setPatientId(admissionEntity.getPatientId());
        admissionEntityNew.setMedicalRecordId(orderEntityNew.getMedicalRecordId());
        admissionEntityNew.setServType(orderEntityNew.getServType());
        admissionEntityNew.setOrganId(admissionEntity.getOrganId());
        admissionEntityNew.setDoctorType(admissionEntity.getDoctorType());
        log.info("admissionEntityNew:{}" + admissionEntityNew.toString());
        log.info("orderEntityNew:{}" + orderEntityNew.toString());
        Integer r = this.admissionMapper.insert((Object)admissionEntityNew);
        if (r != 1) {
            return BaseResponse.error((String)"\u65b0\u589e\u5c31\u8bb0\u5f55\u5931\u8d25");
        }
        Integer l = this.orderMapper.insert((Object)orderEntityNew);
        if (l != 1) {
            return BaseResponse.error((String)"\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.imInfromPush(doctorTeamEntity, admissionEntity, admissionEntityNew, orderEntityNew);
        ResTeamReferralVo resTeamReferralVo = new ResTeamReferralVo();
        resTeamReferralVo.setReferralId(doctorTeamEntity.getXId());
        return BaseResponse.success((Object)resTeamReferralVo);
    }

    private DoctorTeamEntity getDoctorTeamEntity(ReqTeamReferralVo reqTeamReferralVo, AdmissionEntity admissionEntity, OrderEntity orderEntity) {
        DoctorTeamEntity doctorTeamEntity = new DoctorTeamEntity();
        doctorTeamEntity.setAdmissionId(reqTeamReferralVo.getAdmissionId());
        doctorTeamEntity.setReferralReason(reqTeamReferralVo.getReferralReason());
        doctorTeamEntity.setPicUrl(reqTeamReferralVo.getPicUrl());
        doctorTeamEntity.setAdmissionDoctorId(reqTeamReferralVo.getAdmissionDoctorId());
        doctorTeamEntity.setAdmissionDoctorName(reqTeamReferralVo.getAdmissionDoctorName());
        doctorTeamEntity.setOrderId(admissionEntity.getOrderId());
        doctorTeamEntity.setReferralDoctorName(orderEntity.getDoctorName());
        doctorTeamEntity.setXRemark(reqTeamReferralVo.getRemark());
        doctorTeamEntity.setPatientId(admissionEntity.getPatientId());
        doctorTeamEntity.setReferralDoctorId(orderEntity.getDoctorId());
        doctorTeamEntity.setTeamId(reqTeamReferralVo.getTeamId());
        doctorTeamEntity.setTeamName(reqTeamReferralVo.getTeamName());
        doctorTeamEntity.setXCreateTime(new Date());
        doctorTeamEntity.setXUpdateTime(new Date());
        doctorTeamEntity.setXId(UUIDUtil.getUUID());
        doctorTeamEntity.setDealSeq(orderEntity.getDealSeq());
        return doctorTeamEntity;
    }

    private void imInfromPush(DoctorTeamEntity doctorTeamEntity, AdmissionEntity admissionEntity, AdmissionEntity admissionEntityNew, OrderEntity orderEntityNew) {
        log.info("admissionEntity:{}" + admissionEntity.toString());
        this.payAsyncService.createPersonalImSession(orderEntityNew, admissionEntityNew.getXId());
    }

    private OrderEntity insertOrderEntity(ReqTeamReferralVo reqTeamReferralVo, OrderEntity orderEntity) {
        OrderEntity orderEntityNew = new OrderEntity();
        BeanUtils.copyProperties((Object)orderEntity, (Object)orderEntityNew);
        orderEntityNew.setXId(UUIDUtil.getUUID());
        orderEntityNew.setXUpdateTime(new Date());
        orderEntityNew.setDoctorId(reqTeamReferralVo.getAdmissionDoctorId());
        orderEntityNew.setDoctorName(reqTeamReferralVo.getAdmissionDoctorName());
        orderEntityNew.setXCreateTime(new Date());
        return orderEntityNew;
    }

    public BaseResponse<ResReferralDetailsVo> selectReferralDetails(String id) {
        if (null == id) {
            return BaseResponse.error((String)"\u4f20\u5165\u7684\u8f6c\u8bca\u5355id\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"x_id", (Object)id);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (null == doctorTeamEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u7684\u4fe1\u606f\u4e3a\u7a7a,\u4f20\u5165\u7684\u53c2\u6570\u4e3a" + id));
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        ResReferralDetailsVo resReferralDetailsVo = new ResReferralDetailsVo();
        resReferralDetailsVo.setPicUrl(doctorTeamEntity.getPicUrl());
        resReferralDetailsVo.setReferralReason(doctorTeamEntity.getReferralReason());
        resReferralDetailsVo.setRemark(doctorTeamEntity.getXRemark());
        resReferralDetailsVo.setReferralDoctorName(doctorTeamEntity.getReferralDoctorName());
        resReferralDetailsVo.setAdmissionDoctorName(doctorTeamEntity.getAdmissionDoctorName());
        resReferralDetailsVo.setUpdateTime(doctorTeamEntity.getXUpdateTime());
        PatientEntity patientEntity = this.patientMapper.selectById(doctorTeamEntity.getPatientId());
        if (patientEntity == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25");
        }
        log.info("patientEntity:{}" + patientEntity.toString());
        resReferralDetailsVo.setCardNo(patientEntity.getCardNo());
        resReferralDetailsVo.setGender(patientEntity.getGender());
        resReferralDetailsVo.setPatientName(patientEntity.getPatientName());
        try {
            Integer age = IDCardUtil.getAge((String)patientEntity.getIdcard());
            resReferralDetailsVo.setAge(age);
        }
        catch (Exception e) {
            log.error("\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u60a3\u8005\u5e74\u9f84\u5931\u8d25\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801={}", (Object)patientEntity.getIdcard(), (Object)e);
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorTeamEntity.getAdmissionDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u95191");
        }
        log.info("doctorDetailsVoBaseResponse:{}" + JSON.toJSONString((Object)doctorDetailsVoBaseResponse.getData()));
        resReferralDetailsVo.setAdmissionDoctorPortrait(((PersonnelInfo)doctorDetailsVoBaseResponse.getData()).getPortrait());
        QueryPersonnelInfoReq queryPersonnelInfo = new QueryPersonnelInfoReq();
        queryPersonnelInfo.setDoctorId(doctorTeamEntity.getReferralDoctorId());
        BaseResponse doctorDetailsVO = this.doctorClient.queryPersonnelInfo(queryPersonnelInfo);
        if (null == doctorDetailsVO || null == doctorDetailsVO.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u95192");
        }
        log.info("doctorDetailsVO:{}" + JSON.toJSONString((Object)doctorDetailsVO.getData()));
        resReferralDetailsVo.setReferralDoctorPortrait(((PersonnelInfo)doctorDetailsVO.getData()).getPortrait());
        return BaseResponse.success((Object)resReferralDetailsVo);
    }

    private ServiceConfigVo calculateOrderPrice(String organId, String doctorId, Integer servType, Long deptId) {
        GetDocServiceConfigReq getServiceConfigReq = new GetDocServiceConfigReq();
        getServiceConfigReq.setDoctorId(doctorId);
        getServiceConfigReq.setOrganId(organId);
        getServiceConfigReq.setServType(servType);
        getServiceConfigReq.setDeptId(deptId.toString());
        ResultData resultData = this.inquiryServiceConfigService.getDoctorServiceInfo(getServiceConfigReq);
        log.info("\u533b\u751f\u670d\u52a1\u4fe1\u606f:{}", (Object)resultData);
        if (resultData == null || !resultData.isSuccess()) {
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        return (ServiceConfigVo)resultData.getData();
    }

    public BaseResponse<ResReferralDetailsVo> selectReferralDetailsByAdmId(String admId) {
        if (null == admId) {
            return BaseResponse.error((String)"\u4f20\u5165\u7684\u5c31\u8bcaid\u4e3a\u7a7a");
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findByAdmId(admId);
        QueryWrapper queryWrapper = new QueryWrapper();
        ReferralInfoEntity entity = new ReferralInfoEntity();
        entity.setOrderId(admissionEntity.getOrderId());
        queryWrapper.setEntity((Object)entity);
        ReferralInfoEntity referralInfoEntity = (ReferralInfoEntity)this.referralInfoMapper.selectOne((Wrapper)queryWrapper);
        if (null == referralInfoEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u7684\u4fe1\u606f\u4e3a\u7a7a,\u4f20\u5165\u7684\u53c2\u6570\u4e3a" + admId));
        }
        ResReferralDetailsVo resReferralDetailsVo = new ResReferralDetailsVo();
        resReferralDetailsVo.setReferralReason(referralInfoEntity.getReason());
        resReferralDetailsVo.setRemark(referralInfoEntity.getRemark());
        resReferralDetailsVo.setReferralDoctorName(referralInfoEntity.getDoctorName());
        resReferralDetailsVo.setAdmissionDoctorName(referralInfoEntity.getReferralDoctorName());
        resReferralDetailsVo.setUpdateTime(referralInfoEntity.getUpdateTime());
        resReferralDetailsVo.setCreatTime(referralInfoEntity.getUpdateTime());
        PatientEntity patientEntity = this.patientMapper.selectById(referralInfoEntity.getPatientId());
        if (patientEntity == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25");
        }
        log.info("patientEntity:{}" + patientEntity.toString());
        resReferralDetailsVo.setCardNo(patientEntity.getCardNo());
        resReferralDetailsVo.setGender(patientEntity.getGender());
        resReferralDetailsVo.setPatientName(patientEntity.getPatientName());
        try {
            Integer age = IDCardUtil.getAge((String)patientEntity.getIdcard());
            resReferralDetailsVo.setAge(age);
        }
        catch (Exception e) {
            log.error("\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u60a3\u8005\u5e74\u9f84\u5931\u8d25\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801={}", (Object)patientEntity.getIdcard(), (Object)e);
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(referralInfoEntity.getReferralDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u95191");
        }
        log.info("doctorDetailsVoBaseResponse:{}" + JSON.toJSONString((Object)doctorDetailsVoBaseResponse.getData()));
        resReferralDetailsVo.setAdmissionDoctorPortrait(((PersonnelInfo)doctorDetailsVoBaseResponse.getData()).getPortrait());
        QueryPersonnelInfoReq queryPersonnelInfo = new QueryPersonnelInfoReq();
        queryPersonnelInfo.setDoctorId(referralInfoEntity.getDoctorId());
        BaseResponse doctorDetailsVO = this.doctorClient.queryPersonnelInfo(queryPersonnelInfo);
        if (null == doctorDetailsVO || null == doctorDetailsVO.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u95192");
        }
        log.info("doctorDetailsVO:{}" + JSON.toJSONString((Object)doctorDetailsVO.getData()));
        resReferralDetailsVo.setReferralDoctorPortrait(((PersonnelInfo)doctorDetailsVO.getData()).getPortrait());
        return BaseResponse.success((Object)resReferralDetailsVo);
    }

    public BaseResponse<ResTeamReferralVo> insertDoctorTeamAfresh(ReqTeamReferralVo reqTeamReferralVo) {
        ServiceConfigVo serviceConfig;
        Integer t;
        AdmissionEntity admissionEntity = this.admissionMapper.findByAdmId(reqTeamReferralVo.getAdmissionId());
        if (null == admissionEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u5c31\u8bca\u4fe1\u606f\u5931\u8d25" + reqTeamReferralVo.getAdmissionId()));
        }
        log.info("admissionEntity:{}" + admissionEntity.toString());
        OrderEntity orderEntity = this.orderMapper.findByAdmId(reqTeamReferralVo.getAdmissionId());
        if (null == orderEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25" + reqTeamReferralVo.getAdmissionId()));
        }
        log.info("orderEntity:{}" + orderEntity.toString());
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign())) {
            if (!AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
                return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u8f6c\u8bca");
            }
        } else if (!AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus()) && !AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            return BaseResponse.error((String)("\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u8f6c\u8bca\u7684\u8ba2\u5355" + reqTeamReferralVo.getAdmissionId()));
        }
        if (Objects.isNull(orderEntity.getIsSwitch()) || Integer.valueOf(0).equals(orderEntity.getIsSwitch())) {
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u7528\u6237\u9009\u62e9\u4e86\u4e0d\u53ef\u8f6c\u8bca");
        }
        DoctorTeamEntity doctorTeamEntity = this.getDoctorTeamEntity(reqTeamReferralVo, admissionEntity, orderEntity);
        admissionEntity.setStatus(AdmissionStatusEnum.REFERRAL.getValue());
        admissionEntity.setXUpdateTime(new Date());
        admissionEntity.setEndTime(new Date());
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign())) {
            doctorTeamEntity.setTeamId("\u7ba1\u7406\u7aef\u8f6c\u8bca");
            doctorTeamEntity.setXVersion(Long.valueOf(1L));
            admissionEntity.setStatus(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue());
        }
        if ((t = this.admissionMapper.update(admissionEntity)) != 1) {
            return BaseResponse.error((String)"\u66f4\u65b0\u5c31\u8bca\u8bb0\u5f55\u4e3a\u5df2\u8f6c\u8bca\u5931\u8d25");
        }
        AdmissionEntity admissionEntityNew = new AdmissionEntity();
        admissionEntityNew.setXId(UUIDUtil.getUUID());
        doctorTeamEntity.setAdmissionIdNew(admissionEntityNew.getXId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntity((Object)doctorTeamEntity);
        DoctorTeamEntity entity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (entity != null) {
            return BaseResponse.error((String)"\u8be5\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728");
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        Integer count = this.doctorTeamMapper.insert((Object)doctorTeamEntity);
        if (null == count) {
            return BaseResponse.error((String)"\u65b0\u5efa\u8f6c\u8bca\u5355\u5931\u8d25");
        }
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign()) && StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
            QueryWrapper doctorTeamEntityQueryWrapper = new QueryWrapper();
            DoctorTeamEntity doctorTeam = new DoctorTeamEntity();
            doctorTeam.setDealSeq(orderEntity.getDealSeq());
            doctorTeamEntityQueryWrapper.setEntity((Object)doctorTeam);
            List doctorTeamEntities = this.doctorTeamMapper.selectList((Wrapper)doctorTeamEntityQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)doctorTeamEntities)) {
                return BaseResponse.error((String)"\u8f6c\u8bca\u5931\u8d25");
            }
            if (doctorTeamEntities.size() == 1) {
                this.scheduleRecordMapper.addAvailableCount(Integer.valueOf(orderEntity.getScheduleId()));
            }
        }
        OrderEntity orderEntityNew = this.insertOrderEntity(reqTeamReferralVo, orderEntity);
        orderEntity.setOrderSeq("");
        orderEntity.setBankTradeNo("");
        this.orderMapper.updateById((Object)orderEntity);
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(reqTeamReferralVo.getAdmissionDoctorId());
        log.info("queryPersonnelInfoReq:{}" + JSON.toJSONString((Object)queryPersonnelInfoReq));
        BaseResponse personnelInfoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (!personnelInfoBaseResponse.isSuccess()) {
            return BaseResponse.error((String)personnelInfoBaseResponse.getMsg());
        }
        PersonnelInfo personnelInfo = (PersonnelInfo)personnelInfoBaseResponse.getData();
        log.info("personnelInfo:{}" + JSON.toJSONString((Object)personnelInfo));
        orderEntityNew.setDeptId(Long.valueOf(personnelInfo.getDeptId().intValue()));
        orderEntityNew.setDeptName(personnelInfo.getDeptName());
        if (StringUtils.isNotEmpty((String)reqTeamReferralVo.getManagerSign())) {
            orderEntityNew.setDeptId(Long.valueOf(reqTeamReferralVo.getDeptId()));
            orderEntityNew.setDeptName(reqTeamReferralVo.getDeptName());
        }
        if ((serviceConfig = this.calculateOrderPrice(orderEntityNew.getOrganId(), orderEntityNew.getDoctorId(), orderEntityNew.getServType(), orderEntityNew.getDeptId())) == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        orderEntityNew.setServTime(serviceConfig.getServTime());
        orderEntityNew.setTotalNum(serviceConfig.getNumLimit());
        admissionEntityNew.setXCreateTime(new Date());
        admissionEntityNew.setXUpdateTime(new Date());
        admissionEntityNew.setOrderId(orderEntityNew.getXId());
        admissionEntityNew.setDoctorId(reqTeamReferralVo.getAdmissionDoctorId());
        admissionEntityNew.setDoctorName(reqTeamReferralVo.getAdmissionDoctorName());
        admissionEntityNew.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        admissionEntityNew.setPackageId(admissionEntity.getPackageId());
        admissionEntityNew.setServTime(orderEntityNew.getServTime());
        admissionEntityNew.setTotalNum(orderEntityNew.getTotalNum());
        admissionEntityNew.setCurrentNum(orderEntityNew.getTotalNum());
        admissionEntityNew.setPatientId(admissionEntity.getPatientId());
        admissionEntityNew.setMedicalRecordId(orderEntityNew.getMedicalRecordId());
        admissionEntityNew.setServType(orderEntityNew.getServType());
        admissionEntityNew.setOrganId(admissionEntity.getOrganId());
        BaseResponse docIsLearder = this.doctorTemInfomService.getDocIsLearder(reqTeamReferralVo.getAdmissionDoctorId(), admissionEntity.getOrganId());
        List personTeamNew = this.doctorTemInfomService.getPersonTeamNew(reqTeamReferralVo.getAdmissionDoctorId());
        if (docIsLearder.isSuccess() && ((Boolean)docIsLearder.getData()).booleanValue() && personTeamNew != null) {
            admissionEntityNew.setDoctorType(DoctorTypeEnum.TEAM.getValue());
            orderEntityNew.setDoctorType(DoctorTypeEnum.TEAM.getValue());
        } else {
            admissionEntityNew.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
            orderEntityNew.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
        }
        log.info("admissionEntityNew:{}" + admissionEntityNew.toString());
        log.info("orderEntityNew:{}" + orderEntityNew.toString());
        Integer r = this.admissionMapper.insert((Object)admissionEntityNew);
        if (r != 1) {
            return BaseResponse.error((String)"\u65b0\u589e\u5c31\u8bb0\u5f55\u5931\u8d25");
        }
        Integer l = this.orderMapper.insert((Object)orderEntityNew);
        if (l != 1) {
            return BaseResponse.error((String)"\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.imInfromPush(doctorTeamEntity, admissionEntity, admissionEntityNew, orderEntityNew);
        ResTeamReferralVo resTeamReferralVo = new ResTeamReferralVo();
        resTeamReferralVo.setReferralId(doctorTeamEntity.getXId());
        return BaseResponse.success((Object)resTeamReferralVo);
    }

    static /* synthetic */ OrderSender access$000(DoctorTeamServiceImpl x0) {
        return x0.orderSender;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

