/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.FollowService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.vo.FollowVo;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FollowServiceImpl
implements FollowService {
    private static final Logger log = LoggerFactory.getLogger(FollowServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private OrderMapper orderMapper;

    public BaseResponse folloList() {
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/follow/v1/folloList";
            log.info("\u83b7\u53d6his\u968f\u8bbf\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)url));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(result, FrontResponse.class);
        if ("1".equals(frontResponse.getCode())) {
            return BaseResponse.success((Object)frontResponse.getBody());
        }
        return BaseResponse.error((String)frontResponse.getMessage());
    }

    public BaseResponse sendFollo(FollowVo follow) {
        if (ObjectUtils.isEmpty((Object)follow) || StringUtils.isEmpty((Object)follow.getFormId())) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(follow.getSerialNo());
        if (ObjectUtils.isEmpty((Object)orderEntity)) {
            return BaseResponse.error((String)"\u8ba2\u5355\u5f02\u5e38");
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(follow.getStaffIndex());
        BaseResponse response = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (Objects.isNull(response) || !response.isSuccess() || Objects.isNull(response.getData()) || Objects.isNull(((PersonnelInfo)response.getData()).getEmplCode())) {
            return BaseResponse.error((String)"\u533b\u751f\u5f02\u5e38");
        }
        follow.setSerialNo(UUID.randomUUID().toString());
        follow.setStaffIndex(((PersonnelInfo)response.getData()).getEmplCode());
        follow.setSerialNo(orderEntity.getInvoiceNo());
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/follow/v1/sendFollo";
            log.info("\u53d1\u9001\u968f\u8bbf\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)follow));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)follow));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(result, FrontResponse.class);
        if ("1".equals(frontResponse.getCode())) {
            return BaseResponse.success((Object)frontResponse.getBody());
        }
        return BaseResponse.error((String)frontResponse.getMessage());
    }
}

