/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.health.management.client.ServicepkgServiceOrderClient;
import com.ebaiyihui.health.management.common.vo.OnlineOutpatientUsageReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.MedicalPayDto;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.MedicalPaycallReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PayCreateOrderVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core.UpdateOrderRecordService;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalPayNotifyMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServiceMerchantConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MedicalPayNotifyEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.SdyPaymentPlatformsService;
import com.ebaiyihui.onlineoutpatient.core.service.UnifiedPayService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.JsonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InsuSettlementReqDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicalNotifyReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PayNotifyResultVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PayReqInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestPayByPackageVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnifiedRefundReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PaymentRefundDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.vo.RequestPaymentRefundVO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.MedicalNotifyReq;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.MedicalPayNotifyVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.MedicalPayVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.MedicalRefundDto;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.RefundDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AliPayCreateOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AliPayExtendParamsEntrty;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AliPayMedicalRequesExtEntrty;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AlipayNotifyParam;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.MedicalPaymentRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.QueryMedicalSettlementOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.RefundOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.ResultResponse;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.UndoOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.YdBaseResponse;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.YdCreadOrderResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private ServicepkgServiceOrderClient servicepkgServiceOrderClient;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private UpdateOrderRecordService updateOrderRecordService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    SdyPaymentPlatformsService sdyPaymentPlatformsService;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private AliSmsPushService aliSmsPushService;
    @Autowired
    MedicalPayNotifyMapper medicalPayNotifyMapper;
    @Autowired
    private PayCallBackService payCallBackService;
    @Resource
    private UnifiedPayService unifiedPayService;
    private static final String ONE = "1";
    private static final String ONE_ONE = "-1";

    public BaseResponse<String> doWhilePayCallBack(MedicalNotifyReq medicalNotifyReq) {
        Date date;
        log.info("\u533b\u4fdd\u652f\u4ed8\u56de\u8c03\uff1a{}", (Object)JSON.toJSONString((Object)medicalNotifyReq));
        MedicalPayNotifyVo medicalPayNotifyVo = medicalNotifyReq.getData();
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setClinicCode(medicalPayNotifyVo.getMedOrgOrd());
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderInfo = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (orderInfo == null) {
            return BaseResponse.success((Object)"fail");
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        if (this.vaildParams(medicalPayNotifyVo, orderInfo)) {
            return BaseResponse.success((Object)"fail");
        }
        orderInfo.setStatus(OrderStatusEnum.PAID.getValue());
        orderInfo.setBankTradeNo(medicalPayNotifyVo.getTtpPaySn());
        orderInfo.setOwnCost(ObjectUtils.isEmpty((Object)medicalPayNotifyVo.getOwnpayAmt()) ? null : medicalPayNotifyVo.getOwnpayAmt().toPlainString());
        orderInfo.setTotCost(orderInfo.getPayAmount().toPlainString());
        orderInfo.setPubCost(ObjectUtils.isEmpty((Object)medicalPayNotifyVo.getFundPay()) ? null : medicalPayNotifyVo.getFundPay().toPlainString());
        try {
            date = DateUtils.parseDate((String)medicalPayNotifyVo.getHiChrgTime(), (String)"yyyyMMddHHmmss");
        }
        catch (Exception e) {
            date = new Date();
        }
        orderInfo.setPaymentTime(date);
        orderInfo.setPayMethod(PayChannelEnum.MEDICAL.getPayChannel());
        orderInfo.setDealSeq(medicalPayNotifyVo.getPayOrdId());
        log.info("\u652f\u4ed8\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        this.baseInquiryOrderService.updateById((Object)orderInfo);
        ServicePayBillEntity servicePayBillEntity = (ServicePayBillEntity)this.servicePayBillMapper.selectById((Serializable)((Object)orderInfo.getBillPayId()));
        log.info("\u8d26\u5355\u4fe1\u606f\u4e3a:{}" + servicePayBillEntity.toString());
        servicePayBillEntity.setDealTradeNo(medicalPayNotifyVo.getPayOrdId());
        servicePayBillEntity.setTradeTime(DateUtils.stringToFullDate((String)medicalPayNotifyVo.getHiChrgTime()));
        servicePayBillEntity.setTradeNo(medicalPayNotifyVo.getTtpPaySn());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setStatus(PayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setPayChannel(medicalPayNotifyVo.getSetlCashPayWay());
        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderInfo.getXId());
        admissionEntity.setServTime(orderInfo.getServTime());
        admissionEntity.setStartTime(DateUtils.stringToFullDate((String)medicalPayNotifyVo.getHiChrgTime()));
        admissionEntity.setTotalNum(orderInfo.getTotalNum());
        admissionEntity.setCurrentNum(orderInfo.getTotalNum());
        admissionEntity.setDoctorName(orderInfo.getDoctorName());
        if (null != orderInfo.getScheduleDate()) {
            admissionEntity.setScheduleDate(orderInfo.getScheduleDate());
            Date scheduleDate = orderInfo.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderInfo.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
            admissionEntity.setEndTime(expirationDateTime);
        } else {
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setConvertWaitTime(new Date());
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        }
        admissionEntity.setPauseTime(Long.valueOf(0L));
        admissionEntity.setOrganId(orderInfo.getHospitalId());
        log.info("\u652f\u4ed8\u56de\u8c03\u6dfb\u52a0\u5c31\u8bca\u8bb0\u5f55:{}", (Object)admissionEntity.toString());
        this.admissionMapper.updateById((Object)admissionEntity);
        MedicalPayNotifyEntity entity = new MedicalPayNotifyEntity();
        BeanUtils.copyProperties((Object)medicalPayNotifyVo, (Object)entity);
        if (StringUtils.isNotEmpty((String)medicalPayNotifyVo.getUpldFeeOutPut())) {
            JSONObject resultObject = JSON.parseObject((String)medicalPayNotifyVo.getUpldFeeOutPut());
            entity.setPayToken(resultObject.isEmpty() ? null : String.valueOf(resultObject.get((Object)"payToken")));
        }
        this.medicalPayNotifyMapper.insert((Object)entity);
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
            this.payAsyncService.asyncTask(orderInfo, admissionEntity);
        } else if (AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admissionEntity.getStatus())) {
            this.imInformService.makeAnAppiontment(admissionEntity.getXId());
        }
        if (null != orderInfo.getScheduleDate()) {
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(orderInfo.getXId());
            log.info("\u5b9a\u65f6\u5904\u7406\u60a3\u8005\u672a\u70b9\u51fb'\u5019\u8bca\u62a5\u9053\u63a5\u53e3'\uff0c\u63d0\u793a\u60a3\u8005\u53bb\u5019\u8bca\uff0corderTaskVo3\uff1a{}", (Object)orderTaskVo3.toString());
            this.orderSender.sendDelay(orderTaskVo3);
            OrderTaskVo orderTaskVo4 = new OrderTaskVo();
            orderTaskVo4.setType(Integer.valueOf(4));
            orderTaskVo4.setId(orderInfo.getXId());
            log.info("\u9884\u7ea6\u6392\u73ed\u7ed3\u675f\u65f6\u95f4\u5c31\u8bca\u8ba2\u5355\u5904\u7406orderTaskVo4\uff1a{}", (Object)orderTaskVo4.toString());
            this.orderSender.sendDelay(orderTaskVo4);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(orderInfo.getXId());
            log.info("\u65e0\u6392\u73ed\u8ba2\u5355\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u8ba2\u5355\u5904\u7406 orderTaskVo2\uff1a{}", (Object)orderTaskVo2.toString());
            this.orderSender.sendDelay(orderTaskVo2);
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse<String> callbackRefundPaySuccess(ResponseNotifyRestVo dto) {
        log.info("\u9000\u6b3e\u56de\u8c03doWhilePayCallBack dto :{}", (Object)JsonUtil.convertObject((Object)dto));
        OrderEntity orderInfo = this.getOrderByOrderSeq(dto.getOutTradeNo());
        if (this.refundParams(dto, orderInfo)) {
            return BaseResponse.success((Object)"fail");
        }
        log.info("\u9000\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        log.info("\u9000\u6b3e\u65f6\u95f4:{}" + dto.getRefundTime());
        orderInfo.setStatus(OrderStatusEnum.REFUNDED.getValue());
        orderInfo.setRefundTime(dto.getRefundTime());
        this.orderMapper.updateOrderEntity(orderInfo);
        log.info("\u9000\u6b3e\u56de\u8c03\u6210\u529f:{}", (Object)"success");
        PatientEntity patientEntity = this.patientMapper.selectById(orderInfo.getPatientId());
        InquiryMchCodeEntity inquiryEntity = this.getHisUrl(orderInfo.getAppCode(), orderInfo.getHospitalId());
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && patientEntity != null && StringUtils.isNotEmpty((String)orderInfo.getClinicCode()) && null != inquiryEntity && StringUtils.isNotEmpty((String)inquiryEntity.getHisUrl()) && "HYT".equals(inquiryEntity.getAppCode()) && this.HYTRefund(dto, orderInfo)) {
            return BaseResponse.error((String)"\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f");
        }
        return BaseResponse.success((Object)"success");
    }

    private boolean HYTRefund(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        UnregisterPayMethodReqVo unregisterPayMethodReqVo = new UnregisterPayMethodReqVo();
        PayNotifyResultVo payNotifyReqVO = (PayNotifyResultVo)JSON.parseObject((String)dto.getNotifyResultStr(), PayNotifyResultVo.class);
        log.info("payNotifyReqVO:" + JSON.toJSONString((Object)payNotifyReqVO));
        PayReqInfoVo payReqInfoVo = (PayReqInfoVo)JSON.parseObject((String)payNotifyReqVO.getReqInfo(), PayReqInfoVo.class);
        log.info("payReqInfoVo:" + JSON.toJSONString((Object)payReqInfoVo));
        BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
        BigDecimal ownCost = bigDecimal.multiply(new BigDecimal(100));
        String sign = "";
        if (StringUtils.isNotEmpty((String)payNotifyReqVO.getSign())) {
            sign = payNotifyReqVO.getSign();
        }
        String transInfo = "SUCCESS|OK|SUCCESS|||SUCCESS|" + payNotifyReqVO.getAppid() + "|" + payNotifyReqVO.getMchId() + "|" + payNotifyReqVO.getNonceStr() + "|" + payReqInfoVo.getOutRefundNo() + "||" + payReqInfoVo.getRefundFee() + "|" + payReqInfoVo.getRefundId() + "|" + payReqInfoVo.getRefundRecvAccout() + "|" + sign + "|" + payReqInfoVo.getTotalFee() + "|" + payReqInfoVo.getTransactionId() + "|" + payReqInfoVo.getOutTradeNo() + "||";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = simpleDateFormat.format(orderInfo.getPaymentTime());
        unregisterPayMethodReqVo.setTransInfo(transInfo);
        unregisterPayMethodReqVo.setClinicCode(orderInfo.getClinicCode());
        UnregisterPayMethodResVo unregisterPayMethodResVo = this.hisTemplateService.unregisterPayMethod(unregisterPayMethodReqVo);
        if (null == unregisterPayMethodResVo || unregisterPayMethodResVo.getResult().equals(ONE_ONE)) {
            log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25");
            return true;
        }
        log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u6210\u529f");
        return false;
    }

    private boolean vaildParams(MedicalPayNotifyVo medicalPayNotifyVo, OrderEntity orderInfo) {
        BigDecimal bigDecimal;
        if (orderInfo == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355,\u9662\u5185\u8ba2\u5355\u53f7={}", (Object)medicalPayNotifyVo.getMedOrgOrd());
            return true;
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)orderInfo.getPayAmount().toPlainString()) && 0 != (bigDecimal = new BigDecimal(orderInfo.getPayAmount().toPlainString())).compareTo(medicalPayNotifyVo.getFeeSumamt())) {
            log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u652f\u4ed8\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo, (Object)medicalPayNotifyVo);
            return true;
        }
        if (OrderStatusEnum.TOPAY.getValue().intValue() != orderInfo.getStatus().intValue()) {
            log.error("doWhilePayCallBack \u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u8ba2\u5355\u975e\u5f85\u652f\u4ed8\u72b6\u6001!:{}", (Object)orderInfo.getStatus());
            return true;
        }
        return false;
    }

    private InquiryMchCodeEntity getHisUrl(String appCode, String hospitalId) {
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(appCode);
        inquiryMchCodeEntity.setHospitalId(hospitalId);
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        return entity;
    }

    private boolean refundParams(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        if (orderInfo == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355,\u652f\u4ed8\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={},\u4e1a\u52a1\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={}", (Object)dto.getOutTradeNo());
            return true;
        }
        if (!orderInfo.getOrderSeq().equals(dto.getOutTradeNo())) {
            log.error("\u8ba2\u5355\u4fe1\u606f\u4e0e\u56de\u8c03\u53c2\u6570\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)orderInfo.getOwnCost())) {
            BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
            if (0 != bigDecimal.compareTo(dto.getTotalAmount())) {
                log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
                return true;
            }
        } else if (0 != orderInfo.getPayAmount().compareTo(dto.getTotalAmount())) {
            log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (!OrderStatusEnum.PAID.getValue().equals(orderInfo.getStatus()) && !OrderStatusEnum.REFUNDED.getValue().equals(orderInfo.getStatus())) {
            log.error("----------doWhilePayCallBack \u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u8ba2\u5355\u975e\u5df2\u652f\u4ed8\u6216\u8005\u9000\u6b3e\u4e2d\u72b6\u6001!-------------:{}", (Object)orderInfo);
            return true;
        }
        return false;
    }

    private AdmissionEntity createAdmissionEntity(OrderEntity orderInfo) {
        AdmissionEntity entity = new AdmissionEntity();
        entity.setOrganId(orderInfo.getHospitalId());
        entity.setOrderId(orderInfo.getXId());
        entity.setPatientId(orderInfo.getPatientId());
        entity.setDoctorId(orderInfo.getDoctorId());
        entity.setDoctorName(orderInfo.getDoctorName());
        entity.setDoctorType(orderInfo.getDoctorType());
        entity.setServType(orderInfo.getServType());
        entity.setMedicalRecordId(orderInfo.getMedicalRecordId());
        return entity;
    }

    public BaseResponse payCalls(PayCreateOrderVo payCreateOrderVo) {
        BaseResponse baseResponse = this.sdyPaymentPlatformsService.payment(payCreateOrderVo);
        return baseResponse;
    }

    public BaseResponse refundCalls(RequestRefundVo requestRefundVo) {
        RefundDTO dto;
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        OrderEntity orderEntity1 = new OrderEntity();
        orderEntity1.setXId(requestRefundVo.getOrderId());
        objectQueryWrapper.setEntity((Object)orderEntity1);
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectOne((Wrapper)objectQueryWrapper);
        ServicePayBillEntity payBillEntity = (ServicePayBillEntity)this.servicePayBillMapper.selectById((Serializable)((Object)orderEntity.getBillPayId()));
        ServicePayBillEntity refundBillEntity = new ServicePayBillEntity();
        BeanUtils.copyProperties((Object)payBillEntity, (Object)refundBillEntity);
        refundBillEntity.setId(UUIDUtil.getUUID());
        refundBillEntity.setCreateTime(new Date());
        refundBillEntity.setUpdateTime(new Date());
        orderEntity.setBillRefundId(refundBillEntity.getId());
        this.orderMapper.updateById((Object)orderEntity);
        this.servicePayBillMapper.insert((Object)refundBillEntity);
        log.info("orderEntity:{}", (Object)JSON.toJSONString((Object)orderEntity));
        PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        integerList.add(7);
        integerList.add(8);
        integerList.add(9);
        integerList.add(2);
        if (integerList.contains(admissionEntity.getStatus())) {
            BaseResponse baseResponse;
            dto = new RefundDTO();
            dto.setTotlRefdAmt(orderEntity.getPayAmount().toPlainString());
            dto.setMedOrgOrd(orderEntity.getClinicCode());
            if (orderEntity.getFundType().equals("3") || orderEntity.getFundType().equals("9")) {
                String insuStr = orderEntity.getInsuSettlement();
                InsuSettlementReqDTO insuSettlementReqDTO = (InsuSettlementReqDTO)JSON.parseObject((String)insuStr, InsuSettlementReqDTO.class);
                dto.setInsuSettlement(insuSettlementReqDTO);
            }
            if (!(baseResponse = this.sdyPaymentPlatformsService.payRefund(dto)).isSuccess()) {
                return BaseResponse.error((String)"\u9000\u53f7\u5931\u8d25");
            }
            log.info("baseResponse{}", (Object)JSON.toJSONString((Object)baseResponse));
        }
        log.info("FundType:{}", (Object)orderEntity.getFundType());
        if ("4".equals(orderEntity.getFundType())) {
            UnifiedRefundReqVo unifiedRefundReqVo = new UnifiedRefundReqVo();
            unifiedRefundReqVo.setOutTransId(UUIDUtil.getUUID());
            unifiedRefundReqVo.setOriginalOutTransId(orderEntity.getXId());
            unifiedRefundReqVo.setOrganId(orderEntity.getOrganId());
            return this.unifiedPayService.refund(unifiedRefundReqVo);
        }
        if (new BigDecimal(orderEntity.getOwnCost()).compareTo(new BigDecimal("0.00")) != 0) {
            RequestPaymentRefundVO vo = new RequestPaymentRefundVO();
            vo.setAmt(new BigDecimal(orderEntity.getOwnCost()));
            vo.setOrgPayOrdNo(orderEntity.getOrderSeq());
            vo.setRefundOrdNo(UUIDUtil.generateViewId());
            BaseResponse response = this.sdyPaymentPlatformsService.paymentRefund(vo);
            return response;
        }
        dto = new PaymentRefundDTO();
        dto.setOrgPayOrdNo(orderEntity.getOrderSeq());
        dto.setOrdSts(ONE);
        return this.sdyPaymentPlatformsService.sdyRefundCallbacks((PaymentRefundDTO)dto);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse payByPackage(RequestPayByPackageVo requestPayByPackageVo) {
        OrderEntity orderEntity = this.getOrderById(requestPayByPackageVo.getOrderId());
        OnlineOutpatientUsageReqVo outpatientUsageReqVo = new OnlineOutpatientUsageReqVo();
        outpatientUsageReqVo.setId(requestPayByPackageVo.getPackageId());
        BaseResponse baseResponse = this.servicepkgServiceOrderClient.decreaseOnlineOutpatientUsage(outpatientUsageReqVo);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u5305\u4f7f\u7528\u5931\u8d25");
        }
        if (null == orderEntity) {
            return BaseResponse.error((String)"\u5728\u7ebf\u95ee\u8bca\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        orderEntity.setPayMethod(PayChannelEnum.PACKAGE.getPayChannel());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        orderEntity.setDealSeq(requestPayByPackageVo.getPackageId().toString() + "_" + System.currentTimeMillis());
        orderEntity.setPaymentTime(new Date());
        orderEntity.setBankTradeNo(requestPayByPackageVo.getPackageId().toString());
        this.orderMapper.updateOrderEntity(orderEntity);
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        if (null != orderEntity.getScheduleDate()) {
            Date scheduleDate = orderEntity.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderEntity.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setEndTime(expirationDateTime);
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
        } else {
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setConvertWaitTime(new Date());
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u6dfb\u52a0\u5c31\u8bca\u8bb0\u5f55:{}", (Object)admissionEntity.toString());
        Integer insertAdmissionRes = this.admissionMapper.updateById((Object)admissionEntity);
        if (insertAdmissionRes != null && insertAdmissionRes > 0) {
            this.payAsyncService.asyncTask(orderEntity, admissionEntity);
        }
        if (null != orderEntity.getScheduleDate()) {
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(orderEntity.getXId());
            log.info("\u5b9a\u65f6\u5904\u7406\u60a3\u8005\u672a\u70b9\u51fb'\u5019\u8bca\u62a5\u9053\u63a5\u53e3'\uff0c\u63d0\u793a\u60a3\u8005\u53bb\u5019\u8bca\uff0corderTaskVo3\uff1a{}", (Object)orderTaskVo3.toString());
            this.orderSender.sendDelay(orderTaskVo3);
            OrderTaskVo orderTaskVo4 = new OrderTaskVo();
            orderTaskVo4.setType(Integer.valueOf(4));
            orderTaskVo4.setId(orderEntity.getXId());
            log.info("\u9884\u7ea6\u6392\u73ed\u7ed3\u675f\u65f6\u95f4\u5c31\u8bca\u8ba2\u5355\u5904\u7406orderTaskVo4\uff1a{}", (Object)orderTaskVo4.toString());
            this.orderSender.sendDelay(orderTaskVo4);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(orderEntity.getXId());
            log.info("\u65e0\u6392\u73ed\u8ba2\u5355\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u8ba2\u5355\u5904\u7406 orderTaskVo2\uff1a{}", (Object)orderTaskVo2.toString());
            this.orderSender.sendDelay(orderTaskVo2);
        }
        log.info("\u670d\u52a1\u5305\u652f\u4ed8\u6210\u529f");
        return BaseResponse.success((Object)"success");
    }

    private OrderEntity getOrderByOrderSeq(String orderSeq) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setOrderSeq(orderSeq);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    public BaseResponse<YdCreadOrderResponse> createMedicalOrder(MedicalPayDto param) {
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)param.getOrderId()));
        MedicalPaymentRequest medicalPaymentRequest = new MedicalPaymentRequest();
        medicalPaymentRequest.setOrganCode("360ZFB");
        medicalPaymentRequest.setInsuplc_admdvs(param.getInsuplcAdmdvs());
        medicalPaymentRequest.setMdtrtarea_admvs(param.getMdtrtareaAdmvs());
        medicalPaymentRequest.setUldLatlnt(param.getUldLatlnt());
        medicalPaymentRequest.setInsutype(param.getInsutype());
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(String.valueOf(orderEntity.getDeptId()), orderEntity.getDoctorId());
        medicalPaymentRequest.setDeptCode(hisDeptAndDocCode.getDeptCode());
        medicalPaymentRequest.setDeptName(hisDeptAndDocCode.getDeptName());
        medicalPaymentRequest.setDoctorCode(hisDeptAndDocCode.getDoctorCode());
        medicalPaymentRequest.setDoctorName(hisDeptAndDocCode.getDoctorName());
        PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
        medicalPaymentRequest.setMdtrt_cert_no(patientEntity.getIdcard());
        medicalPaymentRequest.setPsn_name(param.getPsnName());
        medicalPaymentRequest.setPsn_no(param.getPsnNo());
        medicalPaymentRequest.setOpenid(param.getOpenId());
        medicalPaymentRequest.setPay_auth_no(param.getPayAuthNo());
        medicalPaymentRequest.setPsnType(param.getPsnType());
        medicalPaymentRequest.setIpt_otp_no(orderEntity.getXId());
        medicalPaymentRequest.setChrgBchno(orderEntity.getXId());
        medicalPaymentRequest.setMedfeeSumamt(String.valueOf(orderEntity.getPayAmount()));
        medicalPaymentRequest.setBegntime(DateUtils.dateToFullString((Date)orderEntity.getXCreateTime()));
        ArrayList<String> diseinfoList = new ArrayList<String>();
        diseinfoList.add(ONE);
        medicalPaymentRequest.setDiseinfoList(diseinfoList);
        ArrayList<String> drugsList = new ArrayList<String>();
        drugsList.add(ONE);
        medicalPaymentRequest.setDrugsList(drugsList);
        ArrayList inspectList = new ArrayList();
        medicalPaymentRequest.setInspectList(inspectList);
        String url = this.projProperties.getBaseAddress() + "/medicare/medicalPayment/nc/medicalInsurancePayment";
        try {
            log.info("\u533b\u4fdd\u4e0b\u5355url\uff1a{}", (Object)url);
            log.info("\u533b\u4fdd\u4e0b\u5355param\uff1a{}", (Object)JSON.toJSONString((Object)medicalPaymentRequest));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)medicalPaymentRequest));
            ResultResponse response = (ResultResponse)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            YdCreadOrderResponse data = (YdCreadOrderResponse)((YdBaseResponse)response.getBody()).getData();
            orderEntity.setTotCost(data.getFeeSumamt());
            orderEntity.setPayCost(data.getPsnAcctPay());
            orderEntity.setPubCost(data.getFundPay());
            orderEntity.setOwnCost(data.getOwnPayAmt());
            this.orderMapper.updateById((Object)orderEntity);
            UndoOrderRequest undoOrderRequest = new UndoOrderRequest();
            undoOrderRequest.setIdNo(patientEntity.getIdcard());
            undoOrderRequest.setIdType("01");
            undoOrderRequest.setInsuplc_admdvs(param.getInsuplcAdmdvs());
            undoOrderRequest.setPayOrdId(data.getPayOrdId());
            undoOrderRequest.setPayToken(data.getPayToken());
            undoOrderRequest.setUserName(patientEntity.getPatientName());
            undoOrderRequest.setOrganCode("360ZFB");
            undoOrderRequest.setExtData("");
            undoOrderRequest.setPayAuthNo(param.getPayAuthNo());
            this.redisUtil.set("yb_" + orderEntity.getXId(), JSONObject.toJSONString((Object)undoOrderRequest));
            return BaseResponse.success((Object)data);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u533b\u4fdd\u4e0b\u5355\u5931\u8d25" + e.getMessage());
            throw new BusinessException("\u8bf7\u6c42\u533b\u4fdd\u4e0b\u5355\u5931\u8d25");
        }
    }

    private BaseResponse aliPayMedical(OrderEntity orderEntity, MedicalPaycallReqVo medicalPaycallReqVo) {
        String orderSeq = UUIDUtil.generateViewId();
        AliPayCreateOrderRequest aliPayCreateOrderRequest = new AliPayCreateOrderRequest();
        BeanUtils.copyProperties((Object)medicalPaycallReqVo, (Object)aliPayCreateOrderRequest);
        AliPayExtendParamsEntrty aliPayExtendParamsEntrty = new AliPayExtendParamsEntrty();
        aliPayExtendParamsEntrty.setSys_service_provider_id("");
        aliPayExtendParamsEntrty.setIsInsurancePay("T");
        aliPayExtendParamsEntrty.setMedical_card_inst_id(medicalPaycallReqVo.getMedical_card_inst_id());
        aliPayExtendParamsEntrty.setMedical_card_id(medicalPaycallReqVo.getMedical_card_id());
        JSONObject medicalRequesCotennt = new JSONObject();
        aliPayExtendParamsEntrty.setMedical_request_content(medicalRequesCotennt);
        AliPayMedicalRequesExtEntrty aliPayMedicalRequesExtEntrty = new AliPayMedicalRequesExtEntrty();
        aliPayMedicalRequesExtEntrty.setBill_no(medicalPaycallReqVo.getPayOrdId());
        aliPayMedicalRequesExtEntrty.setSerial_no(medicalPaycallReqVo.getPayOrdId());
        aliPayMedicalRequesExtEntrty.setOut_trade_no(orderSeq);
        aliPayMedicalRequesExtEntrty.setGmt_out_create(DateUtils.dateToFullString((Date)new Date()));
        aliPayMedicalRequesExtEntrty.setPay_auth_no(medicalPaycallReqVo.getPay_auth_no());
        aliPayMedicalRequesExtEntrty.setChinfo("gjydzf");
        aliPayMedicalRequesExtEntrty.setIndustry("HOSPITAL");
        aliPayMedicalRequesExtEntrty.setScene("TREATMENT");
        aliPayMedicalRequesExtEntrty.setInsurance_pay_scene("APPOINTMENT");
        aliPayExtendParamsEntrty.setMedical_request_ext(aliPayMedicalRequesExtEntrty);
        aliPayCreateOrderRequest.setExtend_params(aliPayExtendParamsEntrty);
        aliPayCreateOrderRequest.setOut_trade_no(orderSeq);
        aliPayCreateOrderRequest.setTotal_amount(orderEntity.getPayAmount());
        aliPayCreateOrderRequest.setSubject(this.projProperties.getProductInfo());
        aliPayCreateOrderRequest.setProduct_code("QUICK_MSECURITY_PAY");
        aliPayCreateOrderRequest.setOrganCode("360ZFB");
        aliPayCreateOrderRequest.setTime_expire(DateUtils.dateToFullString((Date)DateUtils.dateAddMinutes((Date)new Date(), (int)30)));
        aliPayCreateOrderRequest.setNotifyUrl(MessageFormat.format(this.projProperties.getPayNotifyUrl(), orderEntity.getAppCode()));
        orderEntity.setOrderSeq(orderSeq);
        this.orderMapper.updateById((Object)orderEntity);
        String url = this.projProperties.getBaseAddress() + "/medicare/ali/alipayTradeAppPay";
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)aliPayCreateOrderRequest));
            ResultResponse response = (ResultResponse)JSON.parseObject((String)result, ResultResponse.class);
            return BaseResponse.success((Object)response.getBody());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            throw new BusinessException("\u8bf7\u6c42\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25");
        }
    }

    public String medicalCallbackWhilePaySuccessAsync(HttpServletRequest request) {
        Map params = this.convertRequestParamsToMap(request);
        String paramsJson = JSON.toJSONString((Object)params);
        log.info("\u652f\u4ed8\u5b9d\u56de\u8c03\uff0c{}", (Object)paramsJson);
        String json = JSON.toJSONString((Object)params);
        AlipayNotifyParam alipayNotifyParam = (AlipayNotifyParam)JSON.parseObject((String)json, AlipayNotifyParam.class);
        String tradeStatus = alipayNotifyParam.getTradeStatus();
        if (tradeStatus.equals("TRADE_SUCCESS")) {
            log.info("\u652f\u4ed8\u6210\u529f");
        } else {
            log.info("\u652f\u4ed8\u5931\u8d25");
        }
        return "success";
    }

    public BaseResponse medicalCallbackWhilePaySuccess(MedicalNotifyReqVo param) {
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)param.getOrderId()));
        if (Objects.isNull(orderEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u5230\u76f8\u5173\u8ba2\u5355\u4fe1\u606f");
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        String url = this.projProperties.getBaseAddress() + "/medicare/medicalPayment/ybByAliPayOrderQuery";
        QueryMedicalSettlementOrderRequest request = new QueryMedicalSettlementOrderRequest();
        request.setPayToken(param.getPayToken());
        request.setPayOrdId(param.getPayOrdId());
        request.setOutTradeNo(orderEntity.getOrderSeq());
        request.setUserName(patientEntity.getPatientName());
        request.setIdNo(patientEntity.getIdcard());
        request.setIdType("01");
        request.setOrganCode("360ZFB");
        request.setExpContent("");
        request.setOrgCodg("");
        int i = 1;
        int time = 100;
        while (time <= 6000) {
            try {
                Thread.sleep(time);
                String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
                JSONObject jsonResponse = JSON.parseObject((String)result);
                JSONObject jsonbody = jsonResponse.getJSONObject("body");
                JSONObject jsonMedical = jsonbody.getJSONObject("queryMedicalSettlementOrderResponse");
                JSONObject jsonAlipay = jsonbody.getJSONObject("alipayTradeQueryResponse");
                JSONObject body1 = jsonMedical.getJSONObject("body");
                JSONObject body2 = jsonAlipay.getJSONObject("body");
                String payOrdId = body1.get((Object)"payOrdId").toString();
                String traceTime = body1.get((Object)"traceTime").toString();
                String tradeNo = body2.get((Object)"tradeNo").toString();
                String ordStas = body1.get((Object)"ordStas").toString();
                String tradeStatus = body2.get((Object)"tradeStatus").toString();
                if (Objects.equals(tradeStatus, "TRADE_SUCCESS") && Objects.equals(ordStas, "6")) {
                    ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                    responseNotifyRestVo.setTradeNo(tradeNo);
                    responseNotifyRestVo.setPayTime(DateUtils.parseDate((String)traceTime, (String)"yyyyMMddHHmmss"));
                    responseNotifyRestVo.setDealTradeNo(orderEntity.getOrderSeq());
                    this.updateOrderRecordService.updateOrderRecord(responseNotifyRestVo, orderEntity);
                    return BaseResponse.success((Object)"\u652f\u4ed8\u6210\u529f");
                }
                time += ++i * 2 * 100;
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u652f\u4ed8\u7ed3\u679c\u5931\u8d25" + e.getMessage());
                time += ++i * 2 * 100;
            }
        }
        return BaseResponse.error((String)"\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u5931\u8d25");
    }

    public BaseResponse medicalSdy(String clinicCode, String businessType) {
        MedicalPayVo medicalPayVo = new MedicalPayVo();
        medicalPayVo.setMedOrgOrd(clinicCode);
        medicalPayVo.setBusinessType(businessType);
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/medical-insurance/jumpToPay";
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)medicalPayVo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseResponse response = (BaseResponse)JSON.parseObject(result, BaseResponse.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity qorder = new OrderEntity();
        qorder.setClinicCode(clinicCode);
        queryWrapper.setEntity((Object)qorder);
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectOne((Wrapper)queryWrapper);
        orderEntity.setFundType("4");
        this.orderMapper.updateById((Object)orderEntity);
        return response;
    }

    public BaseResponse medicalRefynd(RequestRefundVo requestRefundVo) {
        OrderEntity orderEntity = this.orderMapper.findById(requestRefundVo.getOrderId());
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        RefundDTO dto = new RefundDTO();
        dto.setMedOrgOrd(orderEntity.getClinicCode());
        QueryWrapper queryWrapper = new QueryWrapper();
        MedicalPayNotifyEntity entity = new MedicalPayNotifyEntity();
        entity.setMedOrgOrd(orderEntity.getClinicCode());
        queryWrapper.setEntity((Object)entity);
        MedicalPayNotifyEntity medicalPayNotifyEntity = (MedicalPayNotifyEntity)this.medicalPayNotifyMapper.selectOne((Wrapper)queryWrapper);
        log.info("medicalPayNotifyEntity:{}", (Object)JSON.toJSONString((Object)medicalPayNotifyEntity));
        dto.setExtData(medicalPayNotifyEntity.getJsonStringExtData());
        dto.setTotlRefdAmt(medicalPayNotifyEntity.getFeeSumamt().toPlainString());
        dto.setCashRefdAmt(ObjectUtils.isEmpty((Object)medicalPayNotifyEntity.getOwnpayAmt()) ? "0" : medicalPayNotifyEntity.getOwnpayAmt().toPlainString());
        dto.setFundRefdAmt(medicalPayNotifyEntity.getFundPay().toPlainString());
        dto.setPsnAcctRefdAmt(medicalPayNotifyEntity.getPsnAcctPay().toPlainString());
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/medical-insurance/onlineRefund";
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)dto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseResponse frontResponse = (BaseResponse)JSON.parseObject(result, BaseResponse.class);
        if ("0".equals(frontResponse.getCode())) {
            return BaseResponse.error((String)"\u533b\u4fdd\u9000\u6b3e\u5931\u8d25");
        }
        MedicalRefundDto medicalRefundDto = (MedicalRefundDto)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getData()), MedicalRefundDto.class);
        if ("SUCC".equals(medicalRefundDto.getRefStatus())) {
            ArrayList<Integer> integerList = new ArrayList<Integer>();
            integerList.add(7);
            integerList.add(8);
            integerList.add(9);
            integerList.add(2);
            if (integerList.contains(admissionEntity.getStatus())) {
                RefundDTO refundDTO = new RefundDTO();
                refundDTO.setTotlRefdAmt(orderEntity.getPayAmount().toPlainString());
                refundDTO.setMedOrgOrd(orderEntity.getClinicCode());
                BaseResponse baseResponse = this.sdyPaymentPlatformsService.payRefund(dto);
                log.info("baseResponse{}", (Object)JSON.toJSONString((Object)baseResponse));
            }
            orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(new Date());
            this.orderMapper.updateOrderEntity(orderEntity);
            if (Objects.isNull(admissionEntity.getLastStatus()) || "".equals(admissionEntity.getLastStatus())) {
                if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
                    this.admissionMapper.updateStatusByAdmId(admissionEntity.getXId(), AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
                } else if (AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admissionEntity.getStatus())) {
                    this.admissionMapper.updateStatusByAdmId(admissionEntity.getXId(), AdmissionStatusEnum.RETIRED.getValue());
                }
            } else {
                AdmissionEntity admission = new AdmissionEntity();
                admission.setStatus(admissionEntity.getLastStatus());
                admission.setXId(admissionEntity.getXId());
                admission.setXRemark(AdmissionStatusEnum.getDisplay((Integer)admissionEntity.getLastStatus()));
                this.admissionMapper.update(admission);
            }
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u533b\u4fdd\u9000\u6b3e\u5931\u8d25");
    }

    private Map<String, String> convertRequestParamsToMap(HttpServletRequest request) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            retMap.put(name, valueStr);
        }
        return retMap;
    }

    private void aliRefundMedical(OrderEntity orderEntity, String payAuthNo) {
        RefundOrderRequest refundOrderRequest = new RefundOrderRequest();
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        String data = this.redisUtil.get("yb_" + orderEntity.getXId());
        UndoOrderRequest undoOrderRequest = (UndoOrderRequest)JSONObject.parseObject((String)data, UndoOrderRequest.class);
        PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
        refundOrderRequest.setAppRefdSn(orderEntity.getDealSeq());
        refundOrderRequest.setAppRefdTime(DateUtils.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        refundOrderRequest.setCashRefdAmt(orderEntity.getOwnCost());
        refundOrderRequest.setFundRefdAmt(orderEntity.getPubCost());
        refundOrderRequest.setPsnAcctRefdAmt(orderEntity.getPayCost());
        refundOrderRequest.setTotlRefdAmt(orderEntity.getTotCost());
        refundOrderRequest.setEcToken("");
        refundOrderRequest.setExpContent("");
        refundOrderRequest.setIdNo(patientEntity.getIdcard());
        refundOrderRequest.setOrganCode("360ZFB");
        refundOrderRequest.setPayAuthNo(payAuthNo);
        refundOrderRequest.setPayOrdId(undoOrderRequest.getPayOrdId());
        refundOrderRequest.setRefdType("ALL");
        refundOrderRequest.setUserName(patientEntity.getPatientName());
        String url = this.projProperties.getBaseAddress() + "/medicare//medicalPayment/ybAliReturnOrderAndRevoke";
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)refundOrderRequest));
            log.info("\u533b\u4fdd\u8ba2\u5355\u9000\u8d39\u7ed3\u679c:{}", (Object)result);
            ResultResponse response = (ResultResponse)JSON.parseObject((String)result, ResultResponse.class);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMessage());
            }
            orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(new Date());
            this.orderMapper.updateOrderEntity(orderEntity);
            this.admissionMapper.updateStatusByAdmId(admissionEntity.getXId(), AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            throw new BusinessException("\u9000\u6b3e\u5931\u8d25");
        }
    }

    static /* synthetic */ AliSmsPushService access$000(PayCallBackServiceImpl x0) {
        return x0.aliSmsPushService;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

