/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.ServiceConfigVo;
import com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.vo.LockedNumDTO;
import com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.vo.LockedNumVO;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ReferralInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ReferralInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.ReferralInfoService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqPageReferralVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqReferralVerifyVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqReferralVo;
import com.ebaiyihui.onlineoutpatient.core.vo.workservice.GetDocServiceConfigReq;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferralInfoServiceImpl
extends ServiceImpl<ReferralInfoMapper, ReferralInfoEntity>
implements ReferralInfoService {
    private static final Logger log = LoggerFactory.getLogger(ReferralInfoServiceImpl.class);
    @Resource
    AdmissionMapper admissionMapper;
    @Resource
    private ProjProperties projProperties;
    @Resource
    private PatientMapper patientMapper;
    @Resource
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Resource
    OrderMapper orderMapper;
    @Resource
    private InquiryServiceConfigService inquiryServiceConfigService;
    @Resource
    private OrderSender orderSender;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private UmAppPushService umAppPushService;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private AliSmsPushService aliSmsPushService;
    @Resource
    private IMInformService imInformService;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public BaseResponse saveReferral(ReqReferralVo reqReferralVo) {
        try {
            QueryWrapper admissionQueryWrapper = new QueryWrapper();
            AdmissionEntity queryAdmissionEntity = new AdmissionEntity();
            queryAdmissionEntity.setOrderId(reqReferralVo.getOrderId());
            admissionQueryWrapper.setEntity((Object)queryAdmissionEntity);
            AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionQueryWrapper);
            if (null != admissionEntity && admissionEntity.getStatus() != AdmissionStatusEnum.TO_BE_RECEIVED.getValue()) {
                return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u975e\u5f85\u63a5\u8bca\u72b6\u6001\uff0c\u4e0d\u53ef\u8f6c\u8bca");
            }
            admissionEntity.setInReferral(Integer.valueOf(1));
            this.admissionMapper.update(admissionEntity);
            QueryWrapper queryWrapper = new QueryWrapper();
            ReferralInfoEntity qre = new ReferralInfoEntity();
            qre.setOrderId(reqReferralVo.getOrderId());
            queryWrapper.setEntity((Object)qre);
            ReferralInfoEntity referralInfo = (ReferralInfoEntity)this.getOne((Wrapper)queryWrapper);
            if (Objects.nonNull(referralInfo)) {
                return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u8f6c\u8bca\uff0c\u4e0d\u53ef\u91cd\u590d\u8f6c\u8bca");
            }
            ReferralInfoEntity entity = new ReferralInfoEntity();
            BeanUtils.copyProperties((Object)reqReferralVo, (Object)entity);
            entity.setCreateTime(new Date());
            entity.setVerifyTime(null);
            this.save((Object)entity);
        }
        catch (Exception e) {
            log.info("\u65b0\u589e\u8f6c\u8bca\u4fe1\u606f\u5931\u8d25:\n{}", (Throwable)e);
            return BaseResponse.error((String)"\u65b0\u589e\u8f6c\u8bca\u4fe1\u606f\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse<PageInfo<ReferralInfoEntity>> pageListReferral(ReqPageReferralVo reqPageReferralVo) {
        PageHelper.startPage((int)reqPageReferralVo.getPageNum(), (int)reqPageReferralVo.getPageSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        ReferralInfoEntity referralInfoEntity = new ReferralInfoEntity();
        if (null != reqPageReferralVo.getStatus()) {
            referralInfoEntity.setStatus(reqPageReferralVo.getStatus());
        }
        queryWrapper.setEntity((Object)referralInfoEntity);
        if (StringUtil.isNotEmpty((String)reqPageReferralVo.getSearchParams())) {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.like((Object)"doctor_name", (Object)reqPageReferralVo.getSearchParams())).or()).like((Object)"patient_name", (Object)reqPageReferralVo.getSearchParams())).or()).like((Object)"referral_doctor_name", (Object)reqPageReferralVo.getSearchParams());
        }
        queryWrapper.orderByDesc((Object)"update_time");
        List infoEntityList = this.list((Wrapper)queryWrapper);
        for (ReferralInfoEntity list : infoEntityList) {
            if (list.getStatus() == 2) continue;
            list.setVerifyTime(null);
        }
        PageInfo pageInfo = new PageInfo(infoEntityList);
        return BaseResponse.success((Object)pageInfo);
    }

    public BaseResponse verify(ReqReferralVerifyVo reqReferralVerifyVo) {
        try {
            BaseResponse referral;
            ReferralInfoEntity referralInfoEntity = (ReferralInfoEntity)this.getById((Serializable)reqReferralVerifyVo.getId());
            referralInfoEntity.setStatus(Integer.valueOf(2));
            referralInfoEntity.setVerifier(reqReferralVerifyVo.getVerifier());
            if (StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDeptId()) && StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDeptName()) && StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDoctorId()) && StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDoctorName())) {
                referralInfoEntity.setReferralDeptId(reqReferralVerifyVo.getReferralDeptId());
                referralInfoEntity.setReferralDeptName(reqReferralVerifyVo.getReferralDeptName());
                referralInfoEntity.setReferralDoctorId(reqReferralVerifyVo.getReferralDoctorId());
                referralInfoEntity.setReferralDoctorName(reqReferralVerifyVo.getReferralDoctorName());
                referralInfoEntity.setReason(reqReferralVerifyVo.getReason());
            }
            if (!(referral = this.referral(reqReferralVerifyVo)).isSuccess()) {
                return referral;
            }
            referralInfoEntity.setVerifyTime(new Date());
            this.updateById((Object)referralInfoEntity);
        }
        catch (Exception e) {
            log.info("\u590d\u8bca\u8f6c\u8bca\u5ba1\u6838\u5931\u8d25\uff1a\n{}", (Throwable)e);
            return BaseResponse.error((String)"\u590d\u8bca\u8f6c\u8bca\u5ba1\u6838\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse referral(ReqReferralVerifyVo reqReferralVerifyVo) {
        log.info("\u590d\u8bca\u8f6c\u8bcareqReferralVerifyVo\uff1a{}", (Object)JSON.toJSONString((Object)reqReferralVerifyVo));
        ReferralInfoEntity referralInfoEntity = (ReferralInfoEntity)this.getById((Serializable)reqReferralVerifyVo.getId());
        QueryWrapper queryWrapper = new QueryWrapper();
        AdmissionEntity queryAdmissionEntity = new AdmissionEntity();
        queryAdmissionEntity.setOrderId(referralInfoEntity.getOrderId());
        queryWrapper.setEntity((Object)queryAdmissionEntity);
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u590d\u8bca\u8f6c\u8bcaadmissionEntity\uff1a{}", (Object)JSON.toJSONString((Object)admissionEntity));
        OrderEntity orderEntity = this.orderMapper.findById(referralInfoEntity.getOrderId());
        if (null == admissionEntity) {
            return BaseResponse.error((String)"\u67e5\u8be2\u5c31\u8bca\u4fe1\u606f\u5931\u8d25");
        }
        log.info("admissionEntity:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        if (null == orderEntity) {
            return BaseResponse.error((String)"\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        log.info("orderEntity:{}", (Object)JSON.toJSONString((Object)orderEntity));
        if (!AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u8f6c\u8bca");
        }
        String doctorId = referralInfoEntity.getReferralDoctorId();
        if (StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDoctorId())) {
            doctorId = reqReferralVerifyVo.getReferralDoctorId();
        }
        List queryAdmissionList = this.admissionMapper.queryIngOrders(doctorId, admissionEntity.getPatientId());
        log.info("\u590d\u8bca\u8f6c\u8bcaqueryAdmissionList\uff1a{}", (Object)JSON.toJSONString((Object)queryAdmissionList));
        if (null != queryAdmissionList && queryAdmissionList.size() > 0) {
            return BaseResponse.error((String)"\u8be5\u60a3\u8005\u5df2\u7ecf\u4e0b\u5355\u4e86\u8be5\u533b\u751f");
        }
        admissionEntity.setInReferral(Integer.valueOf(0));
        admissionEntity.setStatus(AdmissionStatusEnum.REFERRAL.getValue());
        admissionEntity.setXUpdateTime(new Date());
        admissionEntity.setEndTime(new Date());
        Integer t = this.admissionMapper.update(admissionEntity);
        if (t != 1) {
            return BaseResponse.error((String)"\u66f4\u65b0\u5c31\u8bca\u8bb0\u5f55\u4e3a\u5df2\u8f6c\u8bca\u5931\u8d25");
        }
        AdmissionEntity admissionEntityNew = new AdmissionEntity();
        admissionEntityNew.setXId(UUIDUtil.getUUID());
        OrderEntity orderEntityNew = this.insertOrderEntity(reqReferralVerifyVo, referralInfoEntity, orderEntity);
        if (StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDeptId())) {
            orderEntityNew.setDeptId(Long.valueOf(reqReferralVerifyVo.getReferralDeptId()));
            orderEntityNew.setDeptName(reqReferralVerifyVo.getReferralDeptName());
        } else {
            orderEntityNew.setDeptId(Long.valueOf(referralInfoEntity.getReferralDeptId()));
            orderEntityNew.setDeptName(referralInfoEntity.getReferralDeptName());
        }
        ServiceConfigVo serviceConfig = this.calculateOrderPrice(orderEntityNew.getOrganId(), orderEntityNew.getDoctorId(), orderEntityNew.getServType(), orderEntityNew.getDeptId());
        if (serviceConfig == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        orderEntityNew.setServTime(serviceConfig.getServTime());
        orderEntityNew.setTotalNum(serviceConfig.getNumLimit());
        admissionEntityNew.setXCreateTime(new Date());
        admissionEntityNew.setXUpdateTime(new Date());
        admissionEntityNew.setOrderId(orderEntityNew.getXId());
        if (StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDeptId())) {
            admissionEntityNew.setDoctorId(reqReferralVerifyVo.getReferralDoctorId());
            admissionEntityNew.setDoctorName(reqReferralVerifyVo.getReferralDoctorName());
        } else {
            admissionEntityNew.setDoctorId(referralInfoEntity.getReferralDoctorId());
            admissionEntityNew.setDoctorName(referralInfoEntity.getReferralDoctorName());
        }
        admissionEntityNew.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        admissionEntityNew.setPackageId(admissionEntity.getPackageId());
        admissionEntityNew.setServTime(serviceConfig.getServTime());
        admissionEntityNew.setTotalNum(orderEntityNew.getTotalNum());
        admissionEntityNew.setCurrentNum(orderEntityNew.getTotalNum());
        admissionEntityNew.setPatientId(admissionEntity.getPatientId());
        admissionEntityNew.setMedicalRecordId(orderEntityNew.getMedicalRecordId());
        admissionEntityNew.setServType(orderEntityNew.getServType());
        admissionEntityNew.setOrganId(admissionEntity.getOrganId());
        admissionEntityNew.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
        log.info("admissionEntityNew:{}", (Object)JSON.toJSONString((Object)admissionEntityNew));
        Integer r = this.admissionMapper.insert((Object)admissionEntityNew);
        if (r != 1) {
            return BaseResponse.error((String)"\u65b0\u589e\u5c31\u8bb0\u5f55\u5931\u8d25");
        }
        Integer l = this.orderMapper.insert((Object)orderEntityNew);
        if (l != 1) {
            return BaseResponse.error((String)"\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        orderEntity.setDealSeq(orderEntity.getDealSeq() + "ZZ");
        orderEntity.setOrderSeq(orderEntity.getOrderSeq() + "ZZ");
        this.orderMapper.updateById((Object)orderEntity);
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success();
    }

    private OrderEntity insertOrderEntity(ReqReferralVerifyVo reqReferralVerifyVo, ReferralInfoEntity referralInfoEntity, OrderEntity orderEntity) {
        OrderEntity orderEntityNew = new OrderEntity();
        BeanUtils.copyProperties((Object)orderEntity, (Object)orderEntityNew);
        orderEntityNew.setXId(UUIDUtil.getUUID());
        if (StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDeptId())) {
            orderEntityNew.setDoctorId(reqReferralVerifyVo.getReferralDoctorId());
            orderEntityNew.setDoctorName(reqReferralVerifyVo.getReferralDoctorName());
        } else {
            orderEntityNew.setDoctorId(referralInfoEntity.getReferralDoctorId());
            orderEntityNew.setDoctorName(referralInfoEntity.getReferralDoctorName());
        }
        orderEntityNew.setHospitalId(orderEntity.getHospitalId());
        orderEntityNew.setHospitalName(orderEntity.getHospitalName());
        orderEntityNew.setDealSeq(orderEntity.getDealSeq());
        orderEntityNew.setBankTradeNo(orderEntity.getBankTradeNo());
        orderEntityNew.setOrderSeq(orderEntity.getOrderSeq());
        orderEntityNew.setPayMethod(orderEntity.getPayMethod());
        orderEntityNew.setPatientUserId(orderEntity.getPatientUserId());
        orderEntityNew.setPatientId(orderEntity.getPatientId());
        orderEntityNew.setPaymentTime(orderEntity.getPaymentTime());
        orderEntityNew.setPayAmount(orderEntity.getPayAmount());
        orderEntityNew.setStatus(orderEntity.getStatus());
        orderEntityNew.setOrganId(orderEntity.getOrganId());
        orderEntityNew.setDoctorType(orderEntity.getDoctorType());
        orderEntityNew.setServType(orderEntity.getServType());
        orderEntityNew.setAppCode(orderEntity.getAppCode());
        orderEntityNew.setIdCard(orderEntity.getIdCard());
        orderEntityNew.setMedicalRecordId(orderEntity.getMedicalRecordId());
        orderEntityNew.setAdmType(orderEntity.getAdmType());
        orderEntityNew.setPayCost(orderEntity.getPayCost());
        orderEntityNew.setTotCost(orderEntity.getTotCost());
        orderEntityNew.setPubCost(orderEntity.getPubCost());
        orderEntityNew.setOwnCost(orderEntity.getOwnCost());
        orderEntityNew.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
        orderEntityNew.setClinicCode(orderEntity.getClinicCode());
        orderEntityNew.setInvoiceNo(orderEntity.getInvoiceNo());
        orderEntityNew.setMerchantId(orderEntity.getMerchantId());
        log.info("orderEntityNew:{}", (Object)JSON.toJSONString((Object)orderEntityNew));
        orderEntityNew.setInsuSettlement(orderEntity.getInsuSettlement());
        return orderEntityNew;
    }

    private ServiceConfigVo calculateOrderPrice(String organId, String doctorId, Integer servType, Long deptId) {
        GetDocServiceConfigReq getServiceConfigReq = new GetDocServiceConfigReq();
        getServiceConfigReq.setDoctorId(doctorId);
        getServiceConfigReq.setOrganId(organId);
        getServiceConfigReq.setServType(servType);
        getServiceConfigReq.setDeptId(deptId.toString());
        ResultData resultData = this.inquiryServiceConfigService.getDoctorServiceInfo(getServiceConfigReq);
        log.info("\u533b\u751f\u670d\u52a1\u4fe1\u606f:{}", (Object)resultData);
        if (resultData == null || !resultData.isSuccess()) {
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        return (ServiceConfigVo)resultData.getData();
    }

    private BaseResponse<LockedNumVO> LockedNum(ServiceConfigVo serviceConfigVo, ReqReferralVerifyVo reqReferralVerifyVo, ReferralInfoEntity referralInfoEntity) {
        HisDeptAndDocCodeVo hisDeptAndDocCod = StringUtil.isNotEmpty((String)reqReferralVerifyVo.getReferralDeptId()) ? this.internetHospitalDetailInfoService.getHisDeptAndDocCode(reqReferralVerifyVo.getReferralDeptId(), reqReferralVerifyVo.getReferralDoctorId()) : this.internetHospitalDetailInfoService.getHisDeptAndDocCode(referralInfoEntity.getReferralDeptId(), referralInfoEntity.getReferralDoctorId());
        if (null == hisDeptAndDocCod) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u8c03\u7528\u51fa\u9519");
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(referralInfoEntity.getPatientId());
        LockedNumDTO dto = new LockedNumDTO();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        dto.setDeptCode(hisDeptAndDocCod.getDeptCode());
        dto.setDrCode(hisDeptAndDocCod.getDoctorCode());
        dto.setScheduleDate(format);
        dto.setPatnId(patientEntity.getMedicalNO());
        dto.setPsnNo(patientEntity.getCardNo());
        dto.setRegFee(serviceConfigVo.getPrice().toPlainString());
        dto.setRgstDate(DateUtils.getCurrentDateToString());
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/appoint/register/occupancySign";
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)dto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(result, FrontResponse.class);
        if ("0".equals(frontResponse.getCode())) {
            log.error("\u9501\u53f7\u5931\u8d25\uff1a" + frontResponse.getMessage());
            log.info("\u5220\u9664\u8d26\u5355\u8bb0\u5f55\u6210\u529f");
            return BaseResponse.error((String)frontResponse.getMessage());
        }
        LockedNumVO vo = (LockedNumVO)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), LockedNumVO.class);
        return BaseResponse.success((Object)vo);
    }

    private void imInfromPush(AdmissionEntity admissionEntity, ReqReferralVerifyVo reqReferralVerifyVo, ReferralInfoEntity referralInfoEntity, AdmissionEntity admissionEntityNew, OrderEntity orderEntityNew) throws AdmissionException {
        this.payAsyncService.createPersonalImSession(orderEntityNew, admissionEntityNew.getXId());
        this.imInformService.admissionDoctor(referralInfoEntity, admissionEntityNew);
        this.imInformService.admissionDoctorNew(referralInfoEntity, admissionEntity);
        this.imInformService.referralCardNew(referralInfoEntity.getId(), admissionEntityNew.getXId());
        log.info("================\u533b\u751f\u7aef\u8f6c\u8bca\u533b\u751f\u8f6c\u8bca\u5355\u5c0f\u5361\u7247\u63a8\u9001\u7ed3\u675f============");
        this.imInformService.referralCardNew(referralInfoEntity.getId(), admissionEntity.getXId());
        this.imInformService.toReferralDoctorTwo(admissionEntity, admissionEntityNew, referralInfoEntity);
        this.imInformService.doctorReferralMsgNew(admissionEntity.getXId(), "\u60a8\u597d,\u6211\u56e0\u8bca\u7597\u65b9\u5411\u4e0d\u5408\u9002,\u5df2\u5c06\u60a8\u7684\u590d\u8bca\u7533\u8bf7\u8f6c\u8bca\u7ed9" + admissionEntityNew.getDoctorName() + "\u533b\u751f\u3002", "user");
        this.imInformService.doctorReferralCard(referralInfoEntity.getId().toString(), admissionEntity.getXId());
        this.imInformService.doctorReferralCardNew(referralInfoEntity.getId().toString(), admissionEntity.getXId());
        this.imInformService.doctorReferralMsgNew(admissionEntity.getXId(), "\u60a8\u597d,\u53ef\u4ee5\u76f4\u63a5\u5728\u8bca\u7597\u9875\u8fdb\u884c\u54a8\u8be2!", "user");
        this.imInformService.patientMedicalRecordTime(admissionEntityNew.getXId());
        log.info("=======\u65b0\u8ba2\u5355\u60a3\u8005\u7aef\u75c5\u4f8b\u63a8\u9001\u65f6\u95f4\uff0c\u63a8\u9001\u7ed3\u675f=====");
        this.imInformService.paySuccess(admissionEntityNew.getXId());
        log.info("=======\u65b0\u8ba2\u5355\u60a3\u8005\u7aef\u75c5\u4f8b\u63a8\u9001\uff0c\u5305\u62ec\u60a3\u8005\u5361\u7247\u4e0b\u5355\u63a8\u9001\u7ed3\u675f=====");
        this.imInformService.referralCard(reqReferralVerifyVo.getId(), admissionEntityNew.getXId());
        log.info("================\u533b\u751f\u7aef\u8f6c\u8bca\u533b\u751f\u8f6c\u8bca\u5355\u5c0f\u5361\u7247\u63a8\u9001============");
        this.imInformService.admissionDoctorOver(referralInfoEntity, admissionEntity);
        this.imInformService.doctorMedicalRecord(admissionEntityNew.getXId());
    }

    static /* synthetic */ OrderSender access$000(ReferralInfoServiceImpl x0) {
        return x0.orderSender;
    }

    static /* synthetic */ AliSmsPushService access$100(ReferralInfoServiceImpl x0) {
        return x0.aliSmsPushService;
    }

    static /* synthetic */ void access$200(ReferralInfoServiceImpl x0, AdmissionEntity x1, ReqReferralVerifyVo x2, ReferralInfoEntity x3, AdmissionEntity x4, OrderEntity x5) throws AdmissionException {
        x0.imInfromPush(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }
}

