/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PayCreateOrderVo;
import com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.vo.QueryLockedNumHospitalRepVO;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WeChatPayTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.SdyPaymentPlatformsService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RegRecipeYjsReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.RegRecipeYjsResVO;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PayOrderDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PaymentRefundDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PaymentResultsDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.vo.PayOrderVO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.vo.PaymentInquiryVO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.vo.PaymentRefundVO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.vo.RequestPaymentRefundVO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.MedicalNotifyReq;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.MedicalPayNotifyVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.RefundDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SdyPaymentPlatformsServiceImpl
implements SdyPaymentPlatformsService {
    private static final Logger log = LoggerFactory.getLogger(SdyPaymentPlatformsServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private AliSmsPushService aliSmsPushService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    PatientMapper patientMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    PayCallBackService payCallBackService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedisTemplateService redisTemplateService;
    private static final Long EXPIRE_DATE = 3L;

    public BaseResponse<PayOrderDTO> payment(PayCreateOrderVo payCreateOrderVo) {
        String redisKey = payCreateOrderVo.getOrderId() + "_" + payCreateOrderVo.getUserSign() + "_" + payCreateOrderVo.getFundType();
        log.info("redisKey:{}" + redisKey);
        Boolean flag = this.redisTemplateService.addLockNew(redisKey, redisKey, EXPIRE_DATE.longValue());
        if (flag.booleanValue()) {
            return BaseResponse.error((String)"\u5904\u7406\u4e2d,\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb\u63d0\u4ea4");
        }
        log.info("\u52a0\u9501\u6210\u529f");
        QueryWrapper admWapper = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrderId(payCreateOrderVo.getOrderId());
        admWapper.setEntity((Object)admissionEntity);
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admWapper);
        if (AdmissionStatusEnum.EXPIRED.getValue().equals(admission.getStatus())) {
            return BaseResponse.error((String)"\u8d85\u8fc7\u9884\u7ea6\u65f6\u95f4,\u8ba2\u5355\u5df2\u5931\u6548");
        }
        OrderEntity orderEntity = this.orderMapper.findById(payCreateOrderVo.getOrderId());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        if (ObjectUtils.isEmpty((Object)orderEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (ObjectUtils.isEmpty((Object)patientEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f");
        }
        if (OrderStatusEnum.CANCEL.getValue().equals(orderEntity.getStatus())) {
            return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u5931\u6548");
        }
        if (ServiceTypeEnum.NOS.getValue().equals(orderEntity.getServType()) && StringUtils.isEmpty((CharSequence)orderEntity.getClinicCode())) {
            return BaseResponse.error((String)"\u9700\u8981\u5148\u5360\u53f7");
        }
        if (orderEntity.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
            return BaseResponse.error((String)"\u91d1\u989d\u9700\u8981\u5927\u4e8e0");
        }
        orderEntity.setFundType(payCreateOrderVo.getFundType().equals("1") ? "1" : "3");
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        this.orderMapper.updateById((Object)orderEntity);
        BaseResponse resVOBaseResponse = this.registerYjs(payCreateOrderVo, orderEntity, patientEntity);
        if (!resVOBaseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u6302\u53f7\u9884\u7ed3\u7b97\u5931\u8d25");
        }
        RegRecipeYjsResVO regRecipeYjsResVO = (RegRecipeYjsResVO)resVOBaseResponse.getData();
        orderEntity.setFundType(payCreateOrderVo.getFundType().equals("1") ? "1" : "3");
        orderEntity.setPayCost(regRecipeYjsResVO.getAcctPay());
        orderEntity.setPubCost(regRecipeYjsResVO.getHifpPay());
        orderEntity.setOwnCost(regRecipeYjsResVO.getPsnCashPay());
        orderEntity.setInsuSettlement(JSON.toJSONString((Object)regRecipeYjsResVO));
        this.orderMapper.updateById((Object)orderEntity);
        if (new BigDecimal(regRecipeYjsResVO.getPsnCashPay()).compareTo(new BigDecimal("0.00")) == 0) {
            PaymentResultsDTO dto = new PaymentResultsDTO();
            dto.setOrdSts("1");
            dto.setTsPayId(orderEntity.getDealSeq());
            this.payNotify(dto);
            PayOrderDTO data = new PayOrderDTO();
            data.setPayAmount(orderEntity.getPayAmount().toPlainString());
            data.setPayCost(orderEntity.getPayCost());
            data.setFundType(orderEntity.getFundType());
            data.setOwnCost(orderEntity.getOwnCost());
            data.setPubCost(orderEntity.getPubCost());
            return BaseResponse.success((Object)data);
        }
        PayOrderVO request = new PayOrderVO();
        if ((payCreateOrderVo.getPayChannel().equals(PayChannelEnum.WECHAT.getPayChannel()) || payCreateOrderVo.getPayChannel().equals(PayChannelEnum.ALIPAY.getPayChannel())) && payCreateOrderVo.getPayType().equals(WeChatPayTypeEnum.JSAPI.getDisplay())) {
            request.setOpenId(payCreateOrderVo.getUserSign());
        }
        request.setOrdNo(orderEntity.getOrderSeq());
        BigDecimal pay = new BigDecimal(regRecipeYjsResVO.getPsnCashPay());
        BigDecimal divide = pay.multiply(new BigDecimal(100));
        request.setAmt(Integer.valueOf(divide.intValue()));
        request.setDesc("\u5728\u7ebf\u95ee\u8bca\u5c0f\u7a0b\u5e8f\u4e0b\u5355");
        request.setNotifyUrl("http://10.7.0.142:9098/paymentPlatforms/payAsynchronousNotifications");
        request.setExpireSecond("");
        request.setBsOrdNo(orderEntity.getClinicCode());
        request.setCashierNo("");
        request.setCashierName("");
        request.setPatientId(orderEntity.getPatientId());
        request.setPatientName(patientEntity.getPatientName());
        request.setInvoiceNo("");
        request.setBusTye("1");
        request.setBusSubTye("1");
        request.setHospitalAreaTye("1");
        request.setPaySource("3");
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/paymentPlatforms/payment";
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673aul:{},\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u8fd4\u56de\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25");
            this.redisUtil.del(redisKey);
            throw new BusinessException("\u4e0b\u5355\u5931\u8d25");
        }
        BaseResponse payOrderResponse = (BaseResponse)JSON.parseObject((String)result, BaseResponse.class);
        if ("0".equals(payOrderResponse.getCode())) {
            log.error("\u8bf7\u6c42\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u5931\u8d25" + payOrderResponse.getMsg());
            this.redisUtil.del(redisKey);
            throw new BusinessException("\u8bf7\u6c42\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u5931\u8d25");
        }
        log.info(JSON.toJSONString((Object)payOrderResponse));
        PayOrderDTO data = (PayOrderDTO)JSON.parseObject((String)JSON.toJSONString((Object)payOrderResponse.getData()), PayOrderDTO.class);
        orderEntity.setDealSeq(data.getTsPayId());
        orderEntity.setFundType(payCreateOrderVo.getFundType());
        this.orderMapper.updateById((Object)orderEntity);
        this.redisUtil.del(redisKey);
        data.setPayAmount(orderEntity.getPayAmount().toPlainString());
        data.setPayCost(orderEntity.getPayCost());
        data.setFundType(orderEntity.getFundType());
        data.setOwnCost(orderEntity.getOwnCost());
        data.setPubCost(orderEntity.getPubCost());
        return BaseResponse.success((Object)data);
    }

    public BaseResponse payNotify(PaymentResultsDTO dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setDealSeq(dto.getTsPayId());
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return BaseResponse.error((String)"fail");
        }
        log.info("order:{}", (Object)JSON.toJSONString((Object)orderEntity));
        AdmissionEntity admissionEntity = (AdmissionEntity)this.update(dto, orderEntity).getData();
        if (admissionEntity == null) {
            return BaseResponse.error((String)"fail");
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success((Object)"success");
    }

    public BaseResponse<PaymentResultsDTO> paymentRefund(RequestPaymentRefundVO requestPaymentRefundVO) {
        PaymentRefundVO request = new PaymentRefundVO();
        request.setRefundOrdNo(requestPaymentRefundVO.getRefundOrdNo());
        request.setOrgPayOrdNo(requestPaymentRefundVO.getOrgPayOrdNo());
        BigDecimal divide = requestPaymentRefundVO.getAmt().multiply(new BigDecimal(100));
        log.info("\u8ba2\u5355\u539f\u652f\u4ed8\u91d1\u989d\uff1a{}(\u5143)\uff0c\u8f6c\u6362\u5206\u5355\u4f4d\u540e\u91d1\u989d\uff1a{}(\u5206)", (Object)requestPaymentRefundVO.getAmt(), (Object)divide.intValue());
        BigDecimal dividey = BigDecimal.valueOf(divide.intValue()).divide(new BigDecimal(100));
        if (requestPaymentRefundVO.getAmt().compareTo(dividey) != 0) {
            throw new BusinessException("\u91d1\u989d\u5f02\u5e38");
        }
        request.setAmt(Integer.valueOf(divide.intValue()));
        request.setDesc(requestPaymentRefundVO.getDesc());
        request.setNotifyUrl("http://10.7.0.142:9098/paymentPlatforms/refundAsynchronousNotification");
        request.setCashierNo("");
        request.setCashierName("");
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/paymentPlatforms/paymentRefund";
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673aurl:{},\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u8fd4\u56de\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25");
            throw new BusinessException("\u4e0b\u5355\u5931\u8d25");
        }
        return (BaseResponse)JSON.parseObject((String)result, BaseResponse.class);
    }

    public BaseResponse<PaymentResultsDTO> paymentResultInquiry(PaymentInquiryVO request) {
        OrderEntity orderEntity = this.orderMapper.findById(request.getOrdNo());
        request.setOrdNo(orderEntity.getOrderSeq());
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/paymentPlatforms/paymentResultInquiry";
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673aul:{},\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u8fd4\u56de\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25");
            throw new BusinessException("\u4e0b\u5355\u5931\u8d25");
        }
        BaseResponse payOrderResponse = (BaseResponse)JSON.parseObject((String)result, BaseResponse.class);
        log.info(JSON.toJSONString((Object)payOrderResponse));
        PaymentResultsDTO data = (PaymentResultsDTO)JSON.parseObject((String)JSON.toJSONString((Object)payOrderResponse.getData()), PaymentResultsDTO.class);
        if ("1".equals(data.getOrdSts()) && orderEntity.getStatus() == OrderStatusEnum.TOPAY.getValue()) {
            this.payNotify(data);
        }
        return payOrderResponse;
    }

    public BaseResponse sdyRefundCallbacks(PaymentRefundDTO param) {
        log.info("\u9000\u6b3e\u56de\u8c03\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)param));
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setOrderSeq(param.getOrgPayOrdNo());
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return BaseResponse.error((String)"fail");
        }
        log.info("order:{}" + JSON.toJSONString((Object)orderEntity));
        orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
        orderEntity.setRefundTime(new Date());
        this.orderMapper.updateOrderEntity(orderEntity);
        log.info("\u4fee\u6539order\u72b6\u6001");
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setRefundTime(new Date());
        servicePayBillEntity.setId(orderEntity.getBillRefundId());
        servicePayBillEntity.setRefundNo(param.getTsRefundId());
        servicePayBillEntity.setStatus(PayBillStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setTradeStatus("1".equals(param.getOrdSts()) ? "SUCCESS" : "");
        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
        log.info("\u4fee\u6539servicePayBill\u72b6\u6001");
        log.info("\u9000\u6b3e\u56de\u8c03\u6210\u529f:{}", (Object)"success");
        QueryWrapper adm = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrderId(orderEntity.getXId());
        adm.setEntity((Object)admissionEntity);
        AdmissionEntity entity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)adm);
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success((Object)"success");
    }

    public BaseResponse<AdmissionEntity> update(PaymentResultsDTO dto, OrderEntity orderInfo) {
        orderInfo.setStatus(OrderStatusEnum.PAID.getValue());
        Date payTime = new Date();
        orderInfo.setPaymentTime(payTime);
        orderInfo.setPayMethod(PayChannelEnum.WECHAT.getPayChannel());
        log.info("\u652f\u4ed8\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        this.baseInquiryOrderService.updateById((Object)orderInfo);
        ServicePayBillEntity servicePayBillEntity = (ServicePayBillEntity)this.servicePayBillMapper.selectById((Serializable)((Object)orderInfo.getBillPayId()));
        log.info("\u8d26\u5355\u4fe1\u606f\u4e3a:{}" + servicePayBillEntity.toString());
        servicePayBillEntity.setDealTradeNo(dto.getTsPayId());
        servicePayBillEntity.setTradeTime(payTime);
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setStatus(PayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setPayChannel(PayChannelEnum.WECHAT.getPayChannel());
        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderInfo.getXId());
        if (!AdmissionStatusEnum.CANCEL.getValue().equals(admissionEntity.getStatus())) {
            return BaseResponse.success((Object)admissionEntity);
        }
        admissionEntity.setServTime(orderInfo.getServTime());
        admissionEntity.setStartTime(payTime);
        admissionEntity.setTotalNum(orderInfo.getTotalNum());
        admissionEntity.setCurrentNum(orderInfo.getTotalNum());
        admissionEntity.setDoctorName(orderInfo.getDoctorName());
        if (null != orderInfo.getScheduleDate()) {
            admissionEntity.setScheduleDate(orderInfo.getScheduleDate());
            Date scheduleDate = orderInfo.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderInfo.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
            admissionEntity.setEndTime(expirationDateTime);
        } else {
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setConvertWaitTime(new Date());
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        }
        admissionEntity.setPauseTime(Long.valueOf(0L));
        admissionEntity.setOrganId(orderInfo.getHospitalId());
        log.info("\u652f\u4ed8\u56de\u8c03\u6dfb\u52a0\u5c31\u8bca\u8bb0\u5f55:{}", (Object)admissionEntity.toString());
        this.admissionMapper.updateById((Object)admissionEntity);
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
            this.payAsyncService.asyncTask(orderInfo, admissionEntity);
        } else if (AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admissionEntity.getStatus())) {
            this.imInformService.makeAnAppiontment(admissionEntity.getXId());
        }
        if (null != orderInfo.getScheduleDate()) {
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(orderInfo.getXId());
            log.info("\u5b9a\u65f6\u5904\u7406'\u5019\u8bca\u62a5\u9053\u63a5\u53e3'orderTaskVo3\uff1a{}", (Object)orderTaskVo3.toString());
            this.orderSender.sendDelay(orderTaskVo3);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(orderInfo.getXId());
            log.info("\u65e0\u6392\u73ed\u8ba2\u5355\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u8ba2\u5355\u5904\u7406 orderTaskVo2\uff1a{}", (Object)orderTaskVo2.toString());
            this.orderSender.sendDelay(orderTaskVo2);
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        return BaseResponse.success((Object)admissionEntity);
    }

    public BaseResponse<String> prescriptionbackSdy(MedicalNotifyReq medicalNotifyReq) {
        log.info("\u533b\u4fdd\u652f\u4ed8\u56de\u8c03\uff1a{}", (Object)JSON.toJSONString((Object)medicalNotifyReq));
        MedicalPayNotifyVo medicalPayNotifyVo = medicalNotifyReq.getData();
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setClinicCode(medicalPayNotifyVo.getMedOrgOrd());
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderInfo = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (orderInfo == null) {
            return BaseResponse.success((Object)"fail");
        }
        log.info("order:{}" + JSON.toJSONString((Object)orderInfo));
        orderInfo.setStatus(OrderStatusEnum.REFUNDED.getValue());
        orderInfo.setRefundTime(new Date());
        this.orderMapper.updateOrderEntity(orderInfo);
        log.info("\u4fee\u6539order\u72b6\u6001");
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setRefundTime(new Date());
        servicePayBillEntity.setId(orderInfo.getBillRefundId());
        servicePayBillEntity.setRefundNo(medicalNotifyReq.getData().getTtpPaySn());
        servicePayBillEntity.setStatus(PayBillStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
        log.info("\u4fee\u6539servicePayBill\u72b6\u6001");
        log.info("\u9000\u6b3e\u56de\u8c03\u6210\u529f:{}", (Object)"success");
        if ("1".equals(orderInfo.getRegLeve())) {
            RequestRefundVo vo = new RequestRefundVo();
            vo.setOrderId(orderInfo.getXId());
            this.payCallBackService.medicalRefynd(vo);
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success((Object)"success");
    }

    public BaseResponse<QueryLockedNumHospitalRepVO> payRefund(RefundDTO param) {
        log.info("\u63a5\u8bca\u540e\u9000\u53f7\u8fd4\u53c2:{}", (Object)JSON.toJSONString((Object)param));
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/appoint/register/payRefund";
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)param));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u63a5\u8bca\u540e\u9000\u53f7\u8fd4\u53c2:" + result);
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)result, FrontResponse.class);
        QueryLockedNumHospitalRepVO repVO = (QueryLockedNumHospitalRepVO)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), QueryLockedNumHospitalRepVO.class);
        if ("0".equals(repVO.getHeadVO().getHisReturnVO().getRetCode())) {
            log.error("\u9000\u53f7\u5931\u8d25\uff1a" + repVO.getHeadVO().getHisReturnVO().getRetCont());
            return BaseResponse.error((String)frontResponse.getMessage());
        }
        return BaseResponse.success();
    }

    public BaseResponse<RegRecipeYjsResVO> registerYjs(PayCreateOrderVo payCreateOrderVo, OrderEntity orderEntity, PatientEntity patientEntity) {
        RegRecipeYjsReqVO regRecipeYjsReqVO = new RegRecipeYjsReqVO();
        regRecipeYjsReqVO.setRegType("4");
        regRecipeYjsReqVO.setPid(patientEntity.getCardNo());
        regRecipeYjsReqVO.setCertNo(patientEntity.getIdcard());
        regRecipeYjsReqVO.setHospitalCode("pj");
        regRecipeYjsReqVO.setOrderNo(orderEntity.getClinicCode());
        regRecipeYjsReqVO.setResponseType(payCreateOrderVo.getFundType());
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/medicalOrder/register/regRecipeYjs";
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)regRecipeYjsReqVO));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if ("0".equals(frontResponse.getCode())) {
            log.error("\u6302\u53f7\u9884\u7ed3\u7b97\u5931\u8d25\uff1a" + frontResponse.getMessage());
            return BaseResponse.error((String)frontResponse.getMessage());
        }
        RegRecipeYjsResVO vo = (RegRecipeYjsResVO)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), RegRecipeYjsResVO.class);
        return BaseResponse.success((Object)vo);
    }

    static /* synthetic */ AliSmsPushService access$000(SdyPaymentPlatformsServiceImpl x0) {
        return x0.aliSmsPushService;
    }

    static /* synthetic */ SmallProgramPushService access$100(SdyPaymentPlatformsServiceImpl x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ AdmissionMapper access$300(SdyPaymentPlatformsServiceImpl x0) {
        return x0.admissionMapper;
    }
}

