/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PayCreateOrderVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.CallbackWhilePaySuccessManage;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.UnifiedPayMapper;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.UnifiedPay;
import com.ebaiyihui.onlineoutpatient.core.model.UnifiedPayBill;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.SdyPaymentPlatformsService;
import com.ebaiyihui.onlineoutpatient.core.service.UnifiedPayBillService;
import com.ebaiyihui.onlineoutpatient.core.service.UnifiedPayService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.SdyPaymentPlatformsServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.encodeSign.UnifiedPayUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.InsuSettlementReqDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.RefundStatusReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RegRecipeYjsResVO;
import com.ebaiyihui.onlineoutpatient.core.vo.SettleConfirmReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.SettleConfirmResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnifiedPayStatusReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnifiedPayStatusResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnifiedRefundReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnifiedRefundResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PaymentRefundDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PaymentResultsDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.RefundDTO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedPayServiceImpl
extends ServiceImpl<UnifiedPayMapper, UnifiedPay>
implements UnifiedPayService {
    private static final Logger log = LoggerFactory.getLogger(UnifiedPayServiceImpl.class);
    @Resource
    private UnifiedPayMapper unifiedPayMapper;
    @Autowired
    private SdyPaymentPlatformsServiceImpl sdyPaymentPlatformsServiceImpl;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private AliSmsPushService aliSmsPushService;
    private static final String SUCCESS = "1";
    @Resource
    private ProjProperties projProperties;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Resource
    private UnifiedPayBillService unifiedPayBillService;
    @Resource
    private CallbackWhilePaySuccessManage callbackWhilePaySuccessManage;
    @Resource
    private OrderMapper orderMapper;
    @Autowired
    PatientMapper patientMapper;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private SdyPaymentPlatformsService sdyPaymentPlatformsService;

    public BaseResponse<SettleConfirmResVo> settleConfirmPay(SettleConfirmReqVo settleConfirmVo) {
        try {
            UnifiedPay unifiedPay = this.unifiedPayMapper.getByOrganId(settleConfirmVo.getOrganId());
            if (Objects.isNull(unifiedPay)) {
                return BaseResponse.error((String)"\u5bf9\u63a5\u53c2\u6570\u4e3a\u7a7a");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            OrderEntity qorder = new OrderEntity();
            qorder.setDealSeq(settleConfirmVo.getOutTransId());
            queryWrapper.setEntity((Object)qorder);
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectOne((Wrapper)queryWrapper);
            PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
            PayCreateOrderVo payCreateOrderVo = new PayCreateOrderVo();
            payCreateOrderVo.setFundType(SUCCESS);
            BaseResponse resVOBaseResponse = this.sdyPaymentPlatformsServiceImpl.registerYjs(payCreateOrderVo, orderEntity, patientEntity);
            if (!resVOBaseResponse.isSuccess()) {
                return BaseResponse.error((String)"\u6302\u53f7\u9884\u7ed3\u7b97\u5931\u8d25");
            }
            RegRecipeYjsResVO regRecipeYjsResVO = (RegRecipeYjsResVO)resVOBaseResponse.getData();
            orderEntity.setPayCost(regRecipeYjsResVO.getAcctPay());
            orderEntity.setPubCost(regRecipeYjsResVO.getHifpPay());
            orderEntity.setOwnCost(regRecipeYjsResVO.getPsnCashPay());
            orderEntity.setInsuSettlement(JSON.toJSONString((Object)regRecipeYjsResVO));
            this.orderMapper.updateById((Object)orderEntity);
            settleConfirmVo.setAmount(new BigDecimal(regRecipeYjsResVO.getPsnCashPay()).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString());
            if (new BigDecimal(regRecipeYjsResVO.getPsnCashPay()).compareTo(new BigDecimal("0.00")) == 0) {
                PaymentResultsDTO dto = new PaymentResultsDTO();
                dto.setOrdSts(SUCCESS);
                dto.setTsPayId(orderEntity.getDealSeq());
                this.sdyPaymentPlatformsServiceImpl.payNotify(dto);
                return BaseResponse.success(null);
            }
            settleConfirmVo.setNotifyUrl(this.projProperties.getUnifiedCallBackAddr());
            BeanUtils.copyProperties((Object)unifiedPay, (Object)settleConfirmVo);
            log.info("\u52a0\u5bc6\u524dsettleConfirmVo= {}", (Object)JSONObject.toJSONString((Object)settleConfirmVo));
            settleConfirmVo.setOrganId(null);
            String reqParam = UnifiedPayUtils.encodeAndSignData((Object)settleConfirmVo, (String)unifiedPay.getDesKey(), (String)unifiedPay.getPrivateKey(), (String)unifiedPay.getBusinessId());
            log.info("\u652f\u4ed8\u6536\u94f6\u53f0\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqParam);
            String url = this.projProperties.getUnifiedPayDomain() + "/regionalpay/pay/v1/checkoutCounter";
            log.info("\u652f\u4ed8\u6536\u94f6\u53f0\u8bf7\u6c42\u5730\u5740url={}", (Object)url);
            String response = HttpKit.jsonPost((String)url, (String)reqParam);
            log.info("\u8bf7\u6c425.2.4\u652f\u4ed8\u6536\u94f6\u53f0\u8fd4\u56de\u54cd\u5e94response={}", (Object)response);
            String result = UnifiedPayUtils.decodeAndSignData((String)response, (String)unifiedPay.getRsaKey(), (String)unifiedPay.getDesKey());
            log.info("5.2.4\u89e3\u5bc6\u8fd4\u56de\u503cresult= {}", (Object)result);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String code = resultJson.get((Object)"code").toString();
            String msg = resultJson.get((Object)"msg").toString();
            if (code.equals("00")) {
                SettleConfirmResVo settleConfirmResVo1 = (SettleConfirmResVo)JSON.parseObject((String)result, SettleConfirmResVo.class);
                orderEntity.setFundType("4");
                this.orderMapper.updateById((Object)orderEntity);
                return BaseResponse.success((Object)settleConfirmResVo1);
            }
            return BaseResponse.error((String)msg);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u6536\u94f6\u53f0\u62a5\u9519", (Throwable)e);
            return null;
        }
    }

    public String payCallback(String param) {
        log.info("5.2.5\u7ed3\u7b97\u6210\u529f\u901a\u77e5====\u5165\u53c2{}", (Object)param);
        String businessId = JSONObject.parseObject((String)param).get((Object)"businessId").toString();
        UnifiedPay unifiedPay = (UnifiedPay)this.unifiedPayMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"business_id", (Object)businessId));
        if (Objects.isNull(unifiedPay)) {
            return null;
        }
        String result = UnifiedPayUtils.decodeAndSignData((String)param, (String)unifiedPay.getRsaKey(), (String)unifiedPay.getDesKey());
        log.info("\u5165\u53c2\u89e3\u5bc6result= {}", (Object)result);
        JSONObject paramJson = JSONObject.parseObject((String)result);
        String merId = paramJson.get((Object)"merId").toString();
        String outTransId = paramJson.get((Object)"outTransId").toString();
        String productId = paramJson.get((Object)"productId").toString();
        String transCode = paramJson.get((Object)"transCode").toString();
        this.handleDecodeResponse(unifiedPay, merId, productId, result, Integer.valueOf(1));
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("businessId", businessId);
        resMap.put("merId", merId);
        resMap.put("outTransId", outTransId);
        resMap.put("productId", productId);
        resMap.put("transCode", transCode);
        resMap.put("code", "00");
        return UnifiedPayUtils.responseStr((String)JSONObject.toJSONString(resMap), (String)businessId, (String)unifiedPay.getDesKey(), (String)unifiedPay.getPrivateKey());
    }

    public BaseResponse<UnifiedPayStatusResVo> getPayStatus(UnifiedPayStatusReqVo unifiedPayStatusReqVo) {
        UnifiedPay unifiedPay = this.unifiedPayMapper.getByOrganId(unifiedPayStatusReqVo.getOrganId());
        String bussinessId = unifiedPay.getBusinessId();
        String merId = unifiedPay.getMerId();
        String productId = unifiedPay.getProductId();
        unifiedPayStatusReqVo.setBusinessId(bussinessId);
        unifiedPayStatusReqVo.setMerId(merId);
        unifiedPayStatusReqVo.setProductId(productId);
        unifiedPayStatusReqVo.setOrganId(null);
        String param = UnifiedPayUtils.encodeAndSignData((Object)unifiedPayStatusReqVo, (String)unifiedPay.getDesKey(), (String)unifiedPay.getPrivateKey(), (String)bussinessId);
        String url = this.projProperties.getUnifiedPayDomain() + "/regionalpay/pay/v1/queryPayOrderDetail";
        log.info("\u8bf7\u6c425.2.6\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3======url= {},\u53c2\u6570= {}", (Object)url, (Object)param);
        try {
            String response = HttpKit.jsonPost((String)url, (String)param);
            log.info("\u8bf7\u6c425.2.6\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u54cd\u5e94response= {}", (Object)response);
            String result = UnifiedPayUtils.decodeAndSignData((String)response, (String)unifiedPay.getRsaKey(), (String)unifiedPay.getDesKey());
            log.info("5.2.6\u89e3\u5bc6\u540eresult= {}", (Object)result);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String code = resultJson.get((Object)"code").toString();
            if (code.equals("00")) {
                return BaseResponse.success((Object)JSON.parseObject((String)result, UnifiedPayStatusResVo.class));
            }
            return BaseResponse.error((String)resultJson.get((Object)"msg").toString());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c425.2.6\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private UnifiedPayBill handleDecodeResponse(UnifiedPay unifiedPay, String merId, String productId, String result, Integer flag) {
        JSONObject paramJson = JSONObject.parseObject((String)result);
        JSONObject busiDataJson = JSONObject.parseObject((String)paramJson.get((Object)"busiData").toString());
        String finalPayTime = busiDataJson.get((Object)"finalPayTime").toString();
        String orderDetailList = busiDataJson.get((Object)"orderDetailList").toString();
        String payNo = busiDataJson.get((Object)"payNo").toString();
        String status = busiDataJson.get((Object)"status").toString();
        String totalAmount = busiDataJson.get((Object)"totalAmount").toString();
        String outTransId = paramJson.get((Object)"outTransId").toString();
        String transCode = paramJson.get((Object)"transCode").toString();
        UnifiedPayBill unifiedPayBill = new UnifiedPayBill();
        unifiedPayBill.setFinalPayTime(finalPayTime);
        unifiedPayBill.setOrderDetailList(orderDetailList);
        unifiedPayBill.setPayNo(payNo);
        unifiedPayBill.setStatus(status);
        unifiedPayBill.setTotalAmout(totalAmount);
        unifiedPayBill.setBusinessId(unifiedPay.getBusinessId());
        unifiedPayBill.setMerId(merId);
        unifiedPayBill.setOutTransId(outTransId);
        unifiedPayBill.setProductId(productId);
        unifiedPayBill.setTransCode(transCode);
        if (flag == 1) {
            PaymentResultsDTO paymentResultsDTO = new PaymentResultsDTO();
            paymentResultsDTO.setOrdSts(status);
            paymentResultsDTO.setTsPayId(outTransId);
            BaseResponse payOrderDTOBaseResponse = this.sdyPaymentPlatformsService.payNotify(paymentResultsDTO);
            log.info("\u8ba2\u5355\u5904\u7406\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)payOrderDTOBaseResponse));
        } else {
            String originalOutTransId = paramJson.get((Object)"originalOutTransId").toString();
            PaymentRefundDTO param = new PaymentRefundDTO();
            param.setOrdSts(String.valueOf(busiDataJson.get((Object)"status").toString().equals("4") ? 1 : 0));
            param.setTsPayId(originalOutTransId);
            param.setOrgPayOrdNo(busiDataJson.get((Object)"orginalPayNo").toString());
            param.setTsRefundId(paramJson.get((Object)"outTransId").toString());
            BaseResponse baseResponse = this.sdyPaymentPlatformsService.sdyRefundCallbacks(param);
            log.info("\u8ba2\u5355\u5904\u7406\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)baseResponse));
        }
        UnifiedPayBill unifiedPayBill1 = (UnifiedPayBill)this.unifiedPayBillService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"out_trans_id", (Object)outTransId)).eq((Object)"pay_no", (Object)payNo)).eq((Object)"status", (Object)status));
        if (!Objects.isNull(unifiedPayBill1)) {
            unifiedPayBill.setId(unifiedPayBill1.getId());
        }
        this.unifiedPayBillService.saveOrUpdate((Object)unifiedPayBill);
        log.info("\u7edf\u4e00\u652f\u4ed8\u4fdd\u5b58\u8d26\u5355\u6210\u529f");
        return unifiedPayBill;
    }

    public BaseResponse<UnifiedRefundResVo> refund(UnifiedRefundReqVo unifiedRefundReqVo) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            OrderEntity wrapperEntity = new OrderEntity();
            wrapperEntity.setXId(unifiedRefundReqVo.getOriginalOutTransId());
            queryWrapper.setEntity((Object)wrapperEntity);
            queryWrapper.last("limit 1");
            OrderEntity order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
            if (null == order) {
                return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            log.info("order:{}", (Object)JSONObject.toJSONString((Object)order));
            unifiedRefundReqVo.setOriginalOutTransId(order.getDealSeq());
            if (order.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) || order.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY.getValue()) || order.getStatus().equals(AdmissionStatusEnum.FINISH_TIME_OUT.getValue()) || order.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue()) || order.getStatus().equals(AdmissionStatusEnum.REFERRAL.getValue()) || order.getStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER.getValue()) || order.getStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue())) {
                BaseResponse queryLockedNumHospitalRepVOBaseResponse;
                RefundDTO param = new RefundDTO();
                param.setMedOrgOrd(order.getClinicCode());
                param.setTotlRefdAmt(String.valueOf(order.getPayAmount()));
                if (order.getFundType().equals("3") || order.getFundType().equals("9")) {
                    String insuStr = order.getInsuSettlement();
                    InsuSettlementReqDTO insuSettlementReqDTO = (InsuSettlementReqDTO)JSON.parseObject((String)insuStr, InsuSettlementReqDTO.class);
                    param.setInsuSettlement(insuSettlementReqDTO);
                }
                if (!(queryLockedNumHospitalRepVOBaseResponse = this.sdyPaymentPlatformsService.payRefund(param)).isSuccess()) {
                    return BaseResponse.error((String)queryLockedNumHospitalRepVOBaseResponse.getMsg());
                }
            }
            log.info("\u7edf\u4e00\u652f\u4ed8\u9000\u6b3e\u5165\u53c2unifiedRefundReqVo= {}", (Object)JSONObject.toJSONString((Object)unifiedRefundReqVo));
            UnifiedPay unifiedPay = this.unifiedPayMapper.getByOrganId(unifiedRefundReqVo.getOrganId());
            if (Objects.isNull(unifiedPay)) {
                return BaseResponse.error((String)"\u5bf9\u63a5\u53c2\u6570\u4e3a\u7a7a");
            }
            unifiedRefundReqVo.setOrganId(null);
            BeanUtils.copyProperties((Object)unifiedPay, (Object)unifiedRefundReqVo);
            unifiedRefundReqVo.setTransCode("P00007");
            unifiedRefundReqVo.setOutTransDate(DateUtils.getCurrentDateToString());
            String param = UnifiedPayUtils.encodeAndSignData((Object)unifiedRefundReqVo, (String)unifiedPay.getDesKey(), (String)unifiedPay.getPrivateKey(), (String)unifiedPay.getBusinessId());
            String url = this.projProperties.getUnifiedPayDomain() + "/regionalpay/pay/v1/refund";
            log.info("\u8bf7\u6c425.2.7\u9000\u8d39\u63a5\u53e3===url= {},\u5165\u53c2param= {}", (Object)url, (Object)param);
            String response = HttpKit.jsonPost((String)url, (String)param);
            log.info("\u8bf7\u6c425.2.7\u9000\u8d39\u63a5\u53e3\u8fd4\u56deresponse= {}", (Object)response);
            String result = UnifiedPayUtils.decodeAndSignData((String)response, (String)unifiedPay.getRsaKey(), (String)unifiedPay.getDesKey());
            log.info("response\u89e3\u5bc6\u540e= {}", (Object)result);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String code = resultJson.get((Object)"code").toString();
            if (code.equals("00")) {
                JSONObject paramJson = JSONObject.parseObject((String)result);
                String merId = paramJson.get((Object)"merId").toString();
                String productId = paramJson.get((Object)"productId").toString();
                this.handleDecodeResponse(unifiedPay, merId, productId, result, Integer.valueOf(2));
                UnifiedRefundResVo unifiedRefundResVo = (UnifiedRefundResVo)JSON.parseObject((String)result, UnifiedRefundResVo.class);
                this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                return BaseResponse.success((Object)unifiedRefundResVo);
            }
            return BaseResponse.error((String)resultJson.get((Object)"msg").toString());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9000\u8d39\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public BaseResponse<UnifiedPayStatusResVo> getRefundStatus(RefundStatusReqVo refundStatusReqVo) {
        UnifiedPay unifiedPay = this.unifiedPayMapper.getByOrganId(refundStatusReqVo.getOrganId());
        BeanUtils.copyProperties((Object)unifiedPay, (Object)refundStatusReqVo);
        refundStatusReqVo.setTransCode("P00008");
        refundStatusReqVo.setOrganId(null);
        log.info("5.2.8\u63a5\u53e3\u660e\u6587\u5165\u53c2refundStatusReqVo= {}", (Object)JSONObject.toJSONString((Object)refundStatusReqVo));
        String url = this.projProperties.getUnifiedPayDomain() + "/regionalpay/pay/v1/queryRefundOrderDetail";
        String param = UnifiedPayUtils.encodeAndSignData((Object)refundStatusReqVo, (String)unifiedPay.getDesKey(), (String)unifiedPay.getPrivateKey(), (String)unifiedPay.getBusinessId());
        try {
            log.info("\u8bf7\u6c425.2.8\u67e5\u8be2\u9000\u8d39\u72b6\u6001\u63a5\u53e3\u5165\u53c2,url= {},param= {}", (Object)url, (Object)param);
            String response = HttpKit.jsonPost((String)url, (String)param);
            log.info("5.2.8\u67e5\u8be2\u9000\u8d39\u72b6\u6001\u63a5\u53e3\u8fd4\u56deresponse= {}", (Object)response);
            String result = UnifiedPayUtils.decodeAndSignData((String)response, (String)unifiedPay.getRsaKey(), (String)unifiedPay.getDesKey());
            log.info("\u89e3\u5bc6result = {}", (Object)result);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String code = resultJson.get((Object)"code").toString();
            if (code.equals("00")) {
                UnifiedPayStatusResVo unifiedPayStatusResVo = (UnifiedPayStatusResVo)JSON.parseObject((String)result, UnifiedPayStatusResVo.class);
                return BaseResponse.success((Object)unifiedPayStatusResVo);
            }
            return BaseResponse.error((String)resultJson.get((Object)"msg").toString());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9000\u8d39\u72b6\u6001\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public BaseResponse<String> sendWechatTemplateMessage() {
        return null;
    }

    static /* synthetic */ AdmissionMapper access$000(UnifiedPayServiceImpl x0) {
        return x0.admissionMapper;
    }

    static /* synthetic */ AliSmsPushService access$100(UnifiedPayServiceImpl x0) {
        return x0.aliSmsPushService;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

