/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayCommerceMedicalIndustrydataInquirydoctorUploadModel;
import com.alipay.api.domain.AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadModel;
import com.alipay.api.domain.AlipayCommerceMedicalIndustrydataInquiryorderUploadModel;
import com.alipay.api.domain.InqueryDoctorData;
import com.alipay.api.domain.InqueryDoctorStatusData;
import com.alipay.api.request.AlipayCommerceMedicalIndustrydataInquirydoctorUploadRequest;
import com.alipay.api.request.AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadRequest;
import com.alipay.api.request.AlipayCommerceMedicalIndustrydataInquiryorderUploadRequest;
import com.alipay.api.response.AlipayCommerceMedicalIndustrydataInquirydoctorUploadResponse;
import com.alipay.api.response.AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadResponse;
import com.alipay.api.response.AlipayCommerceMedicalIndustrydataInquiryorderUploadResponse;
import com.ebaiyihui.onlineoutpatient.core.common.config.AliMedicalPushConfig;
import com.ebaiyihui.onlineoutpatient.core.service.manager.AliMedicalPushService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliMedicalPushServiceImpl
implements AliMedicalPushService {
    private static final Logger log = LoggerFactory.getLogger(AliMedicalPushServiceImpl.class);
    @Autowired
    private AliMedicalPushConfig aliMedicalPushConfig;
    static AlipayClient alipayClient;
    private static final String KEY = "ws_service_url";
    private static final String VALUE = "iblib-229.gz00b.dev.alipay.net:12200";
    private static final String Order_VALUE = "isasp-1066.rz01b.dev.alipay.net:12200";

    private AlipayClient getalipayClient() {
        alipayClient = new DefaultAlipayClient(this.aliMedicalPushConfig.getServerUrl(), this.aliMedicalPushConfig.getAppId(), this.aliMedicalPushConfig.getAppPrivateKey(), this.aliMedicalPushConfig.getFormat(), this.aliMedicalPushConfig.getCharset(), this.aliMedicalPushConfig.getAlipayPublicKey(), this.aliMedicalPushConfig.getSignType());
        return alipayClient;
    }

    public AlipayCommerceMedicalIndustrydataInquirydoctorUploadResponse doctorUpload(List<InqueryDoctorData> doctorList, String outRequestNo) {
        try {
            AlipayClient alipayClient = this.getalipayClient();
            AlipayCommerceMedicalIndustrydataInquirydoctorUploadRequest request = this.doctorUploadRequest(doctorList, outRequestNo);
            return (AlipayCommerceMedicalIndustrydataInquirydoctorUploadResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            log.info("\u533b\u751f\u4e0a\u4f20\u8c03\u7528\u906d\u9047\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadResponse doctorStatusUpload(List<InqueryDoctorStatusData> doctorStatusList) {
        try {
            AlipayClient alipayClient = this.getalipayClient();
            AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadRequest request = this.doctorStatusUploadRequest(doctorStatusList);
            return (AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            log.info("\u533b\u751f\u72b6\u6001\u4e0a\u4f20\u8c03\u7528\u906d\u9047\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public AlipayCommerceMedicalIndustrydataInquiryorderUploadResponse orderUpload(AlipayCommerceMedicalIndustrydataInquiryorderUploadModel order) {
        try {
            AlipayClient alipayClient = this.getalipayClient();
            AlipayCommerceMedicalIndustrydataInquiryorderUploadRequest request = this.orderUploadRequest(order);
            return (AlipayCommerceMedicalIndustrydataInquiryorderUploadResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            log.info("\u8ba2\u5355\u4e0a\u4f20\u8c03\u7528\u906d\u9047\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private AlipayCommerceMedicalIndustrydataInquirydoctorUploadRequest doctorUploadRequest(List<InqueryDoctorData> doctorList, String outRequestNo) {
        AlipayCommerceMedicalIndustrydataInquirydoctorUploadRequest request = new AlipayCommerceMedicalIndustrydataInquirydoctorUploadRequest();
        AlipayCommerceMedicalIndustrydataInquirydoctorUploadModel model = new AlipayCommerceMedicalIndustrydataInquirydoctorUploadModel();
        model.setDoctorList(doctorList);
        model.setOutRequestNo(outRequestNo);
        model.setPlatformCode(this.aliMedicalPushConfig.getPlatformCode());
        request.setBizModel((AlipayObject)model);
        return request;
    }

    private AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadRequest doctorStatusUploadRequest(List<InqueryDoctorStatusData> doctorStatusList) {
        AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadRequest request = new AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadRequest();
        AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadModel model = new AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadModel();
        model.setDoctorStatusList(doctorStatusList);
        model.setPlatformCode(this.aliMedicalPushConfig.getPlatformCode());
        request.setBizModel((AlipayObject)model);
        return request;
    }

    private AlipayCommerceMedicalIndustrydataInquiryorderUploadRequest orderUploadRequest(AlipayCommerceMedicalIndustrydataInquiryorderUploadModel order) {
        AlipayCommerceMedicalIndustrydataInquiryorderUploadRequest request = new AlipayCommerceMedicalIndustrydataInquiryorderUploadRequest();
        AlipayCommerceMedicalIndustrydataInquiryorderUploadModel model = new AlipayCommerceMedicalIndustrydataInquiryorderUploadModel();
        BeanUtils.copyProperties((Object)order, (Object)model);
        model.setPlatformCode(this.aliMedicalPushConfig.getPlatformCode());
        request.setBizContent(JSONObject.toJSONString((Object)model));
        return request;
    }
}

