/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.nczk.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.CheckIdCardReqVO;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.card.common.vo.RegisterCardReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ZkPatPreOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryServiceConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ICDEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MedicalAdmissionRefEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionService;
import com.ebaiyihui.onlineoutpatient.core.service.GoEasyPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ImAccountService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.client.CheckInfoFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.ImApiFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.nczk.ZkFastBuyDrugService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugReqDto;
import com.ebaiyihui.onlineoutpatient.core.vo.ICDSearchVo.ICDSearchNameReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.dto.FastCreateOrderDto;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.dto.QueryPatOrderListDto;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.FastCreateOrderReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.MedicalDetailVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.MyPage;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.QueryPatOrderDetailResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.QueryPatOrderListReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.QueryPatOrderListResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.UpdatePreStatusReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZKfbImInfoResVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.SavePatientDynamicMedicalReqVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ZkFastBuyDrugServiceImpl
implements ZkFastBuyDrugService {
    private static final Logger log = LoggerFactory.getLogger(ZkFastBuyDrugServiceImpl.class);
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private CheckInfoFeignClient checkInfoFeignClient;
    @Autowired
    private ImAccountService imAccountService;
    @Autowired
    private ImApiFeignClient imApiFeignClient;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private ICDMapper icdMapper;
    @Autowired
    private GoEasyPushService goEasyPushService;
    @Autowired
    private CardServiceApi cardServiceFeignClient;
    @Autowired
    private IMInformService iMInformService;
    @Autowired
    private AdmissionService admissionService;
    @Autowired
    private InquiryServiceConfigMapper inquiryServiceConfigMapper;
    @Autowired
    private ProjProperties projProperties;
    private static final String ORGAN_CODE = "NCZK";
    public static final String ORGAN_NAME = "\u5357\u660c\u4f17\u5eb7\u533b\u9662";
    public static final Integer H5 = 2;
    public static final Integer SMALLPROGRAM = 3;

    public BaseResponse<String> creatOrderV1(FastCreateOrderReqVo param) {
        String patientId = "zkfb_" + param.getIdCard();
        String orderId = UUIDUtil.generateViewId();
        String admId = UUIDUtil.getUUID();
        String patientUserId = orderId + "_temp";
        FastCreateOrderDto fastCreateOrderDto = new FastCreateOrderDto();
        BeanUtils.copyProperties((Object)param, (Object)fastCreateOrderDto);
        fastCreateOrderDto.setPatientId(patientId);
        fastCreateOrderDto.setOrderId(orderId);
        fastCreateOrderDto.setAdmId(admId);
        fastCreateOrderDto.setUserId(patientUserId);
        fastCreateOrderDto.setCardNo(param.getIdCard());
        fastCreateOrderDto.setType(H5);
        this.createOrder(fastCreateOrderDto);
        return BaseResponse.success((Object)admId);
    }

    public BaseResponse<String> createOrderV2(FastCreateOrderReqVo param) {
        BaseResponse verifyResponse = this.checkInfoFeignClient.verify(param.getIdCard(), param.getName());
        log.info("\u6821\u9a8c\u7ed3\u679c:{}", (Object)verifyResponse);
        if (!Objects.equals(((CheckIdCardReqVO)verifyResponse.getData()).getMsg(), "\u5339\u914d")) {
            return BaseResponse.error((String)((CheckIdCardReqVO)verifyResponse.getData()).getMsg());
        }
        RegisterCardReqVO registerCardReqVO = new RegisterCardReqVO();
        registerCardReqVO.setAppCode(ORGAN_CODE);
        registerCardReqVO.setChannelCode("PATIENT_WX");
        registerCardReqVO.setChannelName("PATIENT_WX");
        registerCardReqVO.setPatientName(param.getName());
        registerCardReqVO.setCredNo(param.getIdCard());
        registerCardReqVO.setCredTypeCode("01");
        registerCardReqVO.setCredTypeName("\u5c45\u6c11\u8eab\u4efd\u8bc1");
        registerCardReqVO.setCardTypeCode("1703");
        registerCardReqVO.setCardTypeName("\u865a\u62df\u5c31\u8bca\u5361");
        registerCardReqVO.setOrganCode(this.projProperties.getZkOrganId());
        registerCardReqVO.setOrganName(ORGAN_NAME);
        registerCardReqVO.setTel(param.getTelphone());
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u8bf7\u6c42:{}", (Object)registerCardReqVO);
        BaseResponse response = this.cardServiceFeignClient.registerOrBindCard(registerCardReqVO);
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u7ed3\u679c:{}", (Object)response);
        if (!response.isSuccess() || StringUtils.isEmpty((Object)response)) {
            return BaseResponse.error((String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5931\u8d25");
        }
        CardDetailsInfoRespVO data = (CardDetailsInfoRespVO)response.getData();
        String patientId = data.getPatientId();
        String orderId = UUIDUtil.generateViewId();
        String admId = UUIDUtil.getUUID();
        String patientUserId = param.getUserId();
        FastCreateOrderDto fastCreateOrderDto = new FastCreateOrderDto();
        BeanUtils.copyProperties((Object)param, (Object)fastCreateOrderDto);
        fastCreateOrderDto.setPatientId(patientId);
        fastCreateOrderDto.setOrderId(orderId);
        fastCreateOrderDto.setAdmId(admId);
        fastCreateOrderDto.setUserId(patientUserId);
        fastCreateOrderDto.setCardNo(data.getCardNo());
        fastCreateOrderDto.setType(SMALLPROGRAM);
        this.createOrder(fastCreateOrderDto);
        return BaseResponse.success((Object)admId);
    }

    public BaseResponse<String> updatePreStatus(UpdatePreStatusReqVo param) {
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)param.getAdmId()));
        if (Objects.isNull(medicalAdmissionRefEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u4e0b\u5355\u8bb0\u5f55");
        }
        medicalAdmissionRefEntity.setPreStatus(param.getStatus());
        medicalAdmissionRefEntity.setMainId(param.getMainId());
        medicalAdmissionRefEntity.setRemark(param.getVerifyRemark());
        this.medicalAdmissionRefMapper.updateById((Object)medicalAdmissionRefEntity);
        if (Objects.equals(param.getStatus(), ZkPatPreOrderStatusEnum.FINISH_PRE.getValue())) {
            this.admissionMapper.updateStatusByAdmId(param.getAdmId(), AdmissionStatusEnum.FINISH_APPLY.getValue());
            this.iMInformService.zkFastPreSuccessPat(param.getAdmId());
        }
        return BaseResponse.success();
    }

    public BaseResponse<MyPage<QueryPatOrderListResVo>> queryPatOrderList(QueryPatOrderListReqVo param) {
        IPage pages = this.medicalAdmissionRefMapper.queryAdmByUserIdPage((IPage)new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue()), param.getUserId(), param.getPreStatus(), param.getSearchParam());
        long total = pages.getTotal();
        List records = pages.getRecords();
        ArrayList resVos = new ArrayList();
        records.forEach(item -> {
            QueryPatOrderListResVo queryPatOrderListResVo = new QueryPatOrderListResVo();
            BeanUtils.copyProperties((Object)item, (Object)queryPatOrderListResVo);
            List drugReqDtos = JSON.parseArray((String)item.getDrug(), DrugReqDto.class);
            String drug = String.format("\u542b%s\u7b49%d\u79cd\u836f\u54c1", ((DrugReqDto)drugReqDtos.get(0)).getDrugName(), drugReqDtos.size());
            Integer age = IDCardUtil.getAge((String)item.getPatientIdCard());
            String sex = IDCardUtil.getGender((String)item.getPatientIdCard());
            queryPatOrderListResVo.setPatientAge(String.valueOf(age));
            queryPatOrderListResVo.setPatientSex(sex);
            queryPatOrderListResVo.setDrug(drug);
            resVos.add(queryPatOrderListResVo);
        });
        MyPage myPage = new MyPage();
        myPage.setTotal(total);
        myPage.setList(resVos);
        return BaseResponse.success((Object)myPage);
    }

    public BaseResponse<QueryPatOrderDetailResVo> queryPatOrderDetail(String admId) {
        QueryPatOrderDetailResVo queryPatOrderDetailResVo = new QueryPatOrderDetailResVo();
        QueryPatOrderListDto queryPatOrderListDto = this.medicalAdmissionRefMapper.queryAdmByAdmId(admId);
        Integer age = IDCardUtil.getAge((String)queryPatOrderListDto.getPatientIdCard());
        String sex = IDCardUtil.getGender((String)queryPatOrderListDto.getPatientIdCard());
        List drugReqDtos = JSON.parseArray((String)queryPatOrderListDto.getDrug(), DrugReqDto.class);
        IMQueryUserLoginReqVO reqVO = new IMQueryUserLoginReqVO();
        IMQueryTargetSdkAccountRspVO docImAccount = this.imAccountService.queryImAccount(admId, "EHOS_DOCTOR", queryPatOrderListDto.getDoctorId());
        IMQueryTargetSdkAccountRspVO patImAccount = this.imAccountService.queryImAccount(admId, "EHOS_PATIENT", queryPatOrderListDto.getDoctorId());
        reqVO.setAppCode("EHOS_PATIENT");
        reqVO.setUserId(queryPatOrderListDto.getUserId());
        BaseResponse imSysResult = this.imApiFeignClient.queryUserLogin(reqVO);
        ZKfbImInfoResVo imInfo = ZKfbImInfoResVo.builder().docImAccount(docImAccount.getSdkAccount()).patImAccount(patImAccount.getSdkAccount()).roomNum(Long.valueOf(docImAccount.getRoomNum())).sig(((IMQueryUserLoginRspVO)imSysResult.getData()).getSig()).build();
        boolean isrefund = Objects.equals(ZkPatPreOrderStatusEnum.REFUND_PRE.getValue(), queryPatOrderListDto.getPreStatus());
        String remark = "";
        remark = isrefund && !StringUtils.isEmpty((Object)queryPatOrderListDto.getRemark()) ? queryPatOrderListDto.getRemark() : ZkPatPreOrderStatusEnum.getRemarkByValue((String)queryPatOrderListDto.getPreStatus());
        queryPatOrderDetailResVo.setAdmId(admId).setPatientName(queryPatOrderListDto.getPatientName()).setPatientAge(String.valueOf(age)).setPatientSex(sex).setDiagnosis(queryPatOrderListDto.getDiagnosis()).setPreStatus(queryPatOrderListDto.getPreStatus()).setMainId(queryPatOrderListDto.getMainId()).setDrugs(drugReqDtos).setImInfo(imInfo).setRemark(remark);
        return BaseResponse.success((Object)queryPatOrderDetailResVo);
    }

    public BaseResponse<FastCreateOrderReqVo> queryOrderRecord(String admId) {
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)admId));
        List drugs = JSON.parseArray((String)medicalAdmissionRefEntity.getDrugs(), DrugReqDto.class);
        FastCreateOrderReqVo fastCreateOrderReqVo = new FastCreateOrderReqVo();
        fastCreateOrderReqVo.setDrugs(drugs);
        fastCreateOrderReqVo.setStoreCode(medicalAdmissionRefEntity.getStoreCode());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectById((Serializable)((Object)admId));
        PatientEntity patientEntity = this.patientMapper.selectById(admissionEntity.getPatientId());
        fastCreateOrderReqVo.setName(patientEntity.getPatientName());
        fastCreateOrderReqVo.setIdCard(patientEntity.getIdcard());
        fastCreateOrderReqVo.setTelphone(patientEntity.getTelphone());
        PatientMedicalRecordEntity patientMedicalRecord = this.patientMedicalRecordMapper.findById(admissionEntity.getMedicalRecordId());
        fastCreateOrderReqVo.setDiagnosis(patientMedicalRecord.getTags());
        return BaseResponse.success((Object)fastCreateOrderReqVo);
    }

    private void createOrder(FastCreateOrderDto dto) {
        ScheduleRecordEntity scheduleRecordEntity = this.findScheDoctor(dto.getPatientId(), dto.getType());
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.inquiryServiceConfigMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(InquiryServiceConfigEntity::getDoctorId, (Object)scheduleRecordEntity.getDoctorId())).eq(InquiryServiceConfigEntity::getDeptId, (Object)scheduleRecordEntity.getDeptId())).eq(InquiryServiceConfigEntity::getOrganId, (Object)scheduleRecordEntity.getHospitalId())).eq(InquiryServiceConfigEntity::getServiceCode, (Object)ServiceTypeEnum.NOS.getCode())).eq(InquiryServiceConfigEntity::getStatus, (Object)WhetherEnum.ALLOW.getValue()));
        String medicalId = this.insertMedical(dto, dto.getPatientId());
        PatientEntity patientEntity = this.patientMapper.selectById(dto.getPatientId());
        if (Objects.isNull(patientEntity)) {
            PatientEntity patientEntity1 = new PatientEntity();
            patientEntity1.setXId(dto.getPatientId());
            patientEntity1.setAccountPhone(dto.getTelphone());
            patientEntity1.setPatientType(CommonConstants.PATIENT_TYPE);
            patientEntity1.setIdcard(dto.getIdCard());
            patientEntity1.setCardNo(dto.getCardNo());
            patientEntity1.setTelphone(dto.getTelphone());
            patientEntity1.setGender(Integer.valueOf(IDCardUtil.getGenderForInteger((String)dto.getIdCard())));
            patientEntity1.setPatientName(dto.getName());
            patientEntity1.setCredTypeCode("01");
            patientEntity1.setXCreateTime(new Date());
            patientEntity1.setXUpdateTime(new Date());
            patientEntity1.setXVersion(Long.valueOf(0L));
            log.info("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u6dfb\u52a0\u60a3\u8005: {}", (Object)JSON.toJSONString((Object)patientEntity1));
            this.patientMapper.insert(patientEntity1);
        }
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setXId(dto.getOrderId());
        orderEntity.setDealSeq(dto.getOrderId());
        orderEntity.setOrderSeq(dto.getOrderId());
        orderEntity.setPayMethod(PayChannelEnum.NOPAY.getPayChannel());
        orderEntity.setPayAmount(new BigDecimal(0));
        orderEntity.setStatus(Integer.valueOf(1));
        orderEntity.setOrganId(this.projProperties.getZkOrganId());
        orderEntity.setPatientId(dto.getPatientId());
        orderEntity.setDoctorId(scheduleRecordEntity.getDoctorId());
        orderEntity.setDoctorName(scheduleRecordEntity.getDoctorName());
        orderEntity.setDoctorType(Integer.valueOf(1));
        orderEntity.setServType(Integer.valueOf(3));
        orderEntity.setServTime(inquiryServiceConfigEntity.getServTime());
        orderEntity.setTotalNum(Integer.valueOf(999));
        orderEntity.setKeepOrder(dto.getType());
        orderEntity.setIdCard(dto.getIdCard());
        orderEntity.setPaymentTime(new Date());
        orderEntity.setScheduleDate(scheduleRecordEntity.getScheduleDate());
        orderEntity.setScheduleId(scheduleRecordEntity.getId().toString());
        orderEntity.setDeptId(Long.valueOf(Long.parseLong(scheduleRecordEntity.getDeptId())));
        orderEntity.setDeptName(scheduleRecordEntity.getDeptName());
        orderEntity.setHospitalId(this.projProperties.getZkOrganId());
        orderEntity.setHospitalName("\u4f17\u5eb7\u6781\u901f\u8d2d\u836f");
        orderEntity.setAppCode(ORGAN_CODE);
        orderEntity.setPatientUserId(dto.getUserId());
        orderEntity.setMedicalRecordId(medicalId);
        log.info("\u4fdd\u4f9b\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)orderEntity));
        this.orderMapper.insert((Object)orderEntity);
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setXId(dto.getAdmId());
        admissionEntity.setOrderId(dto.getOrderId());
        admissionEntity.setOrganId(this.projProperties.getZkOrganId());
        admissionEntity.setPatientId(dto.getPatientId());
        admissionEntity.setDoctorId(scheduleRecordEntity.getDoctorId());
        admissionEntity.setDoctorType(Integer.valueOf(1));
        admissionEntity.setServType(Integer.valueOf(3));
        admissionEntity.setStartTime(new Date());
        admissionEntity.setReceptionTime(new Date());
        admissionEntity.setServTime(inquiryServiceConfigEntity.getServTime());
        admissionEntity.setEndTime(DateUtils.dateAddMinutes((Date)new Date(), (int)inquiryServiceConfigEntity.getServTime()));
        admissionEntity.setTotalNum(Integer.valueOf(999));
        admissionEntity.setCurrentNum(Integer.valueOf(999));
        admissionEntity.setStatus(Integer.valueOf(2));
        admissionEntity.setReceptionTime(new Date());
        admissionEntity.setDoctorName(scheduleRecordEntity.getDoctorName());
        admissionEntity.setSign("fast");
        admissionEntity.setExtendTimes(Integer.valueOf(2));
        admissionEntity.setMedicalRecordId(medicalId);
        log.info("\u4fdd\u4f9b\u65b0\u589e\u5c31\u8bca\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        this.admissionMapper.insert((Object)admissionEntity);
        PatientMedicalRecordEntity patientMedicalRecordEntity = new PatientMedicalRecordEntity();
        patientMedicalRecordEntity.setXId(medicalId);
        patientMedicalRecordEntity.setXCreateTime(new Date());
        patientMedicalRecordEntity.setXUpdateTime(new Date());
        patientMedicalRecordEntity.setTags(dto.getDiagnosis());
        this.patientMedicalRecordMapper.insertPatientMedicalRecord(patientMedicalRecordEntity);
        String drugs = JSON.toJSONString((Object)dto.getDrugs());
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = new MedicalAdmissionRefEntity();
        medicalAdmissionRefEntity.setDrugs(drugs);
        medicalAdmissionRefEntity.setAdmissionId(dto.getAdmId());
        medicalAdmissionRefEntity.setMedicalRecordId(medicalId);
        medicalAdmissionRefEntity.setStoreCode(dto.getStoreCode());
        medicalAdmissionRefEntity.setPreStatus(ZkPatPreOrderStatusEnum.NO_PRE.getValue());
        this.medicalAdmissionRefMapper.insert((Object)medicalAdmissionRefEntity);
        BaseResponse createImResponse = this.payAsyncService.createImSession(orderEntity, admissionEntity);
        if (!createImResponse.isSuccess()) {
            log.info("\u521b\u5efaIM\u5931\u8d25:{}", (Object)createImResponse.getMsg());
            throw new BusinessException("\u521b\u5efaIM\u5931\u8d25");
        }
        OrderTaskVo orderTaskVo = new OrderTaskVo();
        orderTaskVo.setType(Integer.valueOf(7));
        orderTaskVo.setId(dto.getOrderId());
        this.orderSender.sendDelay(orderTaskVo);
        this.imInformService.zkFastBuyPushCard(dto);
        this.goEasyPushService.newOrderToReceive(dto.getAdmId());
    }

    private String insertMedical(FastCreateOrderDto dto, String patientId) {
        MedicalDetailVo medicalDetailVo = new MedicalDetailVo();
        medicalDetailVo.setPatientName(dto.getName());
        Integer age = IDCardUtil.getAge((String)dto.getIdCard());
        String sex = IDCardUtil.getGender((String)dto.getIdCard());
        medicalDetailVo.setPatientAge(age.toString());
        medicalDetailVo.setPatientSex(sex);
        medicalDetailVo.setDiagnose(dto.getDiagnosis());
        String s = JSON.toJSONString((Object)medicalDetailVo);
        SavePatientDynamicMedicalReqVo patientDynamicMedical = new SavePatientDynamicMedicalReqVo();
        patientDynamicMedical.setAppCode(ORGAN_CODE);
        patientDynamicMedical.setHospitalId(this.projProperties.getZkOrganId());
        patientDynamicMedical.setServType(Integer.valueOf(3));
        patientDynamicMedical.setPatientId(patientId);
        patientDynamicMedical.setMedicalDetail(s);
        patientDynamicMedical.setMedicalUserFills(s);
        String medicalId = this.internetHospitalDetailInfoService.insertMedical(patientDynamicMedical);
        return medicalId;
    }

    public BaseResponse<ZKfbImInfoResVo> queryImInfo(String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        IMQueryTargetSdkAccountRspVO docImAccount = this.imAccountService.queryImAccount(admId, "EHOS_DOCTOR", orderEntity.getDoctorId());
        IMQueryTargetSdkAccountRspVO patImAccount = this.imAccountService.queryImAccount(admId, "EHOS_PATIENT", orderEntity.getDoctorId());
        IMQueryUserLoginReqVO reqVO = new IMQueryUserLoginReqVO();
        reqVO.setAppCode("EHOS_PATIENT");
        reqVO.setUserId(orderEntity.getPatientUserId());
        BaseResponse imSysResult = this.imApiFeignClient.queryUserLogin(reqVO);
        log.info("\u83b7\u53d6IM\u767b\u5f55\u4fe1\u606f:{}", (Object)imSysResult);
        IMQueryMsgReqVO imQueryMsgReqVO = new IMQueryMsgReqVO();
        imQueryMsgReqVO.setAppCode("EHOS_PATIENT");
        imQueryMsgReqVO.setUserId(orderEntity.getPatientUserId());
        imQueryMsgReqVO.setBusinessCode("zxzx");
        imQueryMsgReqVO.setMsgType("1");
        imQueryMsgReqVO.setPageSize(Integer.valueOf(999));
        imQueryMsgReqVO.setSortOrder("ASC");
        ZKfbImInfoResVo resVo = ZKfbImInfoResVo.builder().docImAccount(docImAccount.getSdkAccount()).patImAccount(patImAccount.getSdkAccount()).roomNum(Long.valueOf(docImAccount.getRoomNum())).sig(((IMQueryUserLoginRspVO)imSysResult.getData()).getSig()).doctorName(orderEntity.getDoctorName()).build();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(orderEntity.getDoctorId());
        BaseResponse res = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (res.isSuccess()) {
            resVo.setDoctorPortrait(((PersonnelInfo)res.getData()).getPortrait());
        }
        ArrayList<String> appointmentId = new ArrayList<String>();
        appointmentId.add(admId);
        imQueryMsgReqVO.setAppointmentId(appointmentId);
        BaseResponse allMsgContent = this.admissionService.getAllMsgContent(imQueryMsgReqVO);
        if (allMsgContent.isSuccess() && Objects.nonNull(allMsgContent.getData())) {
            resVo.setIMMsgVo((List)allMsgContent.getData());
        }
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<List<String>> searchIcdName(ICDSearchNameReqVo param) {
        IPage iCDEntities = this.icdMapper.selectPage((IPage)new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue(), false), (Wrapper)new QueryWrapper().lambda().like(ICDEntity::getIcdName, (Object)param.getKeyword()));
        List records = iCDEntities.getRecords();
        List icdNames = records.stream().map(entity -> entity.getIcdName()).collect(Collectors.toList());
        return BaseResponse.success(icdNames);
    }

    private ScheduleRecordEntity findScheDoctor(String patientId, Integer type) {
        String date = DateUtils.dateToSimpleString((Date)new Date());
        String hourAndSecond = DateUtils.getHourAndSecond();
        List doctorIdsFastBuy = this.orderMapper.findDoctorIdsFastBuy(patientId, type);
        log.info("\u60a3\u8005\u5df2\u4e0b\u5355\u533b\u751f:{}", (Object)doctorIdsFastBuy);
        List scheduleRecordEntities = this.scheduleRecordMapper.selectByDate(this.projProperties.getZkOrganId(), Integer.valueOf(3), date, Integer.valueOf(1), hourAndSecond);
        List<Object> doctorIds = new ArrayList();
        log.info("\u5f53\u524d\u6392\u73ed\u533b\u751f:{}", (Object)JSON.toJSONString((Object)scheduleRecordEntities));
        if (CollectionUtils.isEmpty((Collection)scheduleRecordEntities)) {
            throw new BusinessException("\u6682\u65e0\u6392\u73ed\u533b\u751f,\u8bf7\u7a0d\u540e\u4e0b\u5355");
        }
        if (!CollectionUtils.isEmpty((Collection)doctorIdsFastBuy)) {
            scheduleRecordEntities = scheduleRecordEntities.stream().filter(v -> !doctorIdsFastBuy.contains(v.getDoctorId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)scheduleRecordEntities)) {
            throw new BusinessException("\u5df2\u6709\u8ba2\u5355\u8fdb\u884c\u4e2d,\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355");
        }
        doctorIds = scheduleRecordEntities.stream().map(ScheduleRecordEntity::getDoctorId).collect(Collectors.toList());
        List doctorByOrderCount = this.orderMapper.findDoctorByOrderCount(doctorIds, type);
        ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
        if (doctorByOrderCount.size() == scheduleRecordEntities.size()) {
            String doctorId = (String)doctorByOrderCount.get(0);
            Optional<ScheduleRecordEntity> first = scheduleRecordEntities.stream().filter(v -> Objects.equals(v.getDoctorId(), doctorId)).findFirst();
            scheduleRecordEntity = first.get();
        } else if (doctorByOrderCount.size() < scheduleRecordEntities.size()) {
            Random random = new Random();
            int i = random.nextInt((scheduleRecordEntities = scheduleRecordEntities.stream().filter(v -> !doctorByOrderCount.contains(v.getDoctorId())).collect(Collectors.toList())).size() + 1);
            if (i == 0) {
                ++i;
            }
            scheduleRecordEntity = (ScheduleRecordEntity)scheduleRecordEntities.get(i - 1);
        }
        log.info("\u5f53\u524d\u4e0b\u5355\u7684\u533b\u751f:{}", (Object)JSON.toJSONString((Object)scheduleRecordEntity));
        return scheduleRecordEntity;
    }
}

