/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.nczk.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.card.client.PatientServiceClient;
import com.ebaiyihui.card.common.vo.PatientInfoReqVO;
import com.ebaiyihui.card.common.vo.PatientInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ZkPatPreOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalPictureMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MedicalAdmissionRefEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionService;
import com.ebaiyihui.onlineoutpatient.core.service.GoEasyPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ImAccountService;
import com.ebaiyihui.onlineoutpatient.core.service.PatientMedicalPictureService;
import com.ebaiyihui.onlineoutpatient.core.service.PatientMedicalRecordService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.PatientMedicalFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.nczk.ZkbgService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.SignUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugReqDto;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.MedicalDetailVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgCreateOrderReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgFindMedicalRecordVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgMedicalRecordReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgQueryImInfoReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgQueryImInfoResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgRefundVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.SavePatientDynamicMedicalReqVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ZkbgServiceImpl
implements ZkbgService {
    private static final Logger log = LoggerFactory.getLogger(ZkbgServiceImpl.class);
    @Autowired
    private PatientMedicalFeignClient patientDynamicMedicalClient;
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private PatientMedicalPictureService pictureService;
    @Autowired
    private PatientMedicalPictureMapper patientMedicalPictureMapper;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private PatientServiceClient patientServiceFeignClient;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private IMInformService iMInformService;
    @Autowired
    private PatientMedicalRecordService patientMedicalRecordService;
    @Autowired
    private AdmissionService admissionService;
    @Autowired
    private ImAccountService imAccountService;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private GoEasyPushService goEasyPushService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private ProjProperties projProperties;
    private static final Integer PUSH_RES_CODE = 200;
    private static final String ORGAN_CODE = "NCZK";
    private static final Integer STATUS = 1;

    public BaseResponse<String> insertMedicalRecord(ZkbgMedicalRecordReqVo param) {
        List urls;
        boolean b;
        MedicalDetailVo medicalDetailVo = new MedicalDetailVo();
        BeanUtils.copyProperties((Object)param, (Object)medicalDetailVo);
        String s = JSON.toJSONString((Object)medicalDetailVo);
        SavePatientDynamicMedicalReqVo patientDynamicMedical = new SavePatientDynamicMedicalReqVo();
        patientDynamicMedical.setAppCode(ORGAN_CODE);
        patientDynamicMedical.setHospitalId(this.projProperties.getZkOrganId());
        patientDynamicMedical.setServType(Integer.valueOf(3));
        patientDynamicMedical.setPatientId(param.getPatientId());
        patientDynamicMedical.setDescription(param.getConditionDescription());
        patientDynamicMedical.setMedicalDetail(s);
        patientDynamicMedical.setMedicalUserFills(s);
        BaseResponse baseResponse = this.patientDynamicMedicalClient.insertMedical(patientDynamicMedical);
        log.info("\u4e0a\u4f20\u75c5\u5386\u5230\u4e91\u7aef\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)baseResponse));
        if (!baseResponse.isSuccess() || Objects.isNull(baseResponse.getData())) {
            return BaseResponse.error((String)"\u4e0a\u4f20\u75c5\u5386\u5230\u4e91\u7aef\u5931\u8d25");
        }
        PatientInfoReqVO patientInfoReqVO = new PatientInfoReqVO();
        patientInfoReqVO.setPatientId(param.getPatientId());
        patientInfoReqVO.setHospitalId(this.projProperties.getZkOrganId());
        patientInfoReqVO.setAppCode("BYCS");
        patientInfoReqVO.setChannelCode("DOCTOR_NETINQUIRY");
        BaseResponse response = this.patientServiceFeignClient.getPatientInfo(patientInfoReqVO);
        log.info("\u5361\u670d\u52a1\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)response));
        if (!response.isSuccess() || Objects.isNull(response.getData())) {
            return BaseResponse.error((String)"\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25");
        }
        PatientInfoRespVO patientInfoRespVO = (PatientInfoRespVO)response.getData();
        this.updatePatientInfo(param, patientInfoRespVO);
        PatientMedicalRecordEntity patientMedicalRecord = new PatientMedicalRecordEntity();
        patientMedicalRecord.setXCreateTime(new Date());
        patientMedicalRecord.setXUpdateTime(new Date());
        patientMedicalRecord.setXVersion(Long.valueOf(0L));
        patientMedicalRecord.setServType(Integer.valueOf(3));
        patientMedicalRecord.setIllnessTime(param.getRegDate());
        patientMedicalRecord.setPatientId(param.getPatientId());
        patientMedicalRecord.setTags(param.getDiagnose());
        patientMedicalRecord.setDescription(param.getConditionDescription());
        patientMedicalRecord.setVisiteMsg(param.getIsOfflineRecord() + "," + param.getIsUsedDrug());
        patientMedicalRecord.setXId((String)baseResponse.getData());
        patientMedicalRecord.setMedicalRecordNo(param.getCardNo());
        Integer integer = this.patientMedicalRecordMapper.insertPatientMedicalRecord(patientMedicalRecord);
        if (integer < 1) {
            return BaseResponse.error((String)"\u4fdd\u5b58\u75c5\u5386\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)param.getUploadData()) && !(b = this.pictureService.insertPatientMedicalPicture(urls = param.getUploadData(), patientMedicalRecord.getXId()))) {
            return BaseResponse.error((String)"\u4fdd\u5b58\u75c5\u5386\u56fe\u7247\u5931\u8d25");
        }
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getUniqueId, (Object)param.getUniqueId()));
        if (Objects.isNull(medicalAdmissionRefEntity)) {
            log.info("\u75c5\u5386\u4e0d\u5b58\u5728\u65b0\u589e");
            MedicalAdmissionRefEntity medicalAdmissionRefEntity1 = new MedicalAdmissionRefEntity();
            medicalAdmissionRefEntity1.setMedicalRecordId(patientMedicalRecord.getXId());
            medicalAdmissionRefEntity1.setUniqueId(param.getUniqueId());
            int insert = this.medicalAdmissionRefMapper.insert((Object)medicalAdmissionRefEntity1);
            if (integer < 1) {
                return BaseResponse.error((String)"\u4fdd\u5b58\u75c5\u5386\u5931\u8d25");
            }
        } else {
            log.info("\u75c5\u5386\u5b58\u5728\u66f4\u65b0");
            medicalAdmissionRefEntity.setUniqueId(param.getUniqueId());
            medicalAdmissionRefEntity.setMedicalRecordId((String)baseResponse.getData());
            this.medicalAdmissionRefMapper.updateById((Object)medicalAdmissionRefEntity);
        }
        return BaseResponse.success((Object)baseResponse.getData());
    }

    public BaseResponse<String> createOrder(ZkbgCreateOrderReqVo param) {
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getUniqueId, (Object)param.getUniqueId()));
        if (Objects.isNull(medicalAdmissionRefEntity)) {
            return BaseResponse.error((String)"\u672a\u586b\u5199\u75c5\u5386");
        }
        if (StringUtils.isNotBlank((String)medicalAdmissionRefEntity.getAdmissionId())) {
            return BaseResponse.success((Object)medicalAdmissionRefEntity.getAdmissionId());
        }
        PatientMedicalRecordEntity medicalRecordEntity = this.patientMedicalRecordMapper.findById(medicalAdmissionRefEntity.getMedicalRecordId());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(medicalRecordEntity.getPatientId());
        String date = DateUtils.dateToSimpleString((Date)new Date());
        String hourAndSecond = DateUtils.getHourAndSecond();
        List doctorIdsBg = this.orderMapper.findDoctorIdsBg(patientEntity.getUserId());
        List list = this.scheduleRecordMapper.selectByDate(this.projProperties.getZkOrganId(), Integer.valueOf(3), date, Integer.valueOf(1), hourAndSecond);
        if (!CollectionUtils.isEmpty((Collection)doctorIdsBg)) {
            list = list.stream().filter(v -> !doctorIdsBg.contains(v.getDoctorId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BaseResponse.error((String)"\u5f53\u524d\u65e0\u6392\u73ed\u533b\u751f");
        }
        Random random = new Random();
        int i = random.nextInt(list.size() + 1);
        if (i == 0) {
            ++i;
        }
        ScheduleRecordEntity scheduleRecordEntity = (ScheduleRecordEntity)list.get(i - 1);
        log.info("\u5f53\u524d\u6392\u73ed\u7684\u533b\u751f:{}", (Object)JSON.toJSONString((Object)scheduleRecordEntity));
        OrderEntity orderEntity = new OrderEntity();
        String orderId = UUIDUtil.generateViewId();
        orderEntity.setXId(orderId);
        orderEntity.setDealSeq(param.getUniqueId());
        orderEntity.setOrderSeq(param.getUniqueId());
        orderEntity.setPayMethod(PayChannelEnum.NOPAY.getPayChannel());
        orderEntity.setPayAmount(new BigDecimal(0));
        orderEntity.setStatus(STATUS);
        orderEntity.setOrganId(this.projProperties.getZkOrganId());
        orderEntity.setPatientId(medicalRecordEntity.getPatientId());
        orderEntity.setDoctorId(scheduleRecordEntity.getDoctorId());
        orderEntity.setDoctorName(scheduleRecordEntity.getDoctorName());
        orderEntity.setDoctorType(STATUS);
        orderEntity.setServType(Integer.valueOf(3));
        orderEntity.setServTime(Integer.valueOf(720));
        orderEntity.setTotalNum(Integer.valueOf(999));
        orderEntity.setMedicalRecordId(medicalAdmissionRefEntity.getMedicalRecordId());
        orderEntity.setKeepOrder(Integer.valueOf(1));
        orderEntity.setIdCard(patientEntity.getIdcard());
        orderEntity.setPaymentTime(new Date());
        orderEntity.setScheduleDate(scheduleRecordEntity.getScheduleDate());
        orderEntity.setScheduleId(scheduleRecordEntity.getId().toString());
        orderEntity.setDeptId(Long.valueOf(Long.parseLong(scheduleRecordEntity.getDeptId())));
        orderEntity.setDeptName(scheduleRecordEntity.getDeptName());
        orderEntity.setHospitalId(this.projProperties.getZkOrganId());
        orderEntity.setHospitalName("\u4f17\u5eb7\u4fdd\u4f9b");
        orderEntity.setAppCode(ORGAN_CODE);
        orderEntity.setPatientUserId(patientEntity.getUserId());
        log.info("\u4fdd\u4f9b\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)orderEntity));
        this.orderMapper.insert((Object)orderEntity);
        AdmissionEntity admissionEntity = new AdmissionEntity();
        String admId = UUIDUtil.getUUID();
        admissionEntity.setXId(admId);
        admissionEntity.setOrderId(orderId);
        admissionEntity.setOrganId(this.projProperties.getZkOrganId());
        admissionEntity.setPatientId(patientEntity.getXId());
        admissionEntity.setDoctorId(scheduleRecordEntity.getDoctorId());
        admissionEntity.setDoctorType(STATUS);
        admissionEntity.setServType(Integer.valueOf(3));
        admissionEntity.setMedicalRecordId(medicalRecordEntity.getXId());
        admissionEntity.setStartTime(new Date());
        admissionEntity.setReceptionTime(new Date());
        admissionEntity.setEndTime(DateUtils.dateAddHours((Date)new Date(), (int)12));
        admissionEntity.setServTime(Integer.valueOf(720));
        admissionEntity.setTotalNum(Integer.valueOf(999));
        admissionEntity.setCurrentNum(Integer.valueOf(999));
        admissionEntity.setStatus(Integer.valueOf(2));
        admissionEntity.setReceptionTime(new Date());
        admissionEntity.setDoctorName(scheduleRecordEntity.getDoctorName());
        admissionEntity.setSign("bg");
        log.info("\u4fdd\u4f9b\u65b0\u589e\u5c31\u8bca\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        this.admissionMapper.insert((Object)admissionEntity);
        List drugList = this.getDrugList(param.getUniqueId());
        String drugs = JSON.toJSONString((Object)drugList);
        medicalAdmissionRefEntity.setDrugs(drugs);
        medicalAdmissionRefEntity.setAdmissionId(admId);
        this.medicalAdmissionRefMapper.updateById((Object)medicalAdmissionRefEntity);
        BaseResponse createImResponse = this.payAsyncService.createImSession(orderEntity, admissionEntity);
        if (!createImResponse.isSuccess()) {
            log.info("\u521b\u5efaIM\u5931\u8d25");
            return BaseResponse.error((String)createImResponse.getMsg());
        }
        OrderTaskVo orderTaskVo = new OrderTaskVo();
        orderTaskVo.setType(Integer.valueOf(7));
        orderTaskVo.setId(orderId);
        this.orderSender.sendDelay(orderTaskVo);
        try {
            this.iMInformService.zkbgIMpushCard(admId);
            Thread.sleep(1000L);
            this.iMInformService.zkbgIMpush(medicalAdmissionRefEntity);
            this.goEasyPushService.newOrderToReceive(admId);
        }
        catch (Exception e) {
            log.info("\u63a8\u9001IM\u6d88\u606f\u51fa\u9519:{}", (Throwable)e);
        }
        return BaseResponse.success((Object)admId);
    }

    public BaseResponse<ZkbgQueryImInfoResVo> queryImInfo(ZkbgQueryImInfoReqVo param) {
        ZkbgQueryImInfoResVo resVo = new ZkbgQueryImInfoResVo();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(param.getAdmId());
        PatientEntity patientEntity = this.patientMapper.selectById(admissionEntity.getPatientId());
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)param.getAdmId()));
        resVo.setDoctorName(admissionEntity.getDoctorName());
        Integer age = 0;
        String gender = "";
        age = IDCardUtil.getAge((String)patientEntity.getIdcard());
        gender = IDCardUtil.getGender((String)patientEntity.getIdcard());
        resVo.setPatientAge(age.toString());
        resVo.setPatientSex(gender);
        resVo.setPatientName(patientEntity.getPatientName());
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(admissionEntity.getDoctorId());
        BaseResponse doctorDetailsVOBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (!doctorDetailsVOBaseResponse.isSuccess() || null == doctorDetailsVOBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u51fa\u9519");
        }
        resVo.setDoctorPortrait(((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getPortrait());
        List drugReqDtos = JSON.parseArray((String)medicalAdmissionRefEntity.getDrugs(), DrugReqDto.class);
        resVo.setDrugs("\u5305\u542b\u3010 " + ((DrugReqDto)drugReqDtos.get(0)).getDrugName() + "\u3011\u7b49" + drugReqDtos.size() + "\u79cd\u836f\u54c1");
        resVo.setOrderTime(DateUtils.dateToFullString((Date)admissionEntity.getXCreateTime()));
        IMQueryTargetSdkAccountRspVO docImAccount = this.imAccountService.queryImAccount(param.getAdmId(), "EHOS_DOCTOR", admissionEntity.getDoctorId());
        IMQueryTargetSdkAccountRspVO patImAccount = this.imAccountService.queryImAccount(param.getAdmId(), "EHOS_PATIENT", admissionEntity.getDoctorId());
        resVo.setDocImAccount(docImAccount.getSdkAccount());
        resVo.setPatImAccount(patImAccount.getSdkAccount());
        resVo.setRoomNum(Long.valueOf(docImAccount.getRoomNum()));
        IMQueryMsgReqVO imQueryMsgReqVO = new IMQueryMsgReqVO();
        imQueryMsgReqVO.setAppCode("EHOS_PATIENT");
        imQueryMsgReqVO.setUserId(patientEntity.getUserId());
        imQueryMsgReqVO.setBusinessCode("zxzx");
        imQueryMsgReqVO.setMsgType("1");
        imQueryMsgReqVO.setPageSize(param.getPageSize());
        imQueryMsgReqVO.setPage(param.getPageNum());
        ArrayList<String> appointmentId = new ArrayList<String>();
        appointmentId.add(param.getAdmId());
        imQueryMsgReqVO.setAppointmentId(appointmentId);
        BaseResponse allMsgContent = this.admissionService.getAllMsgContent(imQueryMsgReqVO);
        if (allMsgContent.isSuccess() && Objects.nonNull(allMsgContent.getData())) {
            resVo.setIMMsgVo((List)allMsgContent.getData());
        }
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<ZkbgMedicalRecordReqVo> findMedicalRecord(ZkbgFindMedicalRecordVo param) {
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getUniqueId, (Object)param.getUniqueId()));
        if (Objects.isNull(medicalAdmissionRefEntity)) {
            return BaseResponse.success();
        }
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.patientMedicalRecordMapper.findById(medicalAdmissionRefEntity.getMedicalRecordId());
        List list = this.patientMedicalPictureMapper.queryRecordPictures(medicalAdmissionRefEntity.getMedicalRecordId());
        PatientEntity patientEntity = this.patientMapper.selectById(patientMedicalRecordEntity.getPatientId());
        ZkbgMedicalRecordReqVo zkbgMedicalRecordReqVo = new ZkbgMedicalRecordReqVo();
        zkbgMedicalRecordReqVo.setRegDate(patientMedicalRecordEntity.getIllnessTime());
        zkbgMedicalRecordReqVo.setConditionDescription(patientMedicalRecordEntity.getDescription());
        zkbgMedicalRecordReqVo.setDiagnose(patientMedicalRecordEntity.getTags());
        zkbgMedicalRecordReqVo.setUploadData(list);
        zkbgMedicalRecordReqVo.setPatientId(patientMedicalRecordEntity.getPatientId());
        zkbgMedicalRecordReqVo.setUserId(patientEntity.getUserId());
        zkbgMedicalRecordReqVo.setPatientName(patientEntity.getPatientName());
        zkbgMedicalRecordReqVo.setPatientSex(Objects.equals(patientEntity.getGender(), 1) ? "\u7537" : "\u5973");
        zkbgMedicalRecordReqVo.setPatientAge(IDCardUtil.getAge((String)patientEntity.getIdcard()).toString());
        zkbgMedicalRecordReqVo.setCardNo(patientEntity.getCardNo());
        zkbgMedicalRecordReqVo.setUniqueId(param.getUniqueId());
        return BaseResponse.success((Object)zkbgMedicalRecordReqVo);
    }

    public BaseResponse<List<MedicalAdmissionRefEntity>> findMedicalRecordList(List<String> list) {
        QueryWrapper qw = new QueryWrapper();
        qw.in((Object)"unique_id", list);
        List refEntities = this.medicalAdmissionRefMapper.selectList((Wrapper)qw);
        if (CollectionUtils.isEmpty((Collection)refEntities)) {
            return BaseResponse.success();
        }
        List collect = refEntities.stream().filter(i -> StringUtils.isNotEmpty((String)i.getMedicalRecordId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return BaseResponse.success();
        }
        return BaseResponse.success(collect);
    }

    public BaseResponse<String> refund(ZkbgRefundVo param) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(param.getAdmId());
        if (Objects.isNull(admissionEntity)) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        admissionEntity.setStatus(AdmissionStatusEnum.FINISH_APPLY.getValue());
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)param.getAdmId()));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(param.getAdmId());
        if (Objects.equals(orderEntity.getKeepOrder(), 2) || Objects.equals(orderEntity.getKeepOrder(), 3)) {
            String s = Objects.equals(param.getStatus(), "1") ? "\u5408\u7406" : "\u4e0d\u5408\u7406";
            admissionEntity.setXRemark(String.format("\u6781\u901f\u8d2d\u836f\u8ba2\u5355%s\u7ed3\u675f", s));
            this.admissionMapper.update(admissionEntity);
            if (Objects.equals(param.getStatus(), "2")) {
                medicalAdmissionRefEntity.setPreStatus(ZkPatPreOrderStatusEnum.REFUND_PRE.getValue());
                this.smallProgramPushService.zkDoctorRefund(param.getAdmId());
            }
            this.medicalAdmissionRefMapper.updateById((Object)medicalAdmissionRefEntity);
            return BaseResponse.success();
        }
        if (Objects.equals("1", param.getStatus())) {
            admissionEntity.setXRemark("\u4fdd\u4f9b\u8ba2\u5355\u5408\u7406\u7ed3\u675f");
            this.iMInformService.zkbgIMpushDrugCard(param.getAdmId(), "\u5f85\u51fa\u8d27");
        } else {
            this.refund(medicalAdmissionRefEntity.getUniqueId());
            admissionEntity.setXRemark("\u4fdd\u4f9b\u8ba2\u5355\u4e0d\u5408\u7406\u7ed3\u675f");
            this.iMInformService.zkbgIMpushDrugCard(param.getAdmId(), "\u5df2\u9000\u6b3e");
        }
        this.admissionMapper.update(admissionEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> findScheduleDoctor(ZkbgCreateOrderReqVo param) {
        String date = DateUtils.dateToSimpleString((Date)new Date());
        String hourAndSecond = DateUtils.getHourAndSecond();
        List list = this.scheduleRecordMapper.selectByDate(this.projProperties.getZkOrganId(), Integer.valueOf(3), date, Integer.valueOf(1), hourAndSecond);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BaseResponse.error((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u95ee\u8bca\u7684\u6392\u73ed\u533b\u751f");
        }
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getUniqueId, (Object)param.getUniqueId()));
        if (Objects.isNull(medicalAdmissionRefEntity)) {
            return BaseResponse.success();
        }
        PatientMedicalRecordEntity medicalRecordEntity = this.patientMedicalRecordMapper.findById(medicalAdmissionRefEntity.getMedicalRecordId());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(medicalRecordEntity.getPatientId());
        List doctorIdsBg = this.orderMapper.findDoctorIdsBg(patientEntity.getUserId());
        if (!CollectionUtils.isEmpty((Collection)doctorIdsBg)) {
            list = list.stream().filter(v -> !doctorIdsBg.contains(v.getDoctorId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BaseResponse.error((String)"\u60a8\u5f53\u524d\u6709\u8ba2\u5355\u5728\u54a8\u8be2\u4e2d,\u6682\u65f6\u65e0\u6cd5\u63d0\u4ea4\u65b0\u7684\u95ee\u8bca\u7533\u8bf7");
        }
        return BaseResponse.success();
    }

    public void refund(String uniqueId) {
        String url = this.projProperties.getBgUrlAddress() + "/orders/refund?orderId=" + uniqueId;
        HashMap<String, String> hearders = new HashMap<String, String>();
        hearders.put("appId", this.projProperties.getAppid());
        hearders.put("mchId", this.projProperties.getMchid());
        hearders.put("appSecret", this.projProperties.getAppSecret());
        hearders.put("signKey", this.projProperties.getSignkey());
        hearders.put("timeStamp", String.valueOf(new Date().getTime()));
        log.info("\u7535\u5546\u9000\u6b3e\u9a8c\u7b7e\u8bf7\u6c42\u53c2\u6570------>" + JSON.toJSONString(hearders));
        String signMl = SignUtil.createSignMl((String)this.projProperties.getSignkey(), hearders);
        log.info("\u7535\u5546\u9000\u6b3e\u9a8c\u7b7e\u503c------>" + signMl);
        hearders.put("sign", signMl);
        try {
            String result = HttpKit.doGetHader((String)url, (String)JSONObject.toJSONString(hearders), hearders);
            log.info("\u7535\u5546\u9000\u6b3e\u8fd4\u56de:" + result);
            if (StringUtils.isBlank((String)result)) {
                throw new BusinessException("\u7535\u5546\u9000\u6b3e\u8fd4\u56de\u4e3anull");
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (PUSH_RES_CODE.intValue() != jsonObject.getInteger("code").intValue()) {
                throw new BusinessException("\u7535\u5546\u9000\u6b3e\u5931\u8d25" + jsonObject.get((Object)"msg"));
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7535\u5546\u9000\u6b3e\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("\u8c03\u7528\u7535\u5546\u9000\u6b3e\u5f02\u5e38");
        }
    }

    public List<DrugReqDto> getDrugList(String uniqueId) {
        String url = this.projProperties.getBgUrlAddress() + "/orders/getOrder?orderId=" + uniqueId;
        HashMap<String, String> hearders = new HashMap<String, String>();
        hearders.put("appId", this.projProperties.getAppid());
        hearders.put("mchId", this.projProperties.getMchid());
        hearders.put("appSecret", this.projProperties.getAppSecret());
        hearders.put("signKey", this.projProperties.getSignkey());
        hearders.put("timeStamp", String.valueOf(new Date().getTime()));
        log.info("\u7535\u5546\u83b7\u53d6\u836f\u54c1\u4fe1\u606f\u9a8c\u7b7e\u8bf7\u6c42\u53c2\u6570------>" + JSON.toJSONString(hearders));
        String signMl = SignUtil.createSignMl((String)this.projProperties.getSignkey(), hearders);
        log.info("\u7535\u5546\u83b7\u53d6\u836f\u54c1\u4fe1\u606f\u9a8c\u7b7e\u503c------>" + signMl);
        hearders.put("sign", signMl);
        try {
            String result = HttpKit.doGetHader((String)url, (String)JSON.toJSONString(hearders), hearders);
            log.info("\u7535\u5546\u83b7\u53d6\u836f\u54c1\u4fe1\u606f\u8fd4\u56de:" + result);
            if (StringUtils.isBlank((String)result)) {
                throw new BusinessException("\u7535\u5546\u83b7\u53d6\u836f\u54c1\u4fe1\u606f\u8fd4\u56de\u4e3anull");
            }
            BaseResponse response = (BaseResponse)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!PUSH_RES_CODE.toString().equals(response.getCode())) {
                throw new BusinessException("\u7535\u5546\u83b7\u53d6\u836f\u54c1\u4fe1\u606f\u5931\u8d25" + response.getMsg());
            }
            if (Objects.isNull(response.getData())) {
                throw new BusinessException("\u836f\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            }
            return (List)response.getData();
        }
        catch (Exception e) {
            log.error("\u7535\u5546\u83b7\u53d6\u836f\u54c1\u4fe1\u606f\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("\u7535\u5546\u83b7\u53d6\u836f\u54c1\u4fe1\u606f\u5f02\u5e38");
        }
    }

    private void updatePatientInfo(ZkbgMedicalRecordReqVo param, PatientInfoRespVO patientInfoRespVO) {
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(param.getPatientId());
        log.info("patientEntity:{}", (Object)patientEntity);
        if (Objects.isNull(patientEntity)) {
            PatientEntity patientEntity1 = new PatientEntity();
            patientEntity1.setXId(param.getPatientId());
            patientEntity1.setAccountPhone(patientInfoRespVO.getContactMobile());
            patientEntity1.setPatientType(CommonConstants.PATIENT_TYPE);
            patientEntity1.setUserId(param.getUserId());
            patientEntity1.setIdcard(patientInfoRespVO.getCredNo());
            patientEntity1.setCardNo(param.getCardNo());
            patientEntity1.setTelphone(patientInfoRespVO.getContactMobile());
            patientEntity1.setGender(Integer.valueOf(patientInfoRespVO.getGender().shortValue()));
            patientEntity1.setPatientName(patientInfoRespVO.getName());
            patientEntity1.setCredTypeCode(patientInfoRespVO.getCredTypeCode());
            patientEntity1.setXCreateTime(new Date());
            patientEntity1.setXUpdateTime(new Date());
            patientEntity1.setXVersion(Long.valueOf(0L));
            patientEntity1.setUserId(param.getUserId());
            log.info("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u6dfb\u52a0\u60a3\u8005: {}", (Object)JSON.toJSONString((Object)patientEntity1));
            this.patientMapper.insert(patientEntity1);
        } else {
            patientEntity.setAccountPhone(patientInfoRespVO.getContactMobile());
            patientEntity.setCardNo(param.getCardNo());
            patientEntity.setTelphone(patientInfoRespVO.getContactMobile());
            patientEntity.setCredTypeCode(patientInfoRespVO.getCredTypeCode());
            patientEntity.setIdcard(patientInfoRespVO.getCredNo());
            patientEntity.setXUpdateTime(new Date());
            patientEntity.setUserId(param.getUserId());
            log.info("\u66f4\u65b0\u60a3\u8005:{}" + JSON.toJSONString((Object)patientEntity));
            this.patientMapper.update(patientEntity);
        }
    }
}

