/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.task;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TopicCustomerTask {
    private static final Logger log = LoggerFactory.getLogger(TopicCustomerTask.class);
    @Autowired
    private UmAppPushService umAppPushService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private PayCallBackService payCallBackService;
    @Resource
    private IMInformService imInformService;
    private ServicePayBillMapper servicePayBillMapper;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;

    @Scheduled(cron="0 59 23 * * ?")
    public void topicCustomerTask() {
        log.info("24\u70b9\u672a\u63a5\u8bca\u5b9a\u65f6\u4efb\u52a1");
        List admissionEntityList = this.admissionMapper.queryListByTime(DateUtils.getDateStr());
        if (null == admissionEntityList || admissionEntityList.size() <= 0) {
            log.info("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        log.info("\u67e5\u8be2\u51fa\u6765\u7684admissionEntityList===\u300b{}", (Object)JSON.toJSONString((Object)admissionEntityList));
        for (AdmissionEntity admissionEntity : admissionEntityList) {
            this.admissionMapper.selectById((Serializable)((Object)admissionEntity.getXId()));
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)admissionEntity.getOrderId()));
            if (!admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) continue;
            if (new BigDecimal(orderEntity.getOwnCost()).compareTo(BigDecimal.ZERO) == 0) {
                admissionEntity.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
                this.admissionMapper.update(admissionEntity);
                this.imInformService.expireRefund(admissionEntity.getXId());
                this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
                this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            admissionEntity.setStatus(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
            this.orderService.updateStatusById(admissionEntity.getOrderId(), OrderStatusEnum.REFUNDED.getValue());
            if (StringUtils.isNotEmpty((String)orderEntity.getBillRefundId())) {
                ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
                servicePayBillEntity.setId(orderEntity.getBillRefundId());
                servicePayBillEntity.setStatus(PayBillStatusEnum.REFUNDED.getValue());
                this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
            }
            admissionEntity.setMessage("\u8d85\u65f6\u672a\u63a5\u8bca\u9000\u6b3e");
            admissionEntity.setXRemark("\u8d85\u65f6\u672a\u63a5\u8bca\u9000\u6b3e");
            this.admissionMapper.update(admissionEntity);
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(orderEntity.getXId());
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
            this.imInformService.expireRefund(admissionEntity.getXId());
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ SmallProgramPushService access$000(TopicCustomerTask x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ UmAppPushService access$100(TopicCustomerTask x0) {
        return x0.umAppPushService;
    }
}

