/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.allowcheck.core;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.client.PatientBlacklistClient;
import com.ebaiyihui.card.common.vo.PatientBlacklistRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlackCheckPublicService {
    private static final Logger log = LoggerFactory.getLogger(BlackCheckPublicService.class);
    @Autowired
    private PatientBlacklistClient patientBlacklistClient;
    @Autowired
    private PatientMapper patientMapper;

    public BaseResponse<AllowBuyCheckRespVO> blackCheck(AllowBuyCheckReqVO param) {
        PatientEntity patientEntity;
        String businessCode = "";
        if (ServiceTypeEnum.HOS.getValue().equals(param.getServType())) {
            businessCode = ServiceTypeEnum.HOS.getCode();
        }
        if (ServiceTypeEnum.NOS.getValue().equals(param.getServType())) {
            businessCode = ServiceTypeEnum.NOS.getCode();
        }
        if ((patientEntity = this.patientMapper.findOneByPatientId(param.getPatientId())) == null) {
            return BaseResponse.error((String)"\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u4e3a\u7a7a");
        }
        log.info("patientEntity:{}", (Object)JSONObject.toJSONString((Object)patientEntity));
        log.info("businessCode:{}", (Object)businessCode);
        BaseResponse response = this.patientBlacklistClient.getByPatientCardNoAndBusinessCode(patientEntity.getIdcard(), businessCode);
        log.info("response:{}", (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && response.getData() != null) {
            AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
            data.setType(ImmediateConsultationVoTypeEnum.BLACK.getValue());
            data.setExpireTime(((PatientBlacklistRespVO)response.getData()).getExpireTime());
            return BaseResponse.success((Object)data);
        }
        return null;
    }
}

