/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.allowcheck.core;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientInformationVo;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class HisCheckPublicService {
    private static final Logger log = LoggerFactory.getLogger(HisCheckPublicService.class);
    @Autowired
    private HisTemplateService hisTemplateService;
    @Resource
    private PatientMapper patientMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;

    public BaseResponse<AllowBuyCheckRespVO> hisCheck(AllowBuyCheckReqVO param) {
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(param.getDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        if (param.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            return null;
        }
        ResPatientInformationVo resPatientInformationVo = this.patientMapper.getPatientById(param.getPatientId());
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setHospitalId(param.getOrganId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            log.info("\u8be5\u533b\u9662\u7684\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u5546\u6237\u53f7");
            return null;
        }
        log.info("entity:{}", (Object)entity.toString());
        if (StringUtils.isEmpty((String)entity.getHisUrl())) {
            log.info("\u67e5\u8be2\u7684\u590d\u8bca\u8c03\u7528his\u7684\u5730\u5740\u4e3a\u7a7a\uff0c\u68c0\u67e5\u6570\u636e\u5e93\u786e\u8ba4\u8be5\u533b\u9662\u662f\u5426\u5bf9\u63a5his");
            return null;
        }
        String hisUrl = entity.getHisUrl();
        List registeredRecordList = this.hisTemplateService.getRegisteredRecord(resPatientInformationVo.getIdcard(), resPatientInformationVo.getPatientName(), param.getDeptName(), hisUrl, param.getDeptId().toString(), ((PersonnelInfo)doctorDetailsVoBaseResponse.getData()).getDoctorId(), param.getCardNo(), param.getAppCode());
        if (CollectionUtils.isEmpty((Collection)registeredRecordList)) {
            AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
            data.setType(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
            return BaseResponse.success();
        }
        registeredRecordList.sort(Comparator.comparing(RegisteredRecordResVo::getRegDate).reversed());
        AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
        data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
        data.setRegisteredRecords(registeredRecordList);
        if (StringUtils.isEmpty((String)entity.getHisUrl())) {
            data.setIsHis("2");
        } else {
            data.setIsHis("1");
        }
        return BaseResponse.success((Object)data);
    }
}

