/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.exception;

import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.exception.PaymentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionHandle {
    private Logger logger = LoggerFactory.getLogger(ExceptionHandle.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultData<?> handle(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        if (e instanceof PaymentException) {
            PaymentException paymentException = (PaymentException)e;
            return new ResultData().error(paymentException.getMessage(), "-10004");
        }
        if (e instanceof BusinessException) {
            BusinessException businessException = (BusinessException)e;
            return new ResultData().error(businessException.getMessage());
        }
        return new ResultData().error("\u672a\u77e5\u9519\u8bef");
    }
}

