/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.domain.AlipayCommerceMedicalIndustrydataInquiryorderUploadModel;
import com.alipay.api.response.AlipayCommerceMedicalIndustrydataInquiryorderUploadResponse;
import com.ebaiyihui.common.pojo.vo.UserUniqueIdentifyReqVo;
import com.ebaiyihui.common.pojo.vo.UserUniqueIdentifyRespVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.StringUtil;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AliOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.client.NodeAccountFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.manager.AliMedicalPushService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class OrderInformationService {
    private static final Logger log = LoggerFactory.getLogger(OrderInformationService.class);
    public static final String INQUIRY_ORDER = "INQUIRY_ORDER";
    public static final int TIME_OUT = 604800;
    public static final int TWO = 2;
    public static final String FURTHER_CONSULTATION = "FURTHER_CONSULTATION";
    public static final String FIRST_CONSULTATION = "FIRST_CONSULTATION";
    public static final String IMAGE_INQUIRY = "IMAGE_INQUIRY";
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private NodeAccountFeignClient nodeAccountFeignClient;
    @Autowired
    private AliMedicalPushService aliMedicalPushService;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProjProperties projProperties;
    public static final String ALI_ORDERS = "online:cache:order:ALI_ORDERS";

    @RabbitListener(queues={"order.information.data"})
    @RabbitHandler
    public void addFollowDelayedMedicineReceiver(DoctorMessageEventsVo doctorMessageEventsVo) {
        log.info("\u5f00\u59cb\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u5b9d\uff1a{}", (Object)JSONObject.toJSONString((Object)doctorMessageEventsVo));
        Boolean alipayOrderStart = this.projProperties.getAlipayOrderStart();
        if (alipayOrderStart == null || !alipayOrderStart.booleanValue()) {
            log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u63a8\u9001\u72b6\u6001\u5173\u95ed\u6216\u7a7a\uff0c\u505c\u6b62\u6267\u884c\uff1a{}", (Object)alipayOrderStart);
            return;
        }
        try {
            if (ObjectUtils.isEmpty((Object)doctorMessageEventsVo) || StringUtil.isEmpty((String)doctorMessageEventsVo.getOrderId())) {
                log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u5173\u952e\u6570\u636e\u7a7a\uff0c\u505c\u6b62\u6267\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)doctorMessageEventsVo));
                return;
            }
            String dateKey = this.redisUtil.get(ALI_ORDERS + doctorMessageEventsVo.getOrderId());
            OrderEntity order = null;
            boolean redisisTrue = false;
            if (Objects.nonNull(dateKey)) {
                order = (OrderEntity)JSONObject.parseObject((String)dateKey.toString(), OrderEntity.class);
            }
            if (ObjectUtils.isEmpty(order)) {
                order = this.orderMapper.findByOrderId(doctorMessageEventsVo.getOrderId());
                redisisTrue = true;
            }
            if (null == order) {
                log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u51fa\u9519{}", (Object)JSONObject.toJSONString((Object)doctorMessageEventsVo));
                return;
            }
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(doctorMessageEventsVo.getOrderId());
            if (ObjectUtils.isEmpty((Object)admissionEntity) || null == admissionEntity.getStatus()) {
                log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u8ba2\u5355\u72b6\u6001\u51fa\u9519{}", (Object)JSONObject.toJSONString((Object)admissionEntity));
                return;
            }
            UserUniqueIdentifyReqVo userUniqueIdentifyReqVo = new UserUniqueIdentifyReqVo();
            userUniqueIdentifyReqVo.setType(Integer.valueOf(2));
            userUniqueIdentifyReqVo.setUserId(order.getPatientUserId());
            userUniqueIdentifyReqVo.setUserType(Integer.valueOf(0));
            log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u67e5\u8be2\u652f\u4ed8\u5b9d\u4e2a\u4eba\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)userUniqueIdentifyReqVo));
            BaseResponse uniqueIdentify = this.nodeAccountFeignClient.getUniqueIdentify(userUniqueIdentifyReqVo);
            log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u67e5\u8be2\u652f\u4ed8\u5b9d\u4e2a\u4eba\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)uniqueIdentify));
            if (null == uniqueIdentify || null == uniqueIdentify.getData()) {
                log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u67e5\u8be2\u652f\u4ed8\u5b9d\u4e2a\u4eba\u4e3a\u7a7a\uff0c\u505c\u6b62\u6267\u884c:{}", (Object)JSONObject.toJSONString((Object)userUniqueIdentifyReqVo));
                return;
            }
            AlipayCommerceMedicalIndustrydataInquiryorderUploadModel orders = new AlipayCommerceMedicalIndustrydataInquiryorderUploadModel();
            orders.setAlipayOpenId(null);
            orders.setAlipayUserId(((UserUniqueIdentifyRespVo)uniqueIdentify.getData()).getUniqueIdentify());
            orders.setAmount(order.getPayAmount().toString());
            orders.setDepartmentName(order.getDeptName());
            orders.setDoctorName(order.getDoctorName());
            orders.setHospitalName(order.getHospitalName());
            orders.setInquiryMode(IMAGE_INQUIRY);
            orders.setInquiryType(order.getServType().equals(2) ? FIRST_CONSULTATION : FURTHER_CONSULTATION);
            orders.setMerchantDoctorId(order.getDoctorId());
            orders.setMerchantOrderLinkPage("alipays://platformapi/startapp?appId=2021003164692422&page=pages/message/list/index");
            orders.setMerchantOrderStatus(this.setMerchantOrderStatus(admissionEntity, order));
            orders.setMerchantUserId(order.getPatientUserId());
            orders.setOrderCreateTime(DateUtils.dateToFullString((Date)order.getXCreateTime()));
            orders.setOrderModifiedTime(DateUtils.dateToFullString((Date)order.getXUpdateTime()));
            orders.setOrderType(INQUIRY_ORDER);
            orders.setOutBizNo(doctorMessageEventsVo.getOrderId());
            orders.setOutBizType(INQUIRY_ORDER);
            orders.setPlatformCode(null);
            orders.setScheduledTime(null);
            log.info("\u63a8\u9001\u8ba2\u5355\u5230\u652f\u4ed8\u5b9d:{}", (Object)JSONObject.toJSONString((Object)orders));
            AlipayCommerceMedicalIndustrydataInquiryorderUploadResponse response = this.aliMedicalPushService.orderUpload(orders);
            if (response.isSuccess()) {
                log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u8c03\u7528\u6210\u529f:{}", (Object)JSONObject.toJSONString((Object)response));
                if (redisisTrue) {
                    this.redisUtil.set(ALI_ORDERS + doctorMessageEventsVo.getOrderId(), JSONObject.toJSONString((Object)order), 604800L);
                }
            } else {
                log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f-\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + response.getMsg() + "\uff0c" + response.getSubMsg());
            }
            log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606fmq\u5b8c\u6210\uff0c\u7ed3\u679c{}", (Object)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606fmq\u6d88\u8d39\u5f02\u5e38" + e);
        }
        log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606fmq\u6d88\u8d39\u5b8c\u6bd5!");
    }

    private String setMerchantOrderStatus(AdmissionEntity admissionEntity, OrderEntity order) {
        if (order.getStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
            return AliOrderStatusEnum.WAIT_PAY.getDesc();
        }
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
            return AliOrderStatusEnum.WAIT_RECEPTION.getDesc();
        }
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.WAIT_ADMISSION.getValue())) {
            return AliOrderStatusEnum.WAIT_INQUIRY.getDesc();
        }
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
            return AliOrderStatusEnum.IN_INQUIRY.getDesc();
        }
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.FINISH_TIME_OUT.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.REFERRAL.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue())) {
            return AliOrderStatusEnum.FINISHED.getDesc();
        }
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.CANCEL.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.EXPIRED.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.PASSNUMBER.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.ADMIN_REFUNDED.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue())) {
            return AliOrderStatusEnum.CANCELED.getDesc();
        }
        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.REFUNDED_APPLY.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.RETIRED.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue())) {
            return AliOrderStatusEnum.REFUNDED.getDesc();
        }
        return null;
    }
}

