/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.electronicInvoice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.electronicInvoice.InvoiceService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.electronicInvoice.InvoiceRequestBodyVO;
import com.ebaiyihui.onlineoutpatient.core.vo.electronicInvoice.InvoiceRequestChargeDetailVO;
import com.ebaiyihui.onlineoutpatient.core.vo.electronicInvoice.InvoiceRequestListDetailVO;
import com.ebaiyihui.onlineoutpatient.core.vo.electronicInvoice.InvoiceRequestPayChannelDetailVO;
import com.ebaiyihui.onlineoutpatient.core.vo.electronicInvoice.InvoiceResponseBaseDto;
import com.ebaiyihui.onlineoutpatient.core.vo.electronicInvoice.InvoiceResponseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceServiceImpl.class);
    private static final String CREATEINVOICE = "createInvoice";
    private static final String WRITEOFFINVOICE = "writeOffInvoice";
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private CardServiceApi cardServiceApi;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProjProperties projProperties;

    public BaseResponse<String> operaInvoice(OrderEntity orderEntity, String type) {
        orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)orderEntity.getXId()));
        String url = this.projProperties.getInvoice();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        String patientNo = patientEntity.getCardNo();
        if ("1".equals(type)) {
            type = CREATEINVOICE;
            url = url + type;
            InvoiceRequestBodyVO invoiceRequestBodyVO = new InvoiceRequestBodyVO();
            ArrayList<InvoiceRequestChargeDetailVO> chargeDetail = new ArrayList<InvoiceRequestChargeDetailVO>();
            InvoiceRequestChargeDetailVO invoiceRequestChargeDetailVO = new InvoiceRequestChargeDetailVO();
            invoiceRequestChargeDetailVO.setSortNo("1");
            invoiceRequestChargeDetailVO.setNumber("1");
            invoiceRequestChargeDetailVO.setUnit("\u6b21");
            invoiceRequestChargeDetailVO.setStd(orderEntity.getPayAmount().toString());
            invoiceRequestChargeDetailVO.setAmt(orderEntity.getPayAmount().toString());
            invoiceRequestChargeDetailVO.setSelfAmt(orderEntity.getPayAmount().toString());
            invoiceRequestChargeDetailVO.setChargeName("\u8bca\u67e5\u8d39");
            invoiceRequestChargeDetailVO.setChargeCode("44702");
            chargeDetail.add(invoiceRequestChargeDetailVO);
            invoiceRequestBodyVO.setChargeDetail(chargeDetail);
            invoiceRequestBodyVO.setAppCode(orderEntity.getAppCode());
            invoiceRequestBodyVO.setHospitalId(orderEntity.getHospitalId());
            invoiceRequestBodyVO.setServiceName("ZXFZ");
            invoiceRequestBodyVO.setPatientId(patientNo);
            invoiceRequestBodyVO.setPayer(patientEntity.getPatientName());
            invoiceRequestBodyVO.setCardNo(patientEntity.getCardNo());
            invoiceRequestBodyVO.setSelfCashPay(orderEntity.getPayAmount().toString());
            invoiceRequestBodyVO.setTel(patientEntity.getTelphone());
            invoiceRequestBodyVO.setMedicalCareType("\u81ea\u8d39");
            invoiceRequestBodyVO.setBusType("02");
            invoiceRequestBodyVO.setPatientNo(patientNo);
            String date = DateUtils.dateToFullString((Date)new Date());
            invoiceRequestBodyVO.setBusDateTime(date);
            invoiceRequestBodyVO.setTotalAmt(orderEntity.getPayAmount().toString());
            invoiceRequestBodyVO.setPatientCategoryCode(orderEntity.getDeptId().toString());
            invoiceRequestBodyVO.setIdCardNo(patientEntity.getIdcard());
            invoiceRequestBodyVO.setPatientCategory(orderEntity.getDeptName());
            ArrayList<InvoiceRequestPayChannelDetailVO> payChannelDetail = new ArrayList<InvoiceRequestPayChannelDetailVO>();
            InvoiceRequestPayChannelDetailVO invoiceRequestPayChannelDetailVO = new InvoiceRequestPayChannelDetailVO();
            invoiceRequestPayChannelDetailVO.setPayChannelCode("02");
            invoiceRequestPayChannelDetailVO.setPayChannelValue(orderEntity.getPayAmount().toString());
            payChannelDetail.add(invoiceRequestPayChannelDetailVO);
            invoiceRequestBodyVO.setPayChannelDetail(payChannelDetail);
            ArrayList<InvoiceRequestListDetailVO> listDetail = new ArrayList<InvoiceRequestListDetailVO>();
            InvoiceRequestListDetailVO invoiceRequestListDetailVO = new InvoiceRequestListDetailVO();
            invoiceRequestListDetailVO.setStd(orderEntity.getPayAmount().toString());
            invoiceRequestListDetailVO.setCode("30006");
            invoiceRequestListDetailVO.setAmt(orderEntity.getPayAmount().toString());
            invoiceRequestListDetailVO.setSortNo("1");
            invoiceRequestListDetailVO.setNumber("1");
            invoiceRequestListDetailVO.setName("\u6025\u8bca\u8bca\u67e5\u8d39");
            invoiceRequestListDetailVO.setSelfAmt(orderEntity.getPayAmount().toString());
            invoiceRequestListDetailVO.setChargeName("\u8bca\u67e5\u8d39");
            invoiceRequestListDetailVO.setChargeCode("44702");
            listDetail.add(invoiceRequestListDetailVO);
            invoiceRequestBodyVO.setListDetail(listDetail);
            invoiceRequestBodyVO.setSex(patientEntity.getGender() == 1 ? "\u7537" : "\u5973");
            invoiceRequestBodyVO.setCardType("1101");
            invoiceRequestBodyVO.setOwnPay(orderEntity.getPayAmount().toString());
            invoiceRequestBodyVO.setOtherfundPay("0");
            invoiceRequestBodyVO.setPayerType("1");
            invoiceRequestBodyVO.setConsultationDate(date);
            invoiceRequestBodyVO.setBusNo(orderEntity.getXId());
            try {
                Integer age = IDCardUtil.getAge((String)patientEntity.getIdcard());
                invoiceRequestBodyVO.setAge(age.toString());
            }
            catch (Exception e) {
                log.error("\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u60a3\u8005\u5e74\u9f84\u5931\u8d25\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801={}", (Throwable)e);
            }
            try {
                String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)invoiceRequestBodyVO));
                InvoiceResponseBaseDto invoiceResponseBaseDto = (InvoiceResponseBaseDto)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), InvoiceResponseBaseDto.class);
                log.info("invoiceResponseBaseDto:{}", (Object)JSON.toJSONString((Object)invoiceResponseBaseDto));
                if (null == invoiceResponseBaseDto || !"1".equals(invoiceResponseBaseDto.getCode())) {
                    log.info("\u5f00\u5177\u53d1\u7968\u5931\u8d25");
                    return BaseResponse.error((String)"\u5f00\u5177\u53d1\u7968\u5931\u8d25");
                }
                InvoiceResponseVO invoiceResponseVO = (InvoiceResponseVO)JSON.parseObject((String)JSON.toJSONString((Object)invoiceResponseBaseDto.getData()), InvoiceResponseVO.class);
                orderEntity.setInvoicePicture(invoiceResponseVO.getPictureNetUrl());
                this.orderMapper.updateOrderEntity(orderEntity);
            }
            catch (Exception e) {
                log.info("\u5f00\u5177\u53d1\u7968\u51fa\u9519" + e);
                return BaseResponse.error((String)"\u5f00\u5177\u53d1\u7968\u5931\u8d25");
            }
            log.info("\u5f00\u5177\u53d1\u7968\u6210\u529f");
            return BaseResponse.success((Object)"\u5f00\u5177\u53d1\u7968\u6210\u529f");
        }
        type = WRITEOFFINVOICE;
        url = url + type;
        InvoiceRequestBodyVO invoiceRequestBodyVO1 = new InvoiceRequestBodyVO();
        invoiceRequestBodyVO1.setBusNo(orderEntity.getXId());
        invoiceRequestBodyVO1.setPatientId(patientNo);
        invoiceRequestBodyVO1.setAppCode(orderEntity.getAppCode());
        invoiceRequestBodyVO1.setHospitalId(orderEntity.getHospitalId());
        invoiceRequestBodyVO1.setServiceName("ZXFZ");
        invoiceRequestBodyVO1.setBusType("02");
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)invoiceRequestBodyVO1));
            InvoiceResponseBaseDto invoiceResponseBaseDto = (InvoiceResponseBaseDto)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), InvoiceResponseBaseDto.class);
            log.info("invoiceResponseBaseDto:{}", (Object)JSON.toJSONString((Object)invoiceResponseBaseDto));
            if (null == invoiceResponseBaseDto || !"1".equals(invoiceResponseBaseDto.getCode())) {
                log.info("\u51b2\u7ea2\u53d1\u7968\u5931\u8d25");
                return BaseResponse.error((String)"\u51b2\u7ea2\u53d1\u7968\u5931\u8d25");
            }
            InvoiceResponseVO invoiceResponseVO = (InvoiceResponseVO)JSON.parseObject((String)JSON.toJSONString((Object)invoiceResponseBaseDto.getData()), InvoiceResponseVO.class);
            orderEntity.setRedInvoicePicture(invoiceResponseVO.getPictureNetUrl());
            this.orderMapper.updateOrderEntity(orderEntity);
        }
        catch (Exception e) {
            log.info("\u51b2\u7ea2\u53d1\u7968\u51fa\u9519" + e);
            return BaseResponse.error((String)"\u51b2\u7ea2\u53d1\u7968\u5931\u8d25");
        }
        log.info("\u51b2\u7ea2\u53d1\u7968\u6210\u529f");
        return BaseResponse.success((Object)"\u51b2\u7ea2\u53d1\u7968\u6210\u529f");
    }
}

