/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.health.management.common.vo.OnlineOutpatientUsageReqVo;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.MangerRefundReq;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServerTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ManagerAdvisoryService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.client.ServicepkgServiceOrderFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.mobile.MobileBenefitPackageService;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagerAdvisoryServiceImpl
implements ManagerAdvisoryService {
    private static final Logger log = LoggerFactory.getLogger(ManagerAdvisoryServiceImpl.class);
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    @Autowired
    private ServicepkgServiceOrderFeignClient servicepkgServiceOrderFeignClient;
    @Autowired
    private MobileBenefitPackageService mobileBenefitPackageService;

    public ResultData<Object> managerRefund(MangerRefundReq param) {
        ResultData resultData;
        ResultData result = new ResultData();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(param.getAdmissionId());
        if (admissionEntity == null) {
            return result.error("\u5c31\u8bca\u4fe1\u606f\u4e3a\u7a7a");
        }
        log.info("admissionEntity:{}" + JSON.toJSONString((Object)admissionEntity));
        OrderEntity order = this.orderMapper.findById(admissionEntity.getOrderId());
        if (order == null) {
            return result.error("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if ("2".equals(order.getFundType())) {
            return result.success((Object)"\u533b\u4fdd\u8ba2\u5355\u6682\u4e0d\u652f\u6301\u7ba1\u7406\u7aef\u9000\u6b3e\uff01");
        }
        if (PayChannelEnum.PACKAGE.getPayChannel().equals(order.getPayMethod())) {
            OnlineOutpatientUsageReqVo outpatientUsageReqVo = new OnlineOutpatientUsageReqVo();
            outpatientUsageReqVo.setId(Long.valueOf(Long.parseLong(order.getDealSeq().split("_")[0])));
            BaseResponse baseResponse = null;
            if (ServerTypeEnum.ONLINE_CONSULTATION.getValue().equals(String.valueOf(order.getServType()))) {
                baseResponse = this.servicepkgServiceOrderFeignClient.increaseOnlineOutpatientUsage(outpatientUsageReqVo);
                log.info("\u670d\u52a1\u5305\u9000\u6b3e\u7ed3\u679c\uff1a{}", (Object)baseResponse.toString());
                if (!baseResponse.isSuccess()) {
                    return result.error("\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u5305\u9000\u6b3e\u5931\u8d25");
                }
            } else if (ServerTypeEnum.FOLLOW_UP.getValue().equals(String.valueOf(order.getServType()))) {
                baseResponse = this.servicepkgServiceOrderFeignClient.increaseFollowUpOutpatientUsage(outpatientUsageReqVo);
                log.info("\u670d\u52a1\u5305\u9000\u6b3e\u7ed3\u679c\uff1a{}", (Object)baseResponse.toString());
                if (!baseResponse.isSuccess()) {
                    return result.error("\u590d\u8bca\u5f00\u836f\u670d\u52a1\u5305\u9000\u6b3e\u5931\u8d25");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)admissionEntity.getPackageId()) && !(resultData = this.mobileBenefitPackageService.refundBenefitService(order, admissionEntity.getPackageId())).isSuccess()) {
            return resultData;
        }
        log.info("order:{}" + JSON.toJSONString((Object)order));
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(order.getAppCode());
        inquiryMchCodeEntity.setHospitalId(order.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u5546\u6237\u53f7\u6216his");
        }
        if (0 == order.getPayAmount().compareTo(new BigDecimal(0.0))) {
            this.orderMapper.updateStatusById(admissionEntity.getOrderId(), OrderStatusEnum.EXPIRED.getValue());
        } else {
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(order.getXId());
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
        }
        if (Objects.equals(admissionEntity.getStatus(), AdmissionStatusEnum.WAIT_ADMISSION.getValue())) {
            admissionEntity.setStatus(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue());
        } else {
            admissionEntity.setStatus(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
        }
        admissionEntity.setXRemark(param.getReason());
        this.admissionMapper.update(admissionEntity);
        if (StringUtils.isNotEmpty((String)order.getScheduleId())) {
            log.info("\u9884\u7ea6\u8ba2\u5355\u589e\u52a0\u6392\u73ed:{}", (Object)order.getScheduleId());
            this.scheduleRecordMapper.addAvailableCount(Long.valueOf(Long.parseLong(order.getScheduleId())));
        }
        if (null != param.getIsRefund() && param.getIsRefund().equals(1)) {
            log.info("\u7ba1\u7406\u7aef\u9000\u6b3e");
            this.imInformService.managerRefund(admissionEntity.getXId());
        } else {
            log.info("\u7533\u8bc9\u9000\u6b3e");
            this.imInformService.doctorRefundAppeal(admissionEntity.getXId(), admissionEntity.getDoctorId());
        }
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(order.getXId()));
        return result.success((Object)"\u9000\u6b3e\u6210\u529f");
    }

    private int differentDays(Date startDate, Date endDate) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        int startDay = startCalendar.get(6);
        int endDay = endCalendar.get(6);
        int startYear = startCalendar.get(1);
        int endYear = endCalendar.get(1);
        if (startYear != endYear) {
            int timeDistance = 0;
            for (int i = startYear; i < endYear; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (endDay - startDay);
        }
        return endDay - startDay;
    }
}

