/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.UcUserEvaluationVO;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.doctoruser.api.pojo.base.dto.FeignQueryDocAndTeamInfoDTO;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.dto.verify.DocAllInfoDto;
import com.doctoruser.api.pojo.base.vo.DoctorAllInfoVo;
import com.doctoruser.api.pojo.base.vo.FeignQueryDocAndTeamInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailQueryReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailRespVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.onlineoutpatient.common.dto.GetDoctorNetinquiryOrdersDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryDoctorNetinquiryOrdersDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryPatientNetinquiryOrdersDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QuiryDoctorNetinquiryOrderDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QuiryPatientNetinquiryOrderDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.OrderInfoDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.OrderCreateDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.OrderCreateResponseDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.QueryNoSourceDto;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.util.SystemConstants;
import com.ebaiyihui.onlineoutpatient.common.vo.CancelOrderReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorNetinquiryOrderListVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DrugsNewVo;
import com.ebaiyihui.onlineoutpatient.common.vo.GetCardNoReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.GetPayRecordDetailReq;
import com.ebaiyihui.onlineoutpatient.common.vo.GetPayRecordDetailRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientNetinquiryOrderListVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PrescriptionsNewVo;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportReq;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportRes;
import com.ebaiyihui.onlineoutpatient.common.vo.ServiceConfigVo;
import com.ebaiyihui.onlineoutpatient.common.vo.UpdateOrderForReconciliationReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordDetailReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordDetailResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.OnlineOutPatientUseRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.PatientNetOrderVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.PatientNetOrderVoRes;
import com.ebaiyihui.onlineoutpatient.common.vo.order.PatientNetOrdersReq;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ReqDoctorMedicalRecordsInfoVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ReqDoctorMedicalRecordsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ResDoctorMedicalRecordsInfoVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ResDoctorMedicalRecordsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core.MedicarePaymentService;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core.UpdateOrderRecordService;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ChannelCodeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.DoctorNetinquiryOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.GenderEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.JxHosNameEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrganTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PatientNetinquiryOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.SubscribeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalPictureMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.EvaluationEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleTimeIntervalEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorUserEvaluationFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseEvaluationServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseScheduleTimeIntervalServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.GnHisManagerService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.PageUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.ActivityRegisteredReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetCardNoResVoNew;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPatientPayInfoVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPatientPayOrderDetailVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPatientPaySuccessInfoVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.HisMedicalsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InternetHospitalEntity;
import com.ebaiyihui.onlineoutpatient.core.vo.MedOrderVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderCheckForPlatformReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderCheckPlatVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.QueryOrderDto;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqPatientPayOrderListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientInformationVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientPayOrderListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PatientInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.TransModelVo;
import com.ebaiyihui.onlineoutpatient.core.vo.workservice.GetDocServiceConfigReq;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdVo;
import com.ebaiyihui.usercenter.client.CardClient;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    public static final Integer UPDATE_ORDER_STATUS_SIGN = 2;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;
    @Autowired
    private BaseInquiryServiceConfigServiceImpl baseService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private CardClient cardClient;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private PatientMedicalPictureMapper patientMedicalPictureMapper;
    @Autowired
    private BaseScheduleTimeIntervalServiceImpl baseScheduleTimeIntervalService;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private DoctorUserEvaluationFeignClient doctorUserEvaluationFeignClient;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;
    @Autowired
    private DoctorUserEvaluationFeignClient evaluationFeignClient;
    @Autowired
    private BaseEvaluationServiceImpl baseEvaluationService;
    @Autowired
    private MedicarePaymentService medicarePaymentService;
    @Autowired
    private UpdateOrderRecordService updateOrderRecordService;
    @Autowired
    private CardServiceApi cardServiceApi;
    @Autowired
    private GnHisManagerService gnHisManagerService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String ONE = "1";
    private static final String ONE_ONE = "-1";
    private static final String STATUS_DESC = "\u5df2\u5931\u6548";

    public void updateStatusById(String id, Integer status) {
        this.orderMapper.updateStatusById(id, status);
    }

    public OrderEntity findById(String id) {
        return this.orderMapper.findById(id);
    }

    public BaseResponse<OrderCreateResponseDTO> createOrder(OrderCreateDTO orderCreateDTO) {
        HisDeptAndDocCodeVo hisDeptAndDocCode;
        log.info("\u5165\u53c2orderCreateDTO:" + orderCreateDTO.toString());
        ServiceConfigVo serviceConfig = this.calculateOrderPrice(orderCreateDTO.getOrganId(), orderCreateDTO.getDoctorId(), orderCreateDTO.getServType(), orderCreateDTO.getDeptId());
        if (serviceConfig == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)orderCreateDTO.getScheduleDate()) && StringUtils.isEmpty((String)orderCreateDTO.getScheduleId())) {
            String scheduleDate = DateUtils.dateToSimpleString((Date)new Date());
            Integer orderCount = this.orderMapper.countDoctorTodayOrders(orderCreateDTO.getDoctorId(), orderCreateDTO.getOrganId(), scheduleDate, orderCreateDTO.getServType());
            if (orderCount >= serviceConfig.getDailyLimit() && -1 != serviceConfig.getDailyLimit()) {
                return BaseResponse.error((String)"\u533b\u751f\u5f53\u65e5\u670d\u52a1\u5df2\u8fbe\u4e0a\u9650");
            }
        } else {
            if (StringUtils.isEmpty((String)orderCreateDTO.getScheduleId())) {
                return BaseResponse.error((String)"\u6392\u73ed\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            QueryWrapper objectQueryWrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setId(Long.valueOf(orderCreateDTO.getScheduleId()));
            objectQueryWrapper.setEntity((Object)scheduleRecordEntity);
            ScheduleRecordEntity scheduleRecordEntity1 = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)objectQueryWrapper);
            log.info("scheduleRecordEntity1{}", (Object)JSON.toJSONString((Object)scheduleRecordEntity1));
            if (scheduleRecordEntity1.getAvailableCount() <= 0) {
                return BaseResponse.error((String)"\u533b\u751f\u5f53\u65e5\u670d\u52a1\u5df2\u8fbe\u4e0a\u9650");
            }
        }
        BigDecimal doctorPrice = serviceConfig.getPrice();
        String serviceName = ServiceTypeEnum.getDesc((Integer)orderCreateDTO.getServType());
        OrderEntity orderEntity = new OrderEntity();
        if (StringUtils.isBlank((String)orderCreateDTO.getAppCode())) {
            InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(orderCreateDTO.getHospitalId(), this.projProperties.getInternetHospitalUrl());
            if (StringUtils.isNotBlank((String)internetHospitalEntity.getAppCode())) {
                orderEntity.setAppCode(internetHospitalEntity.getAppCode());
            }
        } else {
            orderEntity.setAppCode(orderCreateDTO.getAppCode());
        }
        OrderCreateResponseDTO responseDTO = new OrderCreateResponseDTO();
        orderEntity.setHospitalId(orderCreateDTO.getHospitalId());
        orderEntity.setHospitalName(orderCreateDTO.getHospitalName());
        orderEntity.setOrganId(orderCreateDTO.getHospitalId());
        orderEntity.setDoctorId(orderCreateDTO.getDoctorId());
        orderEntity.setPatientId(orderCreateDTO.getPatientId());
        orderEntity.setDoctorType(orderCreateDTO.getDoctorType());
        orderEntity.setMedicalRecordId(orderCreateDTO.getMedicalRecordId());
        orderEntity.setPayAmount(doctorPrice);
        orderEntity.setServType(orderCreateDTO.getServType());
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        orderEntity.setPatientUserId(orderCreateDTO.getPatientUserId());
        orderEntity.setHospFlag(orderCreateDTO.getHospFlag());
        if (orderCreateDTO.getDeptId() != null) {
            orderEntity.setDeptId(Long.valueOf(orderCreateDTO.getDeptId()));
        }
        if (orderCreateDTO.getDeptName() != null) {
            orderEntity.setDeptName(orderCreateDTO.getDeptName());
        }
        orderEntity.setDoctorName(orderCreateDTO.getDoctorName());
        orderEntity.setDealSeq(UUIDUtil.generateViewId());
        if (null != orderCreateDTO.getScheduleDate() && StringUtils.isNotEmpty((String)orderCreateDTO.getScheduleId())) {
            Date date = null;
            try {
                date = DateUtils.strToDate((String)orderCreateDTO.getScheduleDate(), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            QueryWrapper objectQueryWrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setId(Long.valueOf(orderCreateDTO.getScheduleId()));
            objectQueryWrapper.setEntity((Object)scheduleRecordEntity);
            ScheduleRecordEntity scheduleOne = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)objectQueryWrapper);
            log.info("scheduleOne{}", (Object)JSON.toJSONString((Object)scheduleOne));
            orderEntity.setScheduleStartTime(scheduleOne.getStartTime());
            orderEntity.setScheduleEndTime(scheduleOne.getEndTime());
            orderEntity.setScheduleId(orderCreateDTO.getScheduleId());
            responseDTO.setScheduleStartTime(orderEntity.getScheduleStartTime());
            responseDTO.setScheduleEndTime(orderEntity.getScheduleEndTime());
            responseDTO.setScheduleDate(orderCreateDTO.getScheduleDate());
            responseDTO.setScheduleRange(orderCreateDTO.getScheduleRange());
            orderEntity.setScheduleRange(orderCreateDTO.getScheduleRange());
            orderEntity.setScheduleDate(date);
        }
        orderEntity.setServTime(serviceConfig.getServTime());
        orderEntity.setTotalNum(serviceConfig.getNumLimit());
        orderEntity.setXVersion(Long.valueOf(0L));
        String uuid = UUIDUtil.generateViewId();
        orderEntity.setXId(uuid);
        orderEntity.setIdCard(orderCreateDTO.getIdcard());
        log.info("orderEntity:{}" + orderEntity.toString());
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(orderCreateDTO.getAppCode());
        inquiryMchCodeEntity.setHospitalId(orderCreateDTO.getOrganId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        log.info("entity:{}" + JSON.toJSONString((Object)entity));
        if (StringUtils.isEmpty((String)entity.getHisUrl()) || null == entity) {
            log.info("\u6ca1\u6709\u914d\u7f6ehis");
            BigDecimal bigDecimal = doctorPrice.setScale(2, 4);
            responseDTO.setOwnCost(bigDecimal.toString());
        }
        if (null == (hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(orderCreateDTO.getDeptId(), orderCreateDTO.getDoctorId()))) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u8c03\u7528\u51fa\u9519");
        }
        PatientEntity patientEntity = this.patientMapper.selectById(orderCreateDTO.getPatientId());
        if (orderCreateDTO.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != patientEntity && null != entity && StringUtils.isNotEmpty((String)entity.getHisUrl()) && "HYT".equals(entity.getAppCode()) && this.HYTPreSettlement(orderCreateDTO, doctorPrice, orderEntity, responseDTO, entity, hisDeptAndDocCode, patientEntity)) {
            return BaseResponse.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25,\u8bf7\u52ff\u4e0b\u5355");
        }
        if (orderCreateDTO.getServType().equals(ServiceTypeEnum.NOS.getValue()) && "HYT".equals(orderEntity.getAppCode())) {
            orderEntity.setFundType(patientEntity.getFundType());
        }
        responseDTO.setOrderId(uuid);
        responseDTO.setDealSeq(orderEntity.getDealSeq());
        responseDTO.setOrderSeq(orderEntity.getOrderSeq());
        responseDTO.setXCreateTime(orderEntity.getXCreateTime());
        responseDTO.setServiceName(serviceName);
        responseDTO.setPayAmount(orderEntity.getPayAmount());
        responseDTO.setPayPrice(doctorPrice);
        responseDTO.setHospitalName(orderEntity.getHospitalName());
        responseDTO.setDeptName(orderEntity.getDeptName());
        responseDTO.setDocName(orderEntity.getDoctorName());
        AdmissionEntity admissionEntity = this.createAdmissionEntity(orderEntity);
        admissionEntity.setServTime(orderEntity.getServTime());
        admissionEntity.setTotalNum(orderEntity.getTotalNum());
        admissionEntity.setCurrentNum(orderEntity.getTotalNum());
        admissionEntity.setDoctorName(orderEntity.getDoctorName());
        admissionEntity.setOrganId(orderEntity.getHospitalId());
        admissionEntity.setPauseTime(Long.valueOf(0L));
        admissionEntity.setXId(UUIDUtil.getUUID());
        log.info("\u8ba2\u5355:" + JSON.toJSONString((Object)orderEntity));
        Integer insert = this.orderMapper.insert((Object)orderEntity);
        if (StringUtils.isEmpty((String)orderEntity.getTotCost()) && doctorPrice.compareTo(BigDecimal.ZERO) == 0) {
            log.info("0\u539f\u8ba2\u5355\u65b0\u589e");
            orderEntity.setPaymentTime(new Date());
            orderEntity.setPayMethod(ChannelCodeEnum.NOPAY.getValue());
            orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
            orderEntity.setXId(orderEntity.getXId());
            log.info("\u65b0\u589eorderEntity:" + orderEntity.toString());
            this.orderMapper.updateById((Object)orderEntity);
            log.info("\u66f4\u65b0\u540eorderEntity:" + orderEntity.toString());
            if (null != orderEntity.getScheduleDate() && StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
                log.info("\u6392\u73ed0\u5143\u65b0\u589e");
                admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
                Date scheduleDate = orderEntity.getScheduleDate();
                String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
                String scheduleEndTime = orderEntity.getScheduleEndTime();
                String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
                Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
                admissionEntity.setEndTime(expirationDateTime);
            } else {
                log.info("\u975e\u6392\u73ed0\u5143\u65b0\u589e");
                admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
                admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
            }
            log.info("admissionEntity{}", (Object)JSON.toJSONString((Object)admissionEntity));
            Integer insertAdmissionRes = this.admissionMapper.insertAdvisoryRecord(admissionEntity);
            if (null != orderCreateDTO.getScheduleDate() && StringUtils.isNotEmpty((String)orderCreateDTO.getScheduleId())) {
                QueryWrapper objectQueryWrapper = new QueryWrapper();
                ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
                scheduleRecordEntity.setId(Long.valueOf(orderCreateDTO.getScheduleId()));
                objectQueryWrapper.setEntity((Object)scheduleRecordEntity);
                ScheduleRecordEntity scheduleRecordOne = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)objectQueryWrapper);
                if (null != scheduleRecordOne) {
                    this.scheduleRecordMapper.reduceAvailableCount(scheduleRecordOne.getId());
                }
                OrderTaskVo orderTaskVo3 = new OrderTaskVo();
                orderTaskVo3.setType(Integer.valueOf(3));
                orderTaskVo3.setId(uuid);
                this.orderSender.sendDelay(orderTaskVo3);
                OrderTaskVo orderTaskVo4 = new OrderTaskVo();
                orderTaskVo4.setType(Integer.valueOf(4));
                orderTaskVo4.setId(uuid);
                this.orderSender.sendDelay(orderTaskVo4);
            }
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(uuid);
            this.orderSender.sendDelay(orderTaskVo2);
            this.payAsyncService.createImSession(orderEntity, admissionEntity);
            this.payAsyncService.asyncTask(orderEntity, admissionEntity);
            return BaseResponse.success((Object)responseDTO);
        }
        orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
        admissionEntity.setStatus(Integer.valueOf(0));
        log.info("\u975e0\u5143\u8ba2\u5355\u65b0\u589e\u521b\u5efa\u8ba2\u5355\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderEntity));
        orderEntity.setXId(orderEntity.getXId());
        this.baseInquiryOrderService.updateById((Object)orderEntity);
        log.info("\u975e0\u5143\u65b0\u589e\u521b\u5efa\u5c31\u8bca\u53c2\u6570\uff1a" + admissionEntity.toString());
        Integer insertAdmissionRes = this.admissionMapper.insertAdvisoryRecord(admissionEntity);
        if (null != orderEntity.getScheduleDate() && StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
            Date date = null;
            try {
                date = DateUtils.strToDate((String)orderCreateDTO.getScheduleDate(), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            QueryWrapper objectQueryWrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setId(Long.valueOf(orderCreateDTO.getScheduleId()));
            objectQueryWrapper.setEntity((Object)scheduleRecordEntity);
            ScheduleRecordEntity scheduleRecordOne = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)objectQueryWrapper);
            if (null != scheduleRecordOne) {
                this.scheduleRecordMapper.reduceAvailableCount(scheduleRecordOne.getId());
            }
        }
        OrderTaskVo orderTaskVo1 = new OrderTaskVo();
        orderTaskVo1.setType(Integer.valueOf(1));
        orderTaskVo1.setId(uuid);
        log.info("\u8fc7\u671f\u672a\u652f\u4ed8\u53d6\u6d88\u8ba2\u5355\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570\uff1a{}", (Object)orderTaskVo1.toString());
        this.orderSender.sendDelay(orderTaskVo1);
        this.payAsyncService.createImSession(orderEntity, admissionEntity);
        log.info("\u521b\u5efa\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\uff1a" + JSON.toJSONString((Object)responseDTO));
        return BaseResponse.success((Object)responseDTO);
    }

    private boolean HYTPreSettlement(OrderCreateDTO orderCreateDTO, BigDecimal doctorPrice, OrderEntity orderEntity, OrderCreateResponseDTO responseDTO, InquiryMchCodeEntity entity, HisDeptAndDocCodeVo hisDeptAndDocCode, PatientEntity patientEntity) {
        log.info("patientEntity:" + patientEntity.toString());
        log.info("entity:{}" + entity.toString());
        PreSettlementReqVo preSettlementReqVo = new PreSettlementReqVo();
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setBirthDay(patientEntity.getBirthDates());
        patientInfoVo.setCardNO(patientEntity.getMedicalNO());
        patientInfoVo.setSex(patientEntity.getGender().toString());
        patientInfoVo.setPhone(patientEntity.getAccountPhone());
        patientInfoVo.setName(patientEntity.getPatientName());
        patientInfoVo.setPactCode(patientEntity.getPactCode());
        patientInfoVo.setIdCard(orderCreateDTO.getCredNo());
        patientInfoVo.setAddress(patientEntity.getAddress());
        TransModelVo transModelVo = new TransModelVo();
        transModelVo.setMachineNO("byhl");
        transModelVo.setTransNO("");
        transModelVo.setBankTransNO("");
        preSettlementReqVo.setTransModelVo(transModelVo);
        preSettlementReqVo.setPatientInfoVo(patientInfoVo);
        preSettlementReqVo.setDeptCode(hisDeptAndDocCode.getDeptCode());
        preSettlementReqVo.setDoctCode(hisDeptAndDocCode.getDoctorCode());
        preSettlementReqVo.setRegLeve("15");
        preSettlementReqVo.setRegLeveName("\u4e92\u8054\u7f51\u590d\u8bca\u53f7");
        preSettlementReqVo.setRegType("0");
        preSettlementReqVo.setFundType(patientEntity.getFundType());
        preSettlementReqVo.setHospFlag(orderCreateDTO.getHospFlag().toString());
        preSettlementReqVo.setMarkNO(patientEntity.getCardNo());
        preSettlementReqVo.setMarkType(patientEntity.getFundType());
        preSettlementReqVo.setNoonID("0");
        preSettlementReqVo.setOrderID("");
        preSettlementReqVo.setSchemaID("");
        preSettlementReqVo.setDeptName(hisDeptAndDocCode.getDeptName());
        preSettlementReqVo.setDoctName(hisDeptAndDocCode.getDoctorName());
        log.info("\u6302\u53f7\u9884\u7ed3\u7b97\u5165\u53c2:" + preSettlementReqVo.toString());
        PreSettlementResVo preSettlementResVo = this.hisTemplateService.preSettlement(preSettlementReqVo);
        if (null == preSettlementResVo || preSettlementResVo.getResult().equals(ONE_ONE)) {
            return true;
        }
        BeanUtils.copyProperties((Object)preSettlementResVo, (Object)orderEntity);
        BeanUtils.copyProperties((Object)preSettlementResVo, (Object)responseDTO);
        BigDecimal bd = new BigDecimal(preSettlementResVo.getPubCost());
        bd = bd.setScale(2, 4);
        log.info("\u7edf\u7b79\u91d1\u989d\u8f6c\u6362\u503c:" + JSON.toJSONString((Object)bd.toString()));
        BigDecimal price = doctorPrice.subtract(bd);
        price = price.setScale(2, 4);
        log.info("\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570:" + JSON.toJSONString((Object)price.toString()));
        responseDTO.setPrice(price.toString());
        orderEntity.setPrice(price.toString());
        BigDecimal bigDecimal = new BigDecimal(orderEntity.getTotCost());
        orderEntity.setPayAmount(bigDecimal);
        return false;
    }

    private ServiceConfigVo calculateOrderPrice(String organId, String doctorId, Integer servType, String deptId) {
        GetDocServiceConfigReq getServiceConfigReq = new GetDocServiceConfigReq();
        getServiceConfigReq.setDoctorId(doctorId);
        getServiceConfigReq.setOrganId(organId);
        getServiceConfigReq.setServType(servType);
        getServiceConfigReq.setDeptId(deptId);
        log.info("getServiceConfigReq:{}" + JSON.toJSONString((Object)getServiceConfigReq));
        ResultData resultData = this.inquiryServiceConfigService.getDoctorServiceInfo(getServiceConfigReq);
        log.info("\u533b\u751f\u670d\u52a1\u4fe1\u606f:{}", (Object)resultData);
        if (resultData == null || !resultData.isSuccess()) {
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        return (ServiceConfigVo)resultData.getData();
    }

    public ResultData<List<PatientNetinquiryOrderListVo>> getPatientNetinquiryOrders(QueryPatientNetinquiryOrdersDTO dto) {
        dto.setOrderStatus("");
        ArrayList admStatus = new ArrayList();
        this.getStatus(dto, admStatus);
        log.info("dto:{}" + dto.toString());
        ResultData result = new ResultData();
        Integer startRow = 20;
        startRow = null != dto.getPageSize() ? Integer.valueOf((dto.getPageNum() - 1) * dto.getPageSize()) : Integer.valueOf((dto.getPageNum() - 1) * CommonConstants.PAGE_SIZE);
        List dtoList = null;
        dtoList = StringUtils.isNotEmpty((String)dto.getBenefitPhone()) ? this.orderMapper.getPatientNetinquiryOrdersByBenefitPhone(dto.getBenefitPhone(), dto.getOrderStatus(), dto.getAdmStatus(), startRow, dto.getPageSize(), dto.getAppCode(), dto.getServType()) : this.orderMapper.getPatientNetinquiryOrders(dto.getUserId(), dto.getPatientId(), dto.getOrderStatus(), dto.getAdmStatus(), startRow, dto.getPageSize(), dto.getAppCode(), dto.getServType());
        if (dtoList == null || dtoList.isEmpty()) {
            return result.success();
        }
        log.info("dtoList:{}" + JSONObject.toJSONString((Object)dtoList));
        FeignQueryDocAndTeamInfoDTO req = this.buildFeignQueryDocAndTeamInfoReqForPatient(dtoList);
        log.info("\u4ece\u533b\u751f\u57fa\u7840\u670d\u52a1\u83b7\u53d6\u533b\u751f\u76f8\u5173\u4fe1\u606f\uff0c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)req));
        BaseResponse getInfos = this.doctorCilent.feignQueryDocAndTeamInfo(req);
        log.info("\u4ece\u533b\u751f\u57fa\u7840\u670d\u52a1\u83b7\u53d6\u533b\u751f\u76f8\u5173\u4fe1\u606f\uff0c\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)getInfos));
        FeignQueryDocAndTeamInfoVo res = null;
        if (getInfos != null && getInfos.isSuccess()) {
            res = (FeignQueryDocAndTeamInfoVo)getInfos.getData();
        }
        ArrayList<PatientNetinquiryOrderListVo> voList = new ArrayList<PatientNetinquiryOrderListVo>();
        for (QuiryPatientNetinquiryOrderDTO patientNetinquiryOrderDTO : dtoList) {
            Integer status;
            PatientNetinquiryOrderListVo vo = new PatientNetinquiryOrderListVo();
            BeanUtils.copyProperties((Object)patientNetinquiryOrderDTO, (Object)vo);
            log.info("vo:{}" + vo.toString());
            QueryWrapper wrapper = new QueryWrapper();
            InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
            inquiryMchCodeEntity.setAppCode(dto.getAppCode());
            inquiryMchCodeEntity.setHospitalId(patientNetinquiryOrderDTO.getOrganId());
            wrapper.setEntity((Object)inquiryMchCodeEntity);
            InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
            log.info("entity\u51fa\u53c2:{}" + JSON.toJSONString((Object)entity));
            if (patientNetinquiryOrderDTO.getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)entity.getHisUrl()) && 0 != patientNetinquiryOrderDTO.getPayAmount().compareTo(new BigDecimal(0.0)) && StringUtils.isNotEmpty((String)patientNetinquiryOrderDTO.getOwnCost())) {
                log.info("\u914d\u7f6ehis");
                BigDecimal bigDecimal = new BigDecimal(patientNetinquiryOrderDTO.getOwnCost()).setScale(2, 4);
                vo.setPayAmount(bigDecimal);
                vo.setPayPrice(vo.getPayAmount());
            } else {
                vo.setPayPrice(patientNetinquiryOrderDTO.getPayAmount());
            }
            PatientEntity patientEntity = this.patientMapper.selectById(patientNetinquiryOrderDTO.getPatientId());
            if (null != patientEntity) {
                vo.setIdCard(patientEntity.getIdcard());
                vo.setCardNo(patientEntity.getCardNo());
                vo.setFundType(patientEntity.getFundType());
            }
            vo.setCount(Integer.valueOf(1));
            if (res == null || res.getDoctorInfos() == null) {
                return result.error("\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            }
            List doctorInfoList = res.getDoctorInfos();
            for (DoctorAllInfoVo doctorAllInfoVo : doctorInfoList) {
                if (!patientNetinquiryOrderDTO.getDoctorId().equals(doctorAllInfoVo.getDoctorId()) || !patientNetinquiryOrderDTO.getOrganId().equals(doctorAllInfoVo.getOrganId())) continue;
                vo.setDoctorName(doctorAllInfoVo.getDoctorName());
                vo.setPortrait(doctorAllInfoVo.getPortrait());
                vo.setTitleName(doctorAllInfoVo.getHospitalTitle());
                break;
            }
            if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(patientNetinquiryOrderDTO.getAdmStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(patientNetinquiryOrderDTO.getAdmStatus())) {
                QueryWrapper evaluationWrapper = new QueryWrapper();
                EvaluationEntity evaluation = new EvaluationEntity();
                evaluation.setAdmId(patientNetinquiryOrderDTO.getAdmId());
                evaluation.setDisplay(new Integer(1).byteValue());
                evaluationWrapper.setEntity((Object)evaluation);
                List list = this.baseEvaluationService.list((Wrapper)evaluationWrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    patientNetinquiryOrderDTO.setAdmStatus(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
                }
            }
            if ((status = PatientNetinquiryOrderStatusEnum.getPatientNetinquiryOrderListVoStatus((Integer)patientNetinquiryOrderDTO.getOrderStatus(), (Integer)patientNetinquiryOrderDTO.getAdmStatus(), (BigDecimal)patientNetinquiryOrderDTO.getPayAmount(), (Date)patientNetinquiryOrderDTO.getScheduleDate())) != null) {
                log.info("status:{}" + JSON.toJSONString((Object)status));
                if (PatientNetinquiryOrderStatusEnum.TOPAY.getValue().equals(status)) {
                    vo.setExpiredTime(DateUtils.dateAddMinutes((Date)patientNetinquiryOrderDTO.getOrderCreateTime(), (int)30));
                    vo.setNowTime(new Date());
                } else if (PatientNetinquiryOrderStatusEnum.IN_CONSULTATION.getValue().equals(status)) {
                    vo.setNowTime(new Date());
                    vo.setAdmStartTime(patientNetinquiryOrderDTO.getAdmStartTime());
                    vo.setAdmEndTime(patientNetinquiryOrderDTO.getAdmEndTime());
                }
            }
            vo.setVoStatus(status);
            voList.add(vo);
        }
        return result.success(voList);
    }

    private void getStatus(QueryPatientNetinquiryOrdersDTO dto, List<String> admStatus) {
        if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.CANCEL.getValue())) {
            dto.setAdmStatus("");
        } else if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.TOPAY.getValue())) {
            dto.setOrderStatus(OrderStatusEnum.TOPAY.getValue().toString());
            dto.setAdmStatus("");
        } else if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.TO_CONSULTATION.getValue())) {
            dto.setAdmStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue().toString());
            dto.setOrderStatus(OrderStatusEnum.PAID.getValue().toString());
        } else if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.TO_REPORT.getValue())) {
            dto.setAdmStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue().toString());
            dto.setOrderStatus(OrderStatusEnum.PAID.getValue().toString());
        } else if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.IN_CONSULTATION.getValue())) {
            dto.setAdmStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue().toString());
            dto.setOrderStatus(OrderStatusEnum.PAID.getValue().toString());
        } else if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.FINISH_NOT_EVALUATED.getValue())) {
            admStatus.add(AdmissionStatusEnum.FINISH_APPLY.getValue().toString());
            admStatus.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue().toString());
            admStatus.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().toString());
            admStatus.add(AdmissionStatusEnum.REFERRAL.getValue().toString());
            admStatus.add(AdmissionStatusEnum.REFERRAL_MANAGER.getValue().toString());
            admStatus.add(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue().toString());
            String join = String.join((CharSequence)",", admStatus);
            dto.setAdmStatus(join);
            dto.setOrderStatus(OrderStatusEnum.PAID.getValue().toString());
        } else if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.ADMISSION_NOT_HANDLE.getValue())) {
            admStatus.add(AdmissionStatusEnum.REFUNDED_REFUSE.getValue().toString());
            admStatus.add(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue().toString());
            admStatus.add(AdmissionStatusEnum.EXPIRED.getValue().toString());
            admStatus.add(AdmissionStatusEnum.RETIRED.getValue().toString());
            admStatus.add(AdmissionStatusEnum.REFUNDED_APPLY.getValue().toString());
            admStatus.add(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().toString());
            admStatus.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().toString());
            admStatus.add(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue().toString());
            admStatus.add(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue().toString());
            admStatus.add(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue().toString());
            admStatus.add(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue().toString());
            admStatus.add(AdmissionStatusEnum.ADMIN_REFUNDED.getValue().toString());
            admStatus.add(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue().toString());
            String join = String.join((CharSequence)",", admStatus);
            dto.setAdmStatus(join);
        } else if (dto.getStatusNum().equals(PatientNetinquiryOrderStatusEnum.PASS_NUMBER.getValue())) {
            dto.setAdmStatus(AdmissionStatusEnum.PASSNUMBER.getValue().toString());
            dto.setOrderStatus(OrderStatusEnum.PAID.getValue().toString());
        }
    }

    private FeignQueryDocAndTeamInfoDTO buildFeignQueryDocAndTeamInfoReqForPatient(List<QuiryPatientNetinquiryOrderDTO> dtoList) {
        FeignQueryDocAndTeamInfoDTO req = new FeignQueryDocAndTeamInfoDTO();
        ArrayList<DocAllInfoDto> doctorDTOs = new ArrayList<DocAllInfoDto>();
        ArrayList teamIds = new ArrayList();
        req.setDoctorDTOs(doctorDTOs);
        req.setTeamIds(teamIds);
        DocAllInfoDto request = null;
        QuiryPatientNetinquiryOrderDTO dto = null;
        int length = dtoList.size();
        for (int index = 0; index < length; ++index) {
            dto = dtoList.get(index);
            request = new DocAllInfoDto();
            request.setDoctorId(dto.getDoctorId());
            request.setOrganId(dto.getOrganId());
            doctorDTOs.add(request);
        }
        return req;
    }

    public BaseResponse<PageUtil<DoctorNetinquiryOrderListVo>> getDoctorNetinquiryOrders(QueryDoctorNetinquiryOrdersDTO dto) {
        GetDoctorNetinquiryOrdersDTO inquireCondition = this.handleInquireCondition(dto);
        log.info("\u5165\u53c2\u5904\u7406\u4e4b\u540e\u7684inquireCondition\u4e3a" + inquireCondition.toString());
        if (inquireCondition == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u7684\u6240\u5728\u56e2\u961f\u4fe1\u606f\u5931\u8d25");
        }
        PageUtil data = new PageUtil();
        Integer count = this.orderMapper.countDoctorNetinquiryOrders(inquireCondition);
        log.info("\u67e5\u8be2\u5230\u7684\u603b\u6570\u4e3acount" + count);
        data.setTotal((long)count.intValue());
        if (count == 0) {
            return BaseResponse.success((Object)data);
        }
        List orders = this.orderMapper.getDoctorNetinquiryOrders(inquireCondition);
        log.info("\u67e5\u8be2\u5230\u7684\u5c31\u8bca\u8bb0\u5f55\u4e3a:" + orders.toString());
        if (orders == null || orders.isEmpty()) {
            return BaseResponse.success();
        }
        for (QuiryDoctorNetinquiryOrderDTO orderDTO : orders) {
            PatientDynamicMedicalEntityVo entityVo;
            if (!StringUtils.isEmpty((String)orderDTO.getDescription()) || null == (entityVo = this.internetHospitalDetailInfoService.getMedicalInfoById(orderDTO.getMedicalId()))) continue;
            orderDTO.setDescription(entityVo.getDescription());
            log.info("entityVo:{}", (Object)JSON.toJSONString((Object)entityVo));
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        ArrayList<DoctorNetinquiryOrderListVo> list = new ArrayList<DoctorNetinquiryOrderListVo>();
        int length = orders.size();
        for (int index = 0; index < length; ++index) {
            queryPersonnelInfoReq.setDoctorId(((QuiryDoctorNetinquiryOrderDTO)orders.get(index)).getDoctorId());
            BaseResponse doctorDetailsVOBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u7684\u533b\u751f\u4e2a\u4eba\u4fe1\u606f\u4e3a" + doctorDetailsVOBaseResponse.toString());
            if (null == doctorDetailsVOBaseResponse || null == doctorDetailsVOBaseResponse.getData()) {
                return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
            }
            PersonnelInfo personnelInfo = (PersonnelInfo)doctorDetailsVOBaseResponse.getData();
            QueryWrapper wrapper = new QueryWrapper();
            InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
            inquiryMchCodeEntity.setAppCode(dto.getAppCode());
            inquiryMchCodeEntity.setHospitalId(((QuiryDoctorNetinquiryOrderDTO)orders.get(index)).getOrganId());
            wrapper.setEntity((Object)inquiryMchCodeEntity);
            InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
            log.info("entity\u51fa\u53c2:{}" + JSON.toJSONString((Object)entity));
            if (((QuiryDoctorNetinquiryOrderDTO)orders.get(index)).getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)entity.getHisUrl()) && 0 != ((QuiryDoctorNetinquiryOrderDTO)orders.get(index)).getPayAmount().compareTo(new BigDecimal(0.0)) && StringUtils.isNotEmpty((String)((QuiryDoctorNetinquiryOrderDTO)orders.get(index)).getOwnCost())) {
                log.info("\u914d\u7f6ehis");
                BigDecimal bigDecimal = new BigDecimal(((QuiryDoctorNetinquiryOrderDTO)orders.get(index)).getOwnCost()).setScale(2, 4);
                ((QuiryDoctorNetinquiryOrderDTO)orders.get(index)).setPayAmount(bigDecimal);
            }
            list.add(this.buildDoctorNetinquiryOrderListVo((QuiryDoctorNetinquiryOrderDTO)orders.get(index), personnelInfo));
        }
        log.info("\u51fa\u53c2\u7684DoctorNetinquiryOrderListVo\u4e3a" + ((Object)list).toString());
        data.setList(list);
        return BaseResponse.success((Object)data);
    }

    private GetDoctorNetinquiryOrdersDTO handleInquireCondition(QueryDoctorNetinquiryOrdersDTO dto) {
        GetDoctorNetinquiryOrdersDTO inquireCondition = new GetDoctorNetinquiryOrdersDTO();
        inquireCondition.setAppCode(dto.getAppCode());
        inquireCondition.setDoctorId(dto.getDoctorId());
        if (null == dto.getServType()) {
            inquireCondition.setServType(null);
        }
        if (null != dto.getServType()) {
            if (dto.getServType().equals(-1)) {
                inquireCondition.setServType(null);
            } else {
                inquireCondition.setServType(dto.getServType());
            }
        }
        inquireCondition.setPageSize(CommonConstants.PAGE_SIZE);
        Integer startRow = null;
        startRow = null != dto.getPageSize() ? Integer.valueOf((dto.getPageNum() - 1) * CommonConstants.PAGE_SIZE) : Integer.valueOf((dto.getPageNum() - 1) * CommonConstants.PAGE_SIZE);
        log.info("\u8d77\u59cb\u884c:", (Object)JSON.toJSONString((Object)startRow.toString()));
        inquireCondition.setStartRow(startRow);
        ArrayList<Integer> admStatus = new ArrayList<Integer>();
        if (SystemConstants.SELECT_ALL_OPTION_INTEGER_VALUE.equals(dto.getAdmStatus())) {
            admStatus.add(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue());
            admStatus.add(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
            admStatus.add(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            admStatus.add(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admStatus.add(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
            admStatus.add(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
            admStatus.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
            admStatus.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
            admStatus.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
            admStatus.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
            admStatus.add(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
            admStatus.add(AdmissionStatusEnum.REFERRAL.getValue());
            admStatus.add(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue());
            admStatus.add(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue());
            admStatus.add(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue());
            admStatus.add(AdmissionStatusEnum.PASSNUMBER.getValue());
            admStatus.add(AdmissionStatusEnum.REFERRAL_MANAGER.getValue());
            admStatus.add(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
            inquireCondition.setAdmStatus(admStatus);
        } else if (dto.getAdmStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
            admStatus.add(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
            inquireCondition.setAdmStatus(admStatus);
        } else if (dto.getAdmStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
            admStatus.add(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            inquireCondition.setAdmStatus(admStatus);
        } else if (dto.getAdmStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue())) {
            admStatus.add(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admStatus.add(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
            admStatus.add(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
            admStatus.add(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
            admStatus.add(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue());
            admStatus.add(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue());
            admStatus.add(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue());
            admStatus.add(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
            admStatus.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
            inquireCondition.setAdmStatus(admStatus);
        } else if (dto.getAdmStatus().equals(AdmissionStatusEnum.FINISH_APPLY.getValue())) {
            admStatus.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
            admStatus.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
            admStatus.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
            admStatus.add(AdmissionStatusEnum.REFERRAL.getValue());
            admStatus.add(AdmissionStatusEnum.REFERRAL_MANAGER.getValue());
            inquireCondition.setAdmStatus(admStatus);
        } else if (dto.getAdmStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue())) {
            admStatus.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
            inquireCondition.setAdmStatus(admStatus);
        } else if (dto.getAdmStatus().equals(AdmissionStatusEnum.PASSNUMBER.getValue())) {
            admStatus.add(AdmissionStatusEnum.PASSNUMBER.getValue());
            inquireCondition.setAdmStatus(admStatus);
        }
        List admIds = new ArrayList();
        admIds = this.teamDoctorInfoMapper.queryAdmIds(inquireCondition);
        if (!CollectionUtils.isEmpty(admIds)) {
            inquireCondition.setAdmIds(admIds);
        }
        return inquireCondition;
    }

    private FeignQueryDocAndTeamInfoDTO buildFeignQueryDocAndTeamInfoReqForDoctor(List<QuiryDoctorNetinquiryOrderDTO> orders) {
        FeignQueryDocAndTeamInfoDTO req = new FeignQueryDocAndTeamInfoDTO();
        ArrayList<DocAllInfoDto> doctorDTOs = new ArrayList<DocAllInfoDto>();
        ArrayList teamIds = new ArrayList();
        req.setDoctorDTOs(doctorDTOs);
        req.setTeamIds(teamIds);
        DocAllInfoDto request = null;
        QuiryDoctorNetinquiryOrderDTO dto = null;
        int length = orders.size();
        for (int index = 0; index < length; ++index) {
            dto = orders.get(index);
            request = new DocAllInfoDto();
            request.setDoctorId(dto.getDoctorId());
            request.setOrganId(dto.getOrganId());
            doctorDTOs.add(request);
        }
        return req;
    }

    private DoctorNetinquiryOrderListVo buildDoctorNetinquiryOrderListVo(QuiryDoctorNetinquiryOrderDTO dto, PersonnelInfo res) {
        PatientEntity patient;
        DoctorNetinquiryOrderListVo vo = new DoctorNetinquiryOrderListVo();
        BeanUtils.copyProperties((Object)dto, (Object)vo);
        vo.setAdmCreateTime(Long.valueOf(dto.getAdmCreateTime().getTime()));
        vo.setCount(Integer.valueOf(1));
        this.setDoctorNetinquiryOrderListVoStatus(dto, vo);
        if (res != null) {
            vo.setDeptName(res.getDeptName());
            vo.setOrganName(res.getOrganName());
        }
        if ((patient = this.patientMapper.selectById(dto.getPatientId())) == null) {
            return vo;
        }
        Integer age = IDCardUtil.getAge((String)patient.getIdcard());
        vo.setPatientAge(age);
        return vo;
    }

    private void setDoctorNetinquiryOrderListVoStatus(QuiryDoctorNetinquiryOrderDTO dto, DoctorNetinquiryOrderListVo vo) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(dto.getAdmId());
        OrderEntity orderEntity = this.orderMapper.findByAdmId(dto.getAdmId());
        if (null == orderEntity) {
            log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u7684\u8ba2\u5355\u4e3a\u7a7a,\u5c31\u8bcaid\u4e3a:{}", (Object)dto.getAdmId());
            return;
        }
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.TO_CONSULTATION.getValue());
            vo.setVoDesc(DoctorNetinquiryOrderStatusEnum.TO_CONSULTATION.getDesc());
            vo.setNowTime(Long.valueOf(System.currentTimeMillis()));
            InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
            wrapperEntity.setDoctorId(dto.getDoctorId());
            wrapperEntity.setOrganId(String.valueOf(dto.getOrganId()));
            if (ServiceTypeEnum.NOS.getValue().equals(dto.getServType())) {
                wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
            }
            if (ServiceTypeEnum.HOS.getValue().equals(dto.getServType())) {
                wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
            }
            wrapperEntity.setDeptId(Long.valueOf(dto.getDeptId().longValue()));
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.setEntity((Object)wrapperEntity);
            queryWrapper1.last("limit 1");
            InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper1);
            if (null == inquiryServiceConfigEntity) {
                log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606f");
                return;
            }
            log.info("\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
            if (null != inquiryServiceConfigEntity.getOrderTime()) {
                Date paymentTime = null;
                paymentTime = Objects.isNull(orderEntity.getPaymentTime()) ? admissionEntity.getXUpdateTime() : orderEntity.getPaymentTime();
                Date date = null;
                if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
                    String newDateTimeStr = DateUtils.dateToSimpleString((Date)orderEntity.getScheduleDate()) + " " + orderEntity.getScheduleEndTime() + ":00";
                    date = DateUtils.stringToDate((String)newDateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
                } else {
                    date = DateUtils.dateAddMinutes((Date)paymentTime, (int)inquiryServiceConfigEntity.getOrderTime());
                }
                long times = date.getTime();
                log.info("date.getTime:{}" + date.getTime());
                vo.setCountDown(Long.valueOf(times));
            } else {
                log.info("dto.getPaymentTime():{}" + dto.getPaymentTime());
                log.info("dto.getPaymentTime().getTime():{}" + dto.getPaymentTime().getTime());
                Date date = DateUtils.getDateAfter((Date)dto.getPaymentTime(), (int)1);
                log.info("date:{}" + date);
                log.info("date.getTime:{}" + date.getTime());
                long times = date.getTime();
                vo.setCountDown(Long.valueOf(times));
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            OrderEntity entity = new OrderEntity();
            entity.setDealSeq(orderEntity.getDealSeq());
            log.info("entity:{}" + entity.toString());
            queryWrapper.setEntity((Object)entity);
            List list = this.orderMapper.selectList((Wrapper)queryWrapper);
            log.info("list:{}" + list.toString());
            if (list.size() > 1) {
                log.info("\u662f\u8f6c\u8bca\u7684\u8ba2\u5355");
                log.info("\u8f6c\u8bca\u7684AdmId:{}", (Object)dto.getAdmId());
                log.info("\u8f6c\u8bca\u7684admissionEntity\uff1a{}", (Object)JSON.toJSONString((Object)admissionEntity));
                int addMinutes = inquiryServiceConfigEntity.getOrderTime();
                Date date = DateUtils.dateAddMinutes((Date)admissionEntity.getXCreateTime(), (int)addMinutes);
                log.info("\u8f6c\u8bca\u7684\u5012\u8ba1\u65f6date:{}", (Object)date.getTime());
                vo.setCountDown(Long.valueOf(date.getTime()));
            }
            if (Objects.equals(orderEntity.getKeepOrder(), 1) || Objects.equals(orderEntity.getKeepOrder(), 2)) {
                vo.setCountDown(Long.valueOf(admissionEntity.getEndTime().getTime()));
            }
            log.info("doctorNetinquiryList\u63a5\u53e3\uff0c\u8fd4\u56de\u7684\u5012\u8ba1\u65f6,{}", (Object)JSON.toJSONString((Object)vo.getCountDown()));
        } else if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.IN_CONSULTATION.getValue());
            vo.setVoDesc(DoctorNetinquiryOrderStatusEnum.IN_CONSULTATION.getDesc());
            vo.setNowTime(Long.valueOf(System.currentTimeMillis()));
            vo.setAdmStartTime(Long.valueOf(dto.getAdmStartTime().getTime()));
            vo.setAdmEndTime(Long.valueOf(dto.getAdmEndTime().getTime()));
        } else if (AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.REQUEST_REFUND.getValue());
            vo.setVoDesc(STATUS_DESC);
        } else if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.REFUSE_ADMISSION.getValue());
            vo.setVoDesc(STATUS_DESC);
        } else if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(dto.getAdmStatus()) || AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue().equals(dto.getAdmStatus()) || AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue().equals(dto.getAdmStatus()) || AdmissionStatusEnum.PASSNUMBER_REFUND.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.ADMISSION_NOT_HANDLE.getValue());
            vo.setVoDesc(STATUS_DESC);
        } else if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(dto.getAdmStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(dto.getAdmStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.END_CONSULTATION.getValue());
            vo.setVoDesc(DoctorNetinquiryOrderStatusEnum.END_CONSULTATION.getDesc());
        } else if (AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.ZERO_REFUSE_REFUND.getValue());
            vo.setVoDesc(STATUS_DESC);
        } else if (AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
            vo.setVoDesc(STATUS_DESC);
        } else if (AdmissionStatusEnum.REFERRAL.getValue().equals(dto.getAdmStatus()) || AdmissionStatusEnum.REFERRAL_MANAGER.getValue().equals(dto.getAdmStatus()) || AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.REFERRAL.getValue());
            vo.setVoDesc(DoctorNetinquiryOrderStatusEnum.REFERRAL.getDesc());
        } else if (AdmissionStatusEnum.PASSNUMBER.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.PASS_NUMBER.getValue());
            vo.setVoDesc(DoctorNetinquiryOrderStatusEnum.PASS_NUMBER.getDesc());
        } else if (AdmissionStatusEnum.ADMIN_REFUNDED.getValue().equals(dto.getAdmStatus())) {
            vo.setVoStatus(DoctorNetinquiryOrderStatusEnum.ADMIN_REFUNDED.getValue());
            vo.setVoDesc(DoctorNetinquiryOrderStatusEnum.ADMIN_REFUNDED.getDesc());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultData<Object> cancelOrder(CancelOrderReqVO param) {
        ResultData result = new ResultData();
        OrderEntity order = this.orderMapper.findById(param.getOrderId());
        if (null == order) {
            return result.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba2\u5355");
        }
        log.info("\u53d6\u6d88\u8be5\u8ba2\u5355\uff1a" + order.toString());
        if (!order.getStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
            return result.error("\u8be5\u8ba2\u5355\u72b6\u6001\u975e\u5f85\u652f\u4ed8\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88");
        }
        this.gnHisManagerService.gnCancelOrderToHis(order, Integer.valueOf(1));
        if (Objects.equals(order.getFundType(), "2")) {
            String url = this.projProperties.getBaseAddress() + "/medicare/medicalPayment/ybAliUndoOrder";
            String data = this.redisUtil.get("yb_" + order.getXId());
            if (StringUtils.isNotBlank((String)data)) {
                try {
                    String s = HttpKit.jsonPost((String)url, (String)data);
                    log.info("\u533b\u4fdd\u64a4\u9500\u7ed3\u679c\uff1a{}", (Object)s);
                    this.redisUtil.del("yb_" + order.getXId());
                }
                catch (Exception e) {
                    log.info("\u533b\u4fdd\u64a4\u9500\u5931\u8d25\uff1a{}", (Throwable)e);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)order.getScheduleId())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setId(Long.valueOf(order.getScheduleId()));
            queryWrapper.setEntity((Object)scheduleRecordEntity);
            ScheduleRecordEntity scheduleRecordOne = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)queryWrapper);
            if (null != scheduleRecordOne) {
                this.scheduleRecordMapper.addAvailableCount(scheduleRecordOne.getId());
            }
        }
        order.setStatus(OrderStatusEnum.CANCEL.getValue());
        this.orderMapper.updateOrderEntity(order);
        return result.success((Object)"\u53d6\u6d88\u8ba2\u5355\u6210\u529f");
    }

    public BaseResponse<List<OrderInfoDTO>> getByTimeAndAppCode(String time, String appCode) {
        QueryOrderDto dto = new QueryOrderDto();
        dto.setCreateTimeStart(time);
        dto.setAppCode(appCode);
        dto.setCreateTimeEnd(DateUtils.getNextDayToString((String)time));
        List orderEntities = this.orderMapper.getByTimeAndAppCode(dto);
        ArrayList<OrderInfoDTO> orderInfoDTOList = new ArrayList<OrderInfoDTO>();
        for (OrderEntity orderEntity : orderEntities) {
            OrderInfoDTO orderInfoDTO = new OrderInfoDTO();
            BeanUtils.copyProperties((Object)orderEntity, (Object)orderInfoDTO);
            orderInfoDTOList.add(orderInfoDTO);
        }
        return BaseResponse.success(orderInfoDTOList);
    }

    public GetPatientPayOrderDetailVoRes getPatientPayOrderDetail(String admId, String cardId) {
        GetPatientPayOrderDetailVoRes getPatientPayOrderDetailVoRes = new GetPatientPayOrderDetailVoRes();
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        getPatientPayOrderDetailVoRes.setDoctorName(orderEntity.getDoctorName());
        getPatientPayOrderDetailVoRes.setDeptName(orderEntity.getDeptName());
        getPatientPayOrderDetailVoRes.setOrderId(orderEntity.getOrderSeq());
        getPatientPayOrderDetailVoRes.setSeverType(orderEntity.getServType());
        getPatientPayOrderDetailVoRes.setOrderStatus(orderEntity.getStatus());
        getPatientPayOrderDetailVoRes.setPayAmount(orderEntity.getPayAmount());
        getPatientPayOrderDetailVoRes.setCreateTime(orderEntity.getXCreateTime());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        getPatientPayOrderDetailVoRes.setCardNo(orderEntity.getIdCard());
        getPatientPayOrderDetailVoRes.setPatientName(patientEntity.getPatientName());
        getPatientPayOrderDetailVoRes.setPatientAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)patientEntity.getIdcard())));
        getPatientPayOrderDetailVoRes.setPatientGender(patientEntity.getGender());
        getPatientPayOrderDetailVoRes.setOrganName(orderEntity.getHospitalName());
        CardDetailQueryReqVO cardDetailQueryReqVO = new CardDetailQueryReqVO();
        cardDetailQueryReqVO.setCardId(cardId);
        if (StringUtils.isNotEmpty((String)orderEntity.getPatientUserId())) {
            cardDetailQueryReqVO.setUserId(orderEntity.getPatientUserId());
        } else {
            cardDetailQueryReqVO.setUserId(patientEntity.getUserId());
        }
        BaseResponse cardDetailResponse = this.cardClient.getCardDetailForManage(cardDetailQueryReqVO);
        log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\uff1a \u5165\u53c2->{}  \u51fa\u53c2->{}", (Object)cardId, (Object)cardDetailResponse.toString());
        if (cardDetailResponse.isSuccess() && cardDetailResponse.getData() != null) {
            getPatientPayOrderDetailVoRes.setCardNoTypeName(((CardDetailRespVO)cardDetailResponse.getData()).getCardTypeName());
        }
        return getPatientPayOrderDetailVoRes;
    }

    public GetPatientPayInfoVoRes getPatientPayInfo(String admId) {
        GetPatientPayInfoVoRes getPatientPayInfoVoRes = new GetPatientPayInfoVoRes();
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        getPatientPayInfoVoRes.setCreateTime(orderEntity.getXCreateTime());
        getPatientPayInfoVoRes.setOrderId(orderEntity.getOrderSeq());
        getPatientPayInfoVoRes.setPayAmount(orderEntity.getPayAmount());
        return getPatientPayInfoVoRes;
    }

    public GetPatientPaySuccessInfoVoRes getPatientPaySuccessInfo(String admId) {
        GetPatientPaySuccessInfoVoRes getPatientPaySuccessInfoVoRes = new GetPatientPaySuccessInfoVoRes();
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        getPatientPaySuccessInfoVoRes.setDoctorName(orderEntity.getDoctorName());
        getPatientPaySuccessInfoVoRes.setDeptName(orderEntity.getDeptName());
        getPatientPaySuccessInfoVoRes.setOrderId(orderEntity.getOrderSeq());
        getPatientPaySuccessInfoVoRes.setSeverType(orderEntity.getServType());
        getPatientPaySuccessInfoVoRes.setOrderStatus(orderEntity.getStatus());
        getPatientPaySuccessInfoVoRes.setPayAmount(orderEntity.getPayAmount());
        getPatientPaySuccessInfoVoRes.setCreateTime(orderEntity.getXCreateTime());
        getPatientPaySuccessInfoVoRes.setPayMethod(orderEntity.getPayMethod());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        getPatientPaySuccessInfoVoRes.setPatientName(patientEntity.getPatientName());
        return getPatientPaySuccessInfoVoRes;
    }

    public void updateOrderForReconciliation(UpdateOrderForReconciliationReqVo updateOrderForReconciliationReqVo) {
        log.info("updateOrderForReconciliation\u8bf7\u6c42\u53c2\u6570: {}", (Object)updateOrderForReconciliationReqVo.toString());
        OrderEntity orderEntity = this.orderMapper.getOrderByDealSeq(updateOrderForReconciliationReqVo.getDealSeq());
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        if (UPDATE_ORDER_STATUS_SIGN.equals(updateOrderForReconciliationReqVo.getType())) {
            if ("REFUND".equals(updateOrderForReconciliationReqVo.getValue())) {
                this.orderMapper.updateStatusById(orderEntity.getXId(), OrderStatusEnum.REFUNDED.getValue());
                this.admissionMapper.updateStatusByOrderId(orderEntity.getXId(), AdmissionStatusEnum.REFUNDED_APPLY.getValue());
                return;
            }
            if ("SUCCESS".equals(updateOrderForReconciliationReqVo.getValue()) && admissionEntity != null) {
                this.orderMapper.updateStatusById(orderEntity.getXId(), OrderStatusEnum.PAID.getValue());
                return;
            }
        }
        RequestRefundVo requestRefundVo = new RequestRefundVo();
        requestRefundVo.setOrderId(orderEntity.getXId());
        this.payCallBackService.refundCalls(requestRefundVo);
    }

    public List<ResPatientPayOrderListVo> getPatientPayOrderList(ReqPatientPayOrderListVo reqPatientPayOrderListVo) {
        InternetHospitalEntity internetHospitalInfo = this.internetHospitalDetailInfoService.getInternetHospitalInfo(reqPatientPayOrderListVo.getOrganId(), this.projProperties.getInternetHospitalUrl());
        String relOrganId = internetHospitalInfo.getRelOrganId();
        Integer organType = internetHospitalInfo.getOrganType();
        if (!OrganTypeEnum.GENERAL_ORGAN_ID.getValue().equals(organType)) {
            reqPatientPayOrderListVo.setOrganId(relOrganId);
            log.info("\u60a3\u8005\u7aef\u7f34\u8d39\u8ba2\u5355\u5217\u8868OrderServiceImpl.getPatientPayOrderList(~)\u5165\u53c2:{}", (Object)reqPatientPayOrderListVo.toString());
        }
        List patientPayOrderList = this.orderMapper.getPatientPayOrderList(reqPatientPayOrderListVo);
        log.info("\u8fd4\u56de\u6570\u636e:{}", patientPayOrderList.toArray());
        return patientPayOrderList;
    }

    public PageResult<PatientNetOrderVoRes> getPatientOrderInfo(PatientNetOrdersReq req) {
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(req.getOrganId(), this.projProperties.getInternetHospitalUrl());
        if (!internetHospitalEntity.getOrganType().equals(SubscribeEnum.ORGAN_TYPE.getValue())) {
            req.setOrganId(internetHospitalEntity.getRelOrganId());
        }
        log.info("=====\u4e92\u8054\u7f51ID\u83b7\u53d6\u4e4b\u540e\uff0c\u67e5\u770b\u5165\u53c2\u503c\u4e2d\u7684organId\u662f\u5426\u6539\u53d8:{}=====" + req);
        PageResult pageResult = new PageResult();
        PageHelper.startPage((int)req.getPageNum(), (int)req.getPageSize());
        Page patientNetOrderResultPage = this.orderMapper.getPatientOrderInfo(req);
        List patientNetOrderVoList = patientNetOrderResultPage.getResult();
        if (CollectionUtils.isEmpty((Collection)patientNetOrderVoList)) {
            return pageResult;
        }
        ArrayList<PatientNetOrderVoRes> patientNetOrderListResList = new ArrayList<PatientNetOrderVoRes>();
        for (PatientNetOrderVo patientNetOrderVo : patientNetOrderVoList) {
            Integer status;
            PatientNetOrderVoRes patientNetOrderVoRes = new PatientNetOrderVoRes();
            BeanUtils.copyProperties((Object)patientNetOrderVo, (Object)patientNetOrderVoRes);
            patientNetOrderVoRes.setCount(SubscribeEnum.BUY_COUNT.getValue());
            BaseResponse doctorInfo = this.doctorCilent.getDoctorInfo(Long.valueOf(patientNetOrderVo.getDoctorId()), patientNetOrderVo.getOrganId());
            if (doctorInfo.isSuccess()) {
                DoctorBaseInfoDTO data = (DoctorBaseInfoDTO)doctorInfo.getData();
                if (data != null) {
                    log.info("======\u8c03\u7528\u533b\u751f\u4fe1\u4fe1\u606f\u6210\u529f:{}======", (Object)JSON.toJSONString((Object)doctorInfo));
                    patientNetOrderVoRes.setDoctorName(data.getDoctorName());
                    patientNetOrderVoRes.setOrganName(data.getOrganName());
                    patientNetOrderVoRes.setOrganId(data.getOrganId());
                    patientNetOrderVoRes.setPortrait(data.getPortrait());
                    patientNetOrderVoRes.setProfession(data.getProfession());
                    patientNetOrderVoRes.setTitleName(data.getTitleName());
                    patientNetOrderVoRes.setDeptName(data.getDeptName());
                }
                if (data == null) {
                    log.error("======\u8c03\u7528\u533b\u751f\u4fe1\u606f\u5931\u8d25:{}======", (Object)JSON.toJSONString((Object)doctorInfo));
                    return pageResult;
                }
            }
            if ((status = PatientNetinquiryOrderStatusEnum.getPatientNetinquiryOrderListVoStatus((Integer)patientNetOrderVo.getOrderStatus(), (Integer)patientNetOrderVo.getAdmStatus(), (BigDecimal)patientNetOrderVo.getPayAmount(), (Date)new Date())) != null) {
                if (PatientNetinquiryOrderStatusEnum.TOPAY.getValue().equals(status)) {
                    patientNetOrderVoRes.setExpiredTime(DateUtils.dateAddMinutes((Date)patientNetOrderVo.getOrderCreateTime(), (int)30));
                    patientNetOrderVoRes.setNowTime(new Date());
                } else if (PatientNetinquiryOrderStatusEnum.IN_CONSULTATION.getValue().equals(status)) {
                    patientNetOrderVoRes.setNowTime(new Date());
                    patientNetOrderVoRes.setAdmStartTime(patientNetOrderVo.getAdmStartTime());
                    patientNetOrderVoRes.setAdmEndTime(patientNetOrderVo.getAdmEndTime());
                }
            }
            log.info("=====\u67e5\u8be2\u51fa\u7684\u8ba2\u5355\u72b6\u6001=====" + status);
            patientNetOrderVoRes.setVoStatus(status);
            log.info("=====\u4e00\u6761\u8ba2\u5355\u7684\u4fe1\u606f:{}=====" + JSON.toJSONString((Object)patientNetOrderVoRes));
            patientNetOrderListResList.add(patientNetOrderVoRes);
        }
        pageResult.setTotal(Long.valueOf(patientNetOrderResultPage.getTotal()).intValue());
        pageResult.setContent(patientNetOrderListResList);
        return pageResult;
    }

    private AdmissionEntity createAdmissionEntity(OrderEntity orderInfo) {
        AdmissionEntity entity = new AdmissionEntity();
        entity.setXId(String.valueOf(System.currentTimeMillis()));
        entity.setOrganId(orderInfo.getHospitalId());
        entity.setOrderId(orderInfo.getXId());
        entity.setPatientId(orderInfo.getPatientId());
        entity.setDoctorId(orderInfo.getDoctorId());
        entity.setDoctorType(orderInfo.getDoctorType());
        entity.setServType(orderInfo.getServType());
        entity.setMedicalRecordId(orderInfo.getMedicalRecordId());
        return entity;
    }

    public BaseResponse<String> getNoSourceByServType(QueryNoSourceDto queryNoSourceDto) {
        GetDocServiceConfigReq getServiceConfigReq = new GetDocServiceConfigReq();
        getServiceConfigReq.setDoctorId(queryNoSourceDto.getDoctorId());
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(queryNoSourceDto.getDoctorId());
        wrapperEntity.setOrganId(queryNoSourceDto.getOrganId());
        if (ServiceTypeEnum.NOS.getValue().equals(queryNoSourceDto.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(queryNoSourceDto.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (StringUtils.isNotEmpty((String)queryNoSourceDto.getDeptId())) {
            wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(queryNoSourceDto.getDeptId())));
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u4ef7\u683c\u914d\u7f6e\u5931\u8d25");
        }
        String todayDate = DateUtils.dateToSimpleString((Date)new Date());
        Integer todayCount = this.orderMapper.countDoctorTodayOrders(queryNoSourceDto.getDoctorId(), queryNoSourceDto.getOrganId(), todayDate, queryNoSourceDto.getServType());
        if (null == todayCount) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u5f53\u65e5\u670d\u52a1\u6b21\u6570\u5931\u8d25");
        }
        if (todayCount >= inquiryServiceConfigEntity.getDailyLimit() && -1 != inquiryServiceConfigEntity.getDailyLimit()) {
            return BaseResponse.error((String)"\u533b\u751f\u5f53\u65e5\u670d\u52a1\u5df2\u8fbe\u4e0a\u9650");
        }
        return BaseResponse.success((Object)"success");
    }

    public List<ResDoctorMedicalRecordsVo> getDoctorMedicalRecords(ReqDoctorMedicalRecordsVo reqDoctorMedicalRecordsVo) {
        List orderIds = this.orderMapper.getOrderIdByDoctorNameAndPatientName(reqDoctorMedicalRecordsVo);
        if (orderIds.size() == 0) {
            log.error("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25,\u533b\u751fid\u548c\u60a3\u8005id\u662f{}" + reqDoctorMedicalRecordsVo.toString());
            return null;
        }
        log.info("==============\u8ba2\u5355ids\u4e3a{}=============" + orderIds.toString());
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
        status.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
        status.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
        status.add(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
        status.add(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
        status.add(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
        status.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
        status.add(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
        status.add(AdmissionStatusEnum.RETIRED.getValue());
        status.add(AdmissionStatusEnum.REFERRAL.getValue());
        List<Object> resVos = new ArrayList();
        List resDoctorMedicalRecords = this.orderMapper.getDoctorMedicalRecords(orderIds, status);
        for (ResDoctorMedicalRecordsVo vo : resDoctorMedicalRecords) {
            List voList;
            PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(vo.getAdmId());
            log.info("medicalEntity:{}" + JSON.toJSONString((Object)patientDynamicMedicalEntityVo));
            if (null == patientDynamicMedicalEntityVo || CollectionUtils.isEmpty((Collection)(voList = this.internetHospitalDetailInfoService.getMedicalUserFills(patientDynamicMedicalEntityVo.getServType(), patientDynamicMedicalEntityVo.getMedicalDetail(), patientDynamicMedicalEntityVo.getHospitalId(), patientDynamicMedicalEntityVo.getDeptId())))) continue;
            vo.setMedicalUserFillsList(voList);
            vo.setMedicalRecordId(patientDynamicMedicalEntityVo.getXId());
            resVos.add(vo);
        }
        resVos = resVos.stream().sorted(Comparator.comparing(ResDoctorMedicalRecordsVo::getEndTime).reversed()).collect(Collectors.toList());
        log.info("\u533b\u60a3\u5173\u7cfb\u533b\u751f\u7aef\u8ba2\u5355\u5217\u8868\u4e3a" + resVos.toString());
        return resVos;
    }

    public BaseResponse<ResDoctorMedicalRecordsInfoVo> getDoctorMedicalRecordsInfo(ReqDoctorMedicalRecordsInfoVo reqDoctorMedicalRecordsInfoVo) {
        ResDoctorMedicalRecordsInfoVo resDoctorMedicalRecordsInfoVo = new ResDoctorMedicalRecordsInfoVo();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(reqDoctorMedicalRecordsInfoVo.getAdmId());
        if (null == admissionEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25,\u5c31\u8bcaid\u4e3a" + reqDoctorMedicalRecordsInfoVo.getAdmId()));
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionEntity.getXId());
        if (null == orderEntity) {
            return BaseResponse.error((String)("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25,\u5c31\u8bcaid\u4e3a" + reqDoctorMedicalRecordsInfoVo.getAdmId()));
        }
        PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
        patientDynamicMedicalIdVo.setId(admissionEntity.getMedicalRecordId());
        PatientDynamicMedicalEntityVo entity = this.internetHospitalDetailInfoService.getMedicalInfoById(admissionEntity.getMedicalRecordId());
        if (Objects.nonNull(entity)) {
            log.info("entity:{}" + JSON.toJSONString((Object)entity));
            List voList = this.internetHospitalDetailInfoService.getMedicalUserFills(entity.getServType(), entity.getMedicalDetail(), entity.getHospitalId(), entity.getDeptId());
            log.info("list:{}" + JSON.toJSONString((Object)voList));
            if (!CollectionUtils.isEmpty((Collection)voList)) {
                resDoctorMedicalRecordsInfoVo.setMedicalUserFills(voList);
            }
        }
        resDoctorMedicalRecordsInfoVo.setDoctorName(orderEntity.getDoctorName());
        resDoctorMedicalRecordsInfoVo.setMedicalOpinion(admissionEntity.getMedicalOpinion());
        resDoctorMedicalRecordsInfoVo.setDeptName(orderEntity.getDeptName());
        resDoctorMedicalRecordsInfoVo.setServType(orderEntity.getServType());
        resDoctorMedicalRecordsInfoVo.setHospitalName(orderEntity.getHospitalName());
        resDoctorMedicalRecordsInfoVo.setStartTime(admissionEntity.getStartTime());
        resDoctorMedicalRecordsInfoVo.setOrderId(admissionEntity.getOrderId());
        resDoctorMedicalRecordsInfoVo.setEndTime(admissionEntity.getXUpdateTime());
        return BaseResponse.success((Object)resDoctorMedicalRecordsInfoVo);
    }

    public List<OnlineOutPatientUseRecordVo> getOnlineByServicepkgOrderId(String servicepkgOrderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity queryOrderParam = new OrderEntity();
        queryOrderParam.setBankTradeNo(servicepkgOrderId);
        queryOrderParam.setServType(Integer.valueOf(2));
        queryWrapper.setEntity((Object)queryOrderParam);
        List orderEntityList = this.orderMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderEntityList)) {
            return new ArrayList<OnlineOutPatientUseRecordVo>();
        }
        return orderEntityList.stream().map(orderEntity -> {
            BaseResponse baseResponse;
            OnlineOutPatientUseRecordVo onlineOutPatientUseRecordVo = new OnlineOutPatientUseRecordVo();
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
            onlineOutPatientUseRecordVo.setUseRecordId(admissionEntity.getXId());
            onlineOutPatientUseRecordVo.setServiceDateTime(DateUtils.dateToFullString((Date)admissionEntity.getXUpdateTime()));
            onlineOutPatientUseRecordVo.setStatus(admissionEntity.getStatus());
            onlineOutPatientUseRecordVo.setAdmId(admissionEntity.getXId());
            if (Objects.nonNull(admissionEntity.getStartTime()) && Objects.nonNull(admissionEntity.getEndTime())) {
                Long servTime = (admissionEntity.getEndTime().getTime() - admissionEntity.getStartTime().getTime()) / 1000L / 60L;
                onlineOutPatientUseRecordVo.setServiceDuration(Integer.valueOf(servTime.intValue()));
            }
            if (null != (baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServiceTypeEnum.getCode((Integer)admissionEntity.getServType()), admissionEntity.getXId(), null)) && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
                UcUserEvaluationVO ucUserEvaluationVO = (UcUserEvaluationVO)((List)baseResponse.getData()).get(0);
                onlineOutPatientUseRecordVo.setServiceComment(ucUserEvaluationVO.getDoctorScore().toString());
            }
            return onlineOutPatientUseRecordVo;
        }).collect(Collectors.toList());
    }

    private ScheduleTimeIntervalEntity getScheduleTime(Long hospitalId, Integer scheduleRange) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleTimeIntervalEntity timeIntervalEntity = new ScheduleTimeIntervalEntity();
        timeIntervalEntity.setHospitalId(hospitalId);
        timeIntervalEntity.setScheduleRange(scheduleRange);
        queryWrapper.setEntity((Object)timeIntervalEntity);
        queryWrapper.last("limit 1");
        return (ScheduleTimeIntervalEntity)this.baseScheduleTimeIntervalService.getOne((Wrapper)queryWrapper);
    }

    private InquiryServiceConfigEntity getInquiryServiceConfigEntity(String organId, String doctorId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(doctorId);
        wrapperEntity.setOrganId(organId);
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return null;
        }
        return inquiryServiceConfigEntity;
    }

    public BaseResponse<List<GetMedicalRecordResVo>> getPatientMedicalRecordList(GetMedicalRecordReqVo getMedicalRecordReqVo) {
        List orderIds = this.orderMapper.getOrderIdByPatientId(getMedicalRecordReqVo);
        log.info("list:{}" + JSON.toJSONString((Object)orderIds));
        if (orderIds.size() == 0) {
            log.info("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25,\u533b\u751fid\u548c\u60a3\u8005id\u662f{}" + getMedicalRecordReqVo.toString());
            return BaseResponse.success(new ArrayList());
        }
        log.info("==============\u8ba2\u5355ids\u4e3a{}=============" + orderIds);
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
        status.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
        status.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
        status.add(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
        status.add(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
        status.add(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
        status.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
        status.add(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
        status.add(AdmissionStatusEnum.RETIRED.getValue());
        List getMedicalRecordResVoList = this.orderMapper.getPatientMedicalRecordList(orderIds, status);
        log.info("getMedicalRecordResVoList:{}" + getMedicalRecordResVoList.toString());
        for (GetMedicalRecordResVo vo : getMedicalRecordResVoList) {
            if (vo.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
                vo.setServTypeDesc(ServiceTypeEnum.HOS.getDesc());
            } else if (vo.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
                vo.setServTypeDesc(ServiceTypeEnum.NOS.getDesc());
            }
            AdmissionEntity admissionEntity = this.admissionMapper.findById(vo.getAdmId());
            if (admissionEntity == null) {
                return BaseResponse.error((String)"\u83b7\u53d6\u5c31\u8bca\u4fe1\u606f\u5931\u8d25");
            }
            vo.setMedicalRecordId(admissionEntity.getMedicalRecordId());
            PatientDynamicMedicalEntityVo medicalEntity = this.internetHospitalDetailInfoService.getMedicalInfoById(admissionEntity.getMedicalRecordId());
            log.info("medicalEntity:{}" + JSON.toJSONString((Object)medicalEntity));
            if (Objects.isNull(medicalEntity)) {
                log.info("\u6839\u636e\u75c5\u4f8bid\u67e5\u8be2\u75c5\u4f8b\u8bb0\u5f55\u5931\u8d25,\u75c5\u4f8bid\u4e3a" + vo.getMedicalRecordId());
                continue;
            }
            List voList = this.internetHospitalDetailInfoService.getMedicalUserFills(medicalEntity.getServType(), medicalEntity.getMedicalDetail(), medicalEntity.getHospitalId(), medicalEntity.getDeptId());
            if (CollectionUtils.isEmpty((Collection)voList)) {
                log.info("\u83b7\u53d6\u75c5\u4f8b\u4fe1\u606f\u5931\u8d25" + vo.getMedicalRecordId());
                continue;
            }
            log.info("voList:{}" + JSON.toJSONString((Object)voList));
            vo.setMedicalUserFills(voList);
            vo.setTags(medicalEntity.getTags());
            vo.setDescription(medicalEntity.getDescription());
            vo.setUpdateTime(medicalEntity.getXUpdateTime());
        }
        if (null == getMedicalRecordResVoList) {
            log.info("\u67e5\u8be2\u5230\u7684\u5217\u8868\u8bb0\u5f55\u4e3a\u7a7a:{}" + JSON.toJSONString((Object)getMedicalRecordResVoList));
            return BaseResponse.success(new ArrayList());
        }
        log.info("getMedicalRecordResVoList:{}" + JSON.toJSONString((Object)getMedicalRecordResVoList));
        getMedicalRecordResVoList = getMedicalRecordResVoList.stream().sorted(Comparator.comparing(GetMedicalRecordResVo::getUpdateTime).reversed()).collect(Collectors.toList());
        log.info("getMedicalRecordResVoList:{}" + JSON.toJSONString(getMedicalRecordResVoList));
        return BaseResponse.success(getMedicalRecordResVoList);
    }

    public BaseResponse<GetMedicalRecordDetailResVo> getMedicalRecordDetail(GetMedicalRecordDetailReqVo getMedicalRecordDetailReqVo) {
        GetMedicalRecordDetailResVo getMedicalRecordDetailResVo = new GetMedicalRecordDetailResVo();
        PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
        patientDynamicMedicalIdVo.setId(getMedicalRecordDetailReqVo.getMedicalRecordId());
        PatientDynamicMedicalEntityVo medicalEntity = this.internetHospitalDetailInfoService.getMedicalInfoById(getMedicalRecordDetailReqVo.getMedicalRecordId());
        if (null == medicalEntity) {
            return BaseResponse.error((String)("\u6839\u636e\u75c5\u4f8bid\u67e5\u8be2\u75c5\u4f8b\u8bb0\u5f55\u5931\u8d25,\u75c5\u4f8bid\u4e3a" + getMedicalRecordDetailReqVo.getMedicalRecordId()));
        }
        log.info("medicalEntity:{}" + JSON.toJSONString((Object)medicalEntity));
        List voList = this.internetHospitalDetailInfoService.getMedicalUserFills(medicalEntity.getServType(), medicalEntity.getMedicalDetail(), medicalEntity.getHospitalId(), medicalEntity.getDeptId());
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return BaseResponse.error((String)"\u83b7\u53d6\u75c5\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        log.info("voList:{}" + JSON.toJSONString((Object)voList));
        AdmissionEntity admissionEntity = this.admissionMapper.findByMedicalRecordId(getMedicalRecordDetailReqVo.getMedicalRecordId());
        if (null == admissionEntity) {
            return BaseResponse.error((String)("\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25,\u5c31\u8bcaid\u4e3a" + admissionEntity.getXId()));
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionEntity.getXId());
        if (null == orderEntity) {
            return BaseResponse.error((String)("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25,\u5c31\u8bcaid\u4e3a" + admissionEntity.getXId()));
        }
        log.info("orderEntity:{}" + orderEntity.toString());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionEntity.getPatientId());
        if (null == patientEntity) {
            return BaseResponse.error((String)("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u60a3\u8005\u8bb0\u5f55\u5931\u8d25,\u60a3\u8005id\u4e3a" + patientEntity.getXId()));
        }
        log.info("patientEntity:{}" + patientEntity.toString());
        getMedicalRecordDetailResVo.setUpdateTime(medicalEntity.getXUpdateTime());
        getMedicalRecordDetailResVo.setMedicalOpinion(admissionEntity.getMedicalOpinion());
        getMedicalRecordDetailResVo.setDoctorName(admissionEntity.getDoctorName());
        getMedicalRecordDetailResVo.setServType(admissionEntity.getServType());
        getMedicalRecordDetailResVo.setDeptName(orderEntity.getDeptName());
        getMedicalRecordDetailResVo.setHospitalName(orderEntity.getHospitalName());
        getMedicalRecordDetailResVo.setMedicalUserFills(voList);
        getMedicalRecordDetailResVo.setAdmId(admissionEntity.getXId());
        getMedicalRecordDetailResVo.setOrderId(admissionEntity.getOrderId());
        Integer gender = patientEntity.getGender();
        if (gender.equals(GenderEnum.MALE.getValue())) {
            getMedicalRecordDetailResVo.setGender(GenderEnum.MALE.getDesc());
        } else if (gender.equals(GenderEnum.FEMALE.getValue())) {
            getMedicalRecordDetailResVo.setGender(GenderEnum.FEMALE.getDesc());
        }
        getMedicalRecordDetailResVo.setPatientName(patientEntity.getPatientName());
        Integer age = IDCardUtil.getAge((String)patientEntity.getIdcard());
        getMedicalRecordDetailResVo.setAge(age);
        if (admissionEntity.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            getMedicalRecordDetailResVo.setServTypeDesc(ServiceTypeEnum.HOS.getDesc());
        } else if (admissionEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            getMedicalRecordDetailResVo.setServTypeDesc(ServiceTypeEnum.NOS.getDesc());
        }
        return BaseResponse.success((Object)getMedicalRecordDetailResVo);
    }

    public BaseResponse<List<RegisteredRecordResVo>> medicalRecordsToHT(HisMedicalsReqVo hisMedicalsReqVo) {
        PatientEntity patientEntity = this.patientMapper.selectById(hisMedicalsReqVo.getPatientId());
        String patientIdCard = patientEntity.getIdcard();
        String patientName = patientEntity.getPatientName();
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(hisMedicalsReqVo.getAppCode());
        inquiryMchCodeEntity.setHospitalId(hisMedicalsReqVo.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            log.info("\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u6539\u533b\u9662\u76f8\u5173\u7684mchCode\u548chisUrl");
            return BaseResponse.error((String)"\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u6539\u533b\u9662\u76f8\u5173\u7684mchCode\u548chisUrl");
        }
        log.info("entity:{}" + entity.toString());
        if (StringUtils.isEmpty((String)entity.getHisUrl())) {
            log.info("\u67e5\u8be2\u7684\u590d\u8bca\u8c03\u7528his\u7684\u5730\u5740\u4e3a\u7a7a\uff0c\u68c0\u67e5\u6570\u636e\u5e93\u786e\u8ba4\u8be5\u533b\u9662\u662f\u5426\u5bf9\u63a5his");
            return BaseResponse.success(new ArrayList());
        }
        String hisUrl = entity.getHisUrl();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(hisMedicalsReqVo.getDoctorId());
        BaseResponse doctorDetailsVOBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (!doctorDetailsVOBaseResponse.isSuccess() || null == doctorDetailsVOBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        String deptName = ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDeptName();
        String deptId = ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDeptId().toString();
        String doctorId = ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDoctorId();
        ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDeptId().toString();
        List registeredRecordList = this.hisTemplateService.getRegisteredRecord(patientIdCard, patientName, deptName, hisUrl, deptId, doctorId, patientEntity.getCardNo(), hisMedicalsReqVo.getAppCode());
        if (CollectionUtils.isEmpty((Collection)registeredRecordList)) {
            return BaseResponse.success(new ArrayList());
        }
        Integer age = 0;
        String gender = null;
        if (null != patientEntity && StringUtils.isNotEmpty((String)patientEntity.getIdcard())) {
            age = IDCardUtil.getAge((String)patientEntity.getIdcard());
            gender = IDCardUtil.getGender((String)patientEntity.getIdcard());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String edTime = format.format(new Date());
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        if ("MZJH".equals(hisMedicalsReqVo.getAppCode())) {
            c.add(2, -2);
        } else {
            c.add(2, -6);
        }
        Date m3 = c.getTime();
        String bgDate = format.format(m3);
        for (RegisteredRecordResVo reg : registeredRecordList) {
            reg.setAge(age.toString());
            reg.setName(patientEntity.getPatientName());
            reg.setSex(gender);
            GetPayRecordDetailReq getPayRecordDetailReq = new GetPayRecordDetailReq();
            getPayRecordDetailReq.setAdmId(reg.getAdmId());
            GetPayRecordDetailRes reportAndDragList = this.hisTemplateService.getReportAndDragList(getPayRecordDetailReq);
            if (null == reportAndDragList || CollectionUtils.isEmpty((Collection)reportAndDragList.getGetPayRecordDetailItemsResList())) continue;
            ArrayList drugsNewList = new ArrayList();
            reportAndDragList.getGetPayRecordDetailItemsResList().stream().forEach(r -> {
                DrugsNewVo drugsNewVo = new DrugsNewVo();
                BeanUtils.copyProperties((Object)r, (Object)drugsNewVo);
                drugsNewVo.setDrugName(r.getArcmiDesc());
                drugsNewList.add(drugsNewVo);
            });
            ArrayList<PrescriptionsNewVo> prescriptionsNewList = new ArrayList<PrescriptionsNewVo>();
            PrescriptionsNewVo prescriptionsNewVo = new PrescriptionsNewVo();
            prescriptionsNewVo.setDrugsList(drugsNewList);
            prescriptionsNewList.add(prescriptionsNewVo);
            reg.setPrescriptionsVo(prescriptionsNewList);
            ReportReq reportReq = new ReportReq();
            reportReq.setAdmId(reg.getAdmId());
            reportReq.setPatientId(reg.getPatientId());
            reportReq.setBeginTime(bgDate);
            reportReq.setEndTime(edTime);
            ReportRes reportList = this.hisTemplateService.getReportList(reportReq);
            if (null == reportList) continue;
            reg.setReportRes(reportList);
        }
        registeredRecordList.sort(Comparator.comparing(RegisteredRecordResVo::getRegDate).reversed());
        return BaseResponse.success((Object)registeredRecordList);
    }

    public BaseResponse<GetCardNoResVoNew> getCardNo(GetCardNoReqVo getCardNoReqVo) {
        PatientEntity patientEntity = this.patientMapper.selectById(getCardNoReqVo.getPatientId());
        if (null == patientEntity) {
            return BaseResponse.error((String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        GetCardNoResVoNew cardNoResVo = new GetCardNoResVoNew();
        cardNoResVo.setCardNo(patientEntity.getCardNo());
        return BaseResponse.success((Object)cardNoResVo);
    }

    public BaseResponse<GetCardNoResVoNew> getCardNoAndCardId(GetCardNoReqVo getCardNoReqVo) {
        PatientEntity patientEntity = this.patientMapper.selectById(getCardNoReqVo.getPatientId());
        if (null == patientEntity) {
            return BaseResponse.error((String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        GetCardNoResVoNew cardNoResVo = new GetCardNoResVoNew();
        cardNoResVo.setCardNo(patientEntity.getCardNo());
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardNo(patientEntity.getCardNo());
        BaseResponse baseResponse = this.cardServiceApi.getHisCardDetails(cardDetailsInfoReqVO);
        if (baseResponse.isSuccess() && Objects.nonNull(baseResponse.getData())) {
            cardNoResVo.setCardId(((CardDetailsInfoRespVO)baseResponse.getData()).getCardId());
        }
        return BaseResponse.success((Object)cardNoResVo);
    }

    public BaseResponse<String> activityRegistered(ActivityRegisteredReqVo activityRegisteredReqVo) {
        QueryWrapper orderWrapper = new QueryWrapper();
        OrderEntity order = new OrderEntity();
        order.setOrderSeq(activityRegisteredReqVo.getOrderSeq());
        orderWrapper.setEntity((Object)order);
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectOne((Wrapper)orderWrapper);
        if (null == orderEntity) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        QueryWrapper admWrapper = new QueryWrapper();
        AdmissionEntity adm = new AdmissionEntity();
        adm.setOrderId(orderEntity.getXId());
        admWrapper.setEntity((Object)adm);
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admWrapper);
        ResponseNotifyRestVo responseNotifyRestVo1 = new ResponseNotifyRestVo();
        responseNotifyRestVo1.setDealTradeNo(UUIDUtil.generateViewId());
        responseNotifyRestVo1.setPayChannel(PayChannelEnum.NOPAY.getPayChannel());
        responseNotifyRestVo1.setPayTime(new Date());
        this.updateOrderRecordService.updateOrderRecord(responseNotifyRestVo1, orderEntity);
        ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
        BaseResponse baseResponse = this.medicarePaymentService.medicarePayment(responseNotifyRestVo, orderEntity, admissionEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> orderCheckForPlatform(OrderCheckForPlatformReqVo orderCheckForPlatformReqVo) throws Exception {
        QueryWrapper orderEntityWrapper = new QueryWrapper();
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setOrderSeq(orderCheckForPlatformReqVo.getOrderSeq());
        orderEntityWrapper.setEntity((Object)orderEntity);
        OrderEntity order = (OrderEntity)this.orderMapper.selectOne((Wrapper)orderEntityWrapper);
        if (null == order) {
            return BaseResponse.error((String)"\u8f93\u5165\u7684\u8ba2\u5355\u53f7\u6709\u8bef\u6216\u4e0d\u5b58\u5728");
        }
        QueryWrapper userOrderWrapper = new QueryWrapper();
        OrderEntity orderUser = new OrderEntity();
        orderUser.setOrderSeq(orderCheckForPlatformReqVo.getOrderSeq());
        orderUser.setPatientUserId(orderCheckForPlatformReqVo.getUserId());
        userOrderWrapper.setEntity((Object)orderUser);
        OrderEntity userOrder = (OrderEntity)this.orderMapper.selectOne((Wrapper)userOrderWrapper);
        if (null == userOrder) {
            log.info("\u975e\u5f53\u524d\u7528\u6237\u6240\u62e5\u6709\u7684\u8ba2\u5355");
            return BaseResponse.error((String)"\u8f93\u5165\u7684\u8ba2\u5355\u53f7\u6709\u8bef\u6216\u4e0d\u5b58\u5728");
        }
        if (!ServiceTypeEnum.NOS.getValue().equals(userOrder.getServType())) {
            log.info("\u4e0d\u662f\u590d\u8bca\u5355");
            return BaseResponse.error((String)"\u8f93\u5165\u7684\u8ba2\u5355\u53f7\u6709\u8bef\u6216\u4e0d\u5b58\u5728");
        }
        QueryWrapper admWrapper = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrderId(userOrder.getXId());
        admWrapper.setEntity((Object)admissionEntity);
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admWrapper);
        if (!(AdmissionStatusEnum.REFERRAL.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.FINISH_APPLY.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(admission.getStatus()))) {
            log.info("\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u5b8c\u6210");
            return BaseResponse.error((String)"\u8f93\u5165\u7684\u8ba2\u5355\u53f7\u6709\u8bef\u6216\u4e0d\u5b58\u5728");
        }
        OrderCheckPlatVo orderCheckPlatVo = new OrderCheckPlatVo();
        orderCheckPlatVo.setTreNo("111111111");
        ArrayList<OrderCheckPlatVo> list = new ArrayList<OrderCheckPlatVo>();
        list.add(orderCheckPlatVo);
        String treId = HttpKit.jsonPost((String)this.projProperties.getTreIdFromPlat(), (String)JSON.toJSONString(list));
        BaseResponse treIdBaseResponse = (BaseResponse)JSON.parseObject((String)treId, BaseResponse.class);
        String data = treIdBaseResponse.getData().toString();
        HashMap<String, String> stringMap = new HashMap<String, String>();
        String hosName = "";
        hosName = JxHosNameEnum.NDEFY.name();
        stringMap.put("hos_name", hosName);
        stringMap.put("data", data);
        String s = JSONObject.toJSONString(stringMap);
        String result = "";
        try {
            String sign = HttpKit.jsonPost((String)this.projProperties.getSignFromPlatform(), (String)s);
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)sign, BaseResponse.class);
            result = baseResponse.getData().toString();
            log.info("\u8c03\u7528\u6210\u529f{}", (Object)sign);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u5931\u8d25{}", (Throwable)e);
        }
        return BaseResponse.success((Object)result);
    }

    public List<OnlineOutPatientUseRecordVo> getFollowUpByServicepkgOrderId(String servicepkgOrderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity queryOrderParam = new OrderEntity();
        queryOrderParam.setBankTradeNo(servicepkgOrderId);
        queryOrderParam.setServType(Integer.valueOf(3));
        queryWrapper.setEntity((Object)queryOrderParam);
        List orderEntityList = this.orderMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderEntityList)) {
            return new ArrayList<OnlineOutPatientUseRecordVo>();
        }
        return orderEntityList.stream().map(orderEntity -> {
            BaseResponse baseResponse;
            OnlineOutPatientUseRecordVo onlineOutPatientUseRecordVo = new OnlineOutPatientUseRecordVo();
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
            onlineOutPatientUseRecordVo.setUseRecordId(admissionEntity.getXId());
            onlineOutPatientUseRecordVo.setServiceDateTime(DateUtils.dateToFullString((Date)admissionEntity.getXUpdateTime()));
            onlineOutPatientUseRecordVo.setStatus(admissionEntity.getStatus());
            onlineOutPatientUseRecordVo.setAdmId(admissionEntity.getXId());
            if (Objects.nonNull(admissionEntity.getStartTime()) && Objects.nonNull(admissionEntity.getEndTime())) {
                Long servTime = (admissionEntity.getEndTime().getTime() - admissionEntity.getStartTime().getTime()) / 1000L / 60L;
                onlineOutPatientUseRecordVo.setServiceDuration(Integer.valueOf(servTime.intValue()));
            }
            if (null != (baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServiceTypeEnum.getCode((Integer)admissionEntity.getServType()), admissionEntity.getXId(), null)) && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
                UcUserEvaluationVO ucUserEvaluationVO = (UcUserEvaluationVO)((List)baseResponse.getData()).get(0);
                onlineOutPatientUseRecordVo.setServiceComment(ucUserEvaluationVO.getDoctorScore().toString());
            }
            return onlineOutPatientUseRecordVo;
        }).collect(Collectors.toList());
    }

    public BaseResponse<MedOrderVo> getOrderDetail(String orderId) {
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)orderId));
        if (Objects.isNull(orderEntity)) {
            return BaseResponse.error((String)"\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        ResPatientInformationVo patientById = this.patientMapper.getPatientById(orderEntity.getPatientId());
        MedOrderVo medOrderVo = new MedOrderVo();
        BeanUtils.copyProperties((Object)orderEntity, (Object)medOrderVo);
        medOrderVo.setPatientName(patientById.getPatientName());
        this.redisUtil.set("yyy_order" + orderId, JSONObject.toJSONString((Object)medOrderVo), 86400L);
        return BaseResponse.success((Object)medOrderVo);
    }
}

