/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api.mobile;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.service.mobile.MobileBenefitPackageService;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.MobileBenefitPackageVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.MobileBenefitResp;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.NotifyConsultDataVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.NotifyConsultDeductVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.RegistPatientVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1.0.0"})
@Api(tags={"\u4f17\u5eb7\u79fb\u52a8\u5bf9\u63a5\u76f8\u5173API"})
public class MobileBenefitPackageController {
    private static final Logger log = LoggerFactory.getLogger(MobileBenefitPackageController.class);
    @Autowired
    private MobileBenefitPackageService mobileBenefitPackageService;

    @GetMapping(value={"/getToken"})
    @ApiOperation(value="\u83b7\u53d6accessToken")
    public BaseResponse<String> getToken() {
        return BaseResponse.success((Object)this.mobileBenefitPackageService.getAssessToken());
    }

    @GetMapping(value={"/refreshToken"})
    @ApiOperation(value="\u5237\u65b0accessToken")
    public BaseResponse<String> refreshToken(@RequestParam(value="refreshToken") String refreshToken) {
        return BaseResponse.success((Object)this.mobileBenefitPackageService.refreshToken(refreshToken));
    }

    @GetMapping(value={"/h5/login"})
    @ApiOperation(value="\u767b\u9646\u5e76\u6ce8\u518c\u5c31\u8bca\u5361")
    public BaseResponse<RegistPatientVo> login(@RequestParam(value="token") String token) {
        return this.mobileBenefitPackageService.regist(token);
    }

    @PostMapping(value={"/benefit/add"})
    @ApiOperation(value="\u751f\u6210\u6743\u76ca\u8ba2\u5355\u540c\u6b65\u63a8\u9001")
    public Result<MobileBenefitResp> addBenefitPackage(@RequestBody List<MobileBenefitPackageVo> vos) {
        return this.mobileBenefitPackageService.addBenefitPackage(vos);
    }

    @PostMapping(value={"/notify/consult"})
    @ApiOperation(value="\u6743\u76ca\u8ba2\u5355-\u540c\u6b65")
    public Result<MobileBenefitResp> notifyConsultData(@RequestBody NotifyConsultDataVo vo) {
        return this.mobileBenefitPackageService.notifyConsultData(vo);
    }

    @PostMapping(value={"/notify/deduct"})
    @ApiOperation(value="\u6743\u76ca\u6b21\u6570\u6838\u9500")
    public Result<MobileBenefitResp> notifyDeduct(@RequestBody NotifyConsultDeductVo vo) {
        return this.mobileBenefitPackageService.notifyDeduct(vo);
    }

    @GetMapping(value={"/getPatientIdsByPhoneAndOrderId"})
    @ApiOperation(value="\u6839\u636e\u6743\u76ca\u624b\u673a\u53f7\u548c\u8ba2\u5355\u67e5\u8be2\u60a3\u8005id")
    public List<String> getPatientIdsByPhoneAndOrderId(@RequestParam(value="phone") String phone) {
        return this.mobileBenefitPackageService.getPatientIdsByPhoneAndOrderId(phone);
    }
}

