/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api.nczk;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestGetDoctorOfficeStatus;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestOnlineOrOfflineVo;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorPoolEntity;
import com.ebaiyihui.onlineoutpatient.core.service.nczk.ZkFastBuyDrugService;
import com.ebaiyihui.onlineoutpatient.core.vo.ICDSearchVo.ICDSearchNameReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.FastCreateOrderReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.FastDoctorScheduleReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.MyPage;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.QueryPatOrderDetailResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.QueryPatOrderListReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.QueryPatOrderListResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.UpdatePreStatusReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZKfbImInfoResVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fastBuyDrug"})
@Api(tags={"\u4f17\u5eb7\u5feb\u901f\u8d2d\u836f\u76f8\u5173API"})
public class ZkFastController {
    private static final Logger log = LoggerFactory.getLogger(ZkFastController.class);
    @Autowired
    private ZkFastBuyDrugService zkFastBuyDrugService;

    @ApiOperation(value="\u521b\u5efa\u8ba2\u5355v1", notes="\u7528\u4e8eH5")
    @PostMapping(value={"/v1/createOrder"})
    public BaseResponse<String> createOrder(@RequestBody FastCreateOrderReqVo param) {
        return this.zkFastBuyDrugService.creatOrderV1(param);
    }

    @ApiOperation(value="\u521b\u5efa\u8ba2\u5355v2", notes="\u7528\u4e8e\u5c0f\u7a0b\u5e8f")
    @PostMapping(value={"/v2/createOrder"})
    public BaseResponse<String> createOrderV2(@RequestBody FastCreateOrderReqVo param) {
        return this.zkFastBuyDrugService.createOrderV2(param);
    }

    @ApiOperation(value="\u67e5\u8be2IM\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/v1/queryImInfo"})
    public BaseResponse<ZKfbImInfoResVo> queryImInfo(@RequestParam(value="admId") String admId) {
        return this.zkFastBuyDrugService.queryImInfo(admId);
    }

    @ApiOperation(value="\u67e5\u8be2\u8bca\u65ad")
    @PostMapping(value={"/v2/searchIcdName"})
    public BaseResponse<List<String>> searchIcdName(@RequestBody ICDSearchNameReqVo param) {
        return this.zkFastBuyDrugService.searchIcdName(param);
    }

    @ApiOperation(value="\u4fee\u6539\u5904\u65b9\u72b6\u6001")
    @PostMapping(value={"/v2/updatePreStatus"})
    public BaseResponse<String> updatePreStatus(@RequestBody UpdatePreStatusReqVo param) {
        return this.zkFastBuyDrugService.updatePreStatus(param);
    }

    @ApiOperation(value="\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/v2/queryPatOrderList"})
    public BaseResponse<MyPage<QueryPatOrderListResVo>> queryPatOrderList(@RequestBody QueryPatOrderListReqVo param) {
        return this.zkFastBuyDrugService.queryPatOrderList(param);
    }

    @ApiOperation(value="\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/v2/queryPatOrderDetail"})
    public BaseResponse<QueryPatOrderDetailResVo> queryPatOrderDetail(@RequestParam(value="admId") String admId) {
        return this.zkFastBuyDrugService.queryPatOrderDetail(admId);
    }

    @ApiOperation(value="\u91cd\u65b0\u4e0b\u5355,\u75c5\u5386\u56de\u663e")
    @GetMapping(value={"/v2/queryOrderRecord"})
    public BaseResponse<FastCreateOrderReqVo> queryOrderRecord(@RequestParam(value="admId") String admId) {
        return this.zkFastBuyDrugService.queryOrderRecord(admId);
    }

    @ApiOperation(value="\u65b0\u589e\u72ec\u7acb\u6392\u73ed\u533b\u751f\u4fe1\u606f")
    @PostMapping(value={"/v2/saveDoctorScheduleIndependently"})
    public BaseResponse<String> saveDoctorScheduleIndependently(@RequestBody @Validated DoctorPoolEntity doctorPoolEntity, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        String result = "";
        result = this.zkFastBuyDrugService.saveDoctorScheduleIndependently(doctorPoolEntity);
        return BaseResponse.success((Object)result);
    }

    @ApiOperation(value="\u5220\u9664\u72ec\u7acb\u6392\u73ed\u533b\u751f\u4fe1\u606f")
    @PostMapping(value={"/v2/deleteDoctorScheduleIndependently"})
    public BaseResponse<String> deleteDoctorScheduleIndependently(@RequestBody @Validated DoctorPoolEntity doctorPoolEntity, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        String result = "";
        result = this.zkFastBuyDrugService.deleteDoctorScheduleIndependently(doctorPoolEntity);
        return BaseResponse.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u72ec\u7acb\u6392\u73ed\u533b\u751f\u4fe1\u606f")
    @PostMapping(value={"/v2/getDoctorScheduleIndependently"})
    public BaseResponse<List<DoctorPoolEntity>> getDoctorScheduleIndependently(@RequestBody @Validated FastDoctorScheduleReqVo fastDoctorScheduleReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List doctorPoolEntities = new ArrayList();
        doctorPoolEntities = this.zkFastBuyDrugService.getDoctorScheduleIndependently(fastDoctorScheduleReqVo);
        return BaseResponse.success(doctorPoolEntities);
    }

    @ApiOperation(value="\u533b\u751f\u4e0a\u4e0b\u7ebf", notes="\u533b\u751f\u4e0a\u7ebf\u4e0b\u7ebf\u64cd\u4f5c")
    @RequestMapping(value={"/v2/officeonlineoroffline"}, method={RequestMethod.POST})
    public BaseResponse<RequestOnlineOrOfflineVo> officeOnlineOrOffline(@RequestBody RequestOnlineOrOfflineVo requestOnlineOrOfflineVo) {
        RequestOnlineOrOfflineVo onlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        onlineOrOfflineVo = this.zkFastBuyDrugService.officeOnlineOrOffline(requestOnlineOrOfflineVo);
        return BaseResponse.success((Object)onlineOrOfflineVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001", notes="\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001")
    @RequestMapping(value={"/v2/getdoctorofficestatus"}, method={RequestMethod.POST})
    public BaseResponse<RequestOnlineOrOfflineVo> getDoctorOfficeStatus(@RequestBody RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus) {
        RequestOnlineOrOfflineVo onlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        onlineOrOfflineVo = this.zkFastBuyDrugService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        return BaseResponse.success((Object)onlineOrOfflineVo);
    }
}

