/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.allowcheck.core;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.ImAccountVo;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.ImAccountService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryAdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderCheckPublicService {
    private static final Logger log = LoggerFactory.getLogger(OrderCheckPublicService.class);
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private BaseInquiryAdmissionServiceImpl baseInquiryAdmissionService;
    @Autowired
    private ImAccountService imAccountService;

    public BaseResponse<AllowBuyCheckRespVO> orderCheck(AllowBuyCheckReqVO param) {
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setHospitalId(param.getOrganId());
        orderEntity.setPatientId(param.getPatientId());
        orderEntity.setDoctorId(param.getDoctorId());
        orderEntity.setServType(param.getServType());
        QueryWrapper queryWrapperOrderEntity = new QueryWrapper((Object)orderEntity);
        queryWrapperOrderEntity.in((Object)"status", new Object[]{0});
        queryWrapperOrderEntity.last("limit 1");
        queryWrapperOrderEntity.orderByDesc((Object)"x_create_time");
        OrderEntity order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapperOrderEntity);
        log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4order: {}", (Object)JSON.toJSONString((Object)order));
        if (order != null) {
            AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
            data.setType(param.getServType());
            data.setOrderId(order.getXId());
            if (param.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
                // empty if block
            }
            data.setType(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
            return BaseResponse.success((Object)data);
        }
        AdmissionEntity admission = this.getAdmissionByHospitalIdAndOrderId(param);
        if (null == admission) {
            return null;
        }
        log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4admission: {}", (Object)JSON.toJSONString((Object)admission));
        boolean isWaitAdmission = AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admission.getStatus());
        boolean inConsult = AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus());
        boolean toBeReceive = AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus());
        if (inConsult || toBeReceive || isWaitAdmission) {
            AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
            data.setOrderId(admission.getOrderId());
            data.setType(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
            data.setAdmId(admission.getXId());
            ImAccountVo imAccountVo = this.getImAccounts(admission.getXId(), "EHOS_DOCTOR", param.getDoctorId());
            data.setDocImAccount(imAccountVo.getDocImAccount());
            data.setPatImAccount(imAccountVo.getPatImAccount());
            return BaseResponse.success((Object)data);
        }
        return null;
    }

    private AdmissionEntity getAdmissionByHospitalIdAndOrderId(AllowBuyCheckReqVO param) {
        QueryWrapper queryWrapperAdmissionEntity = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setServType(param.getServType());
        admissionEntity.setPatientId(param.getPatientId());
        admissionEntity.setDoctorId(param.getDoctorId());
        admissionEntity.setOrganId(param.getOrganId());
        queryWrapperAdmissionEntity.setEntity((Object)admissionEntity);
        queryWrapperAdmissionEntity.in((Object)"status", new Object[]{1, 2, 20});
        return (AdmissionEntity)this.baseInquiryAdmissionService.getOne((Wrapper)queryWrapperAdmissionEntity);
    }

    private ImAccountVo getImAccounts(String admId, String imAppCode, String doctorId) {
        ImAccountVo admission = new ImAccountVo();
        admission.setDoctorType(CommonConstants.STATUS_VALID);
        IMQueryTargetSdkAccountRspVO imAccountRes = this.imAccountService.queryImAccount(admId, imAppCode, doctorId);
        if (imAccountRes == null) {
            log.info("IM ERROR \u6ca1\u6709\u67e5\u8be2\u5230IM\u8d26\u6237-admId:{}", (Object)admId);
            return admission;
        }
        if ("EHOS_DOCTOR".equals(imAppCode)) {
            admission.setDocImAccount(imAccountRes.getSdkAccount());
        } else if ("EHOS_PATIENT".equals(imAppCode)) {
            admission.setPatImAccount(imAccountRes.getSdkAccount());
        }
        admission.setRoomNum(Long.valueOf(imAccountRes.getRoomNum()));
        return admission;
    }
}

