/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.createorder.core;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ChannelCodeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServiceMerchantConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MobileBenefitPackageEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorWorkingServiceClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryAdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.GnHisManagerService;
import com.ebaiyihui.onlineoutpatient.core.service.mobile.MobileBenefitPackageService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.StringUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InternetHospitalEntity;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.NotifyConsultDataVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.NotifyConsultDeductVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.InsertTagsRecordVo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class OrderCheckService {
    private static final Logger log = LoggerFactory.getLogger(OrderCheckService.class);
    @Autowired
    private DoctorWorkingServiceClient doctorWorkingServiceClient;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Resource
    private BaseInquiryServiceConfigServiceImpl baseService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private BaseInquiryAdmissionServiceImpl baseInquiryAdmissionService;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    public static final String CODE = "1";
    @Autowired
    private MobileBenefitPackageService mobileBenefitPackageService;
    @Autowired
    private GnHisManagerService gnHisManagerService;
    @Resource
    private PatientMapper patientMapper;

    public BaseResponse<ImmediateConsultationVo> orderCheck(ImmediateConsultationDTO immediateConsultationDTO) {
        BaseResponse baseResponse;
        if (StringUtils.isNotEmpty((String)immediateConsultationDTO.getBenefitPhone()) && ChannelCodeEnum.MOBILE_PACKAGE.getValue().equals(immediateConsultationDTO.getSmallProgramSource())) {
            MobileBenefitPackageEntity entity = this.mobileBenefitPackageService.queryByPhone(immediateConsultationDTO.getBenefitPhone(), immediateConsultationDTO.getActivateOrderId());
            if (ObjectUtils.isEmpty((Object)entity)) {
                return BaseResponse.error((String)"\u672a\u5f00\u901a\u79fb\u52a8\u6743\u76ca\u5305\u670d\u52a1");
            }
            if (entity.getTimeLimit() - entity.getUsed() <= 0) {
                return BaseResponse.error((String)"\u79fb\u52a8\u670d\u52a1\u5305\u670d\u52a1\u6b21\u6570\u5df2\u7528\u5b8c");
            }
        }
        if (!(baseResponse = this.doctorServiceCheck(immediateConsultationDTO)).isSuccess()) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u67e5\u8be2\u5931\u8d25");
        }
        OrderEntity order = this.getRecentOrder(immediateConsultationDTO);
        if (order == null) {
            this.insertTagsRecord(immediateConsultationDTO);
            return this.createOrder(immediateConsultationDTO);
        }
        log.info("\u60a3\u8005\u6700\u65b0\u7684\u8ba2\u5355\uff1a{}", (Object)order.toString());
        if (OrderStatusEnum.TOPAY.getValue().equals(order.getStatus())) {
            log.info("\u5904\u7406\u672a\u652f\u4ed8\u8ba2\u5355\uff1a{}", (Object)order.toString());
            ImmediateConsultationVo vo = new ImmediateConsultationVo();
            vo.setType(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
            vo.setDealSeq(order.getDealSeq());
            vo.setMerchantSeq(order.getMerchantId());
            vo.setOrderSeq(order.getOrderSeq());
            vo.setXCreateTime(order.getXCreateTime());
            vo.setPayAmount(order.getPayAmount());
            vo.setOrderId(order.getXId());
            if (null != order.getScheduleDate()) {
                vo.setScheduleDate(DateUtils.dateToString((Date)order.getScheduleDate(), (String)"yyyy-MM-dd"));
                vo.setScheduleStartTime(order.getScheduleStartTime());
                vo.setScheduleEndTime(order.getScheduleEndTime());
            }
            InquiryServiceConfigEntity doctorServiceDetail = this.getDoctorServiceDetail(immediateConsultationDTO);
            vo.setPayPrice(doctorServiceDetail.getPrice());
            vo.setHospitalName(immediateConsultationDTO.getHospitalName());
            vo.setDeptName(immediateConsultationDTO.getDeptName());
            vo.setDocName(immediateConsultationDTO.getDoctorName());
            vo.setPrice(order.getPrice());
            OrderEntity orderEntity = new OrderEntity();
            orderEntity.setXId(order.getXId());
            orderEntity.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
            this.orderMapper.updateById((Object)orderEntity);
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(order.getXId());
            if (null != admissionEntity) {
                AdmissionEntity adm = new AdmissionEntity();
                adm.setXId(admissionEntity.getXId());
                adm.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
                this.admissionMapper.update(adm);
            }
            this.insertTagsRecord(immediateConsultationDTO);
            return BaseResponse.success((Object)vo);
        }
        AdmissionEntity admission = this.getAdmissionByHospitalIdAndOrderId(order.getHospitalId(), order.getXId());
        log.info("\u4e0b\u5355\u67e5\u8be2\u5230\u5c31\u8bca\u8bb0\u5f55:" + JSON.toJSONString((Object)admission));
        if (admission == null) {
            this.insertTagsRecord(immediateConsultationDTO);
            return this.createOrder(immediateConsultationDTO);
        }
        boolean isWaitAdmission = AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admission.getStatus());
        boolean inConsult = AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus());
        boolean toBeReceive = AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus());
        if (!(inConsult || toBeReceive || isWaitAdmission)) {
            this.insertTagsRecord(immediateConsultationDTO);
            return this.createOrder(immediateConsultationDTO);
        }
        ImmediateConsultationVo vo = new ImmediateConsultationVo();
        vo.setType(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        vo.setAdmId(admission.getXId());
        this.insertTagsRecord(immediateConsultationDTO);
        PatientEntity patientEntity = this.patientMapper.selectById(immediateConsultationDTO.getPatientId());
        if (patientEntity != null) {
            vo.setPatientCredNo(patientEntity.getIdcard());
        }
        return BaseResponse.success((Object)vo);
    }

    private BaseResponse<Boolean> doctorServiceCheck(ImmediateConsultationDTO immediateConsultationDTO) {
        String serviceCode = "";
        if (ServiceTypeEnum.HOS.getValue().equals(immediateConsultationDTO.getServType())) {
            serviceCode = ServiceTypeEnum.HOS.getCode();
        }
        if (ServiceTypeEnum.NOS.getValue().equals(immediateConsultationDTO.getServType())) {
            serviceCode = ServiceTypeEnum.NOS.getCode();
        }
        ServiceCheckReqVo serviceCheckReqVo = new ServiceCheckReqVo();
        serviceCheckReqVo.setDeptId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getDeptId())));
        serviceCheckReqVo.setDoctorId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getDoctorId())));
        serviceCheckReqVo.setOrganId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getOrganId())));
        serviceCheckReqVo.setServiceCode(serviceCode);
        log.info("\u533b\u751f\u6821\u9a8c\u5165\u53c2" + JSON.toJSONString((Object)serviceCheckReqVo));
        BaseResponse baseResponse = this.doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
        return baseResponse;
    }

    private AdmissionEntity getAdmissionByHospitalIdAndOrderId(String hospitalId, String orderId) {
        QueryWrapper queryWrapperAdmissionEntity = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrganId(hospitalId);
        admissionEntity.setOrderId(orderId);
        queryWrapperAdmissionEntity.setEntity((Object)admissionEntity);
        log.info("\u5c31\u8bca\u8bb0\u5f55\u5165\u53c2{}", (Object)JSON.toJSONString((Object)admissionEntity));
        return (AdmissionEntity)this.baseInquiryAdmissionService.getOne((Wrapper)queryWrapperAdmissionEntity);
    }

    private OrderEntity getRecentOrder(ImmediateConsultationDTO immediateConsultationDTO) {
        QueryWrapper queryWrapperOrderEntity = new QueryWrapper();
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setDoctorId(immediateConsultationDTO.getDoctorId());
        orderEntity.setHospitalId(immediateConsultationDTO.getHospitalId());
        orderEntity.setPatientId(immediateConsultationDTO.getPatientId());
        orderEntity.setServType(immediateConsultationDTO.getServType());
        queryWrapperOrderEntity.setEntity((Object)orderEntity);
        queryWrapperOrderEntity.notIn((Object)"status", new Object[]{-1, 6});
        queryWrapperOrderEntity.last("limit 1");
        queryWrapperOrderEntity.orderByDesc((Object)"x_create_time");
        log.info("\u67e5\u8ba2\u5355\u5165\u53c2{}", (Object)JSON.toJSONString((Object)orderEntity));
        OrderEntity order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapperOrderEntity);
        if (null == order) {
            return null;
        }
        return order;
    }

    private InquiryServiceConfigEntity getDoctorServiceDetail(ImmediateConsultationDTO immediateConsultationDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(immediateConsultationDTO.getDoctorId());
        wrapperEntity.setOrganId(immediateConsultationDTO.getOrganId());
        wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getDeptId())));
        if (ServiceTypeEnum.NOS.getValue().equals(immediateConsultationDTO.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(immediateConsultationDTO.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5165\u53c2{}", (Object)JSON.toJSONString((Object)wrapperEntity));
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
        return inquiryServiceConfigEntity;
    }

    private ScheduleRecordEntity getScheduleById(String scheduleId) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
        scheduleRecordEntity.setId(Long.valueOf(scheduleId));
        objectQueryWrapper.setEntity((Object)scheduleRecordEntity);
        ScheduleRecordEntity scheduleRecord = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)objectQueryWrapper);
        log.info("\u6392\u73ed\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)scheduleRecord));
        return scheduleRecord;
    }

    private String getAppCode(String hospitalId) {
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(hospitalId, this.projProperties.getInternetHospitalUrl());
        if (null == internetHospitalEntity) {
            return null;
        }
        return internetHospitalEntity.getAppCode();
    }

    public BaseResponse<ImmediateConsultationVo> createOrder(ImmediateConsultationDTO immediateConsultationDTO) {
        ScheduleRecordEntity scheduleById;
        BaseResponse gnedLockOrder;
        BaseResponse inquiryServiceBaseResponse = this.doctorUseCheck(immediateConsultationDTO);
        if (!inquiryServiceBaseResponse.isSuccess()) {
            return BaseResponse.error((String)inquiryServiceBaseResponse.getMsg());
        }
        InquiryServiceConfigEntity serviceConfig = (InquiryServiceConfigEntity)inquiryServiceBaseResponse.getData();
        BigDecimal doctorPrice = serviceConfig.getPrice();
        String serviceName = ServiceTypeEnum.getDesc((Integer)immediateConsultationDTO.getServType());
        OrderEntity orderEntity = new OrderEntity();
        ImmediateConsultationVo responseDTO = new ImmediateConsultationVo();
        responseDTO.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
        BeanUtils.copyProperties((Object)immediateConsultationDTO, (Object)orderEntity);
        orderEntity.setPayMethod(ChannelCodeEnum.getValue((String)immediateConsultationDTO.getSmallProgramSource()));
        orderEntity.setServTime(serviceConfig.getServTime());
        orderEntity.setTotalNum(serviceConfig.getNumLimit());
        orderEntity.setXVersion(Long.valueOf(0L));
        String uuid = UUIDUtil.generateViewId();
        orderEntity.setXId(uuid);
        if (StringUtils.isBlank((String)immediateConsultationDTO.getAppCode())) {
            String appCode = this.getAppCode(immediateConsultationDTO.getHospitalId());
            if (StringUtils.isNotBlank((String)appCode)) {
                orderEntity.setAppCode(appCode);
            }
        } else {
            orderEntity.setAppCode(immediateConsultationDTO.getAppCode());
        }
        if (immediateConsultationDTO.getDeptId() != null) {
            orderEntity.setDeptId(Long.valueOf(immediateConsultationDTO.getDeptId()));
        }
        orderEntity.setPayAmount(doctorPrice);
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        orderEntity.setIdCard(immediateConsultationDTO.getIdcard());
        orderEntity.setDealSeq(UUIDUtil.generateViewId());
        if (StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleDate()) && StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleId())) {
            Date date = this.stringToDate(immediateConsultationDTO);
            ScheduleRecordEntity scheduleById2 = this.getScheduleById(immediateConsultationDTO.getScheduleId());
            orderEntity.setScheduleStartTime(scheduleById2.getStartTime());
            orderEntity.setScheduleEndTime(scheduleById2.getEndTime());
            orderEntity.setScheduleDate(date);
            responseDTO.setScheduleStartTime(orderEntity.getScheduleStartTime());
            responseDTO.setScheduleEndTime(orderEntity.getScheduleEndTime());
            responseDTO.setScheduleDate(immediateConsultationDTO.getScheduleDate());
        }
        responseDTO.setDealSeq(orderEntity.getDealSeq());
        responseDTO.setOrderSeq(orderEntity.getOrderSeq());
        responseDTO.setXCreateTime(orderEntity.getXCreateTime());
        responseDTO.setServiceName(serviceName);
        responseDTO.setPayAmount(orderEntity.getPayAmount());
        responseDTO.setPayPrice(doctorPrice);
        responseDTO.setHospitalName(orderEntity.getHospitalName());
        responseDTO.setDeptName(orderEntity.getDeptName());
        responseDTO.setDocName(orderEntity.getDoctorName());
        AdmissionEntity admissionEntity = this.createAdmissionEntity(orderEntity, immediateConsultationDTO);
        log.info("admissionEntity:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        responseDTO.setAdmId(admissionEntity.getXId());
        Integer isTestOrder = this.getIsTestOrder(orderEntity);
        orderEntity.setIsTestOrder(isTestOrder);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setId(UUIDUtil.getUUID());
        if (StringUtils.isNotEmpty((String)orderEntity.getTotCost()) || doctorPrice.compareTo(BigDecimal.ZERO) != 0) {
            orderEntity.setBillPayId(servicePayBillEntity.getId());
        }
        log.info("\u65b0\u589e\u8ba2\u5355\u5165\u53c2:" + JSON.toJSONString((Object)orderEntity));
        this.orderMapper.insert((Object)orderEntity);
        if (Objects.equals(orderEntity.getAppCode(), "GNYFY") && Objects.equals(orderEntity.getServType(), 3) && !(gnedLockOrder = this.gnHisManagerService.gnLockOrder(orderEntity)).isSuccess()) {
            return BaseResponse.error((String)gnedLockOrder.getMsg());
        }
        responseDTO.setOrderId(orderEntity.getXId());
        if (StringUtils.isEmpty((String)orderEntity.getTotCost()) && doctorPrice.compareTo(BigDecimal.ZERO) == 0 || StringUtils.isNotEmpty((String)immediateConsultationDTO.getBenefitPhone())) {
            log.info("0\u539f\u8ba2\u5355\u65b0\u589e");
            orderEntity.setTotCost("0");
            orderEntity.setPayAmount(new BigDecimal("0"));
            this.zeroOrderCreate(orderEntity, admissionEntity, immediateConsultationDTO, uuid, servicePayBillEntity);
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId(), orderEntity.getAppCode()));
            return BaseResponse.success((Object)responseDTO);
        }
        servicePayBillEntity.setAppCode(orderEntity.getAppCode());
        servicePayBillEntity.setCreateTime(new Date());
        servicePayBillEntity.setUpdateTime(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        ServiceMerchantConfigEntity entity = new ServiceMerchantConfigEntity();
        entity.setAppCode(orderEntity.getAppCode());
        if ("HEK".equals(immediateConsultationDTO.getSmallProgramSource())) {
            entity.setBizSysSeq("ZHJYJF");
        } else {
            entity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        }
        entity.setHospitalId(orderEntity.getHospitalId());
        entity.setApplyName(orderEntity.getPayMethod());
        queryWrapper.setEntity((Object)entity);
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u5165\u53c2:{}" + entity.toString());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = (ServiceMerchantConfigEntity)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u51fa\u53c2serviceMerchantConfigEntity:{}" + serviceMerchantConfigEntity.toString());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setDealAmount(doctorPrice);
        servicePayBillEntity.setGoodsInfo(this.projProperties.getProductInfo());
        servicePayBillEntity.setOrderAmount(doctorPrice);
        servicePayBillEntity.setOrganId(orderEntity.getOrganId());
        servicePayBillEntity.setPayChannel(orderEntity.getPayMethod());
        String serviceCode = orderEntity.getAppCode() + "_" + StringUtil.toFirstChar((String)orderEntity.getHospitalName()) + "_" + ServiceTypeEnum.getCode((Integer)orderEntity.getServType());
        servicePayBillEntity.setServiceCode(serviceCode);
        servicePayBillEntity.setStatus(PayBillStatusEnum.TOPAY.getValue());
        servicePayBillEntity.setOrganName(StringUtil.toFirstChar((String)orderEntity.getHospitalName()));
        servicePayBillEntity.setWorkServiceCode(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        servicePayBillEntity.setOutTradeNo(orderEntity.getOrderSeq());
        servicePayBillEntity.setDealTradeNo(orderEntity.getDealSeq());
        this.servicePayBillMapper.insert((Object)servicePayBillEntity);
        orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
        admissionEntity.setStatus(Integer.valueOf(0));
        log.info("\u975e0\u5143\u8ba2\u5355\u65b0\u589e\u521b\u5efa\u8ba2\u5355\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderEntity));
        orderEntity.setXId(orderEntity.getXId());
        String source = Objects.equals("WX", immediateConsultationDTO.getSmallProgramSource()) ? "WX" : "ZFB";
        this.orderMapper.updateSmallProgramSource(orderEntity.getXId(), source);
        this.baseInquiryOrderService.updateById((Object)orderEntity);
        log.info("\u975e0\u5143\u65b0\u589e\u521b\u5efa\u5c31\u8bca\u53c2\u6570\uff1a" + admissionEntity.toString());
        this.admissionMapper.insertAdvisoryRecord(admissionEntity);
        if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId()) && null != (scheduleById = this.getScheduleById(orderEntity.getScheduleId()))) {
            this.scheduleRecordMapper.reduceAvailableCount(scheduleById.getId());
        }
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId(), orderEntity.getAppCode()));
        OrderTaskVo orderTaskVo1 = new OrderTaskVo();
        orderTaskVo1.setType(Integer.valueOf(1));
        orderTaskVo1.setId(uuid);
        this.orderSender.sendDelay(orderTaskVo1);
        this.payAsyncService.createImSession(orderEntity, admissionEntity);
        return BaseResponse.success((Object)responseDTO);
    }

    private Integer getIsTestOrder(OrderEntity orderEntity) {
        Integer isTestOrder = null;
        String aa = "\u51af\u7389\u73c2,\u5468\u6625\u82f1,\u5e38\u745c,\u5e84\u96ea\u541b,\u5f6d\u7a0b\u660a,\u6768\u6842\u8339,\u6c64\u840d\u840d,\u6c6a\u6d77\u4e1c,\u738b\u7487,\u738b\u751c\u751c,\u803f\u8d3a\u59d7,\u80e1\u6842\u82f1,\u8521\u541b,\u8def\u5f71,\u9a6c\u5f66\u534e,\u5f90\u590f\u96e8,\u738b\u8d85,\u65b9\u9536\u7490,\u5f20\u6d69\u6d01,\u97e9\u6653\u4f1f,\u90ed\u9759\u96ef,\u738b\u6d9b,\u4ff1\u5f00\u7855,\u674e\u840c\u840c,\u4ed8\u4e16\u5947,\u8d75\u4e9a\u7ea2,\u5f20\u84d3\u857e,\u5b59\u8273\u82ac,\u9ec4\u8389,\u8463\u6c5f,\u738b\u5b8f\u98de,\u9648\u4f1f,\u5218\u6668,\u5de6\u632f\u829d,\u9a6c\u745e\u745e,\u6731\u5e86\u6db5,\u738b\u8d85,\u7533\u8273\u6ce2,\u623f\u5fd7\u8fdc,\u8303\u56fd\u5a77,\u8d75\u4e9a\u7ea2,\u80e1\u4f1a\u5f1f,\u90ed\u9759\u96ef,\u96f7\u5947\u82b1,\u738b\u6d9b,\u5f90\u590f\u96e8,\u738b\u8d85,\u5f20\u84d3\u857e,\u674e\u751f\u4eae,\u738b\u4f73\u58a8,\u6731\u5e86\u6db5,\u97e9\u9614,\u5415\u5e06,\u4ed8\u4e16\u5947,\u738b\u5fb7\u745e,\u6768\u662d\u745e,\u9648\u8f89\u8f89,\u7f57\u91d1,\u6b66\u6587\u6770,\u6731\u4e34\u8f69,\u4efb\u745e\u9e4f,\u6bb7\u6566\u864e,\u5218\u519b\u4fdd,\u6c88\u73ca\u73ca,\u5218\u541b\u534e,\u8d56\u4e5f\u975e,\u97e9\u6653\u4f1f,\u6768\u94ed,\u6d4b\u8bd5,\u95eb\u4eae,\u738b\u8d85,\u8d75\u4e9a\u7ea2,\u738b\u751c\u751c,\u738b\u4f73\u58a8,\u5eb7\u4f73,\u8d3e\u9759,\u6c99\u519b\u950b,\u738b\u6676\u6676,\u6768\u5a1c,\u6c6a\u677e,\u5218\u60e0\u82ac,\u738b\u4fca\u4e3d,\u725b\u65b9\u6e2f,\u5f20\u620a\u672a,\u6768\u94ed,\u738b\u5b89\u6734,\u5218\u6ce2,\u6768\u6587\u7965,\u674e\u6c38\u71d5,\u9f99\u6c38\u534e,\u8d3e\u9759\u9759,\u7a0b\u8273\u7f8e,\u5510\u6bd3\u4e54,\u90ed\u9759\u96ef,\u80e1\u4f1a\u5f1f,\u96f7\u5947\u82b1,\u738b\u6d9b,\u5f90\u590f\u96e8,\u5f20\u84d3\u857e,\u674e\u751f\u4eae,\u6731\u5e86\u6db5,\u97e9\u9614,\u5415\u5e06,\u4ed8\u4e16\u5947,\u738b\u5fb7\u745e,\u6768\u662d\u745e,\u9648\u8f89\u8f89,\u7f57\u91d1,\u6b66\u6587\u6770,\u6731\u4e34\u8f69,\u4efb\u745e\u9e4f,\u6bb7\u6566\u864e,\u5218\u519b\u4fdd,\u6c88\u73ca\u73ca,\u5218\u541b\u534e,\u8d56\u4e5f\u975e,\u97e9\u6653\u4f1f,\u6d4b\u8bd5,\u795d\u6210\u9f99,CS\u8d75\u4e9a\u7ea2,CS\u80e1\u4f1a\u5f1f,CS\u90ed\u9759\u96ef,CS\u96f7\u5947\u82b1,CS\u738b\u6d9b,CS\u5f90\u590f\u96e8,CS\u738b\u8d85,CS\u5f20\u84d3\u857e,CS\u674e\u751f\u4eae,CS\u738b\u4f73\u58a8,CS\u6731\u5e86\u6db5,CS\u97e9\u9614,CS\u5415\u5e06,CS\u4ed8\u4e16\u5947,CS\u738b\u5fb7\u745e,CS\u6768\u662d\u745e,CS\u9648\u8f89\u8f89,CS\u7f57\u91d1,CS\u6b66\u6587\u6770,CS\u6731\u4e34\u8f69,CS\u4efb\u745e\u9e4f,CS\u6bb7\u6566\u864e,CS\u5218\u519b\u4fdd,CS\u6c88\u73ca\u73ca,CS\u5218\u541b\u534e,CS\u8d56\u4e5f\u975e,CS\u97e9\u6653\u4f1f,CS\u6768\u94ed,CS\u6d4b\u8bd5,CS\u95eb\u4eae,CS\u738b\u8d85,CS\u8d75\u4e9a\u7ea2,CS\u738b\u751c\u751c,CS\u738b\u4f73\u58a8,CS\u5eb7\u4f73,CS\u8d3e\u9759,CS\u6c99\u519b\u950b,CS\u738b\u6676\u6676,CS\u6768\u5a1c,CS\u6c6a\u677e,CS\u5218\u60e0\u82ac,CS\u738b\u4fca\u4e3d,CS\u725b\u65b9\u6e2f,CS\u5f20\u620a\u672a,CS\u6768\u94ed,CS\u738b\u5b89\u6734,CS\u5218\u6ce2,CS\u6768\u6587\u7965,CS\u674e\u6c38\u71d5,CS\u9f99\u6c38\u534e,CS\u8d3e\u9759\u9759,CS\u7a0b\u8273\u7f8e,CS\u5510\u6bd3\u4e54,CS\u90ed\u9759\u96ef,CS\u80e1\u4f1a\u5f1f,CS\u96f7\u5947\u82b1,CS\u738b\u6d9b,CS\u5f90\u590f\u96e8,CS\u5f20\u84d3\u857e,CS\u674e\u751f\u4eae,CS\u6731\u5e86\u6db5,CS\u97e9\u9614,CS\u5415\u5e06,CS\u4ed8\u4e16\u5947,CS\u738b\u5fb7\u745e,CS\u6768\u662d\u745e,CS\u9648\u8f89\u8f89,CS\u7f57\u91d1,CS\u6b66\u6587\u6770,CS\u6731\u4e34\u8f69,CS\u4efb\u745e\u9e4f,CS\u6bb7\u6566\u864e,CS\u5218\u519b\u4fdd,CS\u6c88\u73ca\u73ca,CS\u5218\u541b\u534e,CS\u8d56\u4e5f\u975e,CS\u97e9\u6653\u4f1f,CS\u6d4b\u8bd5,CS\u795d\u6210\u9f99,\u738b\u6d9b9,ZS\u738b\u6d9b,\u7267\u7ae5,ZS\u8d75\u4e9a\u7ea2,\u6d4b\u8bd5\u533b\u751f,\u6d4b\u8bd5\u836f\u5e08,byh\u6d4b\u8bd5,\u5f6d\u519b,\u836f\u5e08\u6d4b\u8bd5,ZS\u5f20\u84d3\u857e,ZS\u5f90\u590f\u96e8,\u738b\u632f\u751f,\u674e\u79c0\u5947,zs\u738b\u6d9b,\u8fd0\u8425\u6d4b\u8bd5\u533b\u751f,\u6b27\u9633\u9876\u8363";
        List<String> list = Arrays.asList(aa.split(","));
        for (String s : list) {
            if (!s.equals(orderEntity.getDoctorName())) continue;
            isTestOrder = 1;
        }
        return isTestOrder;
    }

    private Date stringToDate(ImmediateConsultationDTO immediateConsultationDTO) {
        Date date = null;
        try {
            date = DateUtils.strToDate((String)immediateConsultationDTO.getScheduleDate(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private BaseResponse<InquiryServiceConfigEntity> doctorUseCheck(ImmediateConsultationDTO immediateConsultationDTO) {
        InquiryServiceConfigEntity serviceConfig = this.getDoctorServiceDetail(immediateConsultationDTO);
        if (serviceConfig == null) {
            return BaseResponse.error((String)"\u533b\u751f\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)immediateConsultationDTO.getScheduleDate()) && StringUtils.isEmpty((String)immediateConsultationDTO.getScheduleId())) {
            String scheduleDate = DateUtils.dateToSimpleString((Date)new Date());
            Integer orderCount = this.orderMapper.countDoctorTodayOrders(immediateConsultationDTO.getDoctorId(), immediateConsultationDTO.getOrganId(), scheduleDate, immediateConsultationDTO.getServType());
            if (orderCount >= serviceConfig.getDailyLimit() && -1 != serviceConfig.getDailyLimit()) {
                return BaseResponse.error((String)"\u533b\u751f\u5f53\u65e5\u670d\u52a1\u5df2\u8fbe\u4e0a\u9650");
            }
        } else {
            if (StringUtils.isEmpty((String)immediateConsultationDTO.getScheduleId())) {
                return BaseResponse.error((String)"\u6392\u73ed\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ScheduleRecordEntity scheduleById = this.getScheduleById(immediateConsultationDTO.getScheduleId());
            if (scheduleById.getAvailableCount() <= 0) {
                return BaseResponse.error((String)"\u533b\u751f\u5f53\u65e5\u670d\u52a1\u5df2\u8fbe\u4e0a\u9650");
            }
        }
        return BaseResponse.success((Object)serviceConfig);
    }

    private void zeroOrderCreate(OrderEntity orderEntity, AdmissionEntity admissionEntity, ImmediateConsultationDTO immediateConsultationDTO, String uuid, ServicePayBillEntity servicePayBillEntity) {
        String source;
        MobileBenefitPackageEntity entity = null;
        String string = source = Objects.equals("WX", immediateConsultationDTO.getSmallProgramSource()) ? "WX" : "ZFB";
        if (StringUtils.isNotEmpty((String)immediateConsultationDTO.getBenefitPhone()) && ChannelCodeEnum.MOBILE_PACKAGE.getValue().equals(immediateConsultationDTO.getSmallProgramSource())) {
            entity = this.mobileBenefitPackageService.queryByPhone(immediateConsultationDTO.getBenefitPhone(), immediateConsultationDTO.getActivateOrderId());
            orderEntity.setPayMethod(ChannelCodeEnum.MOBILE_PACKAGE.getValue());
            source = ChannelCodeEnum.MOBILE_PACKAGE.getValue();
        } else {
            orderEntity.setPayMethod(ChannelCodeEnum.NOPAY.getValue());
        }
        orderEntity.setPaymentTime(new Date());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        orderEntity.setXId(orderEntity.getXId());
        log.info("0\u5143\u65b0\u589eorder\u5165\u53c2:" + orderEntity.toString());
        this.orderMapper.updateById((Object)orderEntity);
        log.info("0\u5143\u65b0\u589eorder\u6210\u529f\u51fa\u53c2:" + orderEntity.toString());
        this.orderMapper.updateSmallProgramSource(orderEntity.getXId(), source);
        if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
            log.info("\u6392\u73ed0\u5143\u65b0\u589e");
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
            Date scheduleDate = orderEntity.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderEntity.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setEndTime(expirationDateTime);
        } else {
            log.info("\u975e\u6392\u73ed0\u5143\u65b0\u589e");
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setConvertWaitTime(new Date());
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        }
        if (!ObjectUtils.isEmpty((Object)entity)) {
            admissionEntity.setPackageId(entity.getOrderId());
        }
        log.info("admissionEntity{}", (Object)JSON.toJSONString((Object)admissionEntity));
        this.admissionMapper.insertAdvisoryRecord(admissionEntity);
        log.info("0\u5143\u5c31\u8bca\u8bb0\u5f55\u65b0\u589e\u6210\u529f");
        if (StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleDate()) && StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleId())) {
            ScheduleRecordEntity scheduleById = this.getScheduleById(immediateConsultationDTO.getScheduleId());
            if (null != scheduleById) {
                this.scheduleRecordMapper.reduceAvailableCount(scheduleById.getId());
            }
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(uuid);
            this.orderSender.sendDelay(orderTaskVo3);
            OrderTaskVo orderTaskVo4 = new OrderTaskVo();
            orderTaskVo4.setType(Integer.valueOf(4));
            orderTaskVo4.setId(uuid);
            this.orderSender.sendDelay(orderTaskVo4);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(uuid);
            this.orderSender.sendDelay(orderTaskVo2);
        }
        BaseResponse response = this.payAsyncService.createImSession(orderEntity, admissionEntity);
        if (orderEntity.getScheduleDate() == null) {
            this.payAsyncService.asyncTask(orderEntity, admissionEntity);
        } else {
            this.imInformService.makeAnAppiontment(admissionEntity.getXId());
        }
        if (!ObjectUtils.isEmpty((Object)entity)) {
            NotifyConsultDataVo notifyConsultDataVo = new NotifyConsultDataVo();
            notifyConsultDataVo.setActivateOrderId(entity.getOrderId());
            notifyConsultDataVo.setConsultOrderNo(admissionEntity.getXId());
            notifyConsultDataVo.setStatus(String.valueOf(admissionEntity.getStatus()));
            notifyConsultDataVo.setProductId(entity.getProductId());
            notifyConsultDataVo.setPatientId(entity.getUserId());
            notifyConsultDataVo.setExpertName(admissionEntity.getDoctorName());
            notifyConsultDataVo.setOrderDate(DateUtils.dateToFullString((Date)orderEntity.getXCreateTime()));
            this.mobileBenefitPackageService.notifyConsultData(notifyConsultDataVo);
            entity.setUsed(Integer.valueOf(entity.getUsed() + 1));
            this.mobileBenefitPackageService.updateUsedEntity(entity);
            NotifyConsultDeductVo notifyConsultDeductVo = new NotifyConsultDeductVo();
            notifyConsultDeductVo.setActivateOrderId(entity.getOrderId());
            notifyConsultDeductVo.setProductId(entity.getProductId());
            notifyConsultDeductVo.setBizOrderId(admissionEntity.getXId());
            notifyConsultDeductVo.setOperation(CODE);
            notifyConsultDeductVo.setNum(String.valueOf(entity.getTimeLimit()));
            notifyConsultDeductVo.setSurplusNum(String.valueOf(entity.getTimeLimit() - entity.getUsed()));
            notifyConsultDeductVo.setConsumeNum(CODE);
            this.mobileBenefitPackageService.notifyDeduct(notifyConsultDeductVo);
        }
    }

    private void insertTagsRecord(ImmediateConsultationDTO immediateConsultationDTO) {
        InsertTagsRecordVo insertTagsRecordVo = new InsertTagsRecordVo();
        insertTagsRecordVo.setDeptId(immediateConsultationDTO.getDeptId());
        insertTagsRecordVo.setHospitalId(immediateConsultationDTO.getHospitalId());
        insertTagsRecordVo.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
        insertTagsRecordVo.setServType(immediateConsultationDTO.getServType());
        String response = this.internetHospitalDetailInfoService.insertTagsRecord(insertTagsRecordVo);
        if (StringUtils.isEmpty((String)response)) {
            return;
        }
        log.info("\u4e0b\u5355\u75c5\u4f8b\u4f7f\u7528\u8bb0\u5f55\u65b0\u589e\u6210\u529f");
    }

    private AdmissionEntity createAdmissionEntity(OrderEntity orderInfo, ImmediateConsultationDTO immediateConsultationDTO) {
        AdmissionEntity entity = new AdmissionEntity();
        entity.setXId(String.valueOf(System.currentTimeMillis()));
        entity.setOrganId(orderInfo.getHospitalId());
        entity.setOrderId(orderInfo.getXId());
        entity.setPatientId(orderInfo.getPatientId());
        entity.setDoctorId(orderInfo.getDoctorId());
        entity.setDoctorType(orderInfo.getDoctorType());
        entity.setServType(orderInfo.getServType());
        entity.setMedicalRecordId(orderInfo.getMedicalRecordId());
        entity.setServTime(orderInfo.getServTime());
        entity.setTotalNum(orderInfo.getTotalNum());
        entity.setCurrentNum(orderInfo.getTotalNum());
        entity.setDoctorName(orderInfo.getDoctorName());
        entity.setOrganId(orderInfo.getHospitalId());
        entity.setPauseTime(Long.valueOf(0L));
        entity.setXId(UUIDUtil.getUUID());
        return entity;
    }
}

