/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.createorder.core;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.CardTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PatientInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.TransModelVo;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreSettlementCheckPublicService {
    private static final Logger log = LoggerFactory.getLogger(PreSettlementCheckPublicService.class);
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    private static final String ONE_ONE = "-1";

    public BaseResponse<ImmediateConsultationVo> preSettlementCheck(ImmediateConsultationDTO orderCreateDTO, ImmediateConsultationVo immediateConsultationVo) {
        log.info("\u5165\u53c2immediateConsultationVo{}", (Object)JSON.toJSONString((Object)immediateConsultationVo));
        log.info("\u5165\u53c2orderCreateDTO{}", (Object)JSON.toJSONString((Object)orderCreateDTO));
        if (ServiceTypeEnum.HOS.getValue().equals(orderCreateDTO.getServType())) {
            return BaseResponse.success((Object)immediateConsultationVo);
        }
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(immediateConsultationVo.getAppCode());
        inquiryMchCodeEntity.setHospitalId(orderCreateDTO.getOrganId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity inquiryMchCode = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        log.info("inquiryMchCode:{}" + JSON.toJSONString((Object)inquiryMchCode));
        if (StringUtils.isEmpty((String)inquiryMchCode.getHisUrl()) || null == inquiryMchCode) {
            log.info("\u6ca1\u6709\u914d\u7f6ehis");
            return BaseResponse.success((Object)immediateConsultationVo);
        }
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(orderCreateDTO.getDeptId(), orderCreateDTO.getDoctorId());
        if (null == hisDeptAndDocCode) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u8c03\u7528\u51fa\u9519");
        }
        PatientEntity patientEntity = this.patientMapper.selectById(orderCreateDTO.getPatientId());
        log.info("patientEntity{}", (Object)JSON.toJSONString((Object)patientEntity));
        PreSettlementReqVo preSettlementReqVo = this.preSettlementReq(inquiryMchCode, patientEntity, orderCreateDTO, hisDeptAndDocCode);
        log.info("\u6302\u53f7\u9884\u7ed3\u7b97\u5165\u53c2{}", (Object)JSON.toJSONString((Object)preSettlementReqVo));
        PreSettlementResVo preSettlementResVo = this.hisTemplateService.preSettlement(preSettlementReqVo);
        if (null == preSettlementResVo || preSettlementResVo.getResult().equals(ONE_ONE)) {
            this.orderMapper.deleteById((Serializable)((Object)immediateConsultationVo.getOrderId()));
            log.info("\u5220\u9664\u9884\u7ed3\u7b97\u5931\u8d25\u8ba2\u5355\u6210\u529f");
            AdmissionEntity admissionEntity1 = this.admissionMapper.queryAdmByOrderId(immediateConsultationVo.getOrderId());
            if (null != admissionEntity1) {
                QueryWrapper queryWrapper = new QueryWrapper();
                AdmissionEntity admissionEntity = new AdmissionEntity();
                admissionEntity.setOrderId(immediateConsultationVo.getOrderId());
                queryWrapper.setEntity((Object)admissionEntity);
                this.admissionMapper.delete((Wrapper)queryWrapper);
                log.info("\u5220\u9664\u9884\u7ed3\u7b97\u5931\u8d25\u5c31\u8bca\u8bb0\u5f55\u6210\u529f");
            }
            QueryWrapper queryWrapperTemp = new QueryWrapper();
            ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
            servicePayBillEntity.setOutTradeNo(immediateConsultationVo.getOrderSeq());
            queryWrapperTemp.setEntity((Object)servicePayBillEntity);
            this.servicePayBillMapper.delete((Wrapper)queryWrapperTemp);
            log.info("\u5220\u9664\u8d26\u5355\u8bb0\u5f55\u6210\u529f");
            return BaseResponse.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25,\u8bf7\u52ff\u4e0b\u5355");
        }
        OrderEntity order = new OrderEntity();
        order.setXId(immediateConsultationVo.getOrderId());
        immediateConsultationVo.setPayCost(preSettlementResVo.getPayCost());
        immediateConsultationVo.setTotCost(preSettlementResVo.getTotCost());
        immediateConsultationVo.setPubCost(preSettlementResVo.getPubCost());
        immediateConsultationVo.setOwnCost(preSettlementResVo.getOwnCost());
        order.setHospFlag(orderCreateDTO.getHospFlag());
        order.setPayCost(preSettlementResVo.getPayCost());
        order.setPubCost(preSettlementResVo.getPubCost());
        order.setOwnCost(preSettlementResVo.getOwnCost());
        order.setTotCost(preSettlementResVo.getTotCost());
        order.setFundType(patientEntity.getFundType());
        BigDecimal bigDecimal = new BigDecimal(preSettlementResVo.getTotCost());
        order.setPayAmount(bigDecimal);
        if (StringUtils.isNotEmpty((String)inquiryMchCode.getIsStartActivity()) && CardTypeEnum.ACTIVE.getValue().equals(inquiryMchCode.getIsStartActivity())) {
            Integer age = 0;
            try {
                age = IDCardUtil.getAge((String)patientEntity.getIdcard());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (55 <= age) {
                order.setRegLeve(preSettlementReqVo.getRegLeve());
                order.setDiscount(preSettlementResVo.getOwnCost());
                order.setOwnCost("0.00");
                order.setXRemark("\u6d3b\u52a8\u8ba2\u5355");
                immediateConsultationVo.setDiscount(preSettlementResVo.getOwnCost());
                immediateConsultationVo.setOwnCost("0.00");
                immediateConsultationVo.setRegLeve(order.getRegLeve());
                immediateConsultationVo.setFundType(order.getFundType());
            }
        }
        this.orderMapper.updateById((Object)order);
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)immediateConsultationVo.getOrderId()));
        if (ServiceTypeEnum.NOS.getValue().equals(orderEntity.getServType()) && "HYT".equals(orderEntity.getAppCode())) {
            ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
            servicePayBillEntity.setId(orderEntity.getBillPayId());
            servicePayBillEntity.setDealAmount(new BigDecimal(orderEntity.getOwnCost()));
            this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
        }
        return BaseResponse.success((Object)immediateConsultationVo);
    }

    private PreSettlementReqVo preSettlementReq(InquiryMchCodeEntity inquiryMchCode, PatientEntity patientEntity, ImmediateConsultationDTO orderCreateDTO, HisDeptAndDocCodeVo hisDeptAndDocCode) {
        PreSettlementReqVo preSettlementReqVo = new PreSettlementReqVo();
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setBirthDay(patientEntity.getBirthDates());
        patientInfoVo.setCardNO(patientEntity.getMedicalNO());
        patientInfoVo.setSex(patientEntity.getGender().toString());
        patientInfoVo.setPhone(patientEntity.getAccountPhone());
        patientInfoVo.setName(patientEntity.getPatientName());
        patientInfoVo.setPactCode(patientEntity.getPactCode());
        patientInfoVo.setIdCard(orderCreateDTO.getCredNo());
        patientInfoVo.setAddress(patientEntity.getAddress());
        TransModelVo transModelVo = new TransModelVo();
        transModelVo.setMachineNO("byhl");
        transModelVo.setTransNO("");
        transModelVo.setBankTransNO("");
        preSettlementReqVo.setTransModelVo(transModelVo);
        preSettlementReqVo.setPatientInfoVo(patientInfoVo);
        preSettlementReqVo.setDeptCode(hisDeptAndDocCode.getDeptCode());
        preSettlementReqVo.setDoctCode(hisDeptAndDocCode.getDoctorCode());
        preSettlementReqVo.setRegLeve("16");
        preSettlementReqVo.setRegLeveName("\u4e92\u8054\u7f51\u590d\u8bca\u53f7");
        if (StringUtils.isNotEmpty((String)inquiryMchCode.getIsStartActivity()) && CardTypeEnum.ACTIVE.getValue().equals(inquiryMchCode.getIsStartActivity())) {
            Integer age = 0;
            try {
                age = IDCardUtil.getAge((String)patientEntity.getIdcard());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (55 <= age) {
                preSettlementReqVo.setRegLeve("17");
                preSettlementReqVo.setRegLeveName("\u4e92\u8054\u7f51\u590d\u8bca\u4e49\u8bca\u53f7");
            }
        }
        preSettlementReqVo.setRegType("0");
        preSettlementReqVo.setFundType(patientEntity.getFundType());
        preSettlementReqVo.setHospFlag(orderCreateDTO.getHospFlag().toString());
        preSettlementReqVo.setMarkNO(patientEntity.getCardNo());
        preSettlementReqVo.setMarkType(patientEntity.getFundType());
        preSettlementReqVo.setNoonID("0");
        preSettlementReqVo.setOrderID("");
        preSettlementReqVo.setSchemaID("");
        preSettlementReqVo.setDeptName(hisDeptAndDocCode.getDeptName());
        preSettlementReqVo.setDoctName(hisDeptAndDocCode.getDoctorName());
        return preSettlementReqVo;
    }
}

