/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.sender;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderSender {
    private static final Logger log = LoggerFactory.getLogger(OrderSender.class);
    @Resource
    private BaseInquiryServiceConfigServiceImpl baseService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private AmqpTemplate rabbitTemplate;
    private static final int NO_PAY_DELAYTIME = 86400000;
    private static final int TEN_MIN = 600;
    private static final int NO_RECIVE_DELAYTIME = 86400000;
    private static final long MAX = 2073600000L;
    private static final long MQ_MAX = -61367296L;

    public void sendDelay(OrderTaskVo orderTaskVo) {
        log.info("orderTaskVo{}", (Object)orderTaskVo);
        if (orderTaskVo.getType() == 1) {
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                message.getMessageProperties().setHeader("x-delay", (Object)86400000);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
        if (orderTaskVo.getType() == 2) {
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                long second = this.buildSecond(orderTaskVo);
                message.getMessageProperties().setHeader("x-delay", (Object)second);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
        if (orderTaskVo.getType() == 3) {
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                OrderEntity orderEntity = this.orderService.findById(orderTaskVo.getId());
                long deleyTime = this.buildScheduleBeginTime(orderTaskVo);
                log.info("\u8ddd\u9884\u7ea6\u65f6\u95f4\u5f00\u59cb\uff1adeleyTime \uff1a{}", (Object)deleyTime);
                message.getMessageProperties().setHeader("x-delay", (Object)deleyTime);
                return message;
            });
        }
        if (orderTaskVo.getType() == 4) {
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                long deleyTime = this.buildDeleyTime4(orderTaskVo);
                log.info("\u9884\u7ea6\u65f6\u95f4\u7ed3\u675f\uff1adeleyTime \uff1a{}", (Object)deleyTime);
                message.getMessageProperties().setHeader("x-delay", (Object)deleyTime);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
        if (orderTaskVo.getType() == 5) {
            log.info("======\u5904\u7406\u54a8\u8be2\u4e2d \u8ba2\u5355\u8d85\u65f6\u7684\u95ee\u9898=========");
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderTaskVo.getId());
                Date nowDate = new Date();
                long expireTime = DateUtils.secondsBetween1((Date)nowDate, (Date)admissionEntity.getEndTime());
                log.info("expireTime{}", (Object)JSON.toJSONString((Object)expireTime));
                message.getMessageProperties().setHeader("x-delay", (Object)(expireTime * 1000L));
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
        if (orderTaskVo.getType() == 6) {
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                Date nowDate = new Date();
                AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderTaskVo.getId());
                log.info("admissionEntity:{}", (Object)JSONObject.toJSONString((Object)admissionEntity));
                long time = DateUtils.secondsBetween1((Date)nowDate, (Date)admissionEntity.getEndTime());
                log.info("\u65f6\u95f4\u5dee\u4e3a:{}", (Object)time);
                long lastTime = time - 600L;
                log.info("\u5ef6\u8fdf\u65f6\u95f4\u4e3a\uff1a{}", (Object)lastTime);
                message.getMessageProperties().setHeader("x-delay", (Object)(lastTime * 1000L));
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
        if (orderTaskVo.getType() == 7) {
            long servTime;
            long expireTime = 0L;
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)orderTaskVo.getId()));
            if (Objects.equals(1, orderEntity.getKeepOrder())) {
                expireTime = 43200000L;
            } else if (Objects.equals(2, orderEntity.getKeepOrder())) {
                servTime = orderEntity.getServTime().intValue();
                expireTime = servTime * 60L * 1000L;
                if (expireTime > 2073600000L) {
                    expireTime = 2073600000L;
                }
            } else if (Objects.equals(3, orderEntity.getKeepOrder())) {
                servTime = orderEntity.getServTime().intValue();
                expireTime = servTime * 60L * 1000L;
                if (expireTime > -61367296L) {
                    expireTime = -61367296L;
                }
                expireTime = servTime * 60L * 1000L;
            }
            long time = expireTime;
            log.info("\u8fc7\u671f\u65f6\u95f4:{}", (Object)time);
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                message.getMessageProperties().setHeader("x-delay", (Object)time);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
        if (orderTaskVo.getType() == 8) {
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)orderTaskVo.getId()));
            Date end = DateUtils.dateAddDays((Date)orderEntity.getXCreateTime(), (int)15);
            long time = DateUtils.secondsBetween1((Date)new Date(), (Date)end) * 1000L;
            log.info("\u63d0\u793a\u65f6\u95f4:{}", (Object)time);
            this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "outpatient-order-key", (Object)orderTaskVo, message -> {
                message.getMessageProperties().setHeader("x-delay", (Object)time);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
    }

    public long buildSecond(OrderTaskVo orderTaskVo) {
        long second;
        OrderEntity orderEntity = this.orderService.findById(orderTaskVo.getId());
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(orderEntity.getDoctorId());
        wrapperEntity.setOrganId(String.valueOf(orderEntity.getOrganId()));
        wrapperEntity.setDeptId(orderEntity.getDeptId());
        if (ServiceTypeEnum.NOS.getValue().equals(orderEntity.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(orderEntity.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.setEntity((Object)wrapperEntity);
        queryWrapper1.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper1);
        log.info("\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
        if (null == inquiryServiceConfigEntity && null == inquiryServiceConfigEntity.getOrderTime()) {
            second = 86400000L;
        } else {
            long minute = inquiryServiceConfigEntity.getOrderTime().intValue();
            second = minute * 60L * 1000L;
        }
        return second;
    }

    public long buildDeleyTime4(OrderTaskVo orderTaskVo) {
        OrderEntity orderEntity = this.orderService.findById(orderTaskVo.getId());
        Date scheduleDate = orderEntity.getScheduleDate();
        String scheduleEndTime = orderEntity.getScheduleEndTime();
        String nowDateTimeStr = DateUtils.getCurrentDateToString();
        String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
        String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
        Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
        Date nowDateTime = DateUtils.stringToFullDate((String)nowDateTimeStr);
        long seconds = DateUtils.secondsBetween1((Date)nowDateTime, (Date)expirationDateTime);
        return seconds * 1000L;
    }

    public long buildScheduleBeginTime(OrderTaskVo orderTaskVo) {
        OrderEntity orderEntity = this.orderService.findById(orderTaskVo.getId());
        Date scheduleDate = orderEntity.getScheduleDate();
        String scheduleEndTime = orderEntity.getScheduleStartTime();
        String nowDateTimeStr = DateUtils.getCurrentDateToString();
        String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
        String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
        Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
        Date nowDateTime = DateUtils.stringToFullDate((String)nowDateTimeStr);
        long seconds = DateUtils.secondsBetween1((Date)nowDateTime, (Date)expirationDateTime);
        return seconds * 1000L;
    }

    public static void sendInquiryEndPreNo(RabbitTemplate rabbitTemplate, String admId, Integer differentTime) {
        log.info("-------------\u542f\u52a8\u63d0\u9192\u5ef6\u8fdf\u961f\u5217-------------");
        rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "inquiry-end-pre-key", (Object)admId, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)(differentTime * 1000));
            log.info("send message to rabbitmq: " + admId);
            return message;
        });
        log.info("--------------\u5ef6\u8fdf\u961f\u5217{}ms\u540e\u6267\u884c--------------", (Object)differentTime);
    }
}

