/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.service.MedicalService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicalAdmId;
import com.ebaiyihui.onlineoutpatient.core.vo.PatientCaseDetail;
import com.ebaiyihui.onlineoutpatient.core.vo.UpdateMedicalRecordReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdByAdmIdVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MedicalServiceImpl
implements MedicalService {
    private static final Logger log = LoggerFactory.getLogger(MedicalServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private RedisTemplateService redisTemplateService;

    public PatientCaseDetail getMedicalInfoByAdmId(MedicalAdmId admId) {
        log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u5165\u53c2: " + admId);
        try {
            PatientDynamicMedicalIdByAdmIdVo patientDynamicMedicalIdByAdmIdVo = new PatientDynamicMedicalIdByAdmIdVo();
            patientDynamicMedicalIdByAdmIdVo.setAdmId(admId.getAdmId());
            String body = HttpKit.jsonPost((String)this.projProperties.getMedicalInfoByAdmId(), (String)JSON.toJSONString((Object)patientDynamicMedicalIdByAdmIdVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            if (baseResponse.getData() == null) {
                return null;
            }
            PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = (PatientDynamicMedicalEntityVo)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), PatientDynamicMedicalEntityVo.class);
            log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u8fd4\u56de\u503c: " + patientDynamicMedicalEntityVo.toString());
            PatientCaseDetail patientCaseDetail = new PatientCaseDetail();
            BeanUtils.copyProperties((Object)patientDynamicMedicalEntityVo, (Object)patientCaseDetail);
            return patientCaseDetail;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public BaseResponse updateMedicalRecord(UpdateMedicalRecordReqVo param) {
        String redisKey = param.getAdmId() + "_FZBL";
        Boolean flag = this.redisTemplateService.get(redisKey);
        String url = this.projProperties.getBaseAddress() + "/cloud/sysinfocloud/patientDynamicMedical/updateMedicalNew";
        if (flag.booleanValue()) {
            log.info("\u75c5\u5386\u63d0\u4ea4\u8fc7\u9891\u7e41\uff0c\u8bf7\u7a0d\u7b49\u540e\u91cd\u65b0\u63d0\u4ea4");
            return BaseResponse.error((String)"\u75c5\u5386\u63d0\u4ea4\u8fc7\u9891\u7e41\uff0c\u8bf7\u7a0d\u7b49\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        try {
            log.info("\u4fee\u6539\u75c5\u5386\u5165\u53c2:{} ", (Object)JSONObject.toJSONString((Object)param));
            log.info("url::{}", (Object)url);
            String body = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)param));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u4fee\u6539\u75c5\u5386\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        catch (Exception e) {
            throw new BusinessException("\u4fee\u6539\u75c5\u5386\u5931\u8d25:{}", e.getMessage());
        }
    }
}

