/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.ebaiyihui.onlineoutpatient.common.dto.DeletePatientTagsDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.DeleteTagsDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.InsertTagsDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.PatientIdDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.TagNameDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.team.TeamIdDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorIdVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.TagEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalTagsMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalTagsEntity;
import com.ebaiyihui.onlineoutpatient.core.service.PatientMedicalTagsService;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PatientMedicalTagsServiceImpl
implements PatientMedicalTagsService {
    @Autowired
    private PatientMedicalTagsMapper tagsMapper;

    public ResultData<Integer> insertTags(InsertTagsDTO reqVo) {
        ResultData result = new ResultData();
        reqVo.setTagType(TagEnum.DOCTOR.getValue());
        String tagName = reqVo.getTagName();
        List tagsNameList = this.tagsMapper.selectDoctorTagsByTagsNameAndDoctorId(reqVo.getDoctorId(), tagName);
        if (tagsNameList != null && tagsNameList.size() > 0) {
            return result.error("\u75be\u75c5\u6807\u7b7e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        PatientMedicalTagsEntity entity = this.buildEntity(reqVo);
        Integer count = this.tagsMapper.insertTags(entity);
        if (count == 1) {
            return result.success(null);
        }
        return result.error("\u75be\u75c5\u6807\u7b7e\u6dfb\u52a0\u5931\u8d25\uff01");
    }

    private PatientMedicalTagsEntity buildEntity(InsertTagsDTO reqVo) {
        PatientMedicalTagsEntity entity = new PatientMedicalTagsEntity();
        String patientId = reqVo.getPatientId();
        String doctorId = reqVo.getDoctorId();
        String tagName = reqVo.getTagName();
        Integer tagType = reqVo.getTagType();
        entity.setXCreateTime(new Date());
        entity.setXUpdateTime(new Date());
        entity.setXVersion(Long.valueOf(0L));
        entity.setXId(UUIDUtil.getUUID());
        if (!StringUtils.isEmpty((Object)doctorId)) {
            entity.setDoctorId(doctorId);
        }
        if (!StringUtils.isEmpty((Object)patientId)) {
            entity.setPatientId(patientId);
        }
        if (!StringUtils.isEmpty((Object)tagName)) {
            entity.setTagName(tagName);
        }
        if (!StringUtils.isEmpty((Object)tagType)) {
            entity.setTagType(tagType);
        }
        return entity;
    }

    public ResultData<Integer> deleteTags(DeleteTagsDTO reqVo) {
        ResultData result = new ResultData();
        Integer count = this.tagsMapper.deleteTags(reqVo.getDoctorId(), reqVo.getTagName(), TagEnum.DOCTOR.getValue());
        if (count == 1) {
            return result.success(null);
        }
        return result.error("\u75be\u75c5\u6807\u7b7e\u5220\u9664\u5931\u8d25\uff01");
    }

    public ResultData<List<String>> queryTagsName(TeamIdDTO reqVo) {
        ResultData result = new ResultData();
        List names = this.tagsMapper.queryTagName(reqVo.getDoctorId(), TagEnum.DOCTOR.getValue());
        return result.success((Object)names);
    }

    public ResultData<List<String>> queryPatientTagName(PatientIdDTO reqVo) {
        ResultData result = new ResultData();
        String patientId = reqVo.getPatientId();
        List names = this.tagsMapper.queryPatientTagName(patientId);
        return result.success((Object)names);
    }

    public ResultData<Integer> deletePatientTags(DeletePatientTagsDTO reqVo) {
        ResultData result = new ResultData();
        Integer count = this.tagsMapper.deletePatientTags(reqVo);
        if (count == 1) {
            return result.success(null);
        }
        return result.error("\u60a3\u8005\u75be\u75c5\u6807\u7b7e\u5220\u9664\u5931\u8d25\uff01");
    }

    public ResultData<Integer> insertPatientTags(InsertTagsDTO reqVo) {
        ResultData result = new ResultData();
        DeletePatientTagsDTO dto = new DeletePatientTagsDTO();
        dto.setPatientId(reqVo.getPatientId());
        dto.setTagName(reqVo.getTagName());
        List tagsNameList = this.tagsMapper.selectPatientTagsByTagsNameAndPatientId(dto);
        if (tagsNameList != null && tagsNameList.size() > 0) {
            return result.error("\u6b64\u75be\u75c5\u6807\u7b7e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        reqVo.setTagType(TagEnum.PATIENT.getValue());
        PatientMedicalTagsEntity entity = this.buildEntity(reqVo);
        Integer count = this.tagsMapper.insertTags(entity);
        if (count == 1) {
            return result.success(null);
        }
        return result.error("\u75be\u75c5\u6807\u7b7e\u6dfb\u52a0\u5931\u8d25\uff01");
    }

    public ResultData<String> addPatientTags(InsertTagsDTO reqVo) {
        ResultData result = new ResultData();
        DeletePatientTagsDTO dto = new DeletePatientTagsDTO();
        dto.setPatientId(reqVo.getPatientId());
        dto.setTagName(reqVo.getTagName());
        List tagsNameList = this.tagsMapper.selectPatientTagsByTagsNameAndPatientId(dto);
        if (!CollectionUtils.isEmpty((Collection)tagsNameList)) {
            return result.success((Object)reqVo.getTagName());
        }
        reqVo.setTagType(TagEnum.PATIENT.getValue());
        PatientMedicalTagsEntity entity = this.buildEntity(reqVo);
        Integer count = this.tagsMapper.insertTags(entity);
        if (count == 1) {
            return result.success((Object)reqVo.getTagName());
        }
        return result.error("\u75be\u75c5\u6807\u7b7e\u6dfb\u52a0\u5931\u8d25\uff01");
    }

    public ResultData<List<String>> getDoctorId(TagNameDTO reqVo) {
        ResultData result = new ResultData();
        String tagName = reqVo.getTagName();
        List doctorLists = this.tagsMapper.getDoctorId(tagName);
        return result.success((Object)doctorLists);
    }

    public ResultData<List<PatientMedicalTagsEntity>> patientQueryDoctorTags(DoctorIdVo req) {
        ResultData result = new ResultData();
        if (StringUtils.isEmpty((Object)req.getDoctorId())) {
            return result.error("\u533b\u751fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List tagList = this.tagsMapper.patientQueryDoctorTags(req.getDoctorId(), null);
        return result.success((Object)tagList);
    }
}

