/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.task;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryFamousDotDTO;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.service.doctor.DoctorService;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorAliListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@EnableScheduling
public class AliPushTask {
    private static final Logger log = LoggerFactory.getLogger(AliPushTask.class);
    public static final long ORGAN_ID = 79L;
    public static final String NCEFY = "NCEFY";
    public static final int ONE = 1;
    @Autowired
    private DoctorService doctorService;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;

    @Scheduled(cron="0 0 1 * * ? ")
    public void heartbeat() {
        log.info("\u963f\u91cc\u533b\u751f\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u6267\u884c\u7684\u65f6\u95f4\u4e3a: " + LocalDateTime.now().toLocalTime());
        try {
            ArrayList content = new ArrayList();
            QueryFamousDotDTO reqVo = new QueryFamousDotDTO();
            reqVo.setAppCode("NCEFY");
            reqVo.setOrganId(Long.valueOf(79L));
            reqVo.setPageNum(Integer.valueOf(1));
            reqVo.setPageSize(Integer.valueOf(9999));
            reqVo.setStatus(Integer.valueOf(1));
            reqVo.setType(ServiceTypeEnum.HOS.getValue());
            log.info("\u963f\u91cc\u533b\u751f\u5728\u7ebf\u54a8\u8be2\u67e5\u8be2\u53c2\u6570,{}", (Object)JSONObject.toJSONString((Object)reqVo));
            BaseResponse doctorListVo1 = this.doctorService.getSatfactionAndIdentity(reqVo);
            content.addAll(((PageResult)doctorListVo1.getData()).getContent());
            reqVo.setType(ServiceTypeEnum.NOS.getValue());
            log.info("\u963f\u91cc\u533b\u751f\u5728\u7ebf\u590d\u8bca\u67e5\u8be2\u53c2\u6570,{}", (Object)JSONObject.toJSONString((Object)reqVo));
            BaseResponse doctorListVo2 = this.doctorService.getSatfactionAndIdentity(reqVo);
            content.addAll(((PageResult)doctorListVo2.getData()).getContent());
            log.info("\u963f\u91cc\u533b\u751f\u5728\u7ebf\u54a8\u8be2\u67e5\u8be2\u6761\u6570,{}", (Object)((PageResult)doctorListVo1.getData()).getContent().size());
            log.info("\u963f\u91cc\u533b\u751f\u5728\u7ebf\u590d\u8bca\u67e5\u8be2\u6761\u6570,{}", (Object)((PageResult)doctorListVo2.getData()).getContent().size());
            List collect = content.stream().filter(AliPushTask.distinctByKey(DoctorAliListVo::getDoctorId)).collect(Collectors.toList());
            log.info("\u963f\u91cc\u533b\u751f\u4fe1\u606f\u53bb\u91cd\u540e\u6761\u6570,{}", (Object)collect.size());
            Map doctorHos = ((PageResult)doctorListVo1.getData()).getContent().stream().collect(Collectors.toMap(DoctorAliListVo::getDoctorId, Function.identity()));
            Map doctorNos = ((PageResult)doctorListVo2.getData()).getContent().stream().collect(Collectors.toMap(DoctorAliListVo::getDoctorId, Function.identity()));
            for (DoctorAliListVo doctor : collect) {
                DoctorAliListVo doctorNosStart;
                ArrayList<Integer> types = new ArrayList<Integer>();
                DoctorAliListVo doctorHosStart = (DoctorAliListVo)doctorHos.get(doctor.getDoctorId());
                if (doctorHosStart != null) {
                    types.add(ServiceTypeEnum.HOS.getValue());
                }
                if ((doctorNosStart = (DoctorAliListVo)doctorNos.get(doctor.getDoctorId())) != null) {
                    types.add(ServiceTypeEnum.NOS.getValue());
                }
                doctor.setTypes(types);
            }
            DoctorMessageEventsVo doctorMessageEventsVo = new DoctorMessageEventsVo();
            doctorMessageEventsVo.setAppCode(reqVo.getAppCode());
            doctorMessageEventsVo.setDataType(Integer.valueOf(1));
            doctorMessageEventsVo.setDoctorListVo(collect);
            log.info("\u963f\u91cc\u533b\u751f\u4fe1\u606f\u6570\u636e\u6761\u6570,{}", (Object)doctorMessageEventsVo.getDoctorListVo().size());
            if (!CollectionUtils.isEmpty((Collection)doctorMessageEventsVo.getDoctorListVo())) {
                log.info("\u6dfb\u52a0\u533b\u751f\u4fe1\u606f");
                this.aliMedicalInformationSender.sendDoctorInformationData(doctorMessageEventsVo);
                log.info("\u6dfb\u52a0\u533b\u751f\u72b6\u6001");
                this.aliMedicalInformationSender.sendDoctorInformationState(doctorMessageEventsVo);
            } else {
                log.info("\u963f\u91cc\u533b\u751f\u4fe1\u606f\u6570\u636e\u7a7a\u4e0d\u6dfb\u52a0,{}", (Object)JSONObject.toJSONString((Object)doctorMessageEventsVo));
            }
        }
        catch (Exception e) {
            log.info("\u963f\u91cc\u533b\u751f\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38: " + e);
        }
        log.info("\u963f\u91cc\u533b\u751f\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u6267\u884c\u7684\u65f6\u95f4\u4e3a: " + LocalDateTime.now().toLocalTime());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

