/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.UserRestTemplateUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.PushConfigSignCodeDetailVO;
import com.ebaiyihui.onlineoutpatient.core.vo.PushConfigurationDetailVO;
import com.ebaiyihui.onlineoutpatient.core.vo.UmPushMsgAndroidReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.UmPushMsgIOSReqVo;
import com.ebaiyihui.push.pojo.miniapp.MiniappTmpMsgReqVO;
import com.ebaiyihui.push.pojo.wechat.PushSubscribeMessageReqVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PushUtils {
    private static final Logger log = LoggerFactory.getLogger(PushUtils.class);
    @Autowired
    private ProjProperties projProperties;

    public PushConfigurationDetailVO getPushConfig(String appCode, String pushType, String userType, String channlType) {
        PushConfigurationDetailVO configurationDetailVO = new PushConfigurationDetailVO();
        String pushConfigUrl = this.projProperties.getPushConfigUrl();
        String configuration = UserRestTemplateUtil.getConfigurationDetail((String)appCode, (String)pushType, (String)pushConfigUrl);
        log.info("configuration :{}", (Object)JSON.toJSONString((Object)configuration));
        if (pushType.equals("youmengPush")) {
            List configurationDetailVos = JSONObject.parseArray((String)configuration, PushConfigurationDetailVO.class);
            log.info(" json\u8f6clist ==configurationDetailVos :{}", (Object)JSON.toJSONString((Object)configurationDetailVos));
            for (PushConfigurationDetailVO detailVO : configurationDetailVos) {
                if (!detailVO.getUserType().equals(userType) || !detailVO.getDeviceType().equals(channlType)) continue;
                BeanUtils.copyProperties((Object)detailVO, (Object)configurationDetailVO);
            }
            return configurationDetailVO;
        }
        PushConfigurationDetailVO pushConfigurationDetailVO = (PushConfigurationDetailVO)JSONObject.parseObject((String)configuration, PushConfigurationDetailVO.class);
        log.info(" json\u8f6cobj ==pushConfigurationDetailVO :{}", (Object)JSON.toJSONString((Object)pushConfigurationDetailVO));
        if (pushType.equals("sms")) {
            PushConfigSignCodeDetailVO pushConfigSignCodeDetailVO = (PushConfigSignCodeDetailVO)JSONObject.parseObject((String)pushConfigurationDetailVO.getSignCode(), PushConfigSignCodeDetailVO.class);
            log.info(" json\u8f6cobj ==pushConfigSignCodeDetailVO :{}", (Object)JSON.toJSONString((Object)pushConfigSignCodeDetailVO));
            pushConfigurationDetailVO.setDoctorCode(pushConfigSignCodeDetailVO.getDoctorCode());
            pushConfigurationDetailVO.setPatientCode(pushConfigSignCodeDetailVO.getPatientCode());
        }
        return pushConfigurationDetailVO;
    }

    public BaseResponse<String> pushSubscribeMessage(PushSubscribeMessageReqVO pushSubscribeMessageReqVO) {
        log.info("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u8bf7\u6c42: " + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
        try {
            String body = HttpKit.jsonPost((String)this.projProperties.getWechatpushUrl(), (String)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public BaseResponse<String> pushAndroidMessage(UmPushMsgAndroidReqVO umPushMsgAndroidReqVO) {
        log.info("\u53cb\u76df\u5b89\u5353\u63a8\u9001\u8bf7\u6c42: " + JSON.toJSONString((Object)umPushMsgAndroidReqVO));
        try {
            String body = HttpKit.jsonPost((String)this.projProperties.getAndroidPushurl(), (String)JSON.toJSONString((Object)umPushMsgAndroidReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u53cb\u76df\u5b89\u5353\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53cb\u76df\u5b89\u5353\u63a8\u9001\u63a8\u9001\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public BaseResponse<String> pushIOSMessage(UmPushMsgIOSReqVo umPushMsgIOSReqVo) {
        log.info("\u53cb\u76dfIOS\u63a8\u9001\u8bf7\u6c42: " + JSON.toJSONString((Object)umPushMsgIOSReqVo));
        try {
            String body = HttpKit.jsonPost((String)this.projProperties.getIosPushurl(), (String)JSON.toJSONString((Object)umPushMsgIOSReqVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u53cb\u76dfios\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53cb\u76dfios\u63a8\u9001\u63a8\u9001\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public BaseResponse<String> pushAlipaySubscribeMessage(MiniappTmpMsgReqVO miniappTmpMsgReqVO) {
        if (ObjectUtils.isEmpty((Object)miniappTmpMsgReqVO)) {
            log.info("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u8bf7\u6c42\u53c2\u6570\u7a7a\uff0c\u505c\u6b62\u63a8\u9001: " + JSON.toJSONString((Object)miniappTmpMsgReqVO));
            return new BaseResponse();
        }
        log.info("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u8bf7\u6c42: " + JSON.toJSONString((Object)miniappTmpMsgReqVO));
        try {
            String body = HttpKit.jsonPost((String)this.projProperties.getAlipayPushUrl(), (String)JSON.toJSONString((Object)miniappTmpMsgReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u5931\u8d25" + e.getMessage());
            return null;
        }
    }
}

