/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.CardTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.PayCallBackServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PayNotifyResultVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PatientInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegisteredSaveResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegistrationConfirmReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegistrationConfirmResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.TransModelVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MedicarePaymentService {
    private static final Logger log = LoggerFactory.getLogger(MedicarePaymentService.class);
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private PayCallBackServiceImpl payCallBackService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    private static final String ONE = "1";
    private static final String ONE_ONE = "-1";

    public BaseResponse<String> medicarePayment(ResponseNotifyRestVo dto, OrderEntity orderInfo, AdmissionEntity admissionEntity) {
        BaseResponse x;
        InquiryMchCodeEntity inquiryEntity = this.getHisUrl(orderInfo.getAppCode(), orderInfo.getHospitalId());
        PatientEntity patientEntity = this.patientMapper.selectById(orderInfo.getPatientId());
        if (null == patientEntity) {
            return BaseResponse.error((String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != inquiryEntity && StringUtils.isNotEmpty((String)inquiryEntity.getHisUrl()) && "HYT".equals(inquiryEntity.getAppCode()) && (x = this.HYTHis(inquiryEntity, dto, orderInfo, admissionEntity, patientEntity)) != null) {
            return x;
        }
        return BaseResponse.success((Object)"success");
    }

    public BaseResponse<String> HYTHis(InquiryMchCodeEntity inquiryEntity, ResponseNotifyRestVo dto, OrderEntity orderInfo, AdmissionEntity admissionEntity, PatientEntity patientEntity) {
        log.info("\u56de\u8c03\u4e2d\u8c03\u7528his\u5f00\u59cb\u65f6\u95f4\uff1a{}" + System.currentTimeMillis());
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(orderInfo.getDeptId().toString(), orderInfo.getDoctorId());
        if (null == hisDeptAndDocCode) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u8c03\u7528\u51fa\u9519");
        }
        PreSettlementReqVo preSettlementReqVo = this.getRegisteredSaveReq(orderInfo, patientEntity, hisDeptAndDocCode);
        if (StringUtils.isNotEmpty((String)inquiryEntity.getIsStartActivity()) && CardTypeEnum.ACTIVE.getValue().equals(inquiryEntity.getIsStartActivity()) && StringUtils.isNotEmpty((String)orderInfo.getRegLeve()) && "17".equals(orderInfo.getRegLeve())) {
            preSettlementReqVo.setRegLeve("17");
            preSettlementReqVo.setRegLeveName("\u4e92\u8054\u7f51\u590d\u8bca\u4e49\u8bca\u53f7");
        }
        log.info("\u6302\u53f7\u4fdd\u5b58\u5165\u53c2:" + preSettlementReqVo.toString());
        RegisteredSaveResVo registeredSaveResVo = this.hisTemplateService.registeredSave(preSettlementReqVo);
        if (null != registeredSaveResVo && registeredSaveResVo.getResult().equals(ONE)) {
            log.info("registeredSaveResVo:" + registeredSaveResVo.toString());
            OrderEntity order = new OrderEntity();
            order.setXId(orderInfo.getXId());
            order.setClinicCode(registeredSaveResVo.getClinicCode());
            order.setInvoiceNo(registeredSaveResVo.getInvoiceNo());
            this.orderMapper.updateById((Object)order);
            log.info("order:" + JSON.toJSONString((Object)order));
            RegistrationConfirmReqVo registrationConfirmReqVo = new RegistrationConfirmReqVo();
            registrationConfirmReqVo.setCarNo(patientEntity.getMedicalNO());
            registrationConfirmReqVo.setClino(order.getClinicCode());
            registrationConfirmReqVo.setInvoiceNo(registeredSaveResVo.getInvoiceNo());
            registrationConfirmReqVo.setPayMode("WX");
            if (StringUtils.isNotEmpty((String)inquiryEntity.getIsStartActivity()) && CardTypeEnum.ACTIVE.getValue().equals(inquiryEntity.getIsStartActivity()) && StringUtils.isNotEmpty((String)orderInfo.getRegLeve()) && "17".equals(orderInfo.getRegLeve())) {
                BigDecimal bigDecimal = new BigDecimal(orderInfo.getDiscount());
                BigDecimal discount = bigDecimal.multiply(new BigDecimal(100));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                String format = simpleDateFormat.format(new Date());
                String transInfo = "SUCCESS|OK|wx7ad695a3667e8583|1254487301|" + UUIDUtil.getUUID() + "|" + UUIDUtil.getUUID() + "|SUCCESS|" + UUIDUtil.getUUID() + "|N|WX|0000|" + discount + "|CNY|" + UUIDUtil.getUUID() + "|" + orderInfo.getDealSeq() + "||" + format + "|SUCCESS|" + discount + "|1|" + registeredSaveResVo.getInvoiceNo() + "|" + patientEntity.getMedicalNO() + "|0|1";
                registrationConfirmReqVo.setTransInfo(transInfo);
                registrationConfirmReqVo.setCost(orderInfo.getDiscount());
            } else {
                PayNotifyResultVo payNotifyReqVO = (PayNotifyResultVo)JSON.parseObject((String)dto.getNotifyResultStr(), PayNotifyResultVo.class);
                log.info("payNotifyReqVO:" + JSON.toJSONString((Object)payNotifyReqVO));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                String format = simpleDateFormat.format(orderInfo.getPaymentTime());
                BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
                BigDecimal ownCost = bigDecimal.multiply(new BigDecimal(100));
                String transInfo = "SUCCESS|OK|" + payNotifyReqVO.getAppid() + "|" + payNotifyReqVO.getMchId() + "|" + payNotifyReqVO.getNonceStr() + "|" + payNotifyReqVO.getSign() + "|SUCCESS|" + payNotifyReqVO.getOpenid() + "|" + payNotifyReqVO.getIsSubscribe() + "|" + payNotifyReqVO.getTradeType() + "|" + payNotifyReqVO.getBankType() + "|" + ownCost + "|" + payNotifyReqVO.getFeeType() + "|" + payNotifyReqVO.getTransactionId() + "|" + orderInfo.getDealSeq() + "||" + format + "|SUCCESS|" + ownCost + "|1|" + registeredSaveResVo.getInvoiceNo() + "|" + patientEntity.getMedicalNO() + "|0|1";
                registrationConfirmReqVo.setTransInfo(transInfo);
                registrationConfirmReqVo.setCost(orderInfo.getOwnCost());
            }
            RegistrationConfirmResVo registrationConfirmResVo = this.hisTemplateService.registrationConfirmation(registrationConfirmReqVo);
            if (null == registrationConfirmResVo || registrationConfirmResVo.getResult().equals(ONE_ONE)) {
                log.info("\u6302\u53f7\u786e\u8ba4\u5931\u8d25");
                RequestRefundVo requestRefundVo = new RequestRefundVo();
                requestRefundVo.setOrderId(orderInfo.getXId());
                BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
                AdmissionEntity admission = new AdmissionEntity();
                admission.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
                admission.setXId(admissionEntity.getXId());
                Integer update = this.admissionMapper.update(admission);
                if (!update.equals(WhetherEnum.ALLOW.getValue())) {
                    log.info("\u6302\u53f7\u6210\u529f,\u9000\u6b3e\u6210\u529f,\u9000\u53f7\u6210\u529f,\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
                    return BaseResponse.error((String)"\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
                }
            }
        } else {
            log.info("\u6302\u53f7\u4fdd\u5b58\u8c03\u7528\u5931\u8d25");
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(orderInfo.getXId());
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
            AdmissionEntity admission = new AdmissionEntity();
            admission.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admission.setXId(admissionEntity.getXId());
            Integer update = this.admissionMapper.update(admission);
            if (!update.equals(WhetherEnum.ALLOW.getValue())) {
                log.info("\u6302\u53f7\u5931\u8d25,\u9000\u6b3e\u6210\u529f,\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
                return BaseResponse.error((String)"\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            return BaseResponse.error((String)"\u6302\u53f7\u4fdd\u5b58\u8c03\u7528\u5931\u8d25");
        }
        log.info("\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        return BaseResponse.success((Object)"fail");
    }

    private PreSettlementReqVo getRegisteredSaveReq(OrderEntity orderInfo, PatientEntity patientEntity, HisDeptAndDocCodeVo hisDeptAndDocCode) {
        PreSettlementReqVo preSettlementReqVo = new PreSettlementReqVo();
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setBirthDay(patientEntity.getBirthDates());
        patientInfoVo.setCardNO(patientEntity.getMedicalNO());
        patientInfoVo.setSex(patientEntity.getGender().toString());
        patientInfoVo.setPhone(patientEntity.getAccountPhone());
        patientInfoVo.setName(patientEntity.getPatientName());
        patientInfoVo.setPactCode(patientEntity.getPactCode());
        patientInfoVo.setIdCard(patientEntity.getIdcard());
        patientInfoVo.setAddress(patientEntity.getAddress());
        TransModelVo transModelVo = new TransModelVo();
        transModelVo.setMachineNO("byhl");
        transModelVo.setTransNO(UUIDUtil.getUUID());
        transModelVo.setBankTransNO(UUIDUtil.getUUID());
        preSettlementReqVo.setTransModelVo(transModelVo);
        preSettlementReqVo.setPatientInfoVo(patientInfoVo);
        preSettlementReqVo.setDeptCode(hisDeptAndDocCode.getDeptCode());
        preSettlementReqVo.setDoctCode(hisDeptAndDocCode.getDoctorCode());
        preSettlementReqVo.setDoctName(hisDeptAndDocCode.getDoctorName());
        preSettlementReqVo.setDeptName(hisDeptAndDocCode.getDeptName());
        preSettlementReqVo.setRegLeve("16");
        preSettlementReqVo.setNoonID("0");
        preSettlementReqVo.setRegType("0");
        preSettlementReqVo.setRegLeveName("\u4e92\u8054\u7f51\u590d\u8bca\u53f7");
        preSettlementReqVo.setFundType(patientEntity.getFundType());
        preSettlementReqVo.setHospFlag(orderInfo.getHospFlag().toString());
        preSettlementReqVo.setMarkNO(patientEntity.getCardNo());
        preSettlementReqVo.setMarkType(patientEntity.getFundType());
        preSettlementReqVo.setNoonID("0");
        preSettlementReqVo.setOrderID("");
        preSettlementReqVo.setSchemaID("");
        preSettlementReqVo.setPayType(PayTypeEnum.WX.name());
        return preSettlementReqVo;
    }

    public InquiryMchCodeEntity getHisUrl(String appCode, String hospitalId) {
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(appCode);
        inquiryMchCodeEntity.setHospitalId(hospitalId);
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        return entity;
    }
}

