/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.common.enums;

import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import java.math.BigDecimal;
import java.util.Date;

public enum PatientNetinquiryOrderStatusEnum {
    CANCEL(Integer.valueOf(-1), "\u5df2\u53d6\u6d88"),
    TOPAY(Integer.valueOf(1), "\u5f85\u652f\u4ed8"),
    PAY_EXPIRED(Integer.valueOf(2), "\u5df2\u8fc7\u671f"),
    TO_CONSULTATION(Integer.valueOf(3), "\u5f85\u63a5\u8bca"),
    IN_CONSULTATION(Integer.valueOf(4), "\u54a8\u8be2\u4e2d"),
    FINISH_NOT_EVALUATED(Integer.valueOf(5), "\u5df2\u5b8c\u6210"),
    PATIENT_FINISH_NOT_EVALUATED(Integer.valueOf(12), "\u5df2\u5b8c\u6210"),
    FINISH_EVALUATED(Integer.valueOf(6), "\u5df2\u5b8c\u6210"),
    ADMISSION_NOT_HANDLE(Integer.valueOf(7), "\u5df2\u9000\u6b3e"),
    REQUEST_REFUND(Integer.valueOf(8), "\u5df2\u9000\u6b3e"),
    REFUSE_ADMISSION(Integer.valueOf(9), "\u5df2\u9000\u6b3e"),
    RETIRED_REFUND(Integer.valueOf(14), "\u5df2\u9000\u6b3e"),
    REQUEST_REFUNDING(Integer.valueOf(10), "\u9000\u6b3e\u4e2d"),
    FINISH_DEFAULT_EVALUATED(Integer.valueOf(11), "\u5df2\u5b8c\u6210"),
    REFUNDED_REFUSE_ZERO(Integer.valueOf(30), "\u5df2\u62d2\u7edd"),
    TO_REPORT(Integer.valueOf(20), "\u5f85\u5019\u8bca"),
    EXPIRED(Integer.valueOf(21), "\u5df2\u8fc7\u671f"),
    TO_BE_RECEIVED_REFUND(Integer.valueOf(15), "\u5df2\u9000\u6b3e"),
    DOCTOR_CLOSED_SCHEDULE_REFUND(Integer.valueOf(16), "\u5df2\u9000\u6b3e"),
    REFERRAL(Integer.valueOf(40), "\u5df2\u5b8c\u6210"),
    ADMIN_REFUNDED(Integer.valueOf(45), "\u5df2\u5931\u6548"),
    PASS_NUMBER(Integer.valueOf(50), "\u5df2\u8fc7\u53f7");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private PatientNetinquiryOrderStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static Integer getPatientNetinquiryOrderListVoStatus(Integer orderStatus, Integer admStatus, BigDecimal payAmount, Date scheduleDate) {
        if (OrderStatusEnum.CANCEL.getValue().equals(orderStatus)) {
            return CANCEL.getValue();
        }
        if (OrderStatusEnum.TOPAY.getValue().equals(orderStatus)) {
            return TOPAY.getValue();
        }
        if (OrderStatusEnum.EXPIRED.getValue().equals(orderStatus)) {
            return PAY_EXPIRED.getValue();
        }
        if (OrderStatusEnum.PAID.getValue().equals(orderStatus)) {
            if (null != scheduleDate && AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admStatus)) {
                return TO_REPORT.getValue();
            }
            if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admStatus)) {
                return TO_CONSULTATION.getValue();
            }
            if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admStatus)) {
                return IN_CONSULTATION.getValue();
            }
            if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(admStatus) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(admStatus)) {
                return FINISH_NOT_EVALUATED.getValue();
            }
            if (AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(admStatus)) {
                return FINISH_EVALUATED.getValue();
            }
            if (AdmissionStatusEnum.REFERRAL.getValue().equals(admStatus) || AdmissionStatusEnum.REFERRAL_MANAGER.getValue().equals(admStatus) || AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue().equals(admStatus)) {
                return REFERRAL.getValue();
            }
            if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(admStatus)) {
                return REFUSE_ADMISSION.getValue();
            }
            if (AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(admStatus)) {
                return REFUNDED_REFUSE_ZERO.getValue();
            }
            if (AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue().equals(admStatus)) {
                return TO_BE_RECEIVED_REFUND.getValue();
            }
            if (AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue().equals(admStatus) || AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue().equals(admStatus)) {
                return DOCTOR_CLOSED_SCHEDULE_REFUND.getValue();
            }
            if (AdmissionStatusEnum.PASSNUMBER.getValue().equals(admStatus)) {
                return PASS_NUMBER.getValue();
            }
        } else if (OrderStatusEnum.REFUNDED.getValue().equals(orderStatus)) {
            if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(admStatus)) {
                if (payAmount.compareTo(BigDecimal.ZERO) == 0) {
                    return REFUNDED_REFUSE_ZERO.getValue();
                }
                return REFUSE_ADMISSION.getValue();
            }
            if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(admStatus) || AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue().equals(admStatus) || AdmissionStatusEnum.PASSNUMBER_REFUND.getValue().equals(admStatus)) {
                return ADMISSION_NOT_HANDLE.getValue();
            }
            if (AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(admStatus)) {
                return REQUEST_REFUND.getValue();
            }
            if (AdmissionStatusEnum.RETIRED.getValue().equals(admStatus)) {
                return RETIRED_REFUND.getValue();
            }
            if (AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue().equals(admStatus)) {
                return TO_BE_RECEIVED_REFUND.getValue();
            }
            if (AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue().equals(admStatus) || AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue().equals(admStatus)) {
                return DOCTOR_CLOSED_SCHEDULE_REFUND.getValue();
            }
            if (AdmissionStatusEnum.ADMIN_REFUNDED.getValue().equals(admStatus) || AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue().equals(admStatus)) {
                return ADMIN_REFUNDED.getValue();
            }
        }
        return null;
    }

    public static Integer getManagePatientNetinquiryOrderListVoStatus(Integer orderStatus, Integer admStatus, String reviewsId, String reviewRemark) {
        if (OrderStatusEnum.CANCEL.getValue().equals(orderStatus)) {
            return CANCEL.getValue();
        }
        if (OrderStatusEnum.TOPAY.getValue().equals(orderStatus)) {
            return TOPAY.getValue();
        }
        if (OrderStatusEnum.EXPIRED.getValue().equals(orderStatus)) {
            return PAY_EXPIRED.getValue();
        }
        if (OrderStatusEnum.PAID.getValue().equals(orderStatus) || OrderStatusEnum.REFUNDED.getValue().equals(orderStatus) || OrderStatusEnum.REFUNDING.getValue().equals(orderStatus)) {
            if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admStatus)) {
                return TO_CONSULTATION.getValue();
            }
            if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admStatus)) {
                return IN_CONSULTATION.getValue();
            }
            if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(admStatus)) {
                return REFUSE_ADMISSION.getValue();
            }
            if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(admStatus)) {
                return ADMISSION_NOT_HANDLE.getValue();
            }
            if (AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(admStatus)) {
                return REQUEST_REFUND.getValue();
            }
            if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(admStatus) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(admStatus)) {
                return FINISH_NOT_EVALUATED.getValue();
            }
            if (AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(admStatus)) {
                return FINISH_EVALUATED.getValue();
            }
        }
        return null;
    }
}

