/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.config;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DelayRabbitConfig {
    private static final Logger log = LoggerFactory.getLogger(DelayRabbitConfig.class);
    public static final String ORDER_DELAY_QUEUE_1 = "byh-online-outpatient-delay-queue";
    public static final String ORDER_DELAY_EXCHANGE = "byh-online-outpatient-delay-exchange";
    public static final String ORDER_ROUTING_KEY_5 = "outpatient-order-key";
    public static final String INQUIRY_END_PRE_QUEUE_NAME = "inquiry.end.pre";
    public static final String INQUIRY_END_PRE_KEY = "inquiry-end-pre-key";
    public static final String DOCTOR_INFORMATION_DATA_QUEUE_NAME = "doctor.information.data";
    public static final String DOCTOR_INFORMATION_DATA_KEY = "doctor.information.data.key";
    public static final String DOCTOR_INFORMATION_STATE_QUEUE_NAME = "doctor.information.state";
    public static final String DOCTOR_INFORMATION_STATE_KEY = "doctor.information.state.key";
    public static final String ORDER_INFORMATION_DATA_QUEUE_NAME = "order.information.data";
    public static final String ORDER_INFORMATION_DATA_KEY = "order.information.data.key";

    @Bean
    public Queue orderQueue1() {
        return new Queue(ORDER_DELAY_QUEUE_1, true);
    }

    @Bean
    public CustomExchange orderDelayExchange1() {
        HashMap<String, String> param = new HashMap<String, String>(10);
        param.put("x-delayed-type", "direct");
        return new CustomExchange(ORDER_DELAY_EXCHANGE, "x-delayed-message", true, false, param);
    }

    @Bean
    public Binding orderBinding5() {
        return BindingBuilder.bind((Queue)this.orderQueue1()).to((Exchange)this.orderDelayExchange1()).with(ORDER_ROUTING_KEY_5).noargs();
    }

    @Bean
    public Queue inquiryEndPreQueue() {
        return new Queue(INQUIRY_END_PRE_QUEUE_NAME, true);
    }

    @Bean
    public Binding inquiryEndPreBinding() {
        return BindingBuilder.bind((Queue)this.inquiryEndPreQueue()).to((Exchange)this.orderDelayExchange1()).with(INQUIRY_END_PRE_KEY).noargs();
    }

    @Bean
    public Queue doctorInformationDataQueue() {
        return new Queue(DOCTOR_INFORMATION_DATA_QUEUE_NAME, true);
    }

    @Bean
    public Binding doctorInformationDataBinding() {
        return BindingBuilder.bind((Queue)this.doctorInformationDataQueue()).to((Exchange)this.orderDelayExchange1()).with(DOCTOR_INFORMATION_DATA_KEY).noargs();
    }

    @Bean
    public Queue doctorInformationStateQueue() {
        return new Queue(DOCTOR_INFORMATION_STATE_QUEUE_NAME, true);
    }

    @Bean
    public Binding doctorInformationStateBinding() {
        return BindingBuilder.bind((Queue)this.doctorInformationStateQueue()).to((Exchange)this.orderDelayExchange1()).with(DOCTOR_INFORMATION_STATE_KEY).noargs();
    }

    @Bean
    public Queue orderInformationDataQueue() {
        return new Queue(ORDER_INFORMATION_DATA_QUEUE_NAME, true);
    }

    @Bean
    public Binding orderInformationDataBinding() {
        return BindingBuilder.bind((Queue)this.orderInformationDataQueue()).to((Exchange)this.orderDelayExchange1()).with(ORDER_INFORMATION_DATA_KEY).noargs();
    }
}

