/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UserInfoByDoctorIdRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.ImAccountService;
import com.ebaiyihui.onlineoutpatient.core.service.client.ImApiFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.UserApiFeignClient;
import com.ebaiyihui.onlineoutpatient.core.utils.JsonUtil;
import com.ebaiyihui.usercenter.client.UserClient;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ImAccountServiceImpl
implements ImAccountService {
    private static final Logger log = LoggerFactory.getLogger(ImAccountServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(ImAccountServiceImpl.class);
    @Resource
    private ImApiFeignClient imApiFeignClient;
    @Resource
    private UserClient userCenterClient;
    @Autowired
    private UserApiFeignClient userApiFeignClient;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;

    public IMQueryTargetSdkAccountRspVO queryImAccount(String admId, String imAppCode, String doctorId) {
        BaseResponse response;
        log.info("admId:" + admId);
        log.info("imAppCode:" + imAppCode);
        if (StringUtils.isEmpty((Object)admId)) {
            return null;
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (admissionEntity == null) {
            return null;
        }
        log.info("admissionEntity:" + admissionEntity.toString());
        IMQueryTargetSdkAccountReqVO imQueryTargetSdkAccountReqVO = new IMQueryTargetSdkAccountReqVO();
        if ("EHOS_DOCTOR".equals(imAppCode)) {
            response = this.userApiFeignClient.getUserInfoByDoctorId(doctorId);
            log.info("response:{}", (Object)JsonUtil.convertObject((Object)response));
            if (response.isSuccess()) {
                UserInfoByDoctorIdRespVO userInfoByDoctorIdRespVO = (UserInfoByDoctorIdRespVO)response.getData();
                logger.info("userInfoByDoctorIdRespVO:{}" + JSONObject.toJSONString((Object)userInfoByDoctorIdRespVO));
                imQueryTargetSdkAccountReqVO.setUserId(userInfoByDoctorIdRespVO.getUserId());
            }
        } else if ("EHOS_PATIENT".equals(imAppCode)) {
            imQueryTargetSdkAccountReqVO.setUserId(orderEntity.getPatientUserId());
        }
        imQueryTargetSdkAccountReqVO.setBusiCode("zxzx");
        imQueryTargetSdkAccountReqVO.setAppCode(imAppCode);
        imQueryTargetSdkAccountReqVO.setTreatmentId(admId);
        logger.info("imQueryTargetSdkAccountReqVO:{}" + JSONObject.toJSONString((Object)imQueryTargetSdkAccountReqVO));
        response = this.imApiFeignClient.qeuryTagetSdkAccount(imQueryTargetSdkAccountReqVO);
        log.info("imApiFeignClient-response{}", (Object)JSON.toJSONString((Object)response));
        if (response.isSuccess()) {
            return (IMQueryTargetSdkAccountRspVO)response.getData();
        }
        logger.warn("IM\u8d26\u53f7\u67e5\u8be2 - \u67e5\u8be2\u5931\u8d25 - response:{}", (Object)JsonUtil.convertObject((Object)response));
        return null;
    }
}

