/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.RequestScheduleTimeIntervalVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.ScheduleTimeSaveListVo;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleTimeIntervalEntity;
import com.ebaiyihui.onlineoutpatient.core.service.ScheduleTimeIntervalService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseScheduleTimeIntervalServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleTimeIntervalServiceImpl
implements ScheduleTimeIntervalService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleTimeIntervalServiceImpl.class);
    @Autowired
    private BaseScheduleTimeIntervalServiceImpl baseService;

    public Boolean saveScheduleTimeInterval(RequestScheduleTimeIntervalVo timeIntervalVo) {
        List scheduleTimeSaveListVos = timeIntervalVo.getListVos();
        if (null == scheduleTimeSaveListVos) {
            return null;
        }
        Long hospitalId = timeIntervalVo.getHospitalId();
        String remark = timeIntervalVo.getRemark();
        ArrayList<ScheduleTimeIntervalEntity> entities = new ArrayList<ScheduleTimeIntervalEntity>();
        for (ScheduleTimeSaveListVo saveListVo : scheduleTimeSaveListVos) {
            ScheduleTimeIntervalEntity scheduleTimeIntervalEntity = new ScheduleTimeIntervalEntity();
            scheduleTimeIntervalEntity.setScheduleRange(saveListVo.getScheduleRange());
            scheduleTimeIntervalEntity.setHospitalId(hospitalId);
            scheduleTimeIntervalEntity.setRemark(remark);
            scheduleTimeIntervalEntity.setStartTime(saveListVo.getStartTime());
            scheduleTimeIntervalEntity.setEndTime(saveListVo.getEndTime());
            entities.add(scheduleTimeIntervalEntity);
        }
        log.info("\u65b0\u589e\u6392\u73ed\u65f6\u6bb5\uff1a{}", (Object)((Object)entities).toString());
        Boolean result = this.baseService.saveBatch(entities);
        return result;
    }

    public Boolean updateScheduleTimeInterval(ScheduleTimeIntervalEntity entity) {
        Boolean result = this.baseService.updateById((Object)entity);
        return result;
    }

    public Boolean deleteScheduleTimeInterval(Long id) {
        Boolean result = this.baseService.removeById((Serializable)id);
        return result;
    }

    public ScheduleTimeIntervalEntity getScheduleTimeIntervalById(Long id) {
        return (ScheduleTimeIntervalEntity)this.baseService.getById((Serializable)id);
    }

    public ScheduleTimeIntervalEntity getTimeIntervalByScheduleRangeAndHospitalId(Long hospitalId, Integer scheduleRange) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleTimeIntervalEntity entity = new ScheduleTimeIntervalEntity();
        entity.setHospitalId(hospitalId);
        entity.setScheduleRange(scheduleRange);
        queryWrapper.setEntity((Object)entity);
        ScheduleTimeIntervalEntity scheduleTimeIntervalEntity = (ScheduleTimeIntervalEntity)this.baseService.getOne((Wrapper)queryWrapper);
        return scheduleTimeIntervalEntity;
    }

    public List<ScheduleTimeIntervalEntity> getScheduleTimeIntervalByHospitalId(Long hospitalId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleTimeIntervalEntity entity = new ScheduleTimeIntervalEntity();
        entity.setHospitalId(hospitalId);
        queryWrapper.setEntity((Object)entity);
        List intervalEntityList = this.baseService.list((Wrapper)queryWrapper);
        return intervalEntityList;
    }
}

