/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableDiscoveryClient
@SpringBootApplication
@EnableTransactionManagement
@EnableEurekaClient
@EnableFeignClients
@EnableCircuitBreaker
@EnableAsync
@MapperScan(value={"com.ebaiyihui.onlineoutpatient.core.dao"})
public class ByhOnlineoutpatientCoreApplication {
    public static void main(String[] args) {
        SpringApplication.run(ByhOnlineoutpatientCoreApplication.class, (String[])args);
    }

    @Bean
    public Queue queue() {
        return new Queue("byh-netInquiry-queueName", true);
    }

    @Bean
    DirectExchange exchange() {
        return new DirectExchange("byh-netInquiry-exchange", false, false);
    }

    @Bean
    public Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to(this.exchange()).with("byh-netInquiry-queueName");
    }
}

