/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorScheduleDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorListVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorScheduleVo;
import com.ebaiyihui.onlineoutpatient.common.vo.RequstDoctorListForScheduleVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ResponseDoctorListForScheduleVo;
import com.ebaiyihui.onlineoutpatient.common.vo.doctor.RequestCountDoctorOrders;
import com.ebaiyihui.onlineoutpatient.common.vo.doctor.ResponseCountDoctorOrders;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.doctor.DoctorService;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorListForScheduleNewReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorListForScheduleNewResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorReserveScheduleReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorReserveScheduleResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleInfoResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleNewReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleNewResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorStatisticsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorStatisticsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.QueryXGDoctorsDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.ReferralDoctorFilterReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReferralDoctorFilterResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqSearchParamVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqShowSearchRecordVo;
import com.ebaiyihui.onlineoutpatient.core.vo.SearchDoctorDayScheduleReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.ReqSaveDeptSearchRecordsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.RecommDoctorReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.RecommServiceReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.SerachDoctorReq;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.SerachDoctorRes;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.ServiceStatusReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.ServiceStatusResVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/doctor"})
@Api(tags={"\u533b\u751fAPI"})
public class DoctorController {
    private static final Logger log = LoggerFactory.getLogger(DoctorController.class);
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u5217\u8868\u548c\u670d\u52a1\u6b21\u6570\u4fe1\u606f", notes="\u533b\u751f\u670d\u52a1feign\u8c03\u7528")
    @RequestMapping(value={"/getlistdoctor"}, method={RequestMethod.POST})
    public BaseResponse<PageResult<DoctorListVo>> getSatfaction(@RequestBody QueryXGDoctorsDTO reqVo, BindingResult bindingResult) {
        BaseResponse doctorListVo = null;
        try {
            doctorListVo = this.doctorService.getSatfaction(reqVo);
        }
        catch (NoSuchFieldException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return doctorListVo;
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u4e3b\u9875\u8be6\u60c5", notes="\u533b\u751f\u4e3b\u9875")
    @RequestMapping(value={"/getDoctorScheduleInfo"}, method={RequestMethod.POST})
    public BaseResponse<DoctorScheduleVo> getDoctorSpreadInfo(@RequestBody @Validated DoctorScheduleDTO req, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.inquiryServiceConfigService.getDoctorSpread(req);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u7684\u533b\u751f\u5217\u8868")
    @RequestMapping(value={"/getDoctorListForSchedule"}, method={RequestMethod.POST})
    public BaseResponse<List<ResponseDoctorListForScheduleVo>> getDoctorListForSchedule(@RequestBody RequstDoctorListForScheduleVo vo) {
        return this.doctorService.getDoctorListForSchedule(vo);
    }

    @ApiOperation(value="\u6821\u9a8c\u8be5\u533b\u751f\u662f\u5426\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\uff0c\u5e76\u4e14\u670d\u52a1\u53ef\u8d2d\u4e70")
    @RequestMapping(value={"/checkDoctorService"}, method={RequestMethod.POST})
    public BaseResponse<String> checkDoctorService(@RequestBody DoctorScheduleDTO vo) {
        return this.doctorService.checkDoctorService(vo);
    }

    @ApiOperation(value="\u6e05\u9664\u641c\u7d22\u6846\u4e2d\u7684\u641c\u7d22\u8bb0\u5f55")
    @RequestMapping(value={"/deleteSearchRecord"}, method={RequestMethod.POST})
    public BaseResponse<List<String>> deleteSearchRecord(@RequestBody @Validated ReqSearchParamVo reqSearchParamVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.deleteSearchRecord(reqSearchParamVo);
    }

    @ApiOperation(value="\u5c55\u793a\u641c\u7d22\u6846\u641c\u7d22\u8bb0\u5f55")
    @RequestMapping(value={"/showSearchRecord"}, method={RequestMethod.POST})
    public BaseResponse<List<String>> showSearchRecord(@RequestBody @Validated ReqShowSearchRecordVo reqShowSearchRecordVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.showSearchRecord(reqShowSearchRecordVo);
    }

    @ApiOperation(value="\u4fdd\u5b58\u641c\u7d22\u6846\u641c\u7d22\u8bb0\u5f55")
    @RequestMapping(value={"/saveDeptSearchRecords"}, method={RequestMethod.POST})
    public BaseResponse<String> saveDeptSearchRecords(@RequestBody @Validated ReqSaveDeptSearchRecordsVo reqSaveDeptSearchRecordsVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.saveDeptSearchRecords(reqSaveDeptSearchRecordsVo);
    }

    @ApiOperation(value="\u7edf\u8ba1\u533b\u751f\u95ee\u8bca\u4e2d\u6570\u91cf\uff0c\u603b\u63a5\u8bca\u6570\u91cf")
    @RequestMapping(value={"/countDoctorOrders"}, method={RequestMethod.POST})
    public BaseResponse<ResponseCountDoctorOrders> countDoctorOrders(@RequestBody RequestCountDoctorOrders requestCountDoctorOrders) {
        return this.doctorService.countDoctorOrders(requestCountDoctorOrders);
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u6392\u73ed\u7ba1\u7406")
    @RequestMapping(value={"/doctorScheduleList"}, method={RequestMethod.POST})
    public BaseResponse<List<DoctorScheduleResVo>> doctorScheduleList(@RequestBody DoctorScheduleReqVo doctorScheduleReqVo) {
        return this.doctorService.doctorScheduleList(doctorScheduleReqVo);
    }

    @ApiOperation(value="\u533b\u751fapp\u6392\u73ed\u7ba1\u7406\u65b0")
    @RequestMapping(value={"/doctorScheduleListNew"}, method={RequestMethod.POST})
    public BaseResponse<List<DoctorScheduleNewResVo>> doctorScheduleListNew(@RequestBody DoctorScheduleNewReqVo doctorScheduleNewResVo) {
        return this.doctorService.doctorScheduleListNew(doctorScheduleNewResVo);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u5206\u7c7b\u83b7\u53d6\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u7684\u533b\u751f\u5217\u8868")
    @RequestMapping(value={"/getDoctorListForScheduleNew"}, method={RequestMethod.POST})
    public BaseResponse<List<DoctorListForScheduleNewResVo>> getDoctorListForScheduleNew(@RequestBody DoctorListForScheduleNewReqVo vo) {
        return this.doctorService.getDoctorListForScheduleNew(vo);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u641c\u7d22\u533b\u751f\u67d0\u5929\u7684\u6392\u73ed")
    @RequestMapping(value={"/searchDoctorDaySchedule"}, method={RequestMethod.POST})
    public BaseResponse<DoctorScheduleInfoResVo> searchDoctorDaySchedule(@RequestBody SearchDoctorDayScheduleReqVo searchDoctorDayScheduleReqVo) {
        return this.doctorService.searchDoctorDaySchedule(searchDoctorDayScheduleReqVo);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u533b\u751f\u9884\u7ea6\u6392\u73ed")
    @RequestMapping(value={"/doctorReserveSchedule"}, method={RequestMethod.POST})
    public BaseResponse<List<DoctorReserveScheduleResVo>> doctorReserveSchedule(@RequestBody DoctorReserveScheduleReqVo doctorReserveScheduleReqVo) {
        return this.doctorService.doctorReserveSchedule(doctorReserveScheduleReqVo);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u8f6c\u8bca\u533b\u751f\u7b5b\u9009")
    @RequestMapping(value={"/referralDoctorFilter"}, method={RequestMethod.POST})
    public BaseResponse<List<ReferralDoctorFilterResVo>> referralDoctorFilter(@RequestBody @Valid ReferralDoctorFilterReqVo referralDoctorFilterReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.referralDoctorFilter(referralDoctorFilterReqVo);
    }

    @ApiOperation(value="\u67e5\u770b\u63a8\u8350\u670d\u52a1\u662f\u5426\u5f00\u901a")
    @RequestMapping(value={"/findServiceStatus"}, method={RequestMethod.POST})
    public BaseResponse<List<ServiceStatusResVO>> findServiceStatus(@RequestBody @Valid ServiceStatusReqVO serviceStatusReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.findServiceStatus(serviceStatusReqVO);
    }

    @ApiOperation(value="\u63a8\u8350\u5176\u4ed6\u670d\u52a1")
    @RequestMapping(value={"/recommService"}, method={RequestMethod.POST})
    public BaseResponse<Boolean> recommService(@RequestBody @Valid RecommServiceReqVO recommServiceReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.recommService(recommServiceReqVO);
    }

    @ApiOperation(value="\u63a8\u8350\u5176\u4ed6\u533b\u751f")
    @RequestMapping(value={"/recommDoctor"}, method={RequestMethod.POST})
    public BaseResponse<Boolean> recommDoctor(@RequestBody @Valid RecommDoctorReqVO recommDoctorReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.recommDoctor(recommDoctorReqVO);
    }

    @ApiOperation(value="\u641c\u7d22\u533b\u751f")
    @RequestMapping(value={"/serachDoctor"}, method={RequestMethod.POST})
    public BaseResponse<List<SerachDoctorRes>> serachDoctor(@RequestBody @Valid SerachDoctorReq serachDoctorReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.serachDoctor(serachDoctorReq);
    }

    @ApiOperation(value="\u67e5\u9884\u7ea6\u6302\u53f7\u53f7\u6e90")
    @RequestMapping(value={"/getAppointMent"}, method={RequestMethod.POST})
    public BaseResponse<ServiceStatusResVO> getAppointMent(@RequestBody @Valid ServiceStatusReqVO serviceStatusReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.getAppointMent(serviceStatusReqVO);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u533b\u751f\u76d1\u63a7\u7edf\u8ba1")
    @RequestMapping(value={"/getDoctorMonitoringStatistics"}, method={RequestMethod.POST})
    public BaseResponse<PageResult<DoctorStatisticsVo>> getDoctorMonitoringStatistics(@RequestBody @Valid DoctorStatisticsReqVo reqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.doctorService.getDoctorMonitoringStatistics(reqVo);
    }

    @ApiOperation(value="\u5bfc\u51fa\u7ba1\u7406\u7aef\u533b\u751f\u76d1\u63a7\u7edf\u8ba1")
    @RequestMapping(value={"/exportDoctorMonitoringStatistics"}, method={RequestMethod.POST})
    public void exportDoctorMonitoringStatistics(@RequestBody @Valid DoctorStatisticsReqVo reqVo, BindingResult bindingResult, HttpServletResponse response) {
        if (bindingResult.hasErrors()) {
            BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        this.doctorService.exportDoctorMonitoringStatistics(reqVo, response);
    }
}

