/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.GnHisManagerService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateOrderRecordService {
    private static final Logger log = LoggerFactory.getLogger(UpdateOrderRecordService.class);
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private GnHisManagerService gnHisManagerService;

    public BaseResponse<AdmissionEntity> updateOrderRecord(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        orderInfo.setStatus(OrderStatusEnum.PAID.getValue());
        orderInfo.setBankTradeNo(dto.getTradeNo());
        orderInfo.setPaymentTime(dto.getPayTime());
        orderInfo.setPayMethod(dto.getPayChannel());
        orderInfo.setDealSeq(dto.getDealTradeNo());
        log.info("\u652f\u4ed8\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        this.baseInquiryOrderService.updateById((Object)orderInfo);
        ServicePayBillEntity servicePayBillEntity = (ServicePayBillEntity)this.servicePayBillMapper.selectById((Serializable)((Object)orderInfo.getBillPayId()));
        log.info("\u8d26\u5355\u4fe1\u606f\u4e3a:{}" + servicePayBillEntity.toString());
        servicePayBillEntity.setDealTradeNo(dto.getDealTradeNo());
        servicePayBillEntity.setTradeTime(dto.getPayTime());
        servicePayBillEntity.setTradeNo(dto.getTradeNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setStatus(PayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setPayChannel(dto.getPayChannel());
        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderInfo.getXId());
        admissionEntity.setServTime(orderInfo.getServTime());
        admissionEntity.setStartTime(dto.getPayTime());
        admissionEntity.setTotalNum(orderInfo.getTotalNum());
        admissionEntity.setCurrentNum(orderInfo.getTotalNum());
        admissionEntity.setDoctorName(orderInfo.getDoctorName());
        if (null != orderInfo.getScheduleDate()) {
            admissionEntity.setScheduleDate(orderInfo.getScheduleDate());
            Date scheduleDate = orderInfo.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderInfo.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
            admissionEntity.setEndTime(expirationDateTime);
        } else {
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setConvertWaitTime(new Date());
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        }
        admissionEntity.setPauseTime(Long.valueOf(0L));
        admissionEntity.setOrganId(orderInfo.getHospitalId());
        log.info("\u652f\u4ed8\u56de\u8c03\u6dfb\u52a0\u5c31\u8bca\u8bb0\u5f55:{}", (Object)admissionEntity.toString());
        this.admissionMapper.updateById((Object)admissionEntity);
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
            this.payAsyncService.asyncTask(orderInfo, admissionEntity);
        } else if (AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admissionEntity.getStatus())) {
            this.imInformService.makeAnAppiontment(admissionEntity.getXId());
        }
        if (null != orderInfo.getScheduleDate()) {
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(orderInfo.getXId());
            log.info("\u5b9a\u65f6\u5904\u7406\u60a3\u8005\u672a\u70b9\u51fb'\u5019\u8bca\u62a5\u9053\u63a5\u53e3'\uff0c\u63d0\u793a\u60a3\u8005\u53bb\u5019\u8bca\uff0corderTaskVo3\uff1a{}", (Object)orderTaskVo3.toString());
            this.orderSender.sendDelay(orderTaskVo3);
            OrderTaskVo orderTaskVo4 = new OrderTaskVo();
            orderTaskVo4.setType(Integer.valueOf(4));
            orderTaskVo4.setId(orderInfo.getXId());
            log.info("\u9884\u7ea6\u6392\u73ed\u7ed3\u675f\u65f6\u95f4\u5c31\u8bca\u8ba2\u5355\u5904\u7406orderTaskVo4\uff1a{}", (Object)orderTaskVo4.toString());
            this.orderSender.sendDelay(orderTaskVo4);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(orderInfo.getXId());
            log.info("\u65e0\u6392\u73ed\u8ba2\u5355\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u8ba2\u5355\u5904\u7406 orderTaskVo2\uff1a{}", (Object)orderTaskVo2.toString());
            this.orderSender.sendDelay(orderTaskVo2);
        }
        log.info("======>>\u540c\u6b65his");
        BaseResponse toHis = this.gnHisManagerService.gnRegistrationToHis(orderInfo, dto, "YB");
        if (toHis.isSuccess()) {
            OrderEntity hisOrder = new OrderEntity();
            hisOrder.setXId(orderInfo.getXId());
            hisOrder.setClinicCode((String)toHis.getData());
            this.baseInquiryOrderService.updateById((Object)hisOrder);
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        return BaseResponse.success((Object)admissionEntity);
    }
}

