/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.createorder;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.core.business.createorder.CreateOrderFactory;
import com.ebaiyihui.onlineoutpatient.core.business.createorder.service.CreateOrder;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateOrderManage {
    private static final Logger log = LoggerFactory.getLogger(CreateOrderManage.class);
    @Autowired
    private CreateOrderFactory createOrderFactory;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PatientMapper patientMapper;
    private static final Long EXPIRE_DATE = 2L;

    public BaseResponse<ImmediateConsultationVo> checkProcess(ImmediateConsultationDTO immediateConsultationDTO) {
        String redisKey = immediateConsultationDTO.getPatientId() + "_" + immediateConsultationDTO.getDoctorId() + "_" + immediateConsultationDTO.getMedicalRecordId() + "_" + immediateConsultationDTO.getDeptId() + "_" + immediateConsultationDTO.getServType();
        log.info("redisKey:{}" + redisKey);
        Boolean flag = this.redisTemplateService.addLock(redisKey, redisKey, EXPIRE_DATE.longValue());
        if (!flag.booleanValue()) {
            return BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u8ba2\u5355");
        }
        log.info("\u52a0\u9501\u6210\u529f");
        CreateOrder createOrder = (CreateOrder)this.createOrderFactory.get(immediateConsultationDTO.getOrganId());
        log.info("createOrder{}", (Object)JSON.toJSONString((Object)createOrder));
        BaseResponse orderCheckResponse = createOrder.orderCheck(immediateConsultationDTO);
        log.info("\u8ba2\u5355\u6821\u9a8c\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)orderCheckResponse));
        this.redisUtil.del(redisKey);
        log.info("\u5220\u9664\u9501");
        if (null == orderCheckResponse || !orderCheckResponse.getCode().equals("1")) {
            return BaseResponse.error((String)orderCheckResponse.getMsg());
        }
        BaseResponse buyCheckRespVoBaseResponse = createOrder.preSettlementCheck(immediateConsultationDTO, (ImmediateConsultationVo)orderCheckResponse.getData());
        if (null == buyCheckRespVoBaseResponse) {
            PatientEntity patientEntity = this.patientMapper.selectById(immediateConsultationDTO.getPatientId());
            if (patientEntity != null) {
                ((ImmediateConsultationVo)orderCheckResponse.getData()).setPatientCredNo(patientEntity.getIdcard());
            }
            return orderCheckResponse;
        }
        return buyCheckRespVoBaseResponse;
    }
}

