/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.offlinemedicalrecords;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.card.client.PatientServiceClient;
import com.ebaiyihui.card.common.vo.PatientInfoReqVO;
import com.ebaiyihui.card.common.vo.PatientInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.core.business.offlinemedicalrecords.OfflineMedicalRecordsFactory;
import com.ebaiyihui.onlineoutpatient.core.business.offlinemedicalrecords.service.OfflineMedicalRecords;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.vo.HisMedicalsReqVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OfflineMedicalRecordsManage {
    private static final Logger log = LoggerFactory.getLogger(OfflineMedicalRecordsManage.class);
    @Autowired
    private OfflineMedicalRecordsFactory offlineMedicalRecordsFactory;
    @Autowired
    private PatientMapper patientMapper;
    @Resource
    private PatientServiceClient patientServiceFeignClient;

    public BaseResponse<List<RegisteredRecordResVo>> medicalRecords(HisMedicalsReqVo hisMedicalsReqVo) {
        OfflineMedicalRecords offlineMedicalRecords = (OfflineMedicalRecords)this.offlineMedicalRecordsFactory.get(hisMedicalsReqVo.getHospitalId());
        log.info("offline-get:{}", (Object)JSON.toJSONString((Object)offlineMedicalRecords));
        PatientEntity patientEntity = new PatientEntity();
        PatientEntity patientEntity1 = this.patientMapper.selectById(hisMedicalsReqVo.getPatientId());
        if (null != patientEntity1) {
            patientEntity = patientEntity1;
        } else {
            PatientInfoReqVO patientInfoReqVO = new PatientInfoReqVO();
            patientInfoReqVO.setAppCode(hisMedicalsReqVo.getAppCode());
            patientInfoReqVO.setChannelCode("APP");
            patientInfoReqVO.setPatientId(hisMedicalsReqVo.getPatientId());
            BaseResponse response = this.patientServiceFeignClient.getPatientInfo(patientInfoReqVO);
            patientEntity.setPatientName(((PatientInfoRespVO)response.getData()).getName());
            patientEntity.setCardNo(((PatientInfoRespVO)response.getData()).getCredNo());
            patientEntity.setIdcard(((PatientInfoRespVO)response.getData()).getCredNo());
        }
        BaseResponse listBaseResponse = offlineMedicalRecords.getRegisterRecord(hisMedicalsReqVo, patientEntity);
        if (null == listBaseResponse || CollectionUtils.isEmpty((Collection)((Collection)listBaseResponse.getData()))) {
            return BaseResponse.success(new ArrayList());
        }
        BaseResponse report = offlineMedicalRecords.getReport((List)listBaseResponse.getData(), patientEntity);
        log.info("\u68c0\u9a8c\u68c0\u67e5\u62a5\u544a\u8fdb\u5165");
        if (null == report) {
            return BaseResponse.success((Object)listBaseResponse.getData());
        }
        return report;
    }
}

