/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.ImMqSendService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.ImMqSendServiceImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ImMqSendServiceImpl
implements ImMqSendService {
    private static final Logger log = LoggerFactory.getLogger(ImMqSendServiceImpl.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PatientMapper patientMapper;
    private final String QUEUE_NAME = "im.msg.receive.busiApplyMsg";
    private static final String EXCHANGE = "ehos-im-topic";
    private static final String ROUTING_KEY = "im.msg.busiapplymsg";
    private static final String IM_MQ_BUSICODE = "zxzx";
    private static final String UNBIND = "unbind";

    public void sendLogin(String admId) {
        log.info("\u53d1\u9001Im\u767b\u9646Mq\u6d88\u606f,admId={}", (Object)admId);
        if (StringUtils.isEmpty((Object)admId)) {
            log.error("\u53d1\u9001Im\u767b\u9646Mq\u6d88\u606f,admId\u4e3a\u7a7a");
            return;
        }
        AdmissionEntity adm = this.admissionMapper.findById(admId);
        if (null == adm) {
            log.error("IM mq\u63a8\u9001\u767b\u9646\u6d88\u606f\u9519\u8bef\u7684adm={}", (Object)adm);
            return;
        }
        PatientEntity patient = this.patientMapper.findOneByPatientId(adm.getPatientId());
        if (null == patient) {
            log.error("IM mq\u63a8\u9001\u767b\u9646\u6d88\u606f\u9519\u8bef\u7684patientId={}", (Object)adm.getPatientId());
            return;
        }
        if (StringUtils.isEmpty((Object)patient.getUserId()) || UNBIND.equals(patient.getUserId())) {
            log.error("IM mq\u63a8\u9001\u767b\u9646\u6d88\u606f\u9519\u8bef\u7684userId={}", (Object)patient.getUserId());
            return;
        }
        Date startDate = null;
        Date endDate = null;
        SimpleDateFormat bf = new SimpleDateFormat("yyyy-MM-dd");
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(adm.getStatus())) {
            startDate = new Date();
            endDate = DateUtils.addDays((Date)new Date(), (int)2);
        } else if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(adm.getStatus())) {
            startDate = adm.getStartTime();
            endDate = DateUtils.addDays((Date)adm.getEndTime(), (int)7);
        }
        String admStartDate = startDate != null ? bf.format(startDate) : null;
        String admEndDate = endDate != null ? bf.format(endDate) : null;
        1 mqContent = new /* Unavailable Anonymous Inner Class!! */;
        this.rabbitTemplate.convertAndSend(EXCHANGE, ROUTING_KEY, (Object)JSON.toJSONString((Object)mqContent));
    }
}

