/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.dto.DataScopeListDto;
import com.ebaiyihui.common.vo.DataScopeRoleVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.pojo.entity.BpUserScopeOrganEntity;
import com.ebaiyihui.server.pojo.entity.DateScopeEntity;
import com.ebaiyihui.server.pojo.entity.DateScopeRoleEntity;
import com.ebaiyihui.server.pojo.entity.RoleEntity;
import com.ebaiyihui.server.pojo.entity.UserRoleEntity;
import com.ebaiyihui.server.service.BpUserScopeOrganService;
import com.ebaiyihui.server.service.DataScopeService;
import com.ebaiyihui.server.service.DateScopeRoleService;
import com.ebaiyihui.server.service.RoleService;
import com.ebaiyihui.server.service.UserRoleService;
import com.ebaiyihui.server.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/dataScope"}, produces={"application/json;charset=UTF-8"})
@Api(value="\u6570\u636e\u8303\u56f4")
public class DataScopeController {
    private static final Logger log = LoggerFactory.getLogger(DataScopeController.class);
    @Autowired
    private DataScopeService dataScopeService;
    @Autowired
    private BpUserScopeOrganService bpUserScopeOrganService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private DateScopeRoleService dateScopeRoleService;
    @Autowired
    private UserRoleService userRoleService;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8303\u56f4\u5217\u8868")
    @GetMapping(value={"/getDataScopeList"})
    public BaseResponse<List<DataScopeListDto>> getDataScopeList(@RequestParam(value="roleId", defaultValue="0") Long roleId) {
        if (roleId.intValue() == 0) {
            return new BaseResponse("0", "\u53c2\u6570\u9519\u8bef", null);
        }
        return this.dataScopeService.getDataScopeList(roleId);
    }

    @ApiOperation(value="\u8bbe\u6570\u636e\u5c45\u8303\u56f4")
    @PostMapping(value={"/addDataScope"})
    public BaseResponse<String> addDataScope(@RequestBody @Valid List<DataScopeRoleVo> dataScopeRoleVoList) {
        return this.dataScopeService.addDataScope(dataScopeRoleVoList);
    }

    @ApiOperation(value="\u8bbe\u6570\u636e\u5c45\u8303\u56f4_\u9ed8\u8ba4")
    @PostMapping(value={"/addDataScopeDefault"})
    public BaseResponse<String> addDataScopeDefault(@RequestParam(value="roleId", defaultValue="0") Long roleId) {
        return this.dataScopeService.addDataScopeDefault(roleId);
    }

    @ApiOperation(value="\u8bbe\u7f6euserId\u533b\u9662ids")
    @PostMapping(value={"/addUserScopeOrgan"})
    public BaseResponse<String> addUserScopeOrgan(@RequestParam(value="userId", defaultValue="") String userId) throws IOException, URISyntaxException {
        return this.dataScopeService.addUserScopeOrgan(userId);
    }

    @ApiOperation(value="\u66f4\u65b0userId\u533b\u9662ids,\u533b\u8054\u4f53\u65b0\u589e")
    @PostMapping(value={"/updateUserScopeOrgan"})
    public BaseResponse<String> updateUserScopeOrgan(@RequestParam(value="organIdList") List<String> organIdList) {
        if (CollectionUtils.isEmpty(organIdList)) {
            log.info("\u53c2\u6570\u9519\u8bef:organIdList:{}", organIdList);
            return BaseResponse.error((String)("\u53c2\u6570\u9519\u8bef" + organIdList));
        }
        return this.dataScopeService.updateUserScopeOrgan(organIdList);
    }

    @ApiOperation(value="\u66f4\u65b0userId\u533b\u9662ids,\u533b\u8054\u4f53\u5220\u9664")
    @PostMapping(value={"/updateUserScopeOrganDel"})
    public BaseResponse<String> updateUserScopeOrganDel(@RequestParam(value="healthIdList") List<String> healthIdList) {
        if (CollectionUtils.isEmpty(healthIdList)) {
            log.info("\u53c2\u6570\u9519\u8bef:healthIdList:{}", healthIdList);
            return BaseResponse.error((String)("\u53c2\u6570\u9519\u8bef:healthIdList:" + healthIdList));
        }
        return this.dataScopeService.updateUserScopeOrganDel(healthIdList);
    }

    @ApiOperation(value="\u83b7\u53d6userId\u533b\u9662ids")
    @GetMapping(value={"/getOrganByUserIdAndScopeId"})
    public BaseResponse<String> getOrganByUserIdAndScopeId(@RequestParam(value="userId", defaultValue="") String userId, @RequestParam(value="scopeId", defaultValue="0") Integer scopeId) {
        if ("".equals(userId)) {
            log.info("\u53c2\u6570\u9519\u8bef:organIdList:{}", (Object)userId);
            return BaseResponse.error((String)("\u53c2\u6570\u9519\u8bef:organIdList:" + userId));
        }
        if (scopeId == 0) {
            log.info("\u53c2\u6570\u9519\u8bef:scopeId:{}", (Object)scopeId);
            return BaseResponse.error((String)("\u53c2\u6570\u9519\u8bef:scopeId:" + scopeId));
        }
        return this.dataScopeService.getOrganByUserIdAndScopeId(userId, scopeId);
    }

    @ApiOperation(value="\u83b7\u53d6userId\u6570\u636e\u6743\u9650,\u4e91\u4e0a\u4f7f\u7528")
    @GetMapping(value={"/getCloudUserScope"})
    public BaseResponse<Map<String, String>> getCloudUserScope(@RequestParam(value="userId", defaultValue="") String userId) throws IOException, URISyntaxException {
        if ("".equals(userId)) {
            log.error("===========userId:{}", (Object)userId);
            return BaseResponse.error((String)"userId\u4e3a\u7a7a");
        }
        List bpUserScopeOrganEntityList = this.bpUserScopeOrganService.getListByUserId(userId);
        if (!CollectionUtils.isEmpty((Collection)bpUserScopeOrganEntityList)) {
            return this.dataScopeService.getCloudUserScope(userId);
        }
        this.dataScopeService.addUserScopeOrgan(userId);
        return this.dataScopeService.getCloudUserScope(userId);
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u4ee5\u67e5\u770b\u8be5\u533b\u9662\u5065\u5eb7\u7ba1\u7406\u7684userIds")
    @GetMapping(value={"/getUserIdByHosIdAndScopeId"})
    public BaseResponse<List<String>> getUserIdByHosIdAndScopeId(@RequestParam(value="hosId", defaultValue="") String hosId, @RequestParam(value="scopeId", defaultValue="") String scopeId) {
        if (StringUtil.isEmpty((String)hosId)) {
            return BaseResponse.error((String)("\u53c2\u6570\u9519\u8befhosId:" + hosId));
        }
        if (StringUtil.isEmpty((String)scopeId)) {
            return BaseResponse.error((String)("\u53c2\u6570\u9519\u8befscopeId:" + scopeId));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        List userScopeOrganEntities = this.bpUserScopeOrganService.getUserIdsByScopeId(scopeId);
        if (CollectionUtils.isEmpty((Collection)userScopeOrganEntities)) {
            return BaseResponse.success(userIds);
        }
        for (BpUserScopeOrganEntity userScopeOrganEntity : userScopeOrganEntities) {
            List<String> hosIds = Arrays.asList(userScopeOrganEntity.getOrgan().split(","));
            if (hosIds.contains(hosId)) {
                userIds.add(userScopeOrganEntity.getUserId());
            }
            if (!hosIds.contains("-1")) continue;
            userIds.add(userScopeOrganEntity.getUserId());
        }
        userIds.stream().distinct();
        return BaseResponse.success(userIds);
    }

    @ApiOperation(value="\u6a21\u5757\u6dfb\u52a0")
    @PostMapping(value={"/insertDataScope"})
    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> insertDataScope(@RequestParam(value="moduleName", defaultValue="") String moduleName, @RequestParam(value="identify", defaultValue="") String identify) {
        DateScopeEntity dateScopeEntity = new DateScopeEntity();
        dateScopeEntity.setStatus(Integer.valueOf(1));
        dateScopeEntity.setDateScopeName(moduleName);
        dateScopeEntity.setIdentify(identify);
        DateScopeEntity dateScope = this.dataScopeService.insert(dateScopeEntity);
        if (dateScope == null) {
            log.error("========\u6dfb\u52a0\u6a21\u5757\u5931\u8d25========");
            return BaseResponse.error((String)"no");
        }
        String name = "\u7ba1\u7406\u5458";
        RoleEntity roleEntity = this.roleService.getRoleByName(name);
        if (roleEntity == null) {
            log.error("========\u6dfb\u52a0\u6a21\u5757,\u83b7\u53d6\u7ba1\u7406\u5458\u5931\u8d25========");
            return BaseResponse.error((String)"no");
        }
        DateScopeRoleEntity dateScopeRoleEntity = new DateScopeRoleEntity();
        dateScopeRoleEntity.setStatus(Integer.valueOf(1));
        dateScopeRoleEntity.setDateScopeId(dateScope.getId());
        dateScopeRoleEntity.setRoleId(roleEntity.getId());
        dateScopeRoleEntity.setCheckRange(Integer.valueOf(3));
        DateScopeRoleEntity dateScopeRole = this.dateScopeRoleService.insert(dateScopeRoleEntity);
        if (dateScopeRole == null) {
            log.error("========\u6dfb\u52a0\u6a21\u5757,\u6a21\u5757\u89d2\u8272\u8868\u5931\u8d25========");
            return BaseResponse.error((String)"no");
        }
        List userRoleEntityList = this.userRoleService.getListByRole(roleEntity.getId());
        if (CollectionUtils.isEmpty((Collection)userRoleEntityList)) {
            return BaseResponse.error((String)"no");
        }
        for (UserRoleEntity userRoleEntity : userRoleEntityList) {
            String userId = userRoleEntity.getUserId();
            BpUserScopeOrganEntity userScopeOrganEntity = new BpUserScopeOrganEntity();
            userScopeOrganEntity.setCheckRange(Integer.valueOf(3));
            userScopeOrganEntity.setOrgan("-1");
            userScopeOrganEntity.setUserId(userId);
            userScopeOrganEntity.setStatus(Integer.valueOf(1));
            userScopeOrganEntity.setDateScopeId(dateScope.getId());
            this.bpUserScopeOrganService.insert(userScopeOrganEntity);
        }
        log.error("========\u6dfb\u52a0\u6a21\u5757,\u5168\u90e8\u6d41\u7a0b\u6210\u529f========");
        return BaseResponse.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u7528\u6237\u6743\u9650")
    @GetMapping(value={"/getPermissionsByKey"})
    public BaseResponse<String> getPermissionsByKey(@RequestParam(value="key", defaultValue="") String key) {
        String organ = this.dataScopeService.getPermissionsByKey(key);
        return BaseResponse.success((Object)organ);
    }
}

