/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.vo.role.DeleteRoleParamVO;
import com.ebaiyihui.common.vo.role.FetchListParamVO;
import com.ebaiyihui.common.vo.role.RoleInfoVO;
import com.ebaiyihui.common.vo.role.SaveRoleAuthParamVO;
import com.ebaiyihui.common.vo.role.SaveRoleParamVO;
import com.ebaiyihui.common.vo.role.UpdateRoleParamVO;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.service.RoleAuthService;
import com.ebaiyihui.server.service.RoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ba1\u7406API"})
@RequestMapping(value={"/api/role"}, produces={"application/json;charset=UTF-8"})
@RestController
public class RoleController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleAuthService roleAuthService;

    @ApiOperation(value="\u65b0\u589e\u89d2\u8272", notes="\u65b0\u589e\u89d2\u8272")
    @PostMapping(value={"/save"})
    public BaseResponse<Object> saveRole(@RequestBody @Valid SaveRoleParamVO param) {
        return this.roleService.saveRole(param);
    }

    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f", notes="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public BaseResponse<Object> updateRole(@RequestBody @Valid UpdateRoleParamVO param) {
        return this.roleService.updateRole(param);
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272", notes="\u5220\u9664\u89d2\u8272")
    @PostMapping(value={"/delete"})
    public BaseResponse<Object> deleteRole(@RequestBody @Valid DeleteRoleParamVO param) {
        return this.roleService.deleteRole(param);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u89d2\u8272\u4fe1\u606f", notes="20\u6761\u6bcf\u9875")
    @PostMapping(value={"/paginglist"})
    public BaseResponse<PageResult<RoleInfoVO>> fetchList(@RequestBody PageRequest<FetchListParamVO> param) {
        return this.roleService.fetchList(param);
    }

    @ApiOperation(value="\u89d2\u8272\u5217\u8868\u67e5\u8be2", notes="\u6240\u6709\u7684\u89d2\u8272")
    @PostMapping(value={"/findall"})
    public BaseResponse<List<RoleInfoVO>> findAll(@RequestParam(value="appCode") String appCode) {
        return this.roleService.findAll(appCode);
    }

    @ApiOperation(value="\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272\u5217\u8868")
    @PostMapping(value={"/findbyuserid"})
    public BaseResponse<List<RoleInfoVO>> findByUserId(@RequestParam(value="userId", required=true) String userId) {
        return this.roleService.findByUserId(userId);
    }

    @ApiOperation(value="\u4e3a\u89d2\u8272\u7ed1\u5b9a\u6743\u9650")
    @PostMapping(value={"/saveroleauth"})
    public BaseResponse<Object> saveRoleAuth(@RequestBody @Valid SaveRoleAuthParamVO param) {
        return this.roleAuthService.saveRoleAuth(param);
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u540d\u6a21\u7cca\u5339\u914d\u89d2\u8272")
    @PostMapping(value={"/findlikename"})
    public BaseResponse<List<RoleInfoVO>> findLikeRoleName(@RequestParam(value="roleName") String roleName, @RequestParam(value="appCode") String appCode) {
        return this.roleService.findLikeRoleName(roleName, appCode);
    }

    @ApiOperation(value="\u89d2\u8272\u5217\u8868\u67e5\u8be2-\u6d4b\u8bd5\u6570\u636e\u4e86\u8fde\u63a5", notes="\u6240\u6709\u7684\u89d2\u8272-\u6d4b\u8bd5\u6570\u636e\u5e93\u94fe\u63a5")
    @GetMapping(value={"/check_health"})
    public BaseResponse<List<RoleInfoVO>> checkHealth() {
        return this.roleService.findAll();
    }
}

