/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller.article;

import com.ebaiyihui.common.dto.ArticleDto.AreaBuildDto;
import com.ebaiyihui.common.dto.ArticleDto.AreaFloorDto;
import com.ebaiyihui.common.dto.ArticleDto.AreaListDto;
import com.ebaiyihui.common.dto.ArticleDto.AreaRoomDto;
import com.ebaiyihui.common.dto.ArticleDto.ArticleDetailDto;
import com.ebaiyihui.common.dto.ArticleDto.DepNameDetailDto;
import com.ebaiyihui.common.vo.articleVo.AreaAddVo;
import com.ebaiyihui.common.vo.articleVo.ArticleDetailVo;
import com.ebaiyihui.common.vo.articleVo.ArticleSaveVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.pojo.entity.ArticleAreaEntity;
import com.ebaiyihui.server.pojo.entity.ArticleIntroductionEntity;
import com.ebaiyihui.server.service.ArticleAreaService;
import com.ebaiyihui.server.service.ArticleIntroductionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5185\u5bb9\u670d\u52a1API"})
@RestController
@RequestMapping(value={"/api/v1/article"}, produces={"application/json;charset=UTF-8"})
public class ArticleController {
    private static final Logger log = LoggerFactory.getLogger(ArticleController.class);
    @Autowired
    ArticleIntroductionService articleIntroductionService;
    @Autowired
    ArticleAreaService articleAreaService;

    @ApiOperation(value="\u5185\u5bb9\u8be6\u60c5")
    @GetMapping(value={"/getDetail"})
    public BaseResponse<ArticleDetailDto> getDetail(@RequestParam(value="areaId", defaultValue="0", required=false) Integer areaId, @RequestParam(value="depName", defaultValue="", required=false) String depName, @RequestParam(value="hosId", defaultValue="0") Integer hosId, @RequestParam(value="type", defaultValue="0") Integer type) {
        ArticleDetailVo articleDetailVo = new ArticleDetailVo();
        articleDetailVo.setHosId(hosId);
        articleDetailVo.setDepName(depName);
        articleDetailVo.setAreaId(areaId);
        articleDetailVo.setType(type);
        ArticleDetailDto articleDetailDto = this.articleIntroductionService.getContentByHosIdAndDepIdAndAreaIdAndAppCode(articleDetailVo);
        if (articleDetailDto == null) {
            return BaseResponse.success((Object)new ArticleDetailDto());
        }
        return BaseResponse.success((Object)articleDetailDto);
    }

    @ApiOperation(value="\u91cd\u70b9\u79d1\u5ba4\u5217\u8868")
    @GetMapping(value={"/getKeyDepartment"})
    public BaseResponse<List<String>> getKeyDepartment(@RequestParam(value="hosId", defaultValue="0") Integer hosId, @RequestParam(value="type", defaultValue="0") Integer type) {
        String depNameStr = this.articleIntroductionService.getDepNameStr(hosId, type);
        if (depNameStr == null || depNameStr.length() <= 0) {
            return BaseResponse.success(new ArrayList());
        }
        List<String> depNameList = Arrays.asList(depNameStr.split(","));
        List list = depNameList.stream().filter(depName -> !depName.isEmpty()).collect(Collectors.toList());
        return BaseResponse.success(list);
    }

    @ApiOperation(value="\u91cd\u70b9\u79d1\u5ba4\u5217\u8868\u4ee5\u53ca\u8be6\u60c5_IOS\u4e13\u7528")
    @GetMapping(value={"/getKeyDepartmentAndDetail"})
    public BaseResponse<List<DepNameDetailDto>> getKeyDepartmentAndDetail(@RequestParam(value="hosId", defaultValue="0") Integer hosId) {
        String depNameStr = this.articleIntroductionService.getDepNameStr(hosId, Integer.valueOf(3));
        if (depNameStr == null || depNameStr.length() <= 0) {
            return BaseResponse.success(new ArrayList());
        }
        List<String> depNameList = Arrays.asList(depNameStr.split(","));
        List list = depNameList.stream().filter(depName -> !depName.isEmpty()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return BaseResponse.success(new ArrayList());
        }
        ArrayList<DepNameDetailDto> depNameDetailList = new ArrayList<DepNameDetailDto>();
        ArticleDetailVo articleDetailVo = new ArticleDetailVo();
        articleDetailVo.setHosId(hosId);
        articleDetailVo.setAreaId(Integer.valueOf(0));
        articleDetailVo.setType(Integer.valueOf(3));
        for (String depName2 : list) {
            articleDetailVo.setDepName(depName2);
            ArticleDetailDto articleDetailDto = this.articleIntroductionService.getContentByHosIdAndDepIdAndAreaIdAndAppCode(articleDetailVo);
            if (articleDetailDto == null) continue;
            DepNameDetailDto depNameDetailDto = new DepNameDetailDto();
            depNameDetailDto.setDepName(depName2);
            depNameDetailDto.setTitle(articleDetailDto.getTitle());
            depNameDetailDto.setContext(articleDetailDto.getContent());
            depNameDetailList.add(depNameDetailDto);
        }
        return BaseResponse.success(depNameDetailList);
    }

    @ApiOperation(value="\u533a\u57df\u5c55\u793a")
    @GetMapping(value={"/getAreaList"})
    public BaseResponse<List<AreaListDto>> getAreaList(@RequestParam(value="level", defaultValue="0") Integer level, @RequestParam(value="parentId", defaultValue="0") Integer parentId) {
        List areaListDtoList;
        if (level == 2) {
            ArticleAreaEntity articleAreaEntity = this.articleAreaService.getAreaByAreaIdAndLevel(parentId, Integer.valueOf(1));
            if (articleAreaEntity == null) {
                return BaseResponse.success(new ArrayList());
            }
            Long id = articleAreaEntity.getId();
            parentId = Integer.valueOf(id.toString());
        }
        if (CollectionUtils.isEmpty((Collection)(areaListDtoList = this.articleAreaService.getAreaList(parentId, level)))) {
            return BaseResponse.success(new ArrayList());
        }
        return BaseResponse.success((Object)areaListDtoList);
    }

    @ApiOperation(value="\u533a\u57df\u5220\u9664")
    @GetMapping(value={"/deleteArea"})
    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> deleteArea(@RequestParam(value="areaId", defaultValue="0") Integer areaId, @RequestParam(value="level", defaultValue="0") Integer level) {
        boolean flag = false;
        ArrayList<Integer> areaIdList = new ArrayList<Integer>();
        if (level == 4) {
            flag = this.articleAreaService.deleteArea(areaId);
        } else if (level == 3) {
            flag = this.articleAreaService.deleteArea(areaId);
            List areaListDtos = this.articleAreaService.getAreaList(areaId, Integer.valueOf(4));
            if (!CollectionUtils.isEmpty((Collection)areaListDtos)) {
                areaIdList.add(areaId);
                flag = this.articleAreaService.deleteAreaByParentId(areaIdList);
            }
        } else if (level == 2) {
            List areaListDtos;
            flag = this.articleAreaService.deleteArea(areaId);
            List areaIdThree = this.articleAreaService.getAreaList(areaId, Integer.valueOf(3)).stream().map(AreaListDto::getAreaId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(areaIdThree)) {
                flag = this.articleAreaService.deleteAreaByParentId(areaIdThree);
            }
            if (!CollectionUtils.isEmpty((Collection)(areaListDtos = this.articleAreaService.getAreaList(areaId, Integer.valueOf(3))))) {
                areaIdList.add(areaId);
                flag = this.articleAreaService.deleteAreaByParentId(areaIdList);
            }
        }
        if (flag) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @ApiOperation(value="\u533a\u57df\u6dfb\u52a0")
    @PostMapping(value={"/saveArea"})
    public BaseResponse<String> saveArea(@RequestBody @Validated AreaAddVo areaAddVo, BindingResult bindingResult) {
        boolean flag;
        ArticleAreaEntity articleArea = this.articleAreaService.getAreaByAreaIdAndLevel(areaAddVo.getParentId(), areaAddVo.getParentLevel());
        Long parentId = 0L;
        if (articleArea == null && areaAddVo.getParentLevel() == 1) {
            ArticleAreaEntity articleAreaEntity = new ArticleAreaEntity();
            articleAreaEntity.setAreaId(areaAddVo.getParentId());
            articleAreaEntity.setAreaName(areaAddVo.getParentName());
            articleAreaEntity.setLevel(areaAddVo.getParentLevel());
            articleAreaEntity.setParentId(Long.valueOf(0L));
            flag = this.articleAreaService.save(articleAreaEntity);
            flag = false;
            if (false) {
                return BaseResponse.error((String)"\u533a\u57df\u533b\u9662\u6dfb\u52a0\u5931\u8d25!");
            }
            parentId = this.articleAreaService.getAreaByAreaIdAndLevel(areaAddVo.getParentId(), areaAddVo.getParentLevel()).getId();
        } else {
            if (articleArea == null && areaAddVo.getParentLevel() != 1) {
                return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
            }
            parentId = articleArea.getId();
        }
        ArticleAreaEntity areaEntity = new ArticleAreaEntity();
        areaEntity.setAreaId(areaAddVo.getChildId());
        areaEntity.setAreaName(areaAddVo.getChildName());
        areaEntity.setLevel(areaAddVo.getChildLevel());
        areaEntity.setParentId(parentId);
        flag = this.articleAreaService.save(areaEntity);
        if (flag) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"no");
    }

    @ApiOperation(value="\u5185\u5bb9\u7684\u65b0\u5efa\u548c\u4fee\u6539")
    @PostMapping(value={"/contentAddUpdate"})
    public BaseResponse<String> contentAddUpdate(@RequestBody ArticleSaveVo articleSaveVo) {
        ArticleIntroductionEntity articleIntroductionEntity = new ArticleIntroductionEntity();
        articleIntroductionEntity.setId(articleSaveVo.getId());
        articleIntroductionEntity.setContent(articleSaveVo.getContent());
        articleIntroductionEntity.setTitle(articleSaveVo.getTitle());
        articleIntroductionEntity.setHosId(articleSaveVo.getHosId());
        articleIntroductionEntity.setHosName(articleSaveVo.getHosName());
        articleIntroductionEntity.setDepName(articleSaveVo.getDepName());
        articleIntroductionEntity.setAreaId(articleSaveVo.getAreaId());
        articleIntroductionEntity.setType(articleSaveVo.getType());
        boolean flag = this.articleIntroductionService.save(articleIntroductionEntity);
        if (flag) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25,\u8bf7\u68c0\u67e5\u79d1\u5ba4\u540d\u79f0\u662f\u5426\u91cd\u590d,\u6216\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb");
    }

    @ApiOperation(value="\u5185\u5bb9\u5220\u9664")
    @GetMapping(value={"deleteContent"})
    public BaseResponse<String> deleteContent(@RequestParam(value="id", defaultValue="0") Long id) {
        boolean flag = this.articleIntroductionService.deleteContent(id);
        if (flag) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"no");
    }

    @ApiOperation(value="\u533a\u57df\u8be6\u60c5")
    @GetMapping(value={"getAreaDetailByHosId"})
    public BaseResponse<List<AreaBuildDto>> getAreaDetailByHosId(@RequestParam(value="hosId", defaultValue="0") Long hosId) {
        if (hosId == 0L) {
            return BaseResponse.error((String)"hosId\u9519\u8bef");
        }
        ArrayList<AreaBuildDto> areaBuildDtoList = new ArrayList<AreaBuildDto>();
        ArticleAreaEntity articleAreaEntity = this.articleAreaService.getAreaByAreaIdAndLevel(Integer.valueOf(hosId.intValue()), Integer.valueOf(1));
        if (articleAreaEntity == null) {
            return new BaseResponse("1", "\u8be5\u533b\u9662\u4e0d\u5b58\u5728\u4efb\u4f55\u533a\u57df", areaBuildDtoList);
        }
        List areaBuildList = this.articleAreaService.getAreaList(Integer.valueOf(articleAreaEntity.getId().intValue()), Integer.valueOf(2));
        if (!CollectionUtils.isEmpty((Collection)areaBuildList)) {
            for (AreaListDto areaBuildDto : areaBuildList) {
                AreaBuildDto areaBuild = new AreaBuildDto();
                areaBuild.setBuildId(areaBuildDto.getAreaId());
                areaBuild.setBuildName(areaBuildDto.getAreaName());
                List areaFloorList = this.articleAreaService.getAreaList(areaBuildDto.getAreaId(), Integer.valueOf(3));
                ArrayList<AreaFloorDto> areaFloorDtoList = new ArrayList<AreaFloorDto>();
                if (!CollectionUtils.isEmpty((Collection)areaFloorList)) {
                    for (AreaListDto areaFloorDto : areaFloorList) {
                        AreaFloorDto areaFloor = new AreaFloorDto();
                        areaFloor.setFloorId(areaFloorDto.getAreaId());
                        areaFloor.setFloorName(areaFloorDto.getAreaName());
                        List areaRoomList = this.articleAreaService.getAreaList(areaFloorDto.getAreaId(), Integer.valueOf(4));
                        ArrayList<AreaRoomDto> areaRoomDtoList = new ArrayList<AreaRoomDto>();
                        if (!CollectionUtils.isEmpty((Collection)areaRoomList)) {
                            for (AreaListDto areaRoomDto : areaRoomList) {
                                AreaRoomDto areaRoom = new AreaRoomDto();
                                areaRoom.setRoomId(areaRoomDto.getAreaId());
                                areaRoom.setRoomName(areaRoomDto.getAreaName());
                                ArticleDetailVo articleDetailVo = new ArticleDetailVo();
                                articleDetailVo.setHosId(Integer.valueOf(hosId.intValue()));
                                articleDetailVo.setDepName("");
                                articleDetailVo.setAreaId(areaRoomDto.getAreaId());
                                articleDetailVo.setType(Integer.valueOf(4));
                                ArticleDetailDto articleDetailDto = this.articleIntroductionService.getContentByHosIdAndDepIdAndAreaIdAndAppCode(articleDetailVo);
                                if (articleDetailDto != null) {
                                    areaRoom.setContext(articleDetailDto.getContent());
                                }
                                areaRoomDtoList.add(areaRoom);
                            }
                        }
                        areaFloor.setAreaRoomDtoList(areaRoomDtoList);
                        areaFloorDtoList.add(areaFloor);
                    }
                }
                areaBuild.setAreaFloorDtoList(areaFloorDtoList);
                areaBuildDtoList.add(areaBuild);
            }
        }
        return BaseResponse.success(areaBuildDtoList);
    }
}

