/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.dto.ArticleDto.AreaListDto;
import com.ebaiyihui.server.mapper.ArticleAreaMapper;
import com.ebaiyihui.server.pojo.entity.ArticleAreaEntity;
import com.ebaiyihui.server.service.ArticleAreaService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="articleAreaService")
public class ArticleAreaServiceImpl
implements ArticleAreaService {
    @Resource
    private ArticleAreaMapper articleAreaMapper;

    public ArticleAreaEntity queryById(Long id) {
        return this.articleAreaMapper.queryById(id);
    }

    public List<ArticleAreaEntity> queryAllByLimit(int offset, int limit) {
        return this.articleAreaMapper.queryAllByLimit(offset, limit);
    }

    public ArticleAreaEntity insert(ArticleAreaEntity articleAreaEntity) {
        this.articleAreaMapper.insert(articleAreaEntity);
        return articleAreaEntity;
    }

    public ArticleAreaEntity update(ArticleAreaEntity articleAreaEntity) {
        this.articleAreaMapper.update(articleAreaEntity);
        return this.queryById(articleAreaEntity.getId());
    }

    public boolean deleteById(Long id) {
        return this.articleAreaMapper.deleteById(id) > 0;
    }

    public boolean save(ArticleAreaEntity articleAreaEntity) {
        ArticleAreaEntity articleArea = this.articleAreaMapper.selectByAreaIdaAndLevelAndParentIdAndAppCode(articleAreaEntity.getAreaId(), articleAreaEntity.getLevel(), articleAreaEntity.getParentId());
        if (articleArea != null) {
            articleArea.setAreaName(articleAreaEntity.getAreaName());
            return this.articleAreaMapper.update(articleArea) > 0;
        }
        if (articleArea == null && articleAreaEntity.getLevel() == 1) {
            return this.articleAreaMapper.insert(articleAreaEntity) > 0;
        }
        return this.articleAreaMapper.insertLevel(articleAreaEntity) > 0;
    }

    public List<AreaListDto> getAreaList(Integer parentId, Integer level) {
        return this.articleAreaMapper.getAreaList(parentId, level);
    }

    public boolean deleteArea(Integer areaId) {
        return this.articleAreaMapper.deleteArea(areaId) > 0;
    }

    public boolean deleteAreaByParentId(List<Integer> areaIdList) {
        return this.articleAreaMapper.deleteAreaByParentId(areaIdList) > 0;
    }

    public ArticleAreaEntity getAreaByAreaIdAndLevel(Integer areaId, Integer level) {
        return this.articleAreaMapper.getAreaByAreaIdAndLevel(areaId, level);
    }
}

