/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.server.mapper.RoleAuthMapper;
import com.ebaiyihui.server.mapper.RoleMapper;
import com.ebaiyihui.server.pojo.entity.RoleEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AuthUrlToRedisService {
    private static final Logger log = LoggerFactory.getLogger(AuthUrlToRedisService.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RoleAuthMapper roleAuthMapper;

    public void redisSet(String appCode, Map<String, String[]> authUrlMap) {
        Set<Map.Entry<String, String[]>> entrySet = authUrlMap.entrySet();
        for (Map.Entry<String, String[]> authUrl : entrySet) {
            boolean flag = false;
            do {
                try {
                    this.redisTemplate.opsForSet().add((Object)this.generatePermissionsKey(appCode, authUrl.getKey()), (Object[])authUrl.getValue());
                    log.info("\u5f80redis\u4e2d\u5b58\u6570\u7684\u89d2\u8272url\u6570\u636e\u4e3a:\u89d2\u8272\u4e3a{},url\u4e3a{}", (Object)this.generatePermissionsKey(appCode, authUrl.getKey()), (Object)authUrl.getValue());
                    flag = false;
                }
                catch (Exception e) {
                    log.error("redis\u5b58\u50a8\u89d2\u8272url\u6570\u636e\u5931\u8d25:", (Throwable)e);
                    flag = true;
                }
            } while (flag);
        }
    }

    public void redisDelete(String appCode, String[] roleIds) {
        for (String roleId : roleIds) {
            boolean flag = false;
            do {
                try {
                    boolean ret = this.redisTemplate.delete((Object)this.generatePermissionsKey(appCode, roleId));
                    log.info("\u4eceredis\u4e2d\u5220\u9664\u7684\u89d2\u8272url\u6570\u636e\u4e3a:\u89d2\u8272\u4e3a{}", (Object)this.generatePermissionsKey(appCode, roleId));
                    log.info("\u4eceredis\u4e2d\u5220\u9664\u7684\u89d2\u8272url\u6570\u636e\u7684\u7ed3\u679c\u4e3a:---------{}", (Object)ret);
                    flag = false;
                }
                catch (Exception e) {
                    log.error("redis\u5220\u9664\u89d2\u8272url\u6570\u636e\u5931\u8d25:", (Throwable)e);
                    flag = true;
                }
            } while (flag);
        }
    }

    private String generatePermissionsKey(String appCode, String role) {
        return "permission:appCode:" + appCode + ":role:" + role;
    }

    @PostConstruct
    public void initializationAutjUrl() {
        List stringList = this.roleMapper.findAppCode();
        for (String appCode : stringList) {
            ArrayList<String> roleIdList = new ArrayList<String>();
            try {
                HashMap<String, String[]> map = new HashMap<String, String[]>();
                List roleEntityList = this.roleMapper.findAll(appCode);
                for (RoleEntity roleEntity : roleEntityList) {
                    List urlList = this.roleAuthMapper.selectUrlByRole(roleEntity.getId().toString());
                    if (urlList.size() < 1) continue;
                    String[] urlArray = urlList.toArray(new String[0]);
                    map.put(roleEntity.getId().toString(), urlArray);
                    roleIdList.add(roleEntity.getId().toString());
                }
                String[] roleIds = roleIdList.toArray(new String[0]);
                this.redisDelete(appCode, roleIds);
                this.redisSet(appCode, map);
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u89d2\u8272\u62e5\u6709url\u6570\u636e\u5931\u8d25:", (Throwable)e);
            }
        }
    }
}

