/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.dto.DataScopeListDto;
import com.ebaiyihui.common.vo.DataScopeRoleVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.config.PermissionsConfig;
import com.ebaiyihui.server.mapper.DateScopeMapper;
import com.ebaiyihui.server.mapper.DateScopeRoleMapper;
import com.ebaiyihui.server.mapper.RoleMapper;
import com.ebaiyihui.server.mapper.UserOrganMapper;
import com.ebaiyihui.server.mapper.UserRoleMapper;
import com.ebaiyihui.server.pojo.entity.BpUserScopeOrganEntity;
import com.ebaiyihui.server.pojo.entity.DateScopeEntity;
import com.ebaiyihui.server.pojo.entity.DateScopeRoleEntity;
import com.ebaiyihui.server.pojo.entity.RoleEntity;
import com.ebaiyihui.server.pojo.entity.UserRoleEntity;
import com.ebaiyihui.server.service.BpUserScopeOrganService;
import com.ebaiyihui.server.service.DataScopeService;
import com.ebaiyihui.server.utils.ChinesePinyinUtils;
import com.ebaiyihui.server.utils.HttpClientUtils;
import com.ebaiyihui.server.utils.MessgeUtils;
import com.ebaiyihui.server.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DataScopeServiceImpl
implements DataScopeService {
    private static final Logger log = LoggerFactory.getLogger(DataScopeServiceImpl.class);
    @Resource
    private DateScopeMapper dateScopeMapper;
    @Resource
    private DateScopeRoleMapper dateScopeRoleMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private BpUserScopeOrganService bpUserScopeOrganService;
    @Resource
    private UserOrganMapper userOrganMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Autowired
    private PermissionsConfig permissionsConfig;
    @Autowired
    private RoleMapper roleMapper;

    public BaseResponse<List<DataScopeListDto>> getDataScopeList(Long roleId) {
        List<DataScopeListDto> dataScopeList = new ArrayList();
        dataScopeList = this.dateScopeMapper.getDataScopeList(roleId);
        List dateScopeEntityList = this.dateScopeMapper.getList();
        if (CollectionUtils.isEmpty(dataScopeList)) {
            for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                DataScopeListDto dataScopeListDto = new DataScopeListDto();
                dataScopeListDto.setDataScopeId(dateScopeEntity.getId());
                dataScopeListDto.setDataScopeName(dateScopeEntity.getDateScopeName());
                dataScopeListDto.setDataScopeRoleCheckRange(Integer.valueOf(0));
                dataScopeListDto.setDataScopeRoleId(Long.valueOf(0L));
                dataScopeList.add(dataScopeListDto);
            }
            return BaseResponse.success(dataScopeList);
        }
        if (dataScopeList.size() < dateScopeEntityList.size()) {
            Boolean flag = false;
            for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                for (DataScopeListDto dataScopeListDto : dataScopeList) {
                    if (dataScopeListDto.getDataScopeId().longValue() == dateScopeEntity.getId().longValue()) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
                if (!flag.booleanValue()) continue;
                DataScopeListDto dataScopeListDto1 = new DataScopeListDto();
                dataScopeListDto1.setDataScopeId(dateScopeEntity.getId());
                dataScopeListDto1.setDataScopeName(dateScopeEntity.getDateScopeName());
                dataScopeListDto1.setDataScopeRoleCheckRange(Integer.valueOf(0));
                dataScopeListDto1.setDataScopeRoleId(Long.valueOf(0L));
                dataScopeList.add(dataScopeListDto1);
            }
        }
        log.info("\u6839\u636e\u89d2\u8272id\u67e5\u8be2\u5230\u7684\u6570\u636e\u8303\u56f4\u5217\u8868\u4e3a:{}", dataScopeList);
        return BaseResponse.success(dataScopeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addDataScope(List<DataScopeRoleVo> dataScopeRoleVoList) {
        for (DataScopeRoleVo dataScopeRoleVo : dataScopeRoleVoList) {
            DateScopeRoleEntity dateScopeRole = new DateScopeRoleEntity();
            if (dataScopeRoleVo.getCheckRange() == null && dataScopeRoleVo.getCheckRange() == 0) {
                return BaseResponse.error((String)"CheckRange \u4e0d\u80fd\u4e3a\u7a7a");
            }
            DateScopeRoleEntity dateScopeRoleEntity = this.dateScopeRoleMapper.getByRoleIdAndDateScopeId(dataScopeRoleVo.getRoleId(), dataScopeRoleVo.getDateScopeId());
            if (dateScopeRoleEntity != null) {
                dateScopeRoleEntity.setCheckRange(dataScopeRoleVo.getCheckRange());
                this.dateScopeRoleMapper.updateById(dateScopeRoleEntity);
                BeanCopier copier = BeanCopier.create(DateScopeRoleEntity.class, DateScopeRoleEntity.class, (boolean)false);
                copier.copy((Object)dateScopeRoleEntity, (Object)dateScopeRole, null);
            } else {
                DateScopeRoleEntity dateScopeRoleEntity1 = new DateScopeRoleEntity();
                dateScopeRoleEntity1.setDateScopeId(dataScopeRoleVo.getDateScopeId());
                dateScopeRoleEntity1.setRoleId(dataScopeRoleVo.getRoleId());
                dateScopeRoleEntity1.setCheckRange(dataScopeRoleVo.getCheckRange());
                this.dateScopeRoleMapper.insert(dateScopeRoleEntity1);
                BeanCopier copier = BeanCopier.create(DateScopeRoleEntity.class, DateScopeRoleEntity.class, (boolean)false);
                copier.copy((Object)dateScopeRoleEntity1, (Object)dateScopeRole, null);
            }
            List dateScopeEntityList = this.dateScopeMapper.getList();
            List userRoleList = this.userRoleMapper.findByRoleId(dataScopeRoleVo.getRoleId().toString());
            if (!CollectionUtils.isEmpty((Collection)dateScopeEntityList)) {
                if (CollectionUtils.isEmpty((Collection)userRoleList)) continue;
                for (UserRoleEntity userRole : userRoleList) {
                    String userId = userRole.getUserId();
                    BpUserScopeOrganEntity userScopeOrganEntity = new BpUserScopeOrganEntity();
                    userScopeOrganEntity.setUserId(userId);
                    userScopeOrganEntity.setDateScopeId(dateScopeRole.getDateScopeId());
                    userScopeOrganEntity.setCheckRange(dateScopeRole.getCheckRange());
                    String organIds = "";
                    List organIdList = null;
                    if (dateScopeRole.getCheckRange() != 3) {
                        List userOrganEntityList = this.userOrganMapper.findByUserId(userId);
                        organIdList = userOrganEntityList.stream().map(e -> e.getOrganId()).collect(Collectors.toList());
                        organIds = userOrganEntityList.stream().map(e -> e.getOrganId()).collect(Collectors.joining(","));
                    }
                    switch (dateScopeRole.getCheckRange()) {
                        case 3: {
                            organIds = "-1";
                            userScopeOrganEntity.setOrgan(organIds);
                            break;
                        }
                        case 2: {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("hosIdStr", organIds);
                            try {
                                String url = this.permissionsConfig.getDomain() + "/cloud/consultation/api/v1/healthAlliance/getHealthAllianceByHosIdList";
                                organIds = HttpClientUtils.simpleGetInvoke((String)url, map);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            userScopeOrganEntity.setOrgan(organIds);
                            break;
                        }
                        case 1: {
                            userScopeOrganEntity.setOrgan(organIds);
                            break;
                        }
                        default: {
                            userScopeOrganEntity.setOrgan(organIds);
                        }
                    }
                    boolean flag = this.bpUserScopeOrganService.save(userScopeOrganEntity);
                    String key = "";
                    for (DateScopeEntity dateScope : dateScopeEntityList) {
                        if (dateScopeRole.getDateScopeId().intValue() != dateScope.getId().intValue()) continue;
                        String first = ChinesePinyinUtils.getPinYinHeadChar((String)dateScope.getDateScopeName()).toUpperCase();
                        key = first + "_" + userId;
                        this.redisTemplate.opsForValue().set((Object)key, (Object)organIds);
                        break;
                    }
                    if (flag) continue;
                    return BaseResponse.error((String)"no");
                }
                continue;
            }
            return BaseResponse.error((String)MessgeUtils.get((String)"EMPTY"));
        }
        return new BaseResponse("1", "ok", (Object)"");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addDataScopeDefault(Long roleId) {
        RoleEntity roleEntity = this.roleMapper.findByRoleId(roleId.toString());
        List dateScopeEntityList = this.dateScopeMapper.getList();
        List userRoleList = this.userRoleMapper.findByRoleId(roleId.toString());
        if (!CollectionUtils.isEmpty((Collection)dateScopeEntityList)) {
            for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                DateScopeRoleEntity dateScopeRoleEntity = new DateScopeRoleEntity();
                dateScopeRoleEntity.setRoleId(roleId);
                dateScopeRoleEntity.setCheckRange(Integer.valueOf(1));
                dateScopeRoleEntity.setDateScopeId(dateScopeEntity.getId());
                List list = this.dateScopeRoleMapper.getListByDataScopeRole(dateScopeRoleEntity);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    this.dateScopeRoleMapper.insert(dateScopeRoleEntity);
                }
                if (CollectionUtils.isEmpty((Collection)userRoleList)) continue;
                for (UserRoleEntity userRole : userRoleList) {
                    String userId = userRole.getUserId();
                    BpUserScopeOrganEntity userScopeOrganEntity = new BpUserScopeOrganEntity();
                    userScopeOrganEntity.setUserId(userId);
                    userScopeOrganEntity.setDateScopeId(dateScopeRoleEntity.getDateScopeId());
                    userScopeOrganEntity.setCheckRange(dateScopeRoleEntity.getCheckRange());
                    String organIds = "";
                    List userOrganEntityList = this.userOrganMapper.findByUserId(userId);
                    organIds = userOrganEntityList.stream().map(e -> e.getOrganId()).collect(Collectors.joining(","));
                    userScopeOrganEntity.setOrgan(organIds);
                    boolean flag = this.bpUserScopeOrganService.save(userScopeOrganEntity);
                    String key = "";
                    for (DateScopeEntity dateScope : dateScopeEntityList) {
                        if (dateScopeRoleEntity.getDateScopeId().intValue() != dateScope.getId().intValue()) continue;
                        String first = ChinesePinyinUtils.getPinYinHeadChar((String)dateScope.getDateScopeName()).toUpperCase();
                        key = first + "_" + userId;
                        this.redisTemplate.opsForValue().set((Object)key, (Object)organIds);
                        break;
                    }
                    if (flag) continue;
                    return BaseResponse.error((String)"no");
                }
            }
        } else {
            return BaseResponse.error((String)MessgeUtils.get((String)"EMPTY"));
        }
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addUserScopeOrgan(String userId) {
        List roleIdsList = this.userRoleMapper.findRoleIdsByUserId(userId);
        List dateScopeEntityList = this.dateScopeMapper.getList();
        if (!CollectionUtils.isEmpty((Collection)roleIdsList)) {
            List dateScopeRoleEntityList = this.dateScopeRoleMapper.getListDataScopeRoleByRoleIdList(roleIdsList);
            for (DateScopeRoleEntity dateScopeRoleEntity : dateScopeRoleEntityList) {
                BpUserScopeOrganEntity userScopeOrganEntity = new BpUserScopeOrganEntity();
                userScopeOrganEntity.setUserId(userId);
                userScopeOrganEntity.setDateScopeId(dateScopeRoleEntity.getDateScopeId());
                userScopeOrganEntity.setCheckRange(dateScopeRoleEntity.getCheckRange());
                String organIds = "";
                List organIdList = null;
                if (dateScopeRoleEntity.getCheckRange() != 3) {
                    List userOrganEntityList = this.userOrganMapper.findByUserId(userId);
                    organIdList = userOrganEntityList.stream().map(e -> e.getOrganId()).collect(Collectors.toList());
                    organIds = userOrganEntityList.stream().map(e -> e.getOrganId()).collect(Collectors.joining(","));
                }
                switch (dateScopeRoleEntity.getCheckRange()) {
                    case 3: {
                        organIds = "-1";
                        userScopeOrganEntity.setOrgan(organIds);
                        break;
                    }
                    case 2: {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("hosIdStr", organIds);
                        try {
                            String url = this.permissionsConfig.getDomain() + "/cloud/consultation/api/v1/healthAlliance/getHealthAllianceByHosIdList";
                            organIds = HttpClientUtils.simpleGetInvoke((String)url, map);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        userScopeOrganEntity.setOrgan(organIds);
                        break;
                    }
                    case 1: {
                        userScopeOrganEntity.setOrgan(organIds);
                        break;
                    }
                    default: {
                        userScopeOrganEntity.setOrgan(organIds);
                    }
                }
                boolean flag = this.bpUserScopeOrganService.save(userScopeOrganEntity);
                String key = "";
                for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                    if (dateScopeRoleEntity.getDateScopeId().intValue() != dateScopeEntity.getId().intValue()) continue;
                    String first = ChinesePinyinUtils.getPinYinHeadChar((String)dateScopeEntity.getDateScopeName()).toUpperCase();
                    key = first + "_" + userId;
                    log.info("key:{}", (Object)key);
                    this.redisTemplate.opsForValue().set((Object)key, (Object)organIds);
                    break;
                }
                if (flag) continue;
                return BaseResponse.error((String)"no");
            }
        }
        return BaseResponse.success((Object)"ok");
    }

    @Transactional(rollbackFor={Exception.class})
    public String updateUserScopeOrganByUserIdList(List<String> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return "";
        }
        List dateScopeEntityList = this.dateScopeMapper.getList();
        for (String userId : userIdList) {
            List roleIdsList = this.userRoleMapper.findRoleIdsByUserId(userId);
            if (CollectionUtils.isEmpty((Collection)roleIdsList)) continue;
            List dateScopeRoleEntityList = this.dateScopeRoleMapper.getListDataScopeRoleByRoleIdList(roleIdsList);
            for (DateScopeRoleEntity dateScopeRoleEntity : dateScopeRoleEntityList) {
                BpUserScopeOrganEntity userScopeOrganEntity = new BpUserScopeOrganEntity();
                userScopeOrganEntity.setUserId(userId);
                userScopeOrganEntity.setDateScopeId(dateScopeRoleEntity.getDateScopeId());
                userScopeOrganEntity.setCheckRange(dateScopeRoleEntity.getCheckRange());
                String organIds = "";
                List organIdList = null;
                if (dateScopeRoleEntity.getCheckRange() != 3) {
                    List userOrganEntityList = this.userOrganMapper.findByUserId(userId);
                    organIdList = userOrganEntityList.stream().map(e -> e.getOrganId()).collect(Collectors.toList());
                    organIds = userOrganEntityList.stream().map(e -> e.getOrganId()).collect(Collectors.joining(","));
                }
                switch (dateScopeRoleEntity.getCheckRange()) {
                    case 3: {
                        organIds = "-1";
                        userScopeOrganEntity.setOrgan(organIds);
                        break;
                    }
                    case 2: {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("hosIdStr", organIds);
                        try {
                            String url = this.permissionsConfig.getDomain() + "/cloud/consultation/api/v1/healthAlliance/getHealthAllianceByHosIdList";
                            organIds = HttpClientUtils.simpleGetInvoke((String)url, map);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        userScopeOrganEntity.setOrgan(organIds);
                        break;
                    }
                    case 1: {
                        userScopeOrganEntity.setOrgan(organIds);
                        break;
                    }
                    default: {
                        userScopeOrganEntity.setOrgan(organIds);
                    }
                }
                boolean flag = this.bpUserScopeOrganService.save(userScopeOrganEntity);
                String key = "";
                for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                    if (dateScopeRoleEntity.getDateScopeId().intValue() != dateScopeEntity.getId().intValue()) continue;
                    String first = ChinesePinyinUtils.getPinYinHeadChar((String)dateScopeEntity.getDateScopeName()).toUpperCase();
                    key = first + "_" + userId;
                    log.info("key:{}", (Object)key);
                    this.redisTemplate.opsForValue().set((Object)key, (Object)organIds);
                    break;
                }
                if (flag) continue;
                return "no";
            }
        }
        return "ok";
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> updateUserScopeOrgan(List<String> organIdList) {
        List userScopeOrganEntityLis = this.bpUserScopeOrganService.getListUserScopeOrganByCheckRange(Integer.valueOf(2));
        List dateScopeEntityList = this.dateScopeMapper.getList();
        if (CollectionUtils.isEmpty((Collection)userScopeOrganEntityLis)) {
            log.info("========\u6ca1\u6709\u6743\u9650\u4e3a\u672c\u533b\u9662\u4ee5\u53ca\u6240\u5728\u533b\u8054\u4f53\u7684\u7528\u6237=========");
            return BaseResponse.success((Object)"");
        }
        block0: for (BpUserScopeOrganEntity userScopeOrganEntity : userScopeOrganEntityLis) {
            if (!StringUtil.isNotEmpty((String)userScopeOrganEntity.getOrgan())) continue;
            List<String> hosIdList = Arrays.asList(userScopeOrganEntity.getOrgan().split(","));
            for (String healthId : organIdList) {
                boolean bool = hosIdList.contains(healthId);
                if (!bool) continue;
                ArrayList<String> list = new ArrayList<String>(hosIdList);
                list.addAll(organIdList);
                String organ = list.stream().distinct().collect(Collectors.joining(","));
                userScopeOrganEntity.setOrgan(organ);
                this.bpUserScopeOrganService.update(userScopeOrganEntity);
                String key = "";
                for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                    if (userScopeOrganEntity.getDateScopeId().intValue() != dateScopeEntity.getId().intValue()) continue;
                    String first = ChinesePinyinUtils.getPinYinHeadChar((String)dateScopeEntity.getDateScopeName()).toUpperCase();
                    key = first + "_" + userScopeOrganEntity.getUserId();
                    log.info("key:{}", (Object)key);
                    this.redisTemplate.opsForValue().set((Object)key, (Object)organ);
                    continue block0;
                }
                continue block0;
            }
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> getOrganByUserIdAndScopeId(String userId, Integer scopeId) {
        String organs = "";
        BpUserScopeOrganEntity userScopeOrganEntity = this.bpUserScopeOrganService.getOrganByUserIdAndScopeId(userId, scopeId);
        if (userScopeOrganEntity != null) {
            organs = userScopeOrganEntity.getOrgan();
        }
        return BaseResponse.success((Object)organs);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> updateUserScopeOrganDel(List<String> healthIdList) {
        List userScopeOrganEntityLis = this.bpUserScopeOrganService.getListUserScopeOrganByCheckRange(Integer.valueOf(2));
        List dateScopeEntityList = this.dateScopeMapper.getList();
        if (CollectionUtils.isEmpty((Collection)userScopeOrganEntityLis)) {
            log.info("========\u6ca1\u6709\u6743\u9650\u4e3a\u672c\u533b\u9662\u4ee5\u53ca\u6240\u5728\u533b\u8054\u4f53\u7684\u7528\u6237=========");
            return BaseResponse.success((Object)"");
        }
        block0: for (BpUserScopeOrganEntity userScopeOrganEntity : userScopeOrganEntityLis) {
            if (!StringUtil.isNotEmpty((String)userScopeOrganEntity.getOrgan())) continue;
            List<String> hosIdList = Arrays.asList(userScopeOrganEntity.getOrgan().split(","));
            for (String healthId : healthIdList) {
                boolean bool = hosIdList.contains(healthId);
                if (!bool) continue;
                ArrayList<String> list = new ArrayList<String>(hosIdList);
                list.removeAll(healthIdList);
                String organ = list.stream().distinct().collect(Collectors.joining(","));
                userScopeOrganEntity.setOrgan(organ);
                this.bpUserScopeOrganService.update(userScopeOrganEntity);
                String key = "";
                for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                    if (userScopeOrganEntity.getDateScopeId().intValue() != dateScopeEntity.getId().intValue()) continue;
                    String first = ChinesePinyinUtils.getPinYinHeadChar((String)dateScopeEntity.getDateScopeName()).toUpperCase();
                    key = first + "_" + userScopeOrganEntity.getUserId();
                    log.info("key:{}", (Object)key);
                    this.redisTemplate.opsForValue().set((Object)key, (Object)organ);
                    continue block0;
                }
                continue block0;
            }
        }
        return BaseResponse.success();
    }

    public BaseResponse<Map<String, String>> getCloudUserScope(String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List dateScopeEntityList = this.dateScopeMapper.getList();
        List bpUserScopeOrganEntityList = this.bpUserScopeOrganService.getListByUserId(userId);
        if (!CollectionUtils.isEmpty((Collection)bpUserScopeOrganEntityList)) {
            block0: for (BpUserScopeOrganEntity userScopeOrganEntity : bpUserScopeOrganEntityList) {
                String key = "";
                for (DateScopeEntity dateScopeEntity : dateScopeEntityList) {
                    if (userScopeOrganEntity.getDateScopeId().intValue() != dateScopeEntity.getId().intValue()) continue;
                    String first = ChinesePinyinUtils.getPinYinHeadChar((String)dateScopeEntity.getDateScopeName()).toUpperCase();
                    key = first + "_" + userId;
                    log.info("key:{}", (Object)key);
                    map.put(key, userScopeOrganEntity.getOrgan());
                    continue block0;
                }
            }
        } else {
            return BaseResponse.success(new HashMap());
        }
        return BaseResponse.success(map);
    }

    public BaseResponse<String> getRedisByKey(String key) {
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        log.info("redis\u4e2dkey\u4e3a:{},value\u4e3a:{}", (Object)key, (Object)value);
        return BaseResponse.success((Object)value);
    }

    public DateScopeEntity insert(DateScopeEntity dateScopeEntity) {
        this.dateScopeMapper.insert(dateScopeEntity);
        return dateScopeEntity;
    }

    public String getPermissionsByKey(String key) {
        log.info("===========key:{}", (Object)key);
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        log.info("===========redis,value:{}", (Object)value);
        if (StringUtil.isEmpty((String)value)) {
            String[] split = key.split("_");
            String identify = split[0];
            String userId = split[1];
            Long scopeId = this.dateScopeMapper.getByIdentify(identify).getId();
            log.info("===========\u6a21\u5757Id:{}", (Object)scopeId);
            BpUserScopeOrganEntity userScopeOrganEntity = this.bpUserScopeOrganService.getOrganByUserIdAndScopeId(userId, Integer.valueOf(Integer.parseInt(scopeId.toString())));
            if (userScopeOrganEntity == null) {
                log.info("=======\u6743\u9650\u8868\u65e0\u6570\u636e");
                return "";
            }
            String organ = userScopeOrganEntity.getOrgan();
            log.info("=========\u6743\u9650organ:{}", (Object)organ);
            if (StringUtil.isNotEmpty((String)organ)) {
                this.redisTemplate.opsForValue().set((Object)key, (Object)organ);
                return organ;
            }
            return "";
        }
        return value;
    }
}

