/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.vo.auth.AuthInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.mapper.AuthMapper;
import com.ebaiyihui.server.mapper.DateScopeMapper;
import com.ebaiyihui.server.mapper.DateScopeRoleMapper;
import com.ebaiyihui.server.mapper.InitializationAuthMapper;
import com.ebaiyihui.server.mapper.RoleAuthMapper;
import com.ebaiyihui.server.mapper.RoleMapper;
import com.ebaiyihui.server.pojo.entity.AuthEntity;
import com.ebaiyihui.server.pojo.entity.DateScopeEntity;
import com.ebaiyihui.server.pojo.entity.DateScopeRoleEntity;
import com.ebaiyihui.server.pojo.entity.RoleAuthEntity;
import com.ebaiyihui.server.pojo.entity.RoleEntity;
import com.ebaiyihui.server.service.InitializationService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InitializationServiceImpl
implements InitializationService {
    private static final Logger log = LoggerFactory.getLogger(InitializationServiceImpl.class);
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private InitializationAuthMapper initializationAuthMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RoleAuthMapper roleAuthMapper;
    @Autowired
    private DateScopeMapper dateScopeMapper;
    @Autowired
    private DateScopeRoleMapper dateScopeRoleMapper;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> initializationAuth(String appCode) {
        List allId = this.authMapper.findAllId(appCode);
        if (allId.size() > 0) {
            return BaseResponse.success((Object)"\u521d\u59cb\u5316\u6743\u9650\u6570\u636e\u91cd\u590d");
        }
        List authInfoVOList = this.getinitializationAuth();
        try {
            for (AuthInfoVO authInfoVO : authInfoVOList) {
                AuthEntity authEntity = new AuthEntity();
                BeanUtils.copyProperties((Object)authInfoVO, (Object)authEntity);
                authEntity.setAppCode(appCode);
                this.authMapper.insert(authEntity);
                if (null == authInfoVO.getAuthInfoVOList() || authInfoVO.getAuthInfoVOList().size() <= 0) continue;
                for (AuthInfoVO authInfoVOLevel2 : authInfoVO.getAuthInfoVOList()) {
                    AuthEntity authEntityLevel2 = new AuthEntity();
                    BeanUtils.copyProperties((Object)authInfoVOLevel2, (Object)authEntityLevel2);
                    authEntityLevel2.setAppCode(appCode);
                    authEntityLevel2.setParentId(authEntity.getId());
                    this.authMapper.insert(authEntityLevel2);
                    if (null == authInfoVOLevel2.getAuthInfoVOList() || authInfoVOLevel2.getAuthInfoVOList().size() <= 0) continue;
                    for (AuthInfoVO authInfoVOLevel3 : authInfoVOLevel2.getAuthInfoVOList()) {
                        AuthEntity authEntityLevel3 = new AuthEntity();
                        BeanUtils.copyProperties((Object)authInfoVOLevel3, (Object)authEntityLevel3);
                        authEntityLevel3.setAppCode(appCode);
                        authEntityLevel3.setParentId(authEntityLevel2.getId());
                        this.authMapper.insert(authEntityLevel3);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u6743\u9650\u6570\u636e\u5931\u8d25:", (Throwable)e);
            return BaseResponse.error((String)"\u521d\u59cb\u5316\u6743\u9650\u6570\u636e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u521d\u59cb\u5316\u6743\u9650\u6570\u636e\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> initializationRole(String appCode) {
        try {
            List roleEntityList = this.roleMapper.findAll(appCode);
            if (roleEntityList.size() > 0) {
                return BaseResponse.success((Object)"\u521d\u59cb\u5316\u89d2\u8272\u4ee5\u53ca\u89d2\u8272\u7ed1\u5b9a\u6570\u636e\u91cd\u590d");
            }
            for (RoleEntity roleEntity : this.getinitializationRole(appCode)) {
                this.roleMapper.save(roleEntity);
            }
            for (RoleEntity roleEntity : this.roleMapper.findAll(appCode)) {
                for (DateScopeEntity dateScopeEntity : this.dateScopeMapper.getList()) {
                    DateScopeRoleEntity dateScopeRoleEntity = new DateScopeRoleEntity();
                    if (roleEntity.getIsDefault() == 1) {
                        dateScopeRoleEntity.setCheckRange(Integer.valueOf(3));
                    } else {
                        dateScopeRoleEntity.setCheckRange(Integer.valueOf(1));
                    }
                    dateScopeRoleEntity.setDateScopeId(dateScopeEntity.getId());
                    dateScopeRoleEntity.setRoleId(roleEntity.getId());
                    this.dateScopeRoleMapper.insert(dateScopeRoleEntity);
                }
            }
            for (RoleEntity roleEntity : this.roleMapper.findAll(appCode)) {
                for (Long authId : this.authMapper.findAllId(appCode)) {
                    RoleAuthEntity roleAuthEntity = new RoleAuthEntity();
                    if (roleEntity.getIsDefault() == 1) {
                        roleAuthEntity.setBinding(Integer.valueOf(1));
                    } else {
                        roleAuthEntity.setBinding(Integer.valueOf(0));
                    }
                    roleAuthEntity.setRoleId(roleEntity.getId());
                    roleAuthEntity.setAuthId(authId);
                    this.roleAuthMapper.batchSave(roleAuthEntity);
                }
            }
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u89d2\u8272\u4ee5\u53ca\u89d2\u8272\u7ed1\u5b9a\u6570\u636e\u5931\u8d25:", (Throwable)e);
            return BaseResponse.error((String)"\u521d\u59cb\u5316\u89d2\u8272\u4ee5\u53ca\u89d2\u8272\u7ed1\u5b9a\u6570\u636e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u521d\u59cb\u5316\u89d2\u8272\u4ee5\u53ca\u89d2\u8272\u7ed1\u5b9a\u6570\u636e\u6210\u529f");
    }

    private List<AuthInfoVO> getinitializationAuth() {
        List leftAuthEntityList = this.initializationAuthMapper.findInitializationByAuthLevel(Integer.valueOf(1), Long.valueOf(0L));
        ArrayList<AuthInfoVO> leftAuthInfoVOList = new ArrayList<AuthInfoVO>();
        if (leftAuthEntityList != null && leftAuthEntityList.size() != 0) {
            for (AuthEntity authEntity : leftAuthEntityList) {
                AuthInfoVO authInfoVO = new AuthInfoVO();
                authInfoVO.setAuthInfoVOList(new ArrayList());
                BeanUtils.copyProperties((Object)authEntity, (Object)authInfoVO);
                List authEntityList1 = this.initializationAuthMapper.findInitializationByAuthLevel(Integer.valueOf(2), authEntity.getId());
                if (authEntityList1 != null && authEntityList1.size() != 0) {
                    for (AuthEntity entity : authEntityList1) {
                        AuthInfoVO authInfoVo1 = new AuthInfoVO();
                        authInfoVo1.setAuthInfoVOList(new ArrayList());
                        BeanUtils.copyProperties((Object)entity, (Object)authInfoVo1);
                        List authEntityList2 = this.initializationAuthMapper.findInitializationByAuthLevel(Integer.valueOf(3), entity.getId());
                        if (authEntityList2 != null && authEntityList2.size() != 0) {
                            for (AuthEntity authEntityDb : authEntityList2) {
                                AuthInfoVO authInfoVo2 = new AuthInfoVO();
                                BeanUtils.copyProperties((Object)authEntityDb, (Object)authInfoVo2);
                                authInfoVo1.getAuthInfoVOList().add(authInfoVo2);
                            }
                        }
                        authInfoVO.getAuthInfoVOList().add(authInfoVo1);
                    }
                }
                leftAuthInfoVOList.add(authInfoVO);
            }
        }
        return leftAuthInfoVOList;
    }

    private List<RoleEntity> getinitializationRole(String appCode) {
        ArrayList<RoleEntity> roleEntityList = new ArrayList<RoleEntity>();
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setRoleName("\u7ba1\u7406\u5458");
        roleEntity.setIsDefault(Integer.valueOf(1));
        roleEntity.setAppCode(appCode);
        roleEntityList.add(roleEntity);
        RoleEntity roleEntityDb = new RoleEntity();
        roleEntityDb.setRoleName("\u666e\u901a\u6210\u5458");
        roleEntityDb.setIsDefault(Integer.valueOf(2));
        roleEntityDb.setAppCode(appCode);
        roleEntityList.add(roleEntityDb);
        return roleEntityList;
    }
}

